-- weekly = 12:00 am Mon - 11:59 pm Sun
-- monthly = 12:00 am 1st of the month - 11:59 pm last day of the month

--# Accounts Linked (Drops)
WITH
the_metadata_date_mbr AS (
  SELECT *
  FROM metadata.date AS base
  WHERE base.date>='2017-10-01'::TIMESTAMP --AND base.date<'2018-12-31'::TIMESTAMP
  AND base.date<DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours'))
)
, the_constants_mbr AS (
  SELECT year, month, MIN(date)::TIMESTAMP AS start_time, MAX(date)::TIMESTAMP + INTERVAL '1 day' - INTERVAL '1 second' AS end_time
  FROM the_metadata_date_mbr
  GROUP BY 1,2
)

, game_devs AS (
  SELECT *
  FROM (
    SELECT client_id.readablename AS game_dev_name, client_id.clientid AS client_id, service_id.service
    , CASE WHEN client_id.clientid IN ('4fuoo8jdkayfkehdjb4wnj8z4zzmsq', 'oh1dk0v450lqx820texuxyabiwllx7', 'hfkueujio5chjtpno8d4n8edtwe7zck', 'asdfasdfasdf', '9199oab51zil00ock6nfkvb6z3h0os') THEN 1
    ELSE 0 END AS flag_is_test_account
    FROM analysis.vhs_clientid_name_mapping AS client_id
    FULL OUTER JOIN analysis.vhs_service_names AS service_id ON client_id.readablename = service_id.readablename
  )
  WHERE flag_is_test_account=0
)

, account_links_log AS (
  SELECT year, month, start_time, end_time, client_id, user_id, MAX(time) AS last_time_auth
  FROM (
    SELECT gd.*, oa.time, oa.user_id, tt.*
    FROM logs.oauth_authorize AS oa
    RIGHT JOIN game_devs AS gd ON oa.client_id = gd.client_id
    RIGHT JOIN the_constants_mbr AS tt ON oa.time>='2017-01-01'::TIMESTAMP AND oa.time<tt.end_time
  )
  GROUP BY 1,2,3,4,5,6
)

, account_unlinks_log AS (
  SELECT year, month, start_time, end_time, client_id, user_id, MAX(time) AS last_time_deauth
  FROM (
    SELECT gd.*, od.time, od.user_id, tt.*
    FROM logs.oauth_deauthorize AS od
    RIGHT JOIN game_devs AS gd ON od.client_id = gd.client_id
    RIGHT JOIN the_constants_mbr AS tt ON od.time>='2017-01-01' AND od.time<tt.end_time
  )
  GROUP BY 1,2,3,4,5,6
)

, account_logs AS (
  SELECT link.*, unlink.last_time_deauth
  , CASE WHEN link.last_time_auth > unlink.last_time_deauth THEN 1
  WHEN link.last_time_auth IS NOT NULL AND unlink.last_time_deauth IS NULL THEN 1
  ELSE 0 END AS flag_is_auth
  FROM account_links_log AS link
  LEFT JOIN account_unlinks_log AS unlink ON link.client_id = unlink.client_id AND link.user_id = unlink.user_id AND link.start_time = unlink.start_time
)

, cumulative_net_account_links AS (
  SELECT year, month, start_time, end_time, COUNT(1) AS cumulative_net_account_links
  FROM account_logs
  WHERE flag_is_auth=1
  GROUP BY 1,2,3,4
)

, mbr_drops_account_links AS (
  SELECT *, cumulative_net_account_links - prev_cumulative_net_account_links AS net_account_links_added
  FROM (
    SELECT year, month, start_time, end_time, cumulative_net_account_links
    , LAG(cumulative_net_account_links,1) OVER (ORDER BY start_time ASC) as prev_cumulative_net_account_links
    FROM cumulative_net_account_links
  )
)

SELECT year, month, start_time, end_time, net_account_links_added AS num_account_links_added FROM mbr_drops_account_links WHERE net_account_links_added IS NOT NULL ORDER BY 1,2
