-- weekly = 12:00 am Mon - 11:59 pm Sun
-- monthly = 12:00 am 1st of the month - 11:59 pm last day of the month

--# of New Accounts (Drops)
WITH
the_metadata_date_mbr AS (
  SELECT *
  FROM metadata.date AS base
  WHERE base.date>='2017-11-01'::TIMESTAMP --AND base.date<'2018-12-31'::TIMESTAMP
  AND base.date<DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours'))
)
, the_constants_mbr AS (
  SELECT year, month, MIN(date)::TIMESTAMP AS start_time, MAX(date)::TIMESTAMP + INTERVAL '1 day' - INTERVAL '1 second' AS end_time
  FROM the_metadata_date_mbr
  GROUP BY 1,2
)

, test AS (
  SELECT MAX(end_time) AS end_time FROM the_constants_mbr
)

, game_devs AS (
  SELECT *
  FROM (
    SELECT client_id.readablename AS game_dev_name, client_id.clientid AS client_id, service_id.service
    , CASE WHEN client_id.clientid IN ('4fuoo8jdkayfkehdjb4wnj8z4zzmsq', 'oh1dk0v450lqx820texuxyabiwllx7', 'hfkueujio5chjtpno8d4n8edtwe7zck', 'asdfasdfasdf', '9199oab51zil00ock6nfkvb6z3h0os') THEN 1
    ELSE 0 END AS flag_is_test_account
    FROM analysis.vhs_clientid_name_mapping AS client_id
    FULL OUTER JOIN analysis.vhs_service_names AS service_id ON client_id.readablename = service_id.readablename
  )
  WHERE flag_is_test_account=0
)

, twitch_create_date AS (
  SELECT user_id, MIN(created_on) AS time_create_twitch_account
  FROM analysis.sitedb_users
  GROUP BY 1
)

, twitch_link_date AS (
  SELECT user_id, client_id, MIN(time) AS time_link_twitch_account
  FROM logs.oauth_authorize
  WHERE client_id IN (SELECT client_id FROM game_devs)
  AND time>='2017-01-01'::TIMESTAMP AND time<=(SELECT end_time FROM test)
  GROUP BY 1,2
)

, twitch_prime_signup_date AS (
  SELECT purchaser_id AS user_id, MIN(received_on::TIMESTAMP) AS time_prime_signup
  FROM analysis.sitedb_subscription_payments_raw
  WHERE ticket_type = 'turbo' AND payment_provider = 'samus'
  GROUP BY 1
)

, user_segment AS (
  SELECT *
  FROM (
    SELECT tld.user_id, tld.client_id, tld.time_link_twitch_account, tcd.time_create_twitch_account, tpsd.time_prime_signup
    , DATEDIFF(minutes, tcd.time_create_twitch_account, tld.time_link_twitch_account) AS mins_between_link_create
    , DATEDIFF(minutes, tcd.time_create_twitch_account, tpsd.time_prime_signup) AS mins_between_prime_create
    FROM twitch_link_date AS tld
    LEFT JOIN twitch_create_date AS tcd ON tld.user_id = tcd.user_id
    LEFT JOIN twitch_prime_signup_date AS tpsd ON tld.user_id = tpsd.user_id
  )
  WHERE mins_between_link_create <= 360 --6 hrs difference between account create date and account link date => this is new account created by game solutions
  AND (mins_between_prime_create > 1440 -- greater than 24 hrs difference between account create date and twitch prime signup date
  OR time_prime_signup IS NULL)
)


, mbr_drops_new_accounts AS (
  SELECT *, SUM(num_new_users) OVER (ORDER BY end_time ROWS UNBOUNDED PRECEDING) AS cumulative_num_new_users
  FROM (
    SELECT year, month, start_time, end_time, COUNT(DISTINCT user_id) AS num_new_users
    FROM (
      SELECT base.*, us.user_id, us.client_id, us.time_link_twitch_account, us.time_create_twitch_account
      FROM the_constants_mbr AS base
      LEFT JOIN user_segment AS us ON base.start_time<= us.time_link_twitch_account AND us.time_link_twitch_account<=base.end_time
    )
    GROUP BY 1,2,3,4
  )
)


SELECT year, month, start_time, end_time, num_new_users FROM mbr_drops_new_accounts ORDER BY 1,2
