-- weekly = 12:00 am Mon - 11:59 pm Sun
-- monthly = 12:00 am 1st of the month - 11:59 pm last day of the month

--Extensions/API Gross Revenue
WITH
the_metadata_date_wbr AS (
  SELECT *, LAG(week_of_year,1) OVER (ORDER BY base.date) AS wbr_week_number
  FROM metadata.date AS base
  WHERE base.date>='2017-12-03'::TIMESTAMP --AND base.date<'2018-12-31'::TIMESTAMP
  AND base.date<DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours'))
)
, the_constants_wbr AS (
  SELECT year, wbr_week_number, MIN(date)::TIMESTAMP AS start_time, MAX(date)::TIMESTAMP + INTERVAL '1 day' - INTERVAL '1 second' AS end_time
  FROM the_metadata_date_wbr
  WHERE wbr_week_number IS NOT NULL
  GROUP BY 1,2
)

, extension_gross_rev_log AS (
  SELECT base.*, eie.time, eie.user_id, eie.channel_id, eie.asin, eie.purchase_value
  FROM the_constants_wbr AS base
  LEFT JOIN logs.extension_item_entitled AS eie ON base.start_time <= eie.time AND eie.time <= base.end_time
)
, wbr_extension_gross_rev AS (
  SELECT year, wbr_week_number, start_time, end_time, SUM(purchase_value) AS extensions_gross_revenue
  FROM extension_gross_rev_log
  GROUP BY 1,2,3,4
)


SELECT * FROM wbr_extension_gross_rev ORDER BY 1,2
