-- What I want to do here is be able to say, "of x top developers, what are their most commonly used APIs?"
-- This will help me see if there are patterns that exist between different types of developers and which APIs
-- they're using most frequently.

WITH
the_constants AS (
  SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '30 days' AS start_time, --30 days ago
  DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '1 seconds' AS end_time --yesterday's end date
)

, the_apps AS (
  SELECT name AS app_name, client_id, id AS tahoe_api_request_client_id, oauth2_client_owner_id AS app_dev_user_id, is_first_party, is_fuel_client, redirect_uri
  FROM analysis.sitedb_oauth2_clients
  --WHERE is_first_party IS FALSE
  WHERE client_id IN (
  '8bmp6j83z5w4mepq0dn0q1a7g186azi'
  ,'33kozedd0zs6fbauka98psnc7zwom2s' --discord
  ,'ocgs5mzu2e910kuhv9xy1zv3q06am8v'
  ,'9uavest5z7knsvpbip19fxqkywxz3ec' -- streamelements
  ,'36v98kaawy48toz20d8gntnpk'
  ,'jg509s1n58dzwc7p97o5bb4ffimwuj2'
  ,'6x8avioex0zt85ht6py4sq55z6avsea'
  ,'pjldg61blqydhxlq49gyf2rwlcenw5'
  ,'sv6t1c3j2s5uuz3elxftm7s1bx54b31'
  ,'7dhxmzdtfvllbu5h7rgys2rn4'
  ,'dve7ifeawf0xeegigqamnvqy9qqm2y'
  ,'hf38b1gx7qnebpziq77q34ej4x44qdh'
  ,'nquiw61tb595zscbxktdhwe2i45py5m'
  ,'1z17331cvavqspfdm9h0qd1t6ovo5uo'
  ,'isjln45ehvrv7uo6327u3g6ka1y7vzf'
  ,'r1czfv4czh1ub7ejxi903njcwwzswz'
  ,'99c8xj3f82h6ho6hznh9jurmj5ciz74'
  ,'81oh6vuyfv4w38sj2lxk9utw5zotm4'
  ,'btg981y5c6jugyuwcg3ukortgj22iyf'
  ,'664hk76z0hvg3zr5ej9j3tktbo0nf2n'
  ,'bjf85qht726415euqyjts1eeyxp4x8b'
  ,'r62ryboyyhzbfs3ng6lln92w2op3wdz'
  ,'tczdbjwvqwqcoykov1n9ircfju0yca6'
  ,'sq94brxoevg1rdwqvqna51jr7396ic'
  ,'ye3x8sf0oh9oj4z0fu1bmvlkoyzn8l'
  ,'xqdr3blb8nxv66bxvmg7je1x2c80da'
  )
)

, api_request_logs AS (
  SELECT base.time, tc.client_id, tc.app_name, base.api_name, base.user_id
  , base.http_referrer, base.http_method
  , base.latency, base.http_status_code_int
  , base.path_parameters, base.query_parameters
  FROM tahoe.api_request AS base
  RIGHT JOIN the_apps AS tc ON base.client_id = tc.tahoe_api_request_client_id
  WHERE base.time>=(SELECT start_time FROM the_constants)
  AND base.time<=(SELECT end_time FROM the_constants)
)

, final_data AS (
  SELECT
  DATE_TRUNC('day', time) AS the_date, client_id, app_name, api_name, http_method AS api_request_type
  , CASE
      WHEN api_name LIKE '%v3%' THEN 'v3'
      WHEN api_name LIKE '%v5%' THEN 'v5'
      ELSE 'unknown'
    END AS api_version
  , COUNT(1) AS num_requests
  , MIN(latency) AS min_latency
  , AVG(latency) AS avg_latency
  , MAX(latency) AS max_latency
  FROM api_request_logs
  GROUP BY 1,2,3,4,5,6
)

SELECT *
FROM final_data
--ORDER BY the_date, app_name, api_name
