--the columns in tahoe.api_request are:
-- time
-- ip
-- city
-- country
-- region
-- asn_id
-- api_name
-- user_id
-- client_id --> NOTE: this is analysis.sitedb_oauth2_clients.id (numeric) not analysis.sitedb_oauth2_clients.client_id
-- unix_timestamp
-- backends
-- user_agent
-- http_referrer
-- http_method
-- http_status_code
-- path_parameters
-- query_parameters
-- client_ip
-- client_city
-- client_country
-- client_region
-- client_asn_id
-- latency
-- http_status_code_int
-- time_utc
-- date



WITH
the_constants AS (
  SELECT name AS app_name, client_id, id AS tahoe_api_request_client_id, oauth2_client_owner_id AS app_dev_user_id, is_first_party, is_fuel_client, redirect_uri
  FROM analysis.sitedb_oauth2_clients
  WHERE client_id IN (
    '33kozedd0zs6fbauka98psnc7zwom2s' --discord
    , '9uavest5z7knsvpbip19fxqkywxz3ec' -- streamelements
  )
)

SELECT base.time, tc.client_id, tc.app_name, base.api_name, base.user_id
, base.http_referrer, base.http_method
, base.latency, base.http_status_code_int
, base.path_parameters, base.query_parameters
FROM tahoe.api_request AS base
RIGHT JOIN the_constants AS tc ON base.client_id = tc.tahoe_api_request_client_id
WHERE base.time>='2018-02-01 17:20:00'
