--# of Unique Devices (Web only) in Dedicated channel row 17 (extension only last 30 days)
--https://docs.google.com/spreadsheets/d/1sxkI3v3w5dh4VhbE9ur14ys-iLAsALcg-Fp10VA3igA/edit?ts=5a399fb0#gid=246267467


-- Dedicated broadcasters are defined as broadcasters who has streamed at least 10 minutes per day on average in a given time period.

WITH
the_timeframe AS (
SELECT '2017-05-01 00:00:00'::timestamp AS start_time_extensions
, DATE_TRUNC('day','2018-01-07 23:59:59'::timestamp) - INTERVAL '29 day' AS start_time
, '2018-01-07 23:59:59'::timestamp AS end_time
)



, channels_with_extensions_list AS (
  SELECT channel_id, COUNT(1) AS active_extensions, MAX(1) AS flag_is_activated
  FROM rollups.extension_daily_channel_presence
  WHERE the_day=(SELECT DATE_TRUNC('day',end_time) FROM the_timeframe)
  AND extension_id IN (SELECT extension_id FROM analysis.released_extensions_latest)
  AND bool_extension_activated
  --AND extension_id IN ('3v9falpvk6qw6n5i4okm3xo3bazg8t','a23mttohd32cjppls8v1p9vr0sb0on','thc81rw29g1gsukw0f4mfeczxltio3')--m10n extensions
  GROUP BY 1
)


, dedicated_streamer_list AS (
  SELECT *
  FROM (
    SELECT channel_id, SUM(1)::float / DATE_PART(day, LAST_DAY(MAX(time))) AS mb_per_day
    FROM logs.channel_concurrents
    WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
    GROUP BY 1
  )
  WHERE mb_per_day>=10
)

, dedicated_streamer_with_extension_list AS (
  SELECT channel_id
  FROM (
    SELECT dsl.*, cwel.flag_is_activated, cwel.active_extensions--, cwel.channel_id
    FROM dedicated_streamer_list AS dsl
    LEFT JOIN channels_with_extensions_list AS cwel ON dsl.channel_id = cwel.channel_id
  )
  WHERE flag_is_activated=1
  GROUP BY 1
)

, final_data AS (
  SELECT COUNT(DISTINCT device_id) AS devices, COUNT(DISTINCT channel_id) AS dedicated_channels, COUNT(DISTINCT device_id)::float/COUNT(DISTINCT channel_id)::float AS devices_per_dedicated_channel
  FROM logs.extension_render
  WHERE channel_id IN (SELECT channel_id FROM dedicated_streamer_with_extension_list)
  AND time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
)

SELECT * FROM final_data
