-- Hey Yang,
--
-- As a follow up from our work creating our dedicated streamer output goal, Ivan had a follow up about how extension usage may differ across various broadcaster size cohorts. I can imagine two ways we could slice the data to get insight into this:
--
-- Slice by % of total HW that have an extension active
-- Slice by % of broadcasters with an extension active across broadcaster tiers
-- Ivan can comment on prioritization of this request relative to other work on your plate.
--
-- Specific request from Ivan:
--
-- "Do you have a POV on whether we will get greater or lesser penetration than average among our most-watched broadcasters?
-- I ask because it seems likely that top broadcasters would generally be early adopters and would therefore be more penetrated than the average.
-- Have we looked at whether that has been true so far?"


WITH
the_constants AS (
  SELECT '2018-01-18'::TIMESTAMP AS start_time
)
--get list of channels with extension activated on a specific date
, meta_channels_with_extensions AS (
  SELECT the_day AS the_date, channel_id, 1 AS flag_is_activated
  FROM rollups.extension_daily_channel_presence
  WHERE bool_extension_activated
  AND the_day=(SELECT start_time FROM the_constants)
  GROUP BY 1,2
)

--get list of channels along with their partner/affiliate status
, meta_channel_status AS (
  SELECT channel_id, status
  FROM analysis.dsds163_broadcaster_status_list
)

--get list of channels along with their tier status as of DEC 2017
, meta_channel_tier AS (
  SELECT channel_id, tier
  FROM analysis.dsds163_broadcaster_tier_list
)

, final_data AS (
  -- SELECT base.the_date, base.channel_id, base.flag_is_activated, NVL(mct.tier, 'unknown') AS tier, NVL(mcs.status, 'not_partner_affiliate') AS status
  -- FROM meta_channels_with_extensions AS base
  -- LEFT JOIN meta_channel_tier AS mct on base.channel_id = mct.channel_id
  -- LEFT JOIN meta_channel_status AS mcs ON base.channel_id = mcs.channel_id

  SELECT base.channel_id, NVL(base.tier, 'unknown') AS tier, NVL(mcs.status, 'not_partner_affiliate') AS status, NVL(mcwe.flag_is_activated, 0) AS flag_is_activated
  FROM meta_channel_tier AS base
  LEFT JOIN meta_channel_status AS mcs ON base.channel_id = mcs.channel_id
  LEFT JOIN meta_channels_with_extensions AS mcwe ON base.channel_id = mcwe.channel_id
)

SELECT tier, status, COUNT(DISTINCT channel_id) AS channels, SUM(flag_is_activated)::FLOAT / COUNT(DISTINCT channel_id)::FLOAT AS pct_penetration
FROM final_data
GROUP BY 1,2
ORDER BY 1,2
