-- % of partners, % of affiliate and % of non-partner non-affiliate dedicated streamers that have a 3p app connection. (snapshot as of right now)

WITH
the_constants AS (
  SELECT '2018-01-28'::TIMESTAMP AS analysis_date --choose the date you want to pull dedicated streamer list for
  , '2018-01-29'::TIMESTAMP - INTERVAL '1 seconds' AS end_time
)
, the_time_constants AS (
  SELECT
    date::TIMESTAMP AS the_date
    , date::TIMESTAMP - INTERVAL '29 days' AS start_time_rolling_30 --Greater Than Equal To (>=) this timestamp
    , date::TIMESTAMP + INTERVAL '1 days' - INTERVAL '0 seconds' AS end_time_rolling_30 -- Less Than (<) this timestamp
    , DATEDIFF('hours', date::TIMESTAMP - INTERVAL '29 days', date::TIMESTAMP + INTERVAL '1 days' - INTERVAL '0 seconds')::float/24 AS the_days_difference
  FROM metadata.date
  WHERE date=(SELECT analysis_date FROM the_constants)
)
, list_dedicated_streamer AS (
  SELECT *
  FROM (
    SELECT tc.the_date, cc.channel_id, SUM(1)::float / 30 AS mb_per_day
    FROM logs.channel_concurrents AS cc
    LEFT JOIN the_time_constants AS tc ON 1=1
    WHERE time>=(SELECT start_time_rolling_30 FROM the_time_constants) AND time<(SELECT end_time_rolling_30 FROM the_time_constants)
    GROUP BY 1,2
  )
  WHERE mb_per_day>=10
)
--get list of channels along with their partner/affiliate status
, meta_channel_status AS (
  SELECT channel_id, status
  FROM analysis.dsds170_broadcaster_status_list
)
, list_dedicated_streamer_w_status AS (
  SELECT base.the_date, base.channel_id, NVL(mcs.status, 'not_partner_affiliate') AS status
  FROM list_dedicated_streamer AS base
  LEFT JOIN meta_channel_status AS mcs ON base.channel_id = mcs.channel_id
)

, list_3p_app_client_id AS (
  SELECT client_id, name AS app_name
  FROM analysis.sitedb_oauth2_clients
  WHERE
  --is_first_party IS FALSE AND is_fuel_client IS FALSE
  --custom list of apps from ryan via ==> https://docs.google.com/spreadsheets/d/1CuuGdTZV8exd2CqT3w3PgoH2Bld5-Ebiyzzs_iE7qKA/edit#gid=1720127798
  client_id IN (
  '8bmp6j83z5w4mepq0dn0q1a7g186azi'
  --,'33kozedd0zs6fbauka98psnc7zwom2s' --discord
  ,'ocgs5mzu2e910kuhv9xy1zv3q06am8v'
  ,'9uavest5z7knsvpbip19fxqkywxz3ec'
  ,'36v98kaawy48toz20d8gntnpk'
  ,'jg509s1n58dzwc7p97o5bb4ffimwuj2'
  ,'6x8avioex0zt85ht6py4sq55z6avsea'
  ,'pjldg61blqydhxlq49gyf2rwlcenw5'
  ,'sv6t1c3j2s5uuz3elxftm7s1bx54b31'
  ,'7dhxmzdtfvllbu5h7rgys2rn4'
  ,'dve7ifeawf0xeegigqamnvqy9qqm2y'
  ,'hf38b1gx7qnebpziq77q34ej4x44qdh'
  ,'nquiw61tb595zscbxktdhwe2i45py5m'
  ,'1z17331cvavqspfdm9h0qd1t6ovo5uo'
  ,'isjln45ehvrv7uo6327u3g6ka1y7vzf'
  ,'r1czfv4czh1ub7ejxi903njcwwzswz'
  ,'99c8xj3f82h6ho6hznh9jurmj5ciz74'
  ,'81oh6vuyfv4w38sj2lxk9utw5zotm4'
  ,'btg981y5c6jugyuwcg3ukortgj22iyf'
  ,'664hk76z0hvg3zr5ej9j3tktbo0nf2n'
  ,'bjf85qht726415euqyjts1eeyxp4x8b'
  ,'r62ryboyyhzbfs3ng6lln92w2op3wdz'
  ,'tczdbjwvqwqcoykov1n9ircfju0yca6'
  ,'sq94brxoevg1rdwqvqna51jr7396ic'
  ,'ye3x8sf0oh9oj4z0fu1bmvlkoyzn8l'
  ,'xqdr3blb8nxv66bxvmg7je1x2c80da'
  )
  GROUP BY 1,2
)


, logs_oauth AS (
  SELECT base.user_id, dsl.status, base.client_id, the_3p_apps.app_name, MAX(base.time) AS latest_oauth_time
  FROM logs.oauth_authorize AS base
  RIGHT JOIN list_dedicated_streamer_w_status AS dsl ON base.user_id = dsl.channel_id --only pull the records of dedicated streamers
  RIGHT JOIN list_3p_app_client_id AS the_3p_apps ON base.client_id = the_3p_apps.client_id --only pull the records of client apps that are 3rd party
  WHERE base.time<=(SELECT end_time FROM the_constants)
  GROUP BY 1,2,3,4
)

, logs_deauth AS (
  SELECT base.user_id, dsl.status, base.client_id, the_3p_apps.app_name, MAX(base.time) AS latest_deauth_time
  FROM logs.oauth_deauthorize AS base
  RIGHT JOIN list_dedicated_streamer_w_status AS dsl ON base.user_id = dsl.channel_id --only pull the records of dedicated streamers
  RIGHT JOIN list_3p_app_client_id AS the_3p_apps ON base.client_id = the_3p_apps.client_id --only pull the records of client apps that are 3rd party
  WHERE base.time<=(SELECT end_time FROM the_constants)
  GROUP BY 1,2,3,4
)

, logs_net_auth AS (
  SELECT *, 1 AS flag_is_oauth
  FROM (
    SELECT oauth.user_id, oauth.status, oauth.client_id, oauth.app_name
    , oauth.latest_oauth_time, deauth.latest_deauth_time
    FROM logs_oauth AS oauth
    LEFT JOIN logs_deauth AS deauth ON oauth.user_id = deauth.user_id AND oauth.client_id = deauth.client_id
  )
  WHERE latest_deauth_time IS NULL OR latest_oauth_time>latest_deauth_time
)

, data_numerator AS (
  SELECT status, COUNT(DISTINCT user_id) AS users_net_auth, COUNT(1) AS rows_net_auth
  FROM logs_net_auth
  GROUP BY 1
)
, data_denominator AS (
  SELECT status, COUNT(DISTINCT channel_id) AS users_total, COUNT(1) AS rows_total
  FROM list_dedicated_streamer_w_status
  GROUP BY 1
)

SELECT base.status, base.users_net_auth, other.users_total, base.users_net_auth::FLOAT / other.users_total::FLOAT AS pct_3p_connection
, base.rows_net_auth, other.rows_total
FROM data_numerator AS base
LEFT JOIN data_denominator AS other ON base.status = other.status
