-- 30 day cohort of dedicated streamer turnover - how many were are new dedicated streamers
-- , how many lapsed. 6 month backwards looking window with monthly cohorts, if possible.
-- (note: to simplify just compare current month to previous month)

WITH
list_2017_05 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_05
)
, list_2017_06 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_06
)
, list_2017_07 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_07
)
, list_2017_08 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_08
)
, list_2017_09 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_09
)
, list_2017_10 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_10
)
, list_2017_11 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_11
)
, list_2017_12 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2017_12
)
, list_2018_01 AS (
  SELECT *
  FROM analysis.dsds170_dedicated_streamer_list_2018_01
)
, data_2017_06 AS (
  SELECT '2017-06-01' AS the_date
  , COUNT(DISTINCT list_2017_05.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_05.channel_id IS NULL AND list_2017_06.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_05.channel_id IS NOT NULL AND list_2017_06.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_05.channel_id IS NULL AND list_2017_06.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_05.channel_id IS NOT NULL AND list_2017_06.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2017_06.channel_id) AS total_dedicated_channels_now
  FROM list_2017_06
  FULL OUTER JOIN list_2017_05 ON list_2017_06.channel_id = list_2017_05.channel_id
  GROUP BY 1
)
, data_2017_07 AS (
  SELECT '2017-07-01' AS the_date
  , COUNT(DISTINCT list_2017_06.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_06.channel_id IS NULL AND list_2017_07.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_06.channel_id IS NOT NULL AND list_2017_07.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_06.channel_id IS NULL AND list_2017_07.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_06.channel_id IS NOT NULL AND list_2017_07.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2017_07.channel_id) AS total_dedicated_channels_now
  FROM list_2017_07
  FULL OUTER JOIN list_2017_06 ON list_2017_07.channel_id = list_2017_06.channel_id
  GROUP BY 1
)
, data_2017_08 AS (
  SELECT '2017-08-01' AS the_date
  , COUNT(DISTINCT list_2017_07.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_07.channel_id IS NULL AND list_2017_08.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_07.channel_id IS NOT NULL AND list_2017_08.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_07.channel_id IS NULL AND list_2017_08.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_07.channel_id IS NOT NULL AND list_2017_08.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2017_08.channel_id) AS total_dedicated_channels_now
  FROM list_2017_08
  FULL OUTER JOIN list_2017_07 ON list_2017_08.channel_id = list_2017_07.channel_id
  GROUP BY 1
)
, data_2017_09 AS (
  SELECT '2017-09-01' AS the_date
  , COUNT(DISTINCT list_2017_08.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_08.channel_id IS NULL AND list_2017_09.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_08.channel_id IS NOT NULL AND list_2017_09.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_08.channel_id IS NULL AND list_2017_09.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_08.channel_id IS NOT NULL AND list_2017_09.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2017_09.channel_id) AS total_dedicated_channels_now
  FROM list_2017_09
  FULL OUTER JOIN list_2017_08 ON list_2017_09.channel_id = list_2017_08.channel_id
  GROUP BY 1
)
, data_2017_10 AS (
  SELECT '2017-10-01' AS the_date
  , COUNT(DISTINCT list_2017_09.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_09.channel_id IS NULL AND list_2017_10.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_09.channel_id IS NOT NULL AND list_2017_10.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_09.channel_id IS NULL AND list_2017_10.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_09.channel_id IS NOT NULL AND list_2017_10.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2017_10.channel_id) AS total_dedicated_channels_now
  FROM list_2017_10
  FULL OUTER JOIN list_2017_09 ON list_2017_10.channel_id = list_2017_09.channel_id
  GROUP BY 1
)
, data_2017_11 AS (
  SELECT '2017-11-01' AS the_date
  , COUNT(DISTINCT list_2017_10.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_10.channel_id IS NULL AND list_2017_11.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_10.channel_id IS NOT NULL AND list_2017_11.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_10.channel_id IS NULL AND list_2017_11.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_10.channel_id IS NOT NULL AND list_2017_11.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2017_11.channel_id) AS total_dedicated_channels_now
  FROM list_2017_11
  FULL OUTER JOIN list_2017_10 ON list_2017_11.channel_id = list_2017_10.channel_id
  GROUP BY 1
)
, data_2017_12 AS (
  SELECT '2017-12-01' AS the_date
  , COUNT(DISTINCT list_2017_11.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_11.channel_id IS NULL AND list_2017_12.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_11.channel_id IS NOT NULL AND list_2017_12.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_11.channel_id IS NULL AND list_2017_12.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_11.channel_id IS NOT NULL AND list_2017_12.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2017_12.channel_id) AS total_dedicated_channels_now
  FROM list_2017_12
  FULL OUTER JOIN list_2017_11 ON list_2017_12.channel_id = list_2017_11.channel_id
  GROUP BY 1
)
, data_2018_01 AS (
  SELECT '2018-01-01' AS the_date
  , COUNT(DISTINCT list_2017_12.channel_id) AS total_dedicated_channels_prev
  , SUM(CASE WHEN list_2017_12.channel_id IS NULL AND list_2018_01.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
  , SUM(CASE WHEN list_2017_12.channel_id IS NOT NULL AND list_2018_01.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
  , SUM(CASE WHEN list_2017_12.channel_id IS NULL AND list_2018_01.channel_id IS NOT NULL THEN 1 ELSE 0 END) - SUM(CASE WHEN list_2017_12.channel_id IS NOT NULL AND list_2018_01.channel_id IS NULL THEN 1 ELSE 0 END) AS net_new_dedicated
  , COUNT(DISTINCT list_2018_01.channel_id) AS total_dedicated_channels_now
  FROM list_2018_01
  FULL OUTER JOIN list_2017_12 ON list_2018_01.channel_id = list_2017_12.channel_id
  GROUP BY 1
)


, final_data AS (
  SELECT * FROM data_2017_06
  UNION ALL SELECT * FROM data_2017_07
  UNION ALL SELECT * FROM data_2017_08
  UNION ALL SELECT * FROM data_2017_09
  UNION ALL SELECT * FROM data_2017_10
  UNION ALL SELECT * FROM data_2017_11
  UNION ALL SELECT * FROM data_2017_12
  UNION ALL SELECT * FROM data_2018_01
)
SELECT *
FROM final_data
ORDER BY the_date








-- SELECT '2017-06-01' AS the_date
-- , SUM(CASE WHEN list_2017_05.channel_id IS NOT NULL AND list_2017_06.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_returning_dedicated
-- , SUM(CASE WHEN list_2017_05.channel_id IS NULL AND list_2017_06.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
-- , SUM(CASE WHEN list_2017_05.channel_id IS NOT NULL AND list_2017_06.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
-- , SUM(CASE WHEN list_2017_05.channel_id IS NULL AND list_2017_06.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_error
-- , COUNT(DISTINCT list_2017_05.channel_id) AS total_dedicated_channels_prev
-- , COUNT(DISTINCT list_2017_06.channel_id) AS total_dedicated_channels_now
-- , COUNT(1) AS rows
-- FROM list_2017_06
-- FULL OUTER JOIN list_2017_05 ON list_2017_06.channel_id = list_2017_05.channel_id
-- GROUP BY 1




-- , the_2017_06_01_returning_dedicated AS (
--   SELECT '2017-06-01'::TIMESTAMP AS the_date
--   , SUM(CASE WHEN list_2017_05.channel_id IS NOT NULL AND list_2017_06.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_returning_dedicated
--   FROM list_2017_06
--   INNER JOIN list_2017_05 ON list_2017_06.channel_id = list_2017_05.channel_id
-- )
-- , the_2017_06_01_new_dedicated AS (
--   SELECT '2017-06-01'::TIMESTAMP AS the_date
--   , SUM(CASE WHEN list_2017_05.channel_id IS NULL AND list_2017_06.channel_id IS NOT NULL THEN 1 ELSE 0 END) AS channels_is_new_dedicated
--   FROM list_2017_06
--   LEFT JOIN list_2017_05 ON list_2017_06.channel_id = list_2017_05.channel_id
-- )
-- , the_2017_06_01_lapsed AS (
--   SELECT '2017-06-01'::TIMESTAMP AS the_date
--   , SUM(CASE WHEN list_2017_05.channel_id IS NOT NULL AND list_2017_06.channel_id IS NULL THEN 1 ELSE 0 END) AS channels_is_lapsed
--   FROM list_2017_06
--   RIGHT JOIN list_2017_05 ON list_2017_06.channel_id = list_2017_05.channel_id
-- )
-- , the_2017_06_01_total AS (
--   SELECT '2017-06-01'::TIMESTAMP AS the_date, COUNT(DISTINCT channel_id) AS total_dedicated_channel
--   FROM list_2017_06
-- )
-- , the_2017_06_01_total_prev AS (
--   SELECT '2017-06-01'::TIMESTAMP AS the_date, COUNT(DISTINCT channel_id) AS total_dedicated_channel_prev
--   FROM list_2017_05
-- )
-- , the_2017_06_01_final AS (
--   SELECT base1.the_date, base1.total_dedicated_channel, base2.channels_is_returning_dedicated, base3.channels_is_new_dedicated, base4.channels_is_lapsed, base5.total_dedicated_channel_prev
--   FROM the_2017_06_01_total AS base1
--   LEFT JOIN the_2017_06_01_returning_dedicated AS base2 ON base1.the_date = base2.the_date
--   LEFT JOIN the_2017_06_01_new_dedicated AS base3 ON base1.the_date = base3.the_date
--   LEFT JOIN the_2017_06_01_lapsed AS base4 ON base1.the_date = base4.the_date
--   LEFT JOIN the_2017_06_01_total_prev AS base5 ON base1.the_date = base5.the_date
-- )
--
-- SELECT * FROM the_2017_06_01_final
