-- by yanghung
-- generate list of channels along with their partner/affiliate status
DROP TABLE IF EXISTS    analysis.dsds170_broadcaster_status_list;
CREATE TABLE    analysis.dsds170_broadcaster_status_list    AS


WITH
affiliates_log AS (
  SELECT channel_id, MAX('affiliate') AS status
  FROM analysis.current_affiliates
  GROUP BY 1
)
, partners_log AS (
  SELECT user_id AS channel_id, MAX('partner') AS status
  FROM analysis.sitedb_partner_channels
  GROUP BY 1
)
, affiliate_no_partners_log AS (
  SELECT channel_id, status
  FROM (
    SELECT base.channel_id, base.status, CASE WHEN pl.status IS NOT NULL THEN 1 ELSE 0 END AS flag_is_partner
    FROM affiliates_log AS base
    LEFT JOIN partners_log AS pl on base.channel_id = pl.channel_id
  )
  WHERE flag_is_partner =0
)

, final_log AS (
  SELECT '2018-01-29' AS the_date, * FROM affiliate_no_partners_log
  UNION ALL SELECT '2018-01-29' AS the_date, * FROM partners_log
)

SELECT * FROM final_log
