WITH
the_constants AS (
  SELECT 'yztietbcg0k8z93cg78q2o18uchewz' AS extension_id
)


, extension_lifecycle_logs AS (
  SELECT "time", user_id, extension_id, extension_version, state
  FROM logs.extension_lifecycle
  WHERE extension_id = (SELECT extension_id FROM the_constants)
)

, extension_create_logs AS (
  SELECT "time", user_id, extension_id, extension_version, state
  FROM logs.extension_create
  WHERE extension_id = (SELECT extension_id FROM the_constants)
)

, final_logs AS(
  SELECT * FROM extension_lifecycle_logs
  UNION ALL SELECT * FROM extension_create_logs
)

SELECT * FROM final_logs ORDER BY 1
