
--# of Unique Logged In Devices (Web only) in Dedicated channel w/ Digital Good Extension row 16
--https://docs.google.com/spreadsheets/d/1sxkI3v3w5dh4VhbE9ur14ys-iLAsALcg-Fp10VA3igA/edit?ts=5a399fb0#gid=246267467



-- Dedicated broadcasters are defined as broadcasters who has streamed at least 10 minutes per day on average in a given time period.











CREATE TEMP TABLE the_temp_table (
  the_month                                         TIMESTAMP
  , start_date                                      TIMESTAMP
  , end_date                                        TIMESTAMP
  , num_dedicated_streamers                         BIGINT
  , num_dedicated_with_extensions                   BIGINT
  , num_dedicated_with_digital_goods_extensions     BIGINT
);




PREPARE the_insert_function (int) AS
INSERT INTO the_temp_table
(

WITH

the_digital_goods_extensions AS (
  SELECT '3v9falpvk6qw6n5i4okm3xo3bazg8t' AS extension_id
  UNION ALL SELECT 'a23mttohd32cjppls8v1p9vr0sb0on' AS extension_id
  UNION ALL SELECT 'thc81rw29g1gsukw0f4mfeczxltio3' AS extension_id
)
, the_time_constants AS (
  SELECT DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours')) AS end_date
)
, the_basetable_date AS (
  SELECT row_number() OVER (ORDER BY the_month asc) as the_row_index, *
  FROM (
    SELECT
      DATE_TRUNC('month', date) AS the_month, MIN(date) AS start_date, MAX(date) AS end_date
    FROM metadata.date
    WHERE date>='2017-10-01' AND date<(SELECT end_date FROM the_time_constants)
    GROUP BY 1
  )
  ORDER BY 1
)

, the_selected_month AS (
  SELECT the_month, start_date, end_date
  FROM the_basetable_date
  WHERE the_row_index = $1
)

, the_timeframe AS (
  SELECT start_date AS start_time, end_date + INTERVAL '1 day' - INTERVAL '1 second' AS end_time FROM the_selected_month
)

, channels_with_extensions_list AS (
  SELECT channel_id, COUNT(1) AS active_extensions, MAX(1) AS flag_is_activated
  FROM rollups.extension_daily_channel_presence
  WHERE the_day=(SELECT DATE_TRUNC('day',end_time) FROM the_timeframe)
  AND bool_extension_activated
  AND extension_id IN ('3v9falpvk6qw6n5i4okm3xo3bazg8t','a23mttohd32cjppls8v1p9vr0sb0on','thc81rw29g1gsukw0f4mfeczxltio3')--m10n extensions
  GROUP BY 1
)

, dedicated_streamer_list AS (
  SELECT *
  FROM (
    SELECT channel_id, SUM(1)::float / DATE_PART(day, LAST_DAY(MAX(time))) AS mb_per_day
    FROM logs.channel_concurrents
    WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
    GROUP BY 1
  )
  WHERE mb_per_day>=10
)

, dedicated_streamer_with_extension_list AS (
  SELECT channel_id
  FROM (
    SELECT dsl.*, cwel.flag_is_activated, cwel.active_extensions
    FROM dedicated_streamer_list AS dsl
    LEFT JOIN channels_with_extensions_list AS cwel ON dsl.channel_id = cwel.channel_id
  )
  WHERE flag_is_activated=1
  GROUP BY 1
)

, final_data AS (
  SELECT COUNT(DISTINCT device_id) AS devices_in, COUNT(DISTINCT channel_id) AS dedicated_channels
  FROM logs.extension_render
  WHERE channel_id IN (SELECT channel_id FROM dedicated_streamer_with_extension_list)
  AND time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
)

SELECT * FROM final_data


, channels_with_extensions_list AS (
  SELECT base.channel_id, COUNT(1) AS active_extensions, MAX(1) AS flag_is_activated
  , MAX(CASE WHEN digital.extension_id IS NOT NULL THEN 1 ELSE 0 END) AS flag_is_activated_digital_goods
  FROM rollups.extension_daily_channel_presence AS base
  LEFT JOIN the_digital_goods_extensions AS digital ON base.extension_id = digital.extension_id
  WHERE base.the_day=(SELECT DATE_TRUNC('day',end_time) FROM the_timeframe)
  AND base.extension_id IN (SELECT extension_id FROM analysis.released_extensions_latest)
  AND base.bool_extension_activated
  --AND extension_id IN ('3v9falpvk6qw6n5i4okm3xo3bazg8t','a23mttohd32cjppls8v1p9vr0sb0on','thc81rw29g1gsukw0f4mfeczxltio3')--m10n extensions
  GROUP BY 1
)

, dedicated_streamer_list AS (
  SELECT *
  FROM (
    SELECT channel_id, SUM(1)::float / DATE_PART(day, LAST_DAY(MAX(time))) AS mb_per_day
    FROM logs.channel_concurrents
    WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
    GROUP BY 1
  )
  WHERE mb_per_day>=10
)

, final_data AS (
  SELECT the_selected_month.the_month, the_selected_month.start_date, the_selected_month.end_date
    , num_dedicated_streamers, num_dedicated_with_extensions
  FROM (
    SELECT COUNT(DISTINCT channel_id) AS num_dedicated_streamers, SUM(flag_is_activated) AS num_dedicated_with_extensions
    , SUM(flag_is_activated_digital_goods) AS num_dedicated_with_digital_goods_extensions
    FROM (
      SELECT dsl.channel_id, dsl.mb_per_day, cwel.flag_is_activated, cwel.active_extensions, cwel.flag_is_activated_digital_goods
      FROM dedicated_streamer_list AS dsl
      LEFT JOIN channels_with_extensions_list AS cwel ON dsl.channel_id = cwel.channel_id
    )
  ) AS base
  LEFT JOIN the_selected_month ON 1=1
)

SELECT * FROM final_data



);



EXECUTE the_insert_function (1); --2017-10-01
EXECUTE the_insert_function (2);
EXECUTE the_insert_function (3); --2017-12-01
EXECUTE the_insert_function (4); --2018-01-01
EXECUTE the_insert_function (5);
EXECUTE the_insert_function (6);
EXECUTE the_insert_function (7);
EXECUTE the_insert_function (8);
EXECUTE the_insert_function (9); --2018-06-01
EXECUTE the_insert_function (10);
EXECUTE the_insert_function (11);
EXECUTE the_insert_function (12);
EXECUTE the_insert_function (13);
EXECUTE the_insert_function (14);
EXECUTE the_insert_function (15); --2018-12-01




DEALLOCATE the_insert_function;

SELECT * FROM the_temp_table WHERE the_month IS NOT NULL ORDER BY the_month;















WITH
the_timeframe AS (
SELECT '2017-05-01 00:00:00'::timestamp AS start_time_extensions
-- , '2017-10-01 00:00:00'::timestamp AS start_time
-- , '2017-10-31 23:59:59'::timestamp AS end_time
, '2017-11-01 00:00:00'::timestamp AS start_time
, '2017-11-30 23:59:59'::timestamp AS end_time
-- , '2017-12-01 00:00:00'::timestamp AS start_time
-- , '2017-12-31 23:59:59'::timestamp AS end_time
--, DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours'))::timestamp  - INTERVAL '0 seconds' AS start_time_this_month
--, DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours'))::timestamp  + INTERVAL '1 months' - INTERVAL '1 seconds' AS end_time_this_month
)


, channels_with_extensions_list AS (
  SELECT channel_id, COUNT(1) AS active_extensions, MAX(1) AS flag_is_activated
  FROM rollups.extension_daily_channel_presence
  WHERE the_day=(SELECT DATE_TRUNC('day',end_time) FROM the_timeframe)
  --AND extension_id IN (SELECT extension_id FROM analysis.released_extensions_latest)
  AND bool_extension_activated
  AND extension_id IN ('3v9falpvk6qw6n5i4okm3xo3bazg8t','a23mttohd32cjppls8v1p9vr0sb0on','thc81rw29g1gsukw0f4mfeczxltio3')--m10n extensions
  GROUP BY 1
)

, dedicated_streamer_list AS (
  SELECT *
  FROM (
    SELECT channel_id, SUM(1)::float / DATE_PART(day, LAST_DAY(MAX(time))) AS mb_per_day
    FROM logs.channel_concurrents
    WHERE time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
    GROUP BY 1
  )
  WHERE mb_per_day>=10
)

, dedicated_streamer_with_extension_list AS (
  SELECT channel_id
  FROM (
    SELECT dsl.*, cwel.flag_is_activated, cwel.active_extensions--, cwel.channel_id
    FROM dedicated_streamer_list AS dsl
    LEFT JOIN channels_with_extensions_list AS cwel ON dsl.channel_id = cwel.channel_id
  )
  WHERE flag_is_activated=1
  GROUP BY 1
)

, final_data AS (
  SELECT COUNT(DISTINCT device_id) AS devices, COUNT(DISTINCT channel_id) AS dedicated_channels, COUNT(DISTINCT device_id)::float/COUNT(DISTINCT channel_id)::float AS devices_per_dedicated_channel
  FROM logs.extension_render
  WHERE channel_id IN (SELECT channel_id FROM dedicated_streamer_with_extension_list)
  AND time>=(SELECT start_time FROM the_timeframe) AND time<=(SELECT end_time FROM the_timeframe)
)

SELECT * FROM final_data
