-- -- The UI Interaction table

-- -- select interaction, target_user_id, login , platform, cell_name, item_name
-- -- from logs.ui_interaction
-- -- where time >= '2018-06-27 00:00:00'::timestamp  and target_user_id = 136549157

-- -- The Extension Render Table

select extract(month from base.time) as the_month, base.platform, base.extension_id, extensions.extension_name, count(distinct base.device_id) as devices
from logs.extension_render as base
join analysis.released_extensions_latest as extensions
on base.extension_id = extensions.extension_id
where base.time >= '2018-01-27 00:00:00'::timestamp
AND platform IN ('ios', 'android')
group by 1,2, 3, 4
order by 4 desc, 2, 1 ASC

-- -- Test Events

-- select time::timestamp::date, platform, login, extension_id
-- from logs.extension_render
-- where time >= '2018-01-27 00:00:00'::timestamp and channel_id = 136549157 and login like 'a_dot_burr'
-- order by 1 desc
-- limit 200


-- WITH
-- render AS (
--   SELECT 'render' AS the_table, "time" AS the_time, channel_id, channel, login_id, login, extension_id, platform
--   FROM logs.extension_render
-- where time >= '2018-01-27 00:00:00'::timestamp and channel_id IN (136549157,215166120) and login_id IN ( 227436643,205376024,155528531,154499793)

-- )
-- , mouse AS (
--   SELECT 'mouse' AS the_table, "time" AS the_time, channel_id, channel, login_id, login, extension_id, platform
--   FROM logs.extension_mouseenter
-- where time >= '2018-01-27 00:00:00'::timestamp and channel_id IN (136549157,215166120) and login_id IN ( 227436643,205376024,155528531,154499793)

-- )
-- , click AS (
--   SELECT 'click' AS the_table, "time" AS the_time, channel_id, channel, login_id, login, extension_id, platform
--   FROM logs.extension_click
-- where time >= '2018-01-27 00:00:00'::timestamp and channel_id IN (136549157,215166120) and login_id IN ( 227436643,205376024,155528531,154499793)

-- )

-- SELECT * FROM (
-- SELECT * FROM render
-- UNION ALL SELECT * FROM mouse
-- UNION ALL SELECT * FROM click
-- )
-- ORDER BY login_id, the_time ASC
