-- Context: For Bits in Extensions launch, we will be including a marketing push
-- on 4/23 (at the earliest) to streamers and we will be directing streamers to
-- the Extensions Manager.  We want to be able to understand the impact of the
-- marketing on traffic to the Extension Manager.
--
-- Request:
--
-- Establish a baseline of Extension Manager page views
-- Establish a benchmark of marketing impact on a previous extension launch (e.g. Amazon Gear or Twitch Prime)

-- SELECT * FROM analysis.dsds190_wbr_timeframe ORDER BY 1,2;
--  year | wbr_week_number |     start_time      |      end_time       |  join_key_end_date
--  2017 |              32 | 2017-08-07 00:00:00 | 2017-08-13 23:59:59 | 2017-08-13 00:00:00
--  2017 |              33 | 2017-08-14 00:00:00 | 2017-08-20 23:59:59 | 2017-08-20 00:00:00
--  2017 |              34 | 2017-08-21 00:00:00 | 2017-08-27 23:59:59 | 2017-08-27 00:00:00
--  2017 |              35 | 2017-08-28 00:00:00 | 2017-09-03 23:59:59 | 2017-09-03 00:00:00
--  2017 |              36 | 2017-09-04 00:00:00 | 2017-09-10 23:59:59 | 2017-09-10 00:00:00
--  2017 |              37 | 2017-09-11 00:00:00 | 2017-09-17 23:59:59 | 2017-09-17 00:00:00
--  2017 |              38 | 2017-09-18 00:00:00 | 2017-09-24 23:59:59 | 2017-09-24 00:00:00
--  2017 |              39 | 2017-09-25 00:00:00 | 2017-10-01 23:59:59 | 2017-10-01 00:00:00
--  2017 |              40 | 2017-10-02 00:00:00 | 2017-10-08 23:59:59 | 2017-10-08 00:00:00
--  2017 |              41 | 2017-10-09 00:00:00 | 2017-10-15 23:59:59 | 2017-10-15 00:00:00
-- ....
--  2018 |              14 | 2018-04-02 00:00:00 | 2018-04-08 23:59:59 | 2018-04-08 00:00:00

-- Here are the campaign dates for Gear on Amazon.
-- I don't believe any of the comms drove directly to the Gear on Amazon detail page.

-- 9/6 - Press Release soft launch (Extensions)
-- 9/14  Blog  drove to Extension Manager, not Extension detail page (requesting metrics)
-- 9/14  Twitter  drove to blog (requesting metrics)
-- 9/28 - Launch Email
-- Sends: 82,217
-- Open rate: 28.62%
-- Click-through rate: 5.84%
-- 11/21  Rate Increase Email  drove to https://www.twitch.tv/p/extensions/gear-on-amazon/
-- Sends: 53,485
-- Open rate: 18.24%
-- Click-through rate: 1.97%
-- Marketing plan and assets are below:
-- Marketing Plan
-- Assets

WITH
the_time_constants AS (
  SELECT year, wbr_week_number, start_time, end_time, join_key_end_date
  FROM analysis.dsds190_wbr_timeframe
  WHERE start_time>= '2017-08-07 00:00:00' AND end_time<='2018-04-08 23:59:59'
  ORDER BY 1,2
)

, pageview_logs AS (
  SELECT "time", user_id, url
  FROM logs.pageview
  WHERE time>= '2017-08-07 00:00:00' AND time<='2018-04-08 23:59:59'
  AND url LIKE 'https://www.twitch.tv/%/dashboard/extensions%'
)


SELECT tc.year, tc.wbr_week_number, tc.start_time, tc.end_time, COUNT(DISTINCT base.user_id) AS users, COUNT(1) AS rows
FROM pageview_logs AS base
RIGHT JOIN the_time_constants AS tc ON tc.start_time <= base.time AND base.time <= tc.end_time
GROUP BY 1,2,3,4
ORDER BY 1,2
