
WITH
the_time_constants AS (
  SELECT
  '2018-04-08 00:00:00'::TIMESTAMP AS channel_status_lookup_time
  , '2018-04-12 00:00:00'::TIMESTAMP - INTERVAL '30 days' AS start_time
  , '2018-04-12 00:00:00'::TIMESTAMP AS end_time
)

, partner_affiliate_lookup AS (
  SELECT channel_id AS user_id, category
  FROM analysis.dsds190_channel_partner_affiliate
  WHERE the_date = (SELECT channel_status_lookup_time FROM the_time_constants)
)

, ccu_tier_lookup AS (
  SELECT channel_id AS user_id, tier
  FROM analysis.dsds190_channel_ccu_tier
  WHERE the_date = (SELECT channel_status_lookup_time FROM the_time_constants)
)

, activated_extensions_log AS (
  SELECT user_id, 1 AS flag_activated_extension
  FROM logs.extension_activate
  GROUP BY 1
)

, final_data AS (
  SELECT *
  FROM (
    SELECT ctl.user_id, ael.flag_activated_extension
    , NVL(spo.account_owner, 'account_owner_not_found') AS account_owner
    , NVL(pal.category, 'non_partner_affiliate') AS category
    , NVL(ctl.tier, 'T0: 0-2 CCU') AS tier
    FROM ccu_tier_lookup AS ctl
    LEFT JOIN partner_affiliate_lookup AS pal ON ctl.user_id = pal.user_id
    LEFT JOIN activated_extensions_log AS ael ON ctl.user_id = ael.user_id
    LEFT JOIN analysis.salesforce_partner_owners AS spo ON ctl.user_id = spo.channel_id
  )
  WHERE flag_activated_extension IS NULL
)


-- CHECK TO SEE THAT one row per user_id
-- SELECT * FROM (
--   SELECT user_id, COUNT(1) AS rows
--   FROM final_data
--   GROUP BY 1
-- )
-- WHERE rows>1

-- GET POPULATION COUNTS FOR EACH CATEGORY
-- SELECT category, tier, COUNT(DISTINCT user_id) AS users, COUNT(1) AS rows
-- FROM final_data
-- GROUP BY 1,2
-- ORDER BY 1,2



, partner_users0 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='partner' AND tier = 'T0: 0-2 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, partner_users1 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='partner' AND tier = 'T1: 2-25 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, partner_users2 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='partner' AND tier = 'T2: 25-200 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, partner_users3 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='partner' AND tier = 'T3: 200-2000 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, partner_users4 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='partner' AND tier = 'T4: 2000+ CCU'
  ORDER BY RANDOM()
  LIMIT 25
)


, affiliate_users0 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='affiliate' AND tier = 'T0: 0-2 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, affiliate_users1 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='affiliate' AND tier = 'T1: 2-25 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, affiliate_users2 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='affiliate' AND tier = 'T2: 25-200 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, affiliate_users3 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='affiliate' AND tier = 'T3: 200-2000 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, affiliate_users4 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='affiliate' AND tier = 'T4: 2000+ CCU'
  ORDER BY RANDOM()
  LIMIT 25
)

, other_users0 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='non_partner_affiliate' AND tier = 'T0: 0-2 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, other_users1 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='non_partner_affiliate' AND tier = 'T1: 2-25 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, other_users2 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='non_partner_affiliate' AND tier = 'T2: 25-200 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, other_users3 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='non_partner_affiliate' AND tier = 'T3: 200-2000 CCU'
  ORDER BY RANDOM()
  LIMIT 25
)
, other_users4 AS (
  SELECT user_id, category, tier, account_owner
  FROM final_data
  WHERE category='non_partner_affiliate' AND tier = 'T4: 2000+ CCU'
  ORDER BY RANDOM()
  LIMIT 25
)

SELECT *
FROM (
  SELECT * FROM partner_users0
  UNION ALL SELECT * FROM partner_users1
  UNION ALL SELECT * FROM partner_users2
  UNION ALL SELECT * FROM partner_users3
  UNION ALL SELECT * FROM partner_users4

  UNION ALL SELECT * FROM affiliate_users0
  UNION ALL SELECT * FROM affiliate_users1
  UNION ALL SELECT * FROM affiliate_users2
  UNION ALL SELECT * FROM affiliate_users3
  UNION ALL SELECT * FROM affiliate_users4

  UNION ALL SELECT * FROM other_users0
  UNION ALL SELECT * FROM other_users1
  UNION ALL SELECT * FROM other_users2
  UNION ALL SELECT * FROM other_users3
  UNION ALL SELECT * FROM other_users4
)
ORDER BY category, tier
