--
--
-- SELECT 'analysis.dsds238_monthly_data_final' AS the_table, the_month, COUNT(1) AS rows, COUNT(DISTINCT extension_id) AS extensions, COUNT(DISTINCT channel_id) AS channels
-- , COUNT(DISTINCT user_id) AS users, COUNT(DISTINCT device_id) AS devices, COUNT(DISTINCT viewer_id) AS viewers
-- FROM analysis.dsds238_monthly_data_final
-- GROUP BY 1,2
-- ORDER BY 1,2
-- ;

-- SELECT *
-- FROM (
--   SELECT base.the_month, base.extension_id, rel.extension_name, COUNT(DISTINCT base.channel_id) AS channels, COUNT(DISTINCT base.viewer_id) AS viewers_w_5mp
--   FROM analysis.dsds238_monthly_data_final AS base
--   LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
--   WHERE the_month = '2018-03-01'::TIMESTAMP
--   GROUP BY 1,2,3
-- )
-- ORDER BY viewers_w_5mp DESC


WITH
final_data AS (
  SELECT base.the_month, base.extension_id, rel.extension_name, COUNT(DISTINCT base.channel_id) AS channels, COUNT(DISTINCT base.viewer_id) AS viewers_w_5mp
  FROM analysis.released_extensions_latest AS rel
  LEFT JOIN analysis.dsds238_monthly_data_final AS base ON base.extension_id = rel.extension_id
  GROUP BY 1,2,3
)

, the_data AS (
  SELECT extension_id, extension_name
  , SUM(CASE WHEN the_month = '2018-01-01'::TIMESTAMP THEN channels ELSE 0 END) AS channels_2018_jan
  , SUM(CASE WHEN the_month = '2018-02-01'::TIMESTAMP THEN channels ELSE 0 END) AS channels_2018_feb
  , SUM(CASE WHEN the_month = '2018-03-01'::TIMESTAMP THEN channels ELSE 0 END) AS channels_2018_mar
  , SUM(CASE WHEN the_month = '2018-01-01'::TIMESTAMP THEN viewers_w_5mp ELSE 0 END) AS viewers_w_5mp_2018_jan
  , SUM(CASE WHEN the_month = '2018-02-01'::TIMESTAMP THEN viewers_w_5mp ELSE 0 END) AS viewers_w_5mp_2018_feb
  , SUM(CASE WHEN the_month = '2018-03-01'::TIMESTAMP THEN viewers_w_5mp ELSE 0 END) AS viewers_w_5mp_2018_mar
  FROM final_data
  GROUP BY 1,2
)

SELECT * FROM the_data
ORDER BY viewers_w_5mp_2018_mar DESC
