DROP TABLE IF EXISTS    analysis.dsds238_monthly_5mp_devices;
CREATE TABLE    analysis.dsds238_monthly_5mp_devices    AS

WITH

time_constants AS (
  SELECT '2018-01-01' AS start_time, '2018-04-01' AS end_time
)

, final_data AS (
  SELECT DATE_TRUNC('month', time) AS the_month, channel_id, user_id, device_id
  FROM rollups.five_minute_plays
  WHERE time>=(SELECT start_time FROM time_constants) AND time<(SELECT end_time FROM time_constants)
  GROUP BY 1,2,3,4
)

SELECT * FROM final_data
