
WITH

time_constants AS (
  SELECT '2018-01-01' AS start_time, '2018-04-01' AS end_time
)
, devices_with_5mp AS (
  SELECT DATE_TRUNC('month', time) AS the_month, device_id, user_id
  FROM rollups.five_minute_plays
  WHERE time>=(SELECT start_time FROM time_constants) AND time<(SELECT end_time FROM time_constants)
  GROUP BY 1,2,3
)
-- , viewer_lookup AS (
--   SELECT device_id, user_id, viewer_id
--   FROM rollups.daily_viewers
--   WHERE day>=(SELECT start_time FROM time_constants) AND day<(SELECT end_time FROM time_constants)
--   AND viewer_id != 0
--   GROUP BY 1,2,3
-- )

SELECT base.the_month, COUNT(DISTINCT lookup.viewer_id) AS viewers, COUNT(DISTINCT base.device_id) AS devices, COUNT(DISTINCT base.user_id) AS users
FROM devices_with_5mp AS base
LEFT JOIN analysis.dsds238_viewer_id_lookup AS lookup ON base.device_id = lookup.device_id
GROUP BY 1
ORDER BY 1


--       the_month      | viewers    | devices    |  users
-- ---------------------+------------+------------+----------
--  2018-01-01 00:00:00 | 53,113,028 | 73,153,550 | 21,891,023
--  2018-02-01 00:00:00 | 51,433,441 | 66,541,617 | 21,408,380
--  2018-03-01 00:00:00 | 61,621,806 | 81,458,179 | 25,638,051
