
with

the_urls_we_want AS (
  SELECT distinct url, extension_id
  FROM tahoe.extension_install_button_click
  WHERE time_utc>=current_timestamp-7
),

views as
(
  select base.time::timestamp::date as the_day, urls.extension_id, base.url,
  case when ap.is_affiliate then 'Affiliate'
  when ap.is_partner then 'Partner'
  else 'None'
  end as Category, base.user_id
  from logs.pageview as base
  join the_urls_we_want as urls
  on base.url = urls.url
  left join rollups.affiliates_partners_daily_channel_summary as ap
  on ap.day = base.time::timestamp::date and base.user_id = ap.channel_id
  where base.time_utc >= current_timestamp -7
  group by 1,2,3,4, 5

)
,

installs as
(
  select base.time::timestamp::date as the_day, base.extension_id , base.url,
  case when ap.is_affiliate then 'Affiliate'
  when ap.is_partner then 'Partner'
  else 'None'
  end as Category,  base.user_id
  from tahoe.extension_install_button_click as base
  left join rollups.affiliates_partners_daily_channel_summary as ap
  on ap.day = base.time::timestamp::date and base.user_id = ap.channel_id
  where base.time_utc >= current_timestamp -7 and base.user_id in (select user_id from views)
  group by 1,2,3,4,5
)
,


activations as
(
  select base.time::timestamp::date as the_day, base.extension_id,
  case when ap.is_affiliate then 'Affiliate'
  when ap.is_partner then 'Partner'
  else 'None'
  end as Category, base.user_id
  from logs.extension_activate as base
  left join rollups.affiliates_partners_daily_channel_summary as ap
  on ap.day = base.time::timestamp::date and base.user_id = ap.channel_id
  where base.time_utc >= current_timestamp -7 and base.user_id in (select user_id from installs)
  group by 1,2,3, 4

)
,

total_views as(
  select the_day, extension_id, category, count(user_id) as views
  from views
  group by 1,2,3
)
,

total_installs as (
  select the_day, extension_id, category, count(user_id) as installs
  from installs
  group by 1,2,3
),


total_activations as(
  select the_day, extension_id, category, count(user_id) as activations
  from activations
  group by 1,2,3

),

final as(
  select i.the_day, i.extension_id, extensions.extension_name, i.category, v.views, i.installs, a.activations,
  i.installs::float/v.views as conversion_views_installs,
  a.activations::float/i.installs as conversion_installs_activations
  from total_installs as i, total_views as v, total_activations as a, analysis.released_extensions_latest as extensions
  where i.the_day = v.the_day and v.the_day = a.the_day and i.extension_id = v.extension_id
  and v.extension_id = a.extension_id and i.extension_id = extensions.extension_id
  and i.category = v.category and v.category = a.category

)

select *
from final
