

{% form %}

start_time:
  type: text
  default: '2018-06-14 00:00:00'

end_time:
  type: text
  default: '2018-06-16 00:00:00'

{% endform %}



WITH

time_constants AS (
  SELECT '{{ start_time }}'::timestamp AS start_time, '{{ end_time }}::timestamp' AS end_time
),

categories AS (
  select *
  from analysis.dsds243_extension_categories_list
),

get_category_names AS(
  select extension_id,  concat(c.categoryname,' Category Page') as page, count(distinct base.user_id) as installs
  from tahoe.extension_install_button_click as base, categories as c
  where base.time>=(SELECT start_time FROM time_constants) AND base.time<(SELECT end_time FROM time_constants) and base.url LIKE '%www.twitch.tv/ext/categories%' and c.categoryid in (split_part(base.url, '/categories/',2))
  group by extension_id, page
),

the_logs AS (

SELECT
extension_id,
CASE
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions/manage%' THEN 'Extension Manager Page'
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions/whitelisted%' THEN 'Whitelisted'
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions%' THEN 'Discovery'
WHEN url LIKE '%www.twitch.tv/ext/search%' THEN 'Search Page'
WHEN url LIKE '%www.twitch.tv/ext%' THEN 'Extension Detail Page'
ELSE url
END AS page
, count(distinct user_id) as installs
FROM tahoe.extension_install_button_click
WHERE time>=(SELECT start_time FROM time_constants) AND time<(SELECT end_time FROM time_constants) and url not LIKE '%www.twitch.tv/ext/categories%'
GROUP BY extension_id, page
),

all_logs as (
  select * from the_logs
  union all
  select * from get_category_names
),

extensions as(
 select base.extension_name, base.extension_id, al.page,case when al.installs is not null then al.installs else 0 end as installs
 from analysis.released_extensions_latest as base
 left join all_logs as al
 on base.extension_id = al.extension_id
)


select *
from extensions
