with
the_urls_we_want AS (
  SELECT distinct url
  FROM tahoe.extension_install_button_click
  WHERE time_utc>=current_timestamp-30
)
, installs AS (

SELECT
time::timestamp::date as the_date,
CASE
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions/manage%' THEN 'Extension Manager Page'
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions/whitelisted%' THEN 'Whitelisted'
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions%' THEN 'Discovery'
WHEN url LIKE '%www.twitch.tv/ext/categories%' THEN 'Category Page'
WHEN url LIKE '%www.twitch.tv/ext/search%' THEN 'Search Page'
WHEN url LIKE '%www.twitch.tv/ext%' THEN 'Extension Detail Page'
ELSE url
END AS page,count(1) as installs, count(distinct user_id) as distinct_installs
FROM tahoe.extension_install_button_click
WHERE time_utc>=current_timestamp-30
GROUP BY page, the_date
),

views as
(
SELECT
time::timestamp::date as the_date,
CASE
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions/manage%' THEN 'Extension Manager Page'
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions/whitelisted%' THEN 'Whitelisted'
WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions%' THEN 'Discovery'
WHEN url LIKE '%www.twitch.tv/ext/categories%' THEN 'Category Page'
WHEN url LIKE '%www.twitch.tv/ext/search%' THEN 'Search Page'
WHEN url LIKE '%www.twitch.tv/ext%' THEN 'Extension Detail Page'
ELSE url
END AS page, url, count(1) as views, count(distinct user_id) as distinct_views
from logs.pageview
where time_utc>=current_timestamp-30 and url in (select * from the_urls_we_want)
group by page, url, the_date
)
,

views_final as
(
  select the_date, page, sum(views) as views, sum(distinct_views) as distinct_views
  from views
  group by page, the_date
),

final as
(
select v.the_date, v.page, v.views, v.distinct_views, (case when base.installs is not null then base.installs else 0 end) as installs, (case when base.distinct_installs is not null then base.distinct_installs else 0 end) as distinct_installs
from installs as base
right join views_final as v
on base.page = v.page and base.the_date = v.the_date
)

select *
from final
where page in ('Whitelisted','Category Page','Search Page','Extension Detail Page','Discovery')

order by page
