-- Request: List of Tier 4 partners in the US/Canada who have activated an extension in the last 30 days, along with the list of extensions they have used

WITH

the_timeframe AS (
  SELECT '2018-05-01 00:00:00'::TIMESTAMP AS start_time, '2018-06-01 00:00:00'::TIMESTAMP AS end_time
)

, channel_geo AS (
  SELECT user_id AS channel_id, country, login
  FROM analysis.sitedb_users
  WHERE UPPER(country) IN ('US','CA')
)

, channel_category AS (
  SELECT channel_id, category
  FROM analysis.channel_category AS base
  WHERE start_time<= (SELECT start_time FROM the_timeframe) AND (SELECT end_time FROM the_timeframe)<=end_time
  GROUP BY 1,2
)

, ccu_log AS (
  SELECT channel_id, total
  FROM logs.channel_concurrents
  WHERE time>=(SELECT start_time FROM the_timeframe) AND time<(SELECT end_time FROM the_timeframe)
)
, channel_tier AS (
  SELECT *
  , CASE
    WHEN avg_ccu<2 THEN 'T0: 0-2 CCU'
    WHEN avg_ccu<25 THEN 'T1: 2-25 CCU'
    WHEN avg_ccu<200 THEN 'T2: 25-200 CCU'
    WHEN avg_ccu<2000 THEN 'T3: 200-2000 CCU'
    WHEN avg_ccu>=2000 THEN 'T4: 2000+ CCU'
    ELSE 'T999: ERROR'
  END AS tier
  FROM (
    SELECT channel_id, AVG(total::float) as avg_ccu
    FROM ccu_log
    GROUP BY 1
  )
)

, the_channel_list AS (
  SELECT base.channel_id, tier, category, country, login
  FROM channel_tier AS base
  INNER JOIN channel_category AS cat ON base.channel_id = cat.channel_id
  INNER JOIN channel_geo AS geo ON base.channel_id = geo.channel_id
  WHERE base.tier='T4: 2000+ CCU'
  AND cat.category='partner'
  AND geo.country IN ('US','CA')
  GROUP BY 1,2,3,4,5
)

, extension_activations_log AS (
  SELECT user_id AS channel_id, extension_id, "time" AS the_time
  FROM logs.extension_activate
  WHERE user_id IN (SELECT channel_id FROM the_channel_list)
  AND time>=(SELECT start_time FROM the_timeframe) AND time<(SELECT end_time FROM the_timeframe)
)

SELECT base.channel_id, tcl.login AS channel_name, base.extension_id, REPLACE(rel.extension_name,',','') AS extension_name, base.the_time AS time_activated_extension, tcl.tier, tcl.category, tcl.country, NVL(spo.account_owner, 'account_owner_not_found') AS account_owner
FROM extension_activations_log AS base
LEFT JOIN the_channel_list AS tcl ON base.channel_id = tcl.channel_id
LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
LEFT JOIN analysis.salesforce_partner_owners AS spo ON base.channel_id = spo.channel_id
