with

bits_extensions as (
  select extension_id, extension_name
  from analysis.extensions_metadata_full
  where is_bits_enabled = true
),

streamers_installed as(
  SELECT base.time::timestamp::date as the_day, base.extension_id, be.extension_name, base.channel_id, su.display_name
  FROM logs.extension_install as base
  join bits_extensions as be
  on base.extension_id = be.extension_id
  left join analysis.sitedb_users as su
  on base.channel_id = su.user_id
  WHERE base.time>='2018-04-23 00:00:00'::timestamp
  GROUP BY 1,2,3,4,5
),

teir_classification as
( select sa.the_day, sa.extension_id, sa.extension_name, sa.channel_id, sa.display_name,
         case
          when avg(base.total::float) <= 2 then 'T0: 0-2 ccu'
          when avg(base.total::float) <= 25 then 'T1: 3-25 ccu'
          when avg(base.total::float) <= 200 then  'T2: 26-200 ccu'
          when avg(base.total::float) <= 2000 then  'T3: 201-2000 ccu'
          when avg(base.total::float) > 2000 then  'T4: 2001+ ccu'
         else 'Unknown'
         end as tier
  from logs.channel_concurrents as base
  join streamers_installed as sa
  on base.channel_id = sa.channel_id
  WHERE base.time>='2018-04-23 00:00:00'::timestamp
  group by 1,2,3,4,5
)
select *
from teir_classification
order by tier desc
