
with
views as(
  select time::date as the_day, user_id
  from logs.pageview
  where url like 'https://dev.twitch.tv/start/' and time>=current_timestamp -30
  group by 1,2

)

,clone_git as(
  select time::date as the_day, user_id
  from tahoe.devsite_button_click
  where label = 'user_visit_dev_rig_repo' and time_utc >= current_timestamp - 30
  group by 1,2
)

,sign_in as(
  select time::date as the_day, user_id
  from logs.oauth_authorize
  where client_id = 'rtwj27xsv591q1zcnqqfg7suduj4pq' and time_utc >= current_timestamp - 30 and user_id in (select user_id from clone_git)
  group by 1,2
)

,rig_token as(
  select time::date as the_day, user_id
  from tahoe.extension_rig_token_validation
  where time_utc >= current_timestamp - 30 and user_id in (select user_id from clone_git)
  group by 1,2
)

,online_mode_li as(
  select the_day, count(distinct user_id) as users
  from rig_token
  where user_id in (select user_id from sign_in)
  group by 1
)
,online_mode_lo as(
  select the_day, count(distinct user_id) as users
  from rig_token
  where user_id not in (select user_id from sign_in)
  group by 1
)

,local_mode as (
  select the_day, count(distinct user_id) as users
  from sign_in
  where user_id not in (select user_id from rig_token)
  group by 1

)

, dates as(
  select "date" as the_day
  from metadata.date
  where date >= current_timestamp::date - 30 and date < current_timestamp::date

)
, the_logs as (
select base.the_day,
case when oli.users is not null then oli.users else 0 end as online_logged_in,
case when olo.users is not null then olo.users else 0 end as online_logged_off,
case when lm.users is not null then lm.users else 0 end as local_mode
from dates as base
left join online_mode_li as oli
on base.the_day = oli.the_day
left join online_mode_lo as olo
on base.the_day = olo.the_day
left join local_mode as lm
on base.the_day = lm.the_day
)

, final as(
select base.the_day, count(v.user_id) as views, count(cg.user_id) as git_clones
from dates as base
left join views as v
on base.the_day = v.the_day
left join clone_git as cg
on v.the_day = cg.the_day and v.user_id = cg.user_id
group by 1
)

-- round(f.downloads::float/f.views,3) as conv_downld_views,
-- round(f.git_clones::float/f.views,3) as conv_clone_views,
-- round(l.online_logged_in::float/f.downloads,3) as conv_ol_li_dwnlds,
-- round(l.online_logged_off::float/f.downloads,3) as conv_ol_lo_dwnlds,
-- round(l.local_mode::float/f.downloads,3) as conv_local_dwnlds

select *
from final as f
join the_logs as l
on f.the_day = l.the_day
order by f.the_day asc
