with
bie_users as (
  select distinct extension_id, user_id
  from tahoe.extension_use_bits_complete
  where time >= '2018-04-23 00:00:00'::timestamp
)

, bie_users_count as(
  select extension_id, count(distinct user_id) as users
  from bie_users
  group by 1
)

, extensions as (
  select distinct extension_id, extension_name
  from analysis.extensions_metadata_full
  where is_bits_enabled = true

)

, latest_use as(
  select bu.user_id, bu.extension_id, max(base.time::date) as latest, (current_timestamp::date - max(base.time::date)) as days
  from tahoe.extension_use_bits_complete as base
  join bie_users as bu
  on base.user_id = bu.user_id and base.extension_id = bu.extension_id
  group by 1, 2

)

, logs as(
  select base.extension_name, base.extension_id, case when uc.users is null then 0 else uc.users end as users, count(distinct lu.user_id) as churn
  from extensions as base
  left join latest_use as lu
  on base.extension_id = lu.extension_id
  left join bie_users_count as uc
  on base.extension_id = uc.extension_id
  where lu.days >= 30
  group by 1,2,3
)


select *, churn::float /users::float as pct_churn
from logs
order by pct_churn asc
