-- CREATE TABLE analysis.dsds_281_extension_daily_version_sandbox AS
-- SELECT * FROM analysis.dsds_281_extension_daily_version_test;

CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds_281_extension_daily_version_sandbox);

PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table
(

  WITH
  the_constants AS (
    SELECT
      DATEADD(day, 1, $1::TIMESTAMP) AS range_start
      , DATEADD(day, 2, $1::TIMESTAMP) AS range_end
  )

  , last_known_version AS (
    SELECT
      the_day, extension_id, extension_version AS last_known_version
    FROM analysis.dsds_281_extension_daily_version_sandbox
    WHERE
      the_day=(SELECT range_start - INTERVAL '1 day' FROM the_constants)
      AND extension_id IS NOT NULL AND extension_version IS NOT NULL
  )

  , the_basetable_date AS (
    SELECT
      date::TIMESTAMP AS the_day
    FROM metadata.date
    WHERE
      date>=(SELECT range_start FROM the_constants)
      AND date<(SELECT range_end FROM the_constants)
    GROUP BY 1
  )
  , the_basetable_extension_date AS (
    SELECT table_date.the_day, table_ext.extension_id, table_ext.last_known_version
    FROM the_basetable_date AS table_date
    CROSS JOIN last_known_version table_ext
  )

  --get all the possible extension_id and extension_version combinations
  , the_render_logs_step1 AS (
    SELECT "time" AS the_time, extension_id, extension_version
    FROM tahoe.extension_render
    WHERE date>=(SELECT range_start FROM the_constants) AND date<(SELECT range_end FROM the_constants)
    GROUP BY 1,2,3
  )
  -- count the times each extension_id and extension_version combo occurs each day
  , the_render_logs_step2 AS (
    SELECT *, RANK() OVER (PARTITION BY the_day, extension_id ORDER BY rows DESC) AS row_count_rank
    FROM (
      SELECT DATE_TRUNC('day', the_time) AS the_day, extension_id, extension_version, COUNT(1) AS rows
      FROM the_render_logs_step1
      GROUP BY 1,2,3
    )
  )
  -- to break ties, select the max (latest) extension_version
  , the_render_logs_step3 AS (
    SELECT the_day, extension_id, MAX(extension_version) AS extension_version, rows, row_count_rank
    FROM the_render_logs_step2
    WHERE row_count_rank=1
    GROUP BY 1,2,4,5
  )

  , merged_data_step1 AS (
    SELECT base.the_day, base.extension_id, render.extension_version, base.last_known_version
    FROM the_basetable_extension_date AS base

    LEFT JOIN the_render_logs_step3 AS render
      ON base.the_day = render.the_day
      AND base.extension_id = render.extension_id
  )
  , final_data AS (
    SELECT $1::TIMESTAMP AS the_day, extension_id, NVL(extension_version, last_known_version) AS extension_version
    FROM merged_data_step1
  )


  SELECT * FROM final_data

);



--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (VARCHAR) AS
DELETE FROM analysis.dsds_281_extension_daily_version_sandbox
WHERE analysis.dsds_281_extension_daily_version_sandbox.the_day = DATEADD(day, 0, $1::TIMESTAMP)
;


-- EXECUTE the_insert_function ('2018-09-02');
-- EXECUTE the_insert_function ('2018-09-03');
-- EXECUTE the_insert_function ('2018-09-04');
-- EXECUTE the_insert_function ('2018-09-05');
-- EXECUTE the_insert_function ('2018-09-06');
-- EXECUTE the_insert_function ('2018-09-07');
-- EXECUTE the_insert_function ('2018-09-08');
-- EXECUTE the_insert_function ('2018-09-09');
-- EXECUTE the_insert_function ('2018-09-10');
-- EXECUTE the_insert_function ('2018-09-11');
-- EXECUTE the_insert_function ('2018-09-12');
-- EXECUTE the_insert_function ('2018-09-13');
-- EXECUTE the_insert_function ('2018-09-14');
EXECUTE the_insert_function ('2018-09-15');
EXECUTE the_insert_function ('2018-09-16');
EXECUTE the_insert_function ('2018-09-17');

SELECT the_day, COUNT(1) FROM the_temp_table
WHERE the_day>='2018-09-01'::TIMESTAMP
GROUP BY 1 ORDER BY 1;



-- EXECUTE the_delete_function ('2018-09-02');
-- EXECUTE the_delete_function ('2018-09-03');
-- EXECUTE the_delete_function ('2018-09-04');
-- EXECUTE the_delete_function ('2018-09-05');
-- EXECUTE the_delete_function ('2018-09-06');
-- EXECUTE the_delete_function ('2018-09-07');
-- EXECUTE the_delete_function ('2018-09-08');
-- EXECUTE the_delete_function ('2018-09-09');
-- EXECUTE the_delete_function ('2018-09-10');
-- EXECUTE the_delete_function ('2018-09-11');
-- EXECUTE the_delete_function ('2018-09-12');
-- EXECUTE the_delete_function ('2018-09-13');
-- EXECUTE the_delete_function ('2018-09-14');
EXECUTE the_delete_function ('2018-09-15');
EXECUTE the_delete_function ('2018-09-16');
EXECUTE the_delete_function ('2018-09-17');




--
-- -- Load TEMP_TABLE into ROLLUP_TABLE
INSERT INTO analysis.dsds_281_extension_daily_version_sandbox
(SELECT * FROM the_temp_table);


-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;




SELECT the_day, COUNT(1) FROM analysis.dsds_281_extension_daily_version_sandbox
WHERE the_day>='2018-09-01'::TIMESTAMP
GROUP BY 1 ORDER BY 1;
