
--
-- WITH
-- the_data AS (
--   SELECT old_logic.the_day, old_logic.extension_id, old_logic.extension_version, old_logic.extension_anchor
--     , old_logic.channel_id, old_logic.bool_extension_installed, old_logic.bool_extension_activated
--     , old_logic.time_most_recent_install, old_logic.time_most_recent_activate
--     , old_logic.time_most_recent_anchor_changed, old_logic.time_most_recent_deactivate
--     , old_logic.time_most_recent_uninstall, old_logic.time_most_recent_delete
--     --, CASE WHEN new_logic.extension_id IS NOT NULL AND new_logic.channel_id IS NOT NULL AND new_logic.the_day IS NOT NULL THEN 1 ELSE 0 END AS flag_perfect_match
--     , CASE WHEN new_logic.extension_id IS NULL THEN 1 ELSE 0 END AS flag_look_at_this
--     , new_logic.extension_id AS new_ext
--   FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS old_logic
--   LEFT JOIN analysis.dsds_281_extension_daily_channel_presence_all_anchor_scan_day AS new_logic
--     ON old_logic.the_day = new_logic.the_day
--     AND old_logic.the_day='2017-09-15'::TIMESTAMP AND new_logic.the_day='2017-09-15'::TIMESTAMP
--     AND old_logic.extension_id = new_logic.extension_id
--     AND old_logic.extension_version = new_logic.extension_version
--     --AND old_logic.extension_anchor = new_logic.extension_anchor
--     AND old_logic.channel_id = new_logic.channel_id
--     AND old_logic.flag_install_activate_status = new_logic.flag_install_activate_status
--     AND old_logic.time_most_recent_install = new_logic.time_most_recent_install
--     AND old_logic.time_most_recent_activate = new_logic.time_most_recent_activate
--     AND old_logic.time_most_recent_anchor_changed = new_logic.time_most_recent_anchor_changed
--     AND old_logic.time_most_recent_deactivate = new_logic.time_most_recent_deactivate
--     AND old_logic.time_most_recent_uninstall = new_logic.time_most_recent_uninstall
--     AND old_logic.time_most_recent_delete = new_logic.time_most_recent_delete
--     AND old_logic.bool_extension_installed = new_logic.bool_extension_installed
--     AND old_logic.bool_extension_activated = new_logic.bool_extension_activated
--   --WHERE old_logic.the_day = '2017-09-15'::TIMESTAMP AND new_logic.the_day = '2017-09-15'::TIMESTAMP
-- )
--
-- SELECT  extension_id, COUNT(1) AS rows
-- --SELECT *
-- FROM the_data
-- WHERE flag_look_at_this=1
-- GROUP BY 1
-- ORDER BY 2 DESC;






--
-- --CHECK TO SEE IF THERE ARE DUPLICATES
-- WITH
-- the_data AS (
--   SELECT *  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor_scan_day
--   --WHERE the_day = '2017-09-15'::TIMESTAMP
--   --the_day = '2018-07-01'::TIMESTAMP OR
--   --group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14
-- )
-- , weird_channel_id AS (
--   SELECT *
--   FROM (
--     SELECT channel_id, extension_id, the_day, COUNT(1) AS rows
--     FROM the_data
--     GROUP BY 1,2,3
--   )
--   WHERE rows>1
-- )
-- -- SELECT extension_id, SUM(rows) AS rows, COUNT(DISTINCT channel_id) AS channels, COUNT(DISTINCT the_day) AS days
-- -- FROM weird_channel_id GROUP BY 1 ORDER BY 2 DESC;
--
-- SELECT * FROM the_data
-- WHERE channel_id IN (SELECT channel_id FROM weird_channel_id)
-- OR extension_id IN (SELECT extension_id FROM weird_channel_id)
-- ORDER BY channel_id, extension_id, time_most_recent_activate
-- ;




--
--
-- SELECT COUNT(1) FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor_scan_day WHERE the_day = '2017-09-17'::TIMESTAMP;
-- SELECT COUNT(1) FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor WHERE the_day = '2017-09-17'::TIMESTAMP;




  --   , flag_install_activate_status         VARCHAR(25)
  --   , time_most_recent_install             TIMESTAMP WITHOUT TIME ZONE
  --   , time_most_recent_activate            TIMESTAMP WITHOUT TIME ZONE
  --   , time_most_recent_anchor_changed      TIMESTAMP WITHOUT TIME ZONE
  --   , time_most_recent_deactivate          TIMESTAMP WITHOUT TIME ZONE
  --   , time_most_recent_uninstall           TIMESTAMP WITHOUT TIME ZONE
  --   , time_most_recent_delete              TIMESTAMP WITHOUT TIME ZONE
  --   , bool_extension_installed             BOOLEAN
  --   , bool_extension_activated             BOOLEAN



  --
  -- WITH
  -- the_constants AS (
  --   SELECT '2017-09-06'::TIMESTAMP AS the_day
  -- )
  -- , data_orig AS (
  --   SELECT * FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS old_logic
  --   WHERE the_day IN (SELECT the_day FROM the_constants)
  -- )
  -- , data_new AS (
  --   SELECT * FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor_scan_day AS old_logic
  --   WHERE the_day IN (SELECT the_day FROM the_constants)
  -- )
  -- --new has more rows than orig, why?
  -- , new_join_orig AS (
  --   SELECT data_new.the_day, data_new.channel_id, data_new.extension_id, data_new.extension_version
  --     , data_orig.extension_id AS orig_extension_id
  --   FROM data_new
  --   LEFT JOIN data_orig
  --   ON data_new.the_day = data_orig.the_day
  --     AND data_new.channel_id = data_orig.channel_id
  --     AND data_new.extension_id = data_orig.extension_id
  --     --AND data_new.extension_version = data_orig.extension_version
  -- )
  -- , weird_data AS (
  --   SELECT * FROM new_join_orig WHERE orig_extension_id IS NULL
  -- )
  --
  -- SELECT base.* FROM data_new AS base
  -- RIGHT JOIN weird_data ON base.the_day = weird_data.the_day
  --   AND base.extension_id = weird_data.extension_id
  --   AND base.channel_id = weird_data.channel_id
  -- ORDER BY base.the_day, base.extension_id, base.channel_id
  -- ;
  --


  --
  --
  -- SELECT *
  -- FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor_scan_day
  -- WHERE the_day = '2017-09-14'::TIMESTAMP
  -- AND channel_id = 87655252
  -- ORDER BY the_day, channel_id, extension_id;
  --
  -- SELECT *
  -- FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  -- WHERE the_day = '2017-09-14'::TIMESTAMP
  -- AND channel_id = 87655252
  -- ORDER BY the_day, channel_id, extension_id;





  WITH
  count1 AS (
    SELECT 'new' AS the_table, the_day, COUNT(1) AS rows_new
    FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor_scan_day
    GROUP BY 1,2
  )
  , count2 AS (
    SELECT 'old' AS the_table, the_day, COUNT(1) AS rows_old
    FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
    GROUP BY 1,2
  )

  SELECT count1.the_day, count1.rows_new, count2.rows_old, rows_new - rows_old AS diff, (rows_new - rows_old)::FLOAT / rows_old::FLOAT AS pct_diff
  FROM count1
  LEFT JOIN count2 ON count1.the_day = count2.the_day
  ORDER BY 1
  ;



-- USING 02a
-- the_day       | rows_new | rows_old | diff |       pct_diff       
-- ---------------------+----------+----------+------+----------------------
-- 2017-07-25 00:00:00 |      358 |      358 |    0 |                    0
-- 2017-07-26 00:00:00 |      366 |      365 |    1 |  0.00273972602739726
-- 2017-07-27 00:00:00 |      373 |      369 |    4 |    0.010840108401084
-- 2017-07-28 00:00:00 |      378 |      373 |    5 |   0.0134048257372654
-- 2017-09-05 00:00:00 |      646 |      646 |    0 |                    0
-- 2017-09-06 00:00:00 |    19802 |    19784 |   18 | 0.000909826122118884
-- 2017-09-07 00:00:00 |    64134 |    64059 |   75 |  0.00117079567273919
-- 2017-09-08 00:00:00 |    92008 |    91869 |  139 |  0.00151302397979732
-- 2017-09-09 00:00:00 |   111298 |   111104 |  194 |  0.00174611175115207
-- 2017-09-10 00:00:00 |   127752 |   127515 |  237 |  0.00185860487001529
-- 2017-09-11 00:00:00 |   141040 |   140735 |  305 |  0.00216719366184673
-- 2017-09-12 00:00:00 |   153790 |   153424 |  366 |  0.00238554593805402
-- 2017-09-13 00:00:00 |   166277 |   165873 |  404 |  0.00243559831919601
-- 2017-09-14 00:00:00 |   178180 |   177723 |  457 |   0.0025714173179611
-- 2018-07-01 00:00:00 |  3164525 |  3164525 |    0 |                    0
-- 2018-07-02 00:00:00 |  3174864 |  3174650 |  214 | 6.74090057171657e-05
-- 2018-07-03 00:00:00 |  3183212 |  3182836 |  376 | 0.000118133639307837
-- 2018-07-04 00:00:00 |  3191229 |  3190693 |  536 | 0.000167988584298145
