
CREATE TEMP TABLE the_basetable_date (start_date TIMESTAMP, end_date TIMESTAMP);
PREPARE the_date_parameters_function (VARCHAR) AS
INSERT INTO the_basetable_date (
  SELECT
    '2017-05-01'::TIMESTAMP AS start_date --start from may 1st to capture all possible events
    , $1::TIMESTAMP AS end_date
);
--remove the records from raw install logs
PREPARE the_date_parameters_release (VARCHAR) AS DELETE FROM the_basetable_date;

EXECUTE the_date_parameters_function ('2019-02-18'); -- this will populate the record for the_day = '2018-02-17'



--create temp schemas for the various logs tables we want to pull from
CREATE TABLE analysis.dsds_281_the_install_logs (
    start_date                  DATE
    , end_date                  DATE
    , "time"                    TIMESTAMP WITHOUT TIME ZONE sortkey
    , extension_id              VARCHAR(32) distkey
    , extension_version         VARCHAR(50)
    , channel_id                BIGINT
);



--get raw install logs
PREPARE the_install_logs_pull (VARCHAR) AS
INSERT INTO analysis.dsds_281_the_install_logs (
  WITH
  install_logs_step0 AS (
    SELECT
      (SELECT start_date::DATE FROM the_basetable_date) AS start_date
      , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
      , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, channel_id::BIGINT
    FROM tahoe.extension_install
    WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL AND channel_id IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="date" AND "date"<(SELECT end_date FROM the_basetable_date)
  )
  SELECT * FROM install_logs_step0  GROUP BY 1,2,3,4,5,6
);
--remove the records from raw install logs
PREPARE the_install_logs_release (VARCHAR) AS DELETE FROM analysis.dsds_281_the_install_logs;


EXECUTE the_install_logs_pull('dummy_placeholder_text');

--EXECUTE the_install_logs_release('dummy_placeholder_text');
