-- GENERATE A TABLE WITH THE HISTORICAL EXTENSIONS AS OF 2018-06-18, THIS IS TO BACKFILL FOR extension_anchor
--
--
-- --DATA FROM 2018-06-18, the day before component extensions went live
DROP TABLE IF EXISTS    analysis.dsds_281_historical_extensions;
CREATE TABLE    analysis.dsds_281_historical_extensions    AS

SELECT DISTINCT the_date, extension_state, extension_id, extension_version, extension_category_id, extension_name, extension_anchor, extension_author_email, extension_author_name, extension_support_email, extension_url, is_bits_enabled, is_component_enabled, is_overlay_enabled, is_panel_enabled, is_whitelisted_extension FROM (


SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4ced1fygnrzerfs95cofbwiltq88uh' AS extension_id,'0.0.5' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'AFK' AS extension_name,'video_overlay' AS extension_anchor,'ryayoung@amazon.com' AS extension_author_email,'Amazon Game Studios' AS extension_author_name,'ags-extensions-support@amazon.com' AS extension_support_email,'https://www.twitch.tv/ext/4ced1fygnrzerfs95cofbwiltq88uh' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'izb9s2rwqbcto5yn633z7vxebhoqgx' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Actualité CSGO by Flickshot.fr' AS extension_name,'panel' AS extension_anchor,'contact@flickshot.fr' AS extension_author_email,'flickshot_fr' AS extension_author_name,'contact@flickshot.fr' AS extension_support_email,'https://www.twitch.tv/ext/izb9s2rwqbcto5yn633z7vxebhoqgx' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'14axmi68aaarlknc0wt92xow9twie8' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Alvybait Overlay' AS extension_name,'video_overlay' AS extension_anchor,'gabbo.deias@gmail.com' AS extension_author_email,'Lunarii' AS extension_author_name,'gabbo.deias@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/14axmi68aaarlknc0wt92xow9twie8' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'vjyolfoqx8gotu3kcv2hw5749cd1nc' AS extension_id,'1.0.3' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'AmazonGT_BattleCars' AS extension_name,'video_overlay' AS extension_anchor,'josh.beckwith@toolofna.com' AS extension_author_email,'jbeckwith_tool' AS extension_author_name,'devtoolofna@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/vjyolfoqx8gotu3kcv2hw5749cd1nc' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'tg56ov8te4az7w7vl4m4zzyminnq3p' AS extension_id,'0.1.1' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'AutoStar' AS extension_name,'video_overlay' AS extension_anchor,'brynjar.gigja@gmail.com' AS extension_author_email,'CygnusCross' AS extension_author_name,'cygnuscross@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/tg56ov8te4az7w7vl4m4zzyminnq3p' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'oolbjepiegqs8ffra8pr4wutiibwqs' AS extension_id,'0.9.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'BBS Wall' AS extension_name,'panel' AS extension_anchor,'hellcat@hellcat.net' AS extension_author_email,'HELLCAT' AS extension_author_name,'twitch-extensions@therealhellcat.de' AS extension_support_email,'https://www.twitch.tv/ext/oolbjepiegqs8ffra8pr4wutiibwqs' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ky3y4b7kyvg6uf4oq8o5kthezm5yrs' AS extension_id,'0.0.3' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'BROKEN!' AS extension_name,'video_overlay' AS extension_anchor,'overgd22@naver.com' AS extension_author_email,'overgd22' AS extension_author_name,'overlab120@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/ky3y4b7kyvg6uf4oq8o5kthezm5yrs' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hpk67oi9uynujz12b93gipypek6ns4' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'BabyRage Driver' AS extension_name,'video_overlay' AS extension_anchor,'dev.shawn.m@gmail.com' AS extension_author_email,'cptzippers' AS extension_author_name,'cptzippers@outlook.com' AS extension_support_email,'https://www.twitch.tv/ext/hpk67oi9uynujz12b93gipypek6ns4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'v2011j28pscnu40e0rzjhtaf3lafe4' AS extension_id,'1.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Badge League' AS extension_name,'panel' AS extension_anchor,'bgavilan27@gmail.com' AS extension_author_email,'nara567' AS extension_author_name,'nara567.twitch@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/v2011j28pscnu40e0rzjhtaf3lafe4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'t14llordj5qbtzbg07s3ravgjqi8np' AS extension_id,'1.0.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Bethesda E3 Showcase Extension' AS extension_name,'video_overlay' AS extension_anchor,'twitch@exmachina.nl' AS extension_author_email,'Ex Machina' AS extension_author_name,'twitch@exmachina.nl' AS extension_support_email,'https://www.twitch.tv/ext/t14llordj5qbtzbg07s3ravgjqi8np' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'pp16i51f77pxhwls8tqqo72f5m5ttz' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Better Information Panel' AS extension_name,'panel' AS extension_anchor,'erik.guzman@gooseman.codes' AS extension_author_email,'talk2megooseman' AS extension_author_name,'erik.guzman@gooseman.codes' AS extension_support_email,'https://www.twitch.tv/ext/pp16i51f77pxhwls8tqqo72f5m5ttz' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'nogza3jd4t7x3cpbrzu2z6vqj8l8uk' AS extension_id,'0.0.2' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'BitPoll' AS extension_name,'video_overlay' AS extension_anchor,'coen.mcclelland@gmail.com' AS extension_author_email,'tallco.de' AS extension_author_name,'bitpoll@tallco.de' AS extension_support_email,'https://www.twitch.tv/ext/nogza3jd4t7x3cpbrzu2z6vqj8l8uk' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'4s0p3jkn926i4xix9nqewle4rhxw3t' AS extension_id,'0.0.4' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Bithead Arcade' AS extension_name,'panel' AS extension_anchor,'bcjordan@gmail.com' AS extension_author_email,'Doborog' AS extension_author_name,'support@doborog.com' AS extension_support_email,'https://www.twitch.tv/ext/4s0p3jkn926i4xix9nqewle4rhxw3t' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4s0p3jkn926i4xix9nqewle4rhxw3t' AS extension_id,'0.0.3' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Bithead Arcade' AS extension_name,'panel' AS extension_anchor,'bcjordan@gmail.com' AS extension_author_email,'Doborog' AS extension_author_name,'support@doborog.com' AS extension_support_email,'https://www.twitch.tv/ext/4s0p3jkn926i4xix9nqewle4rhxw3t' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'xc65l98oiu0g8jxzv949sznwkd8735' AS extension_id,'1.0.1' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'Bits Voting Studio' AS extension_name,'video_overlay' AS extension_anchor,'mlohier@ipowow.com' AS extension_author_email,'iPowow!' AS extension_author_name,'twitch@ipowow.com' AS extension_support_email,'https://www.twitch.tv/ext/xc65l98oiu0g8jxzv949sznwkd8735' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'20nvc0bcw7n9g0raambsqwc2cpp2jw' AS extension_id,'1.1.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Black Desert Online Helper' AS extension_name,'panel' AS extension_anchor,'danielrafaelli@gmail.com' AS extension_author_email,'Simego' AS extension_author_name,'contact@thesimego.com' AS extension_support_email,'https://www.twitch.tv/ext/20nvc0bcw7n9g0raambsqwc2cpp2jw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'wigu7ps6di51n6t2xo3tghei6bkr2e' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Blackboard' AS extension_name,'panel' AS extension_anchor,'alvise.dandolo@gmail.com' AS extension_author_email,'AlviDandee' AS extension_author_name,'alvise.dandolo@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/wigu7ps6di51n6t2xo3tghei6bkr2e' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'6tsrte9vp6fgnxk4nfziy2sbnlo75y' AS extension_id,'1.3.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Bob Mob' AS extension_name,'video_overlay' AS extension_anchor,'techteam@vaudience.net' AS extension_author_email,'vAudience' AS extension_author_name,'support@bobmob.stream' AS extension_support_email,'https://www.twitch.tv/ext/6tsrte9vp6fgnxk4nfziy2sbnlo75y' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'6tsrte9vp6fgnxk4nfziy2sbnlo75y' AS extension_id,'1.2.1' AS extension_version,'' AS extension_category_id,'Bob Mob' AS extension_name,'video_overlay' AS extension_anchor,'techteam@vaudience.net' AS extension_author_email,'vAudience' AS extension_author_name,'support@bobmob.stream' AS extension_support_email,'https://www.twitch.tv/ext/6tsrte9vp6fgnxk4nfziy2sbnlo75y' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'ampqh0mn1lt0nssj5xo5m7mml7g9mz' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Boom Livestream Interactions' AS extension_name,'video_overlay' AS extension_anchor,'account@boom.tv' AS extension_author_email,'BoomTV' AS extension_author_name,'supportgroup@boom.tv' AS extension_support_email,'https://www.twitch.tv/ext/ampqh0mn1lt0nssj5xo5m7mml7g9mz' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'upgb5eohbwlk8sqt5jexxl5l2n4wvi' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'BoomTown' AS extension_name,'panel' AS extension_anchor,'joyo@splitmedialabs.com' AS extension_author_email,'Player.me' AS extension_author_name,'feedback@player.me' AS extension_support_email,'https://www.twitch.tv/ext/upgb5eohbwlk8sqt5jexxl5l2n4wvi' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'c2ou58zo8ysle7rql3x6xh8i40fgqa' AS extension_id,'0.0.1' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Botcode' AS extension_name,'panel' AS extension_anchor,'tribunok@gmail.com' AS extension_author_email,'tribunok' AS extension_author_name,'botcodeextension@tribunok.com' AS extension_support_email,'https://www.twitch.tv/ext/c2ou58zo8ysle7rql3x6xh8i40fgqa' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'i2xjgwf8jn5jtq92ce5hd4skgnjtdc' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Brawler - My Challenges' AS extension_name,'panel' AS extension_anchor,'arnehendricks@gmail.com' AS extension_author_email,'Brawler' AS extension_author_name,'arnehendricks@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/i2xjgwf8jn5jtq92ce5hd4skgnjtdc' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'b0brhnzpw67833877v3uo8cf0k8o7p' AS extension_id,'0.1.4' AS extension_version,'' AS extension_category_id,'Burkes Booty' AS extension_name,'panel' AS extension_anchor,'swiftyspiffy@gmail.com' AS extension_author_email,'swiftyspiffy' AS extension_author_name,'swiftyspiffy@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/b0brhnzpw67833877v3uo8cf0k8o7p' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'zyt20fl337b4xbaisl72m23j5ipkce' AS extension_id,'0.1.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'CSGO Info' AS extension_name,'video_overlay' AS extension_anchor,'neverov12@gmail.com' AS extension_author_email,'TheTTATPuOT' AS extension_author_name,'neverov12@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/zyt20fl337b4xbaisl72m23j5ipkce' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'fw3xzmoe7jgzc4w6mnwhznvq9rkr3g' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'CSGO-Analytics Panel' AS extension_name,'panel' AS extension_anchor,'neverov12@gmail.com' AS extension_author_email,'neverov11' AS extension_author_name,'neverov12@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/fw3xzmoe7jgzc4w6mnwhznvq9rkr3g' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'b01ffznr4vfjkuzx19zdnbayafovy7' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Cels: Animated Emote Editor' AS extension_name,'component' AS extension_anchor,'peter.t.ludlow@gmail.com' AS extension_author_email,'tetsuo286' AS extension_author_name,'tetsuo286.dev@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/b01ffznr4vfjkuzx19zdnbayafovy7' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'40zvgmtdca61eez3kr2azlnqkqmp50' AS extension_id,'1.1.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Channel Stats - Show Your Twitch Rank' AS extension_name,'panel' AS extension_anchor,'Sidney2010@gmx.de' AS extension_author_email,'AlphaDuplo' AS extension_author_name,'support@alpha-dev.de' AS extension_support_email,'https://www.twitch.tv/ext/40zvgmtdca61eez3kr2azlnqkqmp50' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'2es28uu39dw9wkinfesvxhsy3pq8jq' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Channel name' AS extension_name,'video_overlay' AS extension_anchor,'bdegrandmaison@hotmail.fr' AS extension_author_email,'devbobo' AS extension_author_name,'bdegrandmaison@hotmail.fr' AS extension_support_email,'https://www.twitch.tv/ext/2es28uu39dw9wkinfesvxhsy3pq8jq' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'36ffx1pd94bm0zir9k8fe8eau2u9oj' AS extension_id,'0.0.1' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Chatterbox' AS extension_name,'panel' AS extension_anchor,'gopixelsgaming@gmail.com' AS extension_author_email,'pixelsgaming.com' AS extension_author_name,'support@pixelsgaming.com' AS extension_support_email,'https://www.twitch.tv/ext/36ffx1pd94bm0zir9k8fe8eau2u9oj' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'1ye3qdhcc8vr50tjygrgsxab6fmqb9' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Chauchas' AS extension_name,'video_overlay' AS extension_anchor,'kernelfreeze@outlook.com' AS extension_author_email,'KernelFreeze' AS extension_author_name,'kernelfreeze@outlook.com' AS extension_support_email,'https://www.twitch.tv/ext/1ye3qdhcc8vr50tjygrgsxab6fmqb9' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'u6sud2nknhji1bf50rmhjmynf49hw4' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Choice Chamber' AS extension_name,'video_overlay' AS extension_anchor,'onemrbean@gmail.com' AS extension_author_email,'Studio Bean' AS extension_author_name,'onemrbean@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/u6sud2nknhji1bf50rmhjmynf49hw4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'fq1gd8trf41nf30ay8wcatc59cd72w' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Choppertown EPG' AS extension_name,'video_overlay' AS extension_anchor,'oneworldstudios@yahoo.com' AS extension_author_email,'Choppertown' AS extension_author_name,'tech@oneworld.digital' AS extension_support_email,'https://www.twitch.tv/ext/fq1gd8trf41nf30ay8wcatc59cd72w' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'cb063xrtohf9muwpjl4doijbjycqa2' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Christmas Tree' AS extension_name,'panel' AS extension_anchor,'gopixelsgaming@gmail.com' AS extension_author_email,'pixelsgaming.com' AS extension_author_name,'support@pixelsgaming.com' AS extension_support_email,'https://www.twitch.tv/ext/cb063xrtohf9muwpjl4doijbjycqa2' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'68yadm5zjklpm8jmmxjso3kgjp76n5' AS extension_id,'0.0.4' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Chroma' AS extension_name,'panel' AS extension_anchor,'tim.graupmann@razerzone.com' AS extension_author_email,'Tim Graupmann' AS extension_author_name,'tgraupmann@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/68yadm5zjklpm8jmmxjso3kgjp76n5' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'8t1cbk7pyu57f7080st12azwblxmnv' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Chrono.gg Daily Deal Panel' AS extension_name,'panel' AS extension_anchor,'zak@chrono.gg' AS extension_author_email,'Chrono.gg' AS extension_author_name,'help@chrono.gg' AS extension_support_email,'https://www.twitch.tv/ext/8t1cbk7pyu57f7080st12azwblxmnv' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'xm9qmvnmls6ifd21kjejl0b30gyheo' AS extension_id,'0.0.5' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Clone Drone in the Danger Zone' AS extension_name,'video_overlay' AS extension_anchor,'brian@doborog.com' AS extension_author_email,'Doborog' AS extension_author_name,'support@doborog.com' AS extension_support_email,'https://www.twitch.tv/ext/xm9qmvnmls6ifd21kjejl0b30gyheo' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'xm9qmvnmls6ifd21kjejl0b30gyheo' AS extension_id,'0.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Clone Drone in the Danger Zone' AS extension_name,'video_overlay' AS extension_anchor,'brian@doborog.com' AS extension_author_email,'Doborog' AS extension_author_name,'support@doborog.com' AS extension_support_email,'https://www.twitch.tv/ext/xm9qmvnmls6ifd21kjejl0b30gyheo' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'xptunrxv6b9qmk5uyeg08iw1cm2i6o' AS extension_id,'0.0.1' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'CohhCarnage Token Checker' AS extension_name,'panel' AS extension_anchor,'barry@barrycarlyon.co.uk' AS extension_author_email,'BarryCarlyon' AS extension_author_name,'barry@barrycarlyon.co.uk' AS extension_support_email,'https://www.twitch.tv/ext/xptunrxv6b9qmk5uyeg08iw1cm2i6o' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'zw3y5ahzbzyutgbbw3p5v8xkc9e02m' AS extension_id,'0.0.3' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Community Members' AS extension_name,'panel' AS extension_anchor,'casperryt@gmail.com' AS extension_author_email,'Casperr' AS extension_author_name,'casperryt@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/zw3y5ahzbzyutgbbw3p5v8xkc9e02m' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'cpbcgv3xn1bhnn9gm0cnaen4wucwbf' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Control The Show' AS extension_name,'video_overlay' AS extension_anchor,'john@digitaltreemedia.co.uk' AS extension_author_email,'Digital Tree Media Ltd' AS extension_author_name,'support@digitaltreemedia.co.uk' AS extension_support_email,'https://www.twitch.tv/ext/cpbcgv3xn1bhnn9gm0cnaen4wucwbf' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'igb4wekjek0vmfhs8f1vsxl0xqhky2' AS extension_id,'1.0.8' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Count Down LT' AS extension_name,'panel' AS extension_anchor,'danefairbanks@gmail.com' AS extension_author_email,'dhqk' AS extension_author_name,'support@danefairbanks.com' AS extension_support_email,'https://www.twitch.tv/ext/igb4wekjek0vmfhs8f1vsxl0xqhky2' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'584uahtccq0llyvu1o14ur2zqlogys' AS extension_id,'1.0.8' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Count Down XL' AS extension_name,'panel' AS extension_anchor,'danefairbanks@gmail.com' AS extension_author_email,'dhqk' AS extension_author_name,'support@danefairbanks.com' AS extension_support_email,'https://www.twitch.tv/ext/584uahtccq0llyvu1o14ur2zqlogys' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'prsrpfk40yc2rc4f04q7xfm233qk17' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'CrowdChess Aggregator Stats' AS extension_name,'panel' AS extension_anchor,'glumandi.pokemon@web.de' AS extension_author_email,'fumbanana' AS extension_author_name,'glumandi.pokemon@web.de' AS extension_support_email,'https://www.twitch.tv/ext/prsrpfk40yc2rc4f04q7xfm233qk17' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'rht5p4rtpme57avow6798xm06u4qvz' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'CrowdChess Board & Stats' AS extension_name,'panel' AS extension_anchor,'glumandi.pokemon@web.de' AS extension_author_email,'fumbanana' AS extension_author_name,'glumandi.pokemon@web.de' AS extension_support_email,'https://www.twitch.tv/ext/rht5p4rtpme57avow6798xm06u4qvz' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'344bna5na8gcfryiauxqpnfqxvp0o4' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'CrowdChess Buttons & Sliders' AS extension_name,'panel' AS extension_anchor,'glumandi.pokemon@web.de' AS extension_author_email,'fumbanana' AS extension_author_name,'glumandi.pokemon@web.de' AS extension_support_email,'https://www.twitch.tv/ext/344bna5na8gcfryiauxqpnfqxvp0o4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hedvsl70563rd1shwc3xcihayi8liz' AS extension_id,'1.0.1' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'Crunchyroll Anime Awards 2018' AS extension_name,'video_overlay' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/hedvsl70563rd1shwc3xcihayi8liz' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'0eov6ke2wwslxaxsh1c9h8z9v2m7lg' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Crypto Collectibles' AS extension_name,'panel' AS extension_anchor,'engineering@rarebits.io' AS extension_author_email,'fanbits.com' AS extension_author_name,'support@rarebits.io' AS extension_support_email,'https://www.twitch.tv/ext/0eov6ke2wwslxaxsh1c9h8z9v2m7lg' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'6drpwe6su74qouku5836kmed6g7cuc' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Crypto Donations' AS extension_name,'panel' AS extension_anchor,'webmaster@queleas.com' AS extension_author_email,'Queleas LLC' AS extension_author_name,'webmaster@queleas.com' AS extension_support_email,'https://www.twitch.tv/ext/6drpwe6su74qouku5836kmed6g7cuc' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'rzkq8dkuoujgm6d8ek2twnkuni31rm' AS extension_id,'1.0.5' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'CurseForge Mod Lister' AS extension_name,'panel' AS extension_anchor,'langrm@justin.tv' AS extension_author_email,'CurseForge' AS extension_author_name,'langrm@justin.tv' AS extension_support_email,'https://www.twitch.tv/ext/rzkq8dkuoujgm6d8ek2twnkuni31rm' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'h24uy9gfaeidk7tflr4isv4a5kcj78' AS extension_id,'0.2.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'CygnusCross' AS extension_name,'video_overlay' AS extension_anchor,'brynjar.gigja@gmail.com' AS extension_author_email,'CygnusCross' AS extension_author_name,'cygnuscross@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/h24uy9gfaeidk7tflr4isv4a5kcj78' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'y0io0scnvisnnlyga0j0bo5vdxkxgv' AS extension_id,'1.1.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Darwin Project Spectator Experience' AS extension_name,'video_overlay' AS extension_anchor,'simon@scavengers.ca' AS extension_author_email,'darwinproject' AS extension_author_name,'support@scavengers.ca' AS extension_support_email,'https://www.twitch.tv/ext/y0io0scnvisnnlyga0j0bo5vdxkxgv' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'a23mttohd32cjppls8v1p9vr0sb0on' AS extension_id,'0.0.8' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Deaths Door Game' AS extension_name,'video_overlay' AS extension_anchor,'mark@shinyshoe.com' AS extension_author_email,'Shiny Shoe' AS extension_author_name,'support@shinyshoe.com' AS extension_support_email,'https://www.twitch.tv/ext/a23mttohd32cjppls8v1p9vr0sb0on' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'907u5jw3bqrl52ccv6i0c7af24lu34' AS extension_id,'1.0.1' AS extension_version,'' AS extension_category_id,'DeckHub' AS extension_name,'video_overlay' AS extension_anchor,'andreliverod@outlook.com' AS extension_author_email,'AetherHub' AS extension_author_name,'admin@aetherhub.com' AS extension_support_email,'https://www.twitch.tv/ext/907u5jw3bqrl52ccv6i0c7af24lu34' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'cplheah4pxjyuwe9mkno9kbmb11lyc' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Deckmaster: MTG Arena Overlay' AS extension_name,'video_overlay' AS extension_anchor,'fugiman47@gmail.com' AS extension_author_email,'Fugi' AS extension_author_name,'fugi@fugiman.com' AS extension_support_email,'https://www.twitch.tv/ext/cplheah4pxjyuwe9mkno9kbmb11lyc' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'tirqrgy7bg0rz4sgyiciy1x8uu4cwh' AS extension_id,'0.2.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'DelFruit Info' AS extension_name,'video_overlay' AS extension_anchor,'patrickjtraynor@gmail.com' AS extension_author_email,'Patrickgh3' AS extension_author_name,'delfruit.info.support@mailfence.com' AS extension_support_email,'https://www.twitch.tv/ext/tirqrgy7bg0rz4sgyiciy1x8uu4cwh' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ix4apxjpd4wh7dm6dzb5l4g9eudn86' AS extension_id,'0.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Destiny 1 Armory Overlay' AS extension_name,'video_overlay' AS extension_anchor,'andy@flightly.com' AS extension_author_email,'Grab Games' AS extension_author_name,'support@grabgames.com' AS extension_support_email,'https://www.twitch.tv/ext/ix4apxjpd4wh7dm6dzb5l4g9eudn86' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'fozlqfmrrdtastjnfxw3pmnqto9zns' AS extension_id,'0.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Destiny 2 Armory Overlay' AS extension_name,'video_overlay' AS extension_anchor,'andy@flightly.com' AS extension_author_email,'Grab Games' AS extension_author_name,'support@grabgames.com' AS extension_support_email,'https://www.twitch.tv/ext/fozlqfmrrdtastjnfxw3pmnqto9zns' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'l0m154prxsmwu1m0tyic1ei0915byb' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Diablo 2 Item Display' AS extension_name,'video_overlay' AS extension_anchor,'nyoung0@gmail.com' AS extension_author_email,'the_saltyspitoon' AS extension_author_name,'d2id@multilurk.tv' AS extension_support_email,'https://www.twitch.tv/ext/l0m154prxsmwu1m0tyic1ei0915byb' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'tt56wyri2zscnr0t2cjakapvocc5qr' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Dijital Saat' AS extension_name,'panel' AS extension_anchor,'afy@mail.com.tr' AS extension_author_email,'beklenenadam' AS extension_author_name,'afy@mail.com.tr' AS extension_support_email,'https://www.twitch.tv/ext/tt56wyri2zscnr0t2cjakapvocc5qr' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'v813hdg6t2txwoz9v4q46lw11c7zce' AS extension_id,'1.0.3' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Doctor Who Watch to Win Sweepstakes' AS extension_name,'video_overlay' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/v813hdg6t2txwoz9v4q46lw11c7zce' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'xj64yera57wb8n3rclp4kq3yrp30iv' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Dota 2 Party' AS extension_name,'panel' AS extension_anchor,'alvise.dandolo@gmail.com' AS extension_author_email,'AlviDandee' AS extension_author_name,'alvise.dandolo@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/xj64yera57wb8n3rclp4kq3yrp30iv' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'48tho10wcksqo22iu60pf0r13cynnl' AS extension_id,'0.8.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Dota 2 Profile Overlay' AS extension_name,'video_overlay' AS extension_anchor,'ermag.bg@gmail.com' AS extension_author_email,'Born2Phil' AS extension_author_name,'ermag.bg@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/48tho10wcksqo22iu60pf0r13cynnl' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ebfbsgj6lg9k2d4czcycledd89vrz9' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Dota 2 Streaks' AS extension_name,'panel' AS extension_anchor,'dankubatko@gmail.com' AS extension_author_email,'drazzzer' AS extension_author_name,'dankubatko@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/ebfbsgj6lg9k2d4czcycledd89vrz9' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'unw8a1ertldsu8x01o44ng68rcbfzw' AS extension_id,'1.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Dota 2 Tracker' AS extension_name,'panel' AS extension_anchor,'topekar@gmail.com' AS extension_author_email,'iamtopik' AS extension_author_name,'topekar@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/unw8a1ertldsu8x01o44ng68rcbfzw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'92ydmhd13dzrhhp087hyxqu3jks7f6' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Dota2 talent viewer' AS extension_name,'video_overlay' AS extension_anchor,'marstranderthomas@gmail.com' AS extension_author_email,'Fedme' AS extension_author_name,'marstranderthomas@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/92ydmhd13dzrhhp087hyxqu3jks7f6' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'kmo9ufu000664pyzr7ernwlt1a4h90' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Dr. Fuji' AS extension_name,'video_overlay' AS extension_anchor,'everoddish@gmail.com' AS extension_author_email,'EverOddish' AS extension_author_name,'everoddish@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/kmo9ufu000664pyzr7ernwlt1a4h90' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2uwzmjkompom5umd417bfk0ycr807b' AS extension_id,'1.0.2' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Drawtastic' AS extension_name,'video_overlay' AS extension_anchor,'mbeierling@gmail.com' AS extension_author_email,'ted_o_brian' AS extension_author_name,'tedobrian4real@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/2uwzmjkompom5umd417bfk0ycr807b' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'uddfpjpm83bcj33vmxkyzf7m55o20q' AS extension_id,'0.0.5' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'EliteTrack' AS extension_name,'video_overlay' AS extension_anchor,'barry@barrycarlyon.co.uk' AS extension_author_email,'BarryCarlyon' AS extension_author_name,'extensions@barrycarlyon.co.uk' AS extension_support_email,'https://www.twitch.tv/ext/uddfpjpm83bcj33vmxkyzf7m55o20q' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'uddfpjpm83bcj33vmxkyzf7m55o20q' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'EliteTrack' AS extension_name,'video_overlay' AS extension_anchor,'barry@barrycarlyon.co.uk' AS extension_author_email,'BarryCarlyon' AS extension_author_name,'extensions@barrycarlyon.co.uk' AS extension_support_email,'https://www.twitch.tv/ext/uddfpjpm83bcj33vmxkyzf7m55o20q' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'zxur5xqgi7x947e2h84ekn07adncrn' AS extension_id,'1.0.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Emogi - Stickers for Streaming' AS extension_name,'component' AS extension_anchor,'twitch@emogi.com' AS extension_author_email,'emogiapp' AS extension_author_name,'twitch@emogi.com' AS extension_support_email,'https://www.twitch.tv/ext/zxur5xqgi7x947e2h84ekn07adncrn' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'g5f7fh1rbgsejjiyo8euv89s1m7qz4' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Essentials.TF Panel' AS extension_name,'panel' AS extension_anchor,'ldesgoui@gmail.com' AS extension_author_email,'Essentials.TF' AS extension_author_name,'ldesgoui@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/g5f7fh1rbgsejjiyo8euv89s1m7qz4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'g9ij4x4m190exaknp30xmnfa8svh8p' AS extension_id,'1.0.2' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Event Countdown' AS extension_name,'panel' AS extension_anchor,'casperryt@gmail.com' AS extension_author_email,'Casperr' AS extension_author_name,'casperryt@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/g9ij4x4m190exaknp30xmnfa8svh8p' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'srf1tifgl6sxmio4y7xly9zv4pq3tz' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'FabSlab Bits' AS extension_name,'panel' AS extension_anchor,'fsbrooke@twitch.tv' AS extension_author_email,'FabSlab' AS extension_author_name,'fsbrooke@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/srf1tifgl6sxmio4y7xly9zv4pq3tz' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'auajwk3d5t6tr1vhd8baeikfzs7etn' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Fam' AS extension_name,'panel' AS extension_anchor,'austin@starfire.games' AS extension_author_email,'Fam' AS extension_author_name,'austin@starfire.games' AS extension_support_email,'https://www.twitch.tv/ext/auajwk3d5t6tr1vhd8baeikfzs7etn' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ih4ptg04wzw6nf4qms0612b8uj0tbh' AS extension_id,'1.0.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Featured Follow Button' AS extension_name,'video_overlay' AS extension_anchor,'nmannesc@twitch.tv' AS extension_author_email,'Noah Manneschmidt' AS extension_author_name,'nmannesc@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/ih4ptg04wzw6nf4qms0612b8uj0tbh' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'uqbw5s35wg1ztqw1kmrf37swiwxmyi' AS extension_id,'1.0.3' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'FishFriendos' AS extension_name,'panel' AS extension_anchor,'contact@voidteam.net' AS extension_author_email,'VoidTeam Studios' AS extension_author_name,'contact@voidteam.net' AS extension_support_email,'https://www.twitch.tv/ext/uqbw5s35wg1ztqw1kmrf37swiwxmyi' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'9bmsurtng2qfh90y5r7mmshzvdryuy' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Fortnite Scout - Detailed Stats' AS extension_name,'component' AS extension_anchor,'jstock@firecrackersw.com' AS extension_author_email,'firecrackersoftware' AS extension_author_name,'support@firecrackersw.com' AS extension_support_email,'https://www.twitch.tv/ext/9bmsurtng2qfh90y5r7mmshzvdryuy' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'ochmobrlxk3aomwuofj5b3p3x393a5' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Fortnite Scout - Healthbar Stats' AS extension_name,'component' AS extension_anchor,'jstock@firecrackersw.com' AS extension_author_email,'firecrackersoftware' AS extension_author_name,'support@firecrackersw.com' AS extension_support_email,'https://www.twitch.tv/ext/ochmobrlxk3aomwuofj5b3p3x393a5' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'sj16zr66yig2f38ju7y8dos0cr4r90' AS extension_id,'0.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Fortnite Scout - Match History Panel' AS extension_name,'panel' AS extension_anchor,'jstock@firecrackersw.com' AS extension_author_email,'firecrackersoftware' AS extension_author_name,'support@firecrackersw.com' AS extension_support_email,'https://www.twitch.tv/ext/sj16zr66yig2f38ju7y8dos0cr4r90' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4fe6rcd6nxjvm2x1tepbszba59ye6c' AS extension_id,'0.0.5' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Fortnite Scout - Stats Panel' AS extension_name,'panel' AS extension_anchor,'jstock@firecrackersw.com' AS extension_author_email,'Firecracker Software LLC' AS extension_author_name,'support@firecrackersw.com' AS extension_support_email,'https://www.twitch.tv/ext/4fe6rcd6nxjvm2x1tepbszba59ye6c' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'9bcrslmfbw59kqwi7gl968a7sixhyl' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Fortnite Stats Overlay' AS extension_name,'video_overlay' AS extension_anchor,'justbeblah@gmail.com' AS extension_author_email,'Seizead' AS extension_author_name,'seizead@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/9bcrslmfbw59kqwi7gl968a7sixhyl' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hfhakw02k45ke92uwts5qkk7l82a9e' AS extension_id,'0.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Fortnite stats' AS extension_name,'panel' AS extension_anchor,'miguelneov@gmail.com' AS extension_author_email,'noobyGamesYT' AS extension_author_name,'miguelneov@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/hfhakw02k45ke92uwts5qkk7l82a9e' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'qkv0hmz3p8xtorxsznoch9crjo5ai9' AS extension_id,'1.0.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Forza Racing Championship' AS extension_name,'video_overlay' AS extension_anchor,'forzarc@outlook.com' AS extension_author_email,'ForzaRC' AS extension_author_name,'ForzaRCSupport@microsoft.com' AS extension_support_email,'https://www.twitch.tv/ext/qkv0hmz3p8xtorxsznoch9crjo5ai9' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'u7h98n42wfj8zhlnlksjsuoxpc559x' AS extension_id,'1.2.2' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Friends' AS extension_name,'panel' AS extension_anchor,'pulsoidnet@gmail.com' AS extension_author_email,'pulsoid' AS extension_author_name,'pulsoidnet@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/u7h98n42wfj8zhlnlksjsuoxpc559x' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'f2wg5ogca5w3eipuys60k95ik63qns' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'FroggedTV Dota 2 Overlay' AS extension_name,'video_overlay' AS extension_anchor,'wyre@hotmail.fr' AS extension_author_email,'Wyre' AS extension_author_name,'wyre@hotmail.fr' AS extension_support_email,'https://www.twitch.tv/ext/f2wg5ogca5w3eipuys60k95ik63qns' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ohp9y1qh87zi1xn6mk6lcjwftpswji' AS extension_id,'1.1.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Galactic Disagreements' AS extension_name,'video_overlay' AS extension_anchor,'terence@hitboxteam.com' AS extension_author_email,'Hitbox Team' AS extension_author_name,'contact@hitboxteam.com' AS extension_support_email,'https://www.twitch.tv/ext/ohp9y1qh87zi1xn6mk6lcjwftpswji' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'gwnj42anc65bqciiim3rkxos06ozra' AS extension_id,'0.0.3' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Game Queue' AS extension_name,'panel' AS extension_anchor,'alex@pixelsgaming.com' AS extension_author_email,'Pixels Gaming' AS extension_author_name,'support@pixelsgaming.com' AS extension_support_email,'https://www.twitch.tv/ext/gwnj42anc65bqciiim3rkxos06ozra' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4xthrtbw4oqjxl478qsjspia8vt3ra' AS extension_id,'0.1.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Game Stat' AS extension_name,'video_overlay' AS extension_anchor,'ciberus.ps@gmail.com' AS extension_author_email,'CiberusPS' AS extension_author_name,'ciberus.ps@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/4xthrtbw4oqjxl478qsjspia8vt3ra' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'7hoqd16sufw9f9h3swlkdt6lqdn3ud' AS extension_id,'1.0.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Gear on Amazon' AS extension_name,'panel' AS extension_anchor,'twitchassociates-dev@amazon.com' AS extension_author_email,'Amazon' AS extension_author_name,'aa-twitch-feedback@amazon.com' AS extension_support_email,'https://www.twitch.tv/ext/7hoqd16sufw9f9h3swlkdt6lqdn3ud' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'am60genxfzdw5oekbjh8jmw9dmshu2' AS extension_id,'0.0.5' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Gem Miner' AS extension_name,'panel' AS extension_anchor,'yangcliu@gmail.com' AS extension_author_email,'End Game' AS extension_author_name,'inquiries@masteroverwatch.com' AS extension_support_email,'https://www.twitch.tv/ext/am60genxfzdw5oekbjh8jmw9dmshu2' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2yufyl6rjnddmwc3efivdm7v3osdlj' AS extension_id,'0.0.4' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Gem Miner Raid Overlay' AS extension_name,'video_overlay' AS extension_anchor,'yangcliu@gmail.com' AS extension_author_email,'End Game' AS extension_author_name,'inquiries@masteroverwatch.com' AS extension_support_email,'https://www.twitch.tv/ext/2yufyl6rjnddmwc3efivdm7v3osdlj' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'yncbd7i177on3ia536r307nlvt8g1w' AS extension_id,'0.1.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Github Projects' AS extension_name,'panel' AS extension_anchor,'me@gooseman.codes' AS extension_author_email,'talk2MeGooseman' AS extension_author_name,'me@gooseman.codes' AS extension_support_email,'https://www.twitch.tv/ext/yncbd7i177on3ia536r307nlvt8g1w' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'p8gi5e3aa16r1er89eacxx4f7s5z75' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Gladiators' AS extension_name,'video_overlay' AS extension_anchor,'chester.work@gmail.com' AS extension_author_email,'TrueZ LLC' AS extension_author_name,'inbox@truez.ru' AS extension_support_email,'https://www.twitch.tv/ext/p8gi5e3aa16r1er89eacxx4f7s5z75' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'apwln3g3ia45kk690tzabfp525h9e1' AS extension_id,'0.3.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Hearthstone Deck Tracker' AS extension_name,'video_overlay' AS extension_anchor,'twitch-admin@hearthsim.net' AS extension_author_email,'HearthSim' AS extension_author_name,'contact@hsreplay.net' AS extension_support_email,'https://www.twitch.tv/ext/apwln3g3ia45kk690tzabfp525h9e1' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'t7a7q7ksm9g5h61qoe4mn74a7s5c6m' AS extension_id,'0.0.2' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Hearts' AS extension_name,'video_overlay' AS extension_anchor,'webmaster@queleas.com' AS extension_author_email,'Queleas LLC' AS extension_author_name,'webmaster@queleas.com' AS extension_support_email,'https://www.twitch.tv/ext/t7a7q7ksm9g5h61qoe4mn74a7s5c6m' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'6i2lbjclohqvigrdyldl29532rkbv0' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Hello Everyone' AS extension_name,'video_overlay' AS extension_anchor,'jameka@twitch.tv' AS extension_author_email,'jamekachu' AS extension_author_name,'jameka@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/6i2lbjclohqvigrdyldl29532rkbv0' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'2s01psbh160nianurwg7ootnruz7d1' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Honor eSports Sponsors' AS extension_name,'panel' AS extension_anchor,'chrisnelson@bssecure.net' AS extension_author_email,'thebanhammerow' AS extension_author_name,'business@honor.gg' AS extension_support_email,'https://www.twitch.tv/ext/2s01psbh160nianurwg7ootnruz7d1' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4ntuott0zqw008atk0wy60phfa8jyf' AS extension_id,'0.0.11' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Innkeeper: Advanced Hearthstone Overlay' AS extension_name,'video_overlay' AS extension_anchor,'oppert@twitch.tv' AS extension_author_email,'Curse inc.' AS extension_author_name,'overlaysupport@curse.com' AS extension_support_email,'https://www.twitch.tv/ext/4ntuott0zqw008atk0wy60phfa8jyf' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'kfk78htcdbpe5gfpzbzcmnhzhe5vud' AS extension_id,'0.0.2' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Instagram Feed' AS extension_name,'panel' AS extension_anchor,'gopixelsgaming@gmail.com' AS extension_author_email,'pixelsgaming.com' AS extension_author_name,'support@pixelsgaming.com' AS extension_support_email,'https://www.twitch.tv/ext/kfk78htcdbpe5gfpzbzcmnhzhe5vud' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'1wp8wjru1pp1510ldhlgpdk6nxbp0q' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Instant-Gaming Partner Overlay' AS extension_name,'video_overlay' AS extension_anchor,'admin@instant-gaming.com' AS extension_author_email,'Instant Gaming Ltd' AS extension_author_name,'support@instant-gaming.com' AS extension_support_email,'https://www.twitch.tv/ext/1wp8wjru1pp1510ldhlgpdk6nxbp0q' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'7beuf1wl1uukibv7wsp1ps7t1ec3ap' AS extension_id,'0.0.3' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Internal Bits Enabled Overlay Test' AS extension_name,'video_overlay' AS extension_anchor,'kngry@twitch.tv' AS extension_author_email,'Ryan King' AS extension_author_name,'kngry@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/7beuf1wl1uukibv7wsp1ps7t1ec3ap' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'x8ltq0ns89cjwfu2eu1lneccwx19wc' AS extension_id,'0.0.3' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Internal Bits Enabled Panel Test' AS extension_name,'panel' AS extension_anchor,'kngry@twitch.tv' AS extension_author_email,'Ryan King' AS extension_author_name,'kngry@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/x8ltq0ns89cjwfu2eu1lneccwx19wc' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'8f47s5tv4mt9sfc5fa2kh7wy5zlo7p' AS extension_id,'0.1.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Inthegame' AS extension_name,'video_overlay' AS extension_anchor,'itai@inthegame.io' AS extension_author_email,'Inthegame' AS extension_author_name,'itai@inthegame.io' AS extension_support_email,'https://www.twitch.tv/ext/8f47s5tv4mt9sfc5fa2kh7wy5zlo7p' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'1z849jl4pvzj51ct2uysvvwynkc5yg' AS extension_id,'1.0.7' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'Ipowow Sparks' AS extension_name,'video_overlay' AS extension_anchor,'mlohier@ipowow.com' AS extension_author_email,'iPowow!' AS extension_author_name,'info@ipowow.com' AS extension_support_email,'https://www.twitch.tv/ext/1z849jl4pvzj51ct2uysvvwynkc5yg' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'nfed9xntpykkdh4t51i3jl6woovex4' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Joels Everything Test Panel' AS extension_name,'panel' AS extension_anchor,'jmizzon@twitch.tv' AS extension_author_email,'foilstormcrow' AS extension_author_name,'jmizzon@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/nfed9xntpykkdh4t51i3jl6woovex4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'aia7xrse1g89w4nu5uno7dekzry3b3' AS extension_id,'0.0.3' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'JopeBot' AS extension_name,'panel' AS extension_anchor,'jopethemetalmessiah@gmail.com' AS extension_author_email,'jopethemetalmessiah' AS extension_author_name,'jope@jopebot.com' AS extension_support_email,'https://www.twitch.tv/ext/aia7xrse1g89w4nu5uno7dekzry3b3' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'3d6j6b6hlyudlr4oy5rz1l27kckwoq' AS extension_id,'0.0.2' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Joshs Swag Bag' AS extension_name,'panel' AS extension_anchor,'joshmade@twitch.tv' AS extension_author_email,'Josh Madewell' AS extension_author_name,'joshmade@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/3d6j6b6hlyudlr4oy5rz1l27kckwoq' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'0avhxqhf046g417vc8yxrb6ydl2j9d' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Kit' AS extension_name,'panel' AS extension_anchor,'developers@kit.com' AS extension_author_email,'Kit' AS extension_author_name,'support@kit.com' AS extension_support_email,'https://www.twitch.tv/ext/0avhxqhf046g417vc8yxrb6ydl2j9d' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'taa2tltx0xam25jrl8jdo364i3mho0' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Kizbat Control Robot' AS extension_name,'video_overlay' AS extension_anchor,'cyril.bareme@gmail.com' AS extension_author_email,'cylwin' AS extension_author_name,'cyril.bareme@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/taa2tltx0xam25jrl8jdo364i3mho0' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'sop3xzfxhlighvjzpvcd95wrzbo30h' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Lantern of Insight' AS extension_name,'video_overlay' AS extension_anchor,'prefecttophat@gmail.com' AS extension_author_email,'rscoates' AS extension_author_name,'magictwich@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/sop3xzfxhlighvjzpvcd95wrzbo30h' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'3kamxfyyp25wocagv5ehgyswwp9njf' AS extension_id,'0.1.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Lasqa Points' AS extension_name,'panel' AS extension_anchor,'bayer1by@gmail.com' AS extension_author_email,'bayer1by' AS extension_author_name,'bayer1by@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/3kamxfyyp25wocagv5ehgyswwp9njf' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'wb3bnc8np7tdnxj2sfbk0aa3vklulo' AS extension_id,'0.0.7' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Latest Followers' AS extension_name,'panel' AS extension_anchor,'zopydude@hotmail.com' AS extension_author_email,'Casperr' AS extension_author_name,'casperryt@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/wb3bnc8np7tdnxj2sfbk0aa3vklulo' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'wb3bnc8np7tdnxj2sfbk0aa3vklulo' AS extension_id,'0.0.6' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Latest Followers' AS extension_name,'panel' AS extension_anchor,'zopydude@hotmail.com' AS extension_author_email,'Casperr' AS extension_author_name,'casperryt@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/wb3bnc8np7tdnxj2sfbk0aa3vklulo' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'24u62kim5mn0slhwigdt7v4ybkwef5' AS extension_id,'1.0.5' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Leaderboard' AS extension_name,'panel' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/24u62kim5mn0slhwigdt7v4ybkwef5' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'ym39j2l9vjuetjha1goufdqaypnp7o' AS extension_id,'1.0.0' AS extension_version,'' AS extension_category_id,'League Accounts' AS extension_name,'panel' AS extension_anchor,'ionutztamas@gmail.com' AS extension_author_email,'IonutzTamas' AS extension_author_name,'ionutztamas+twitch@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/ym39j2l9vjuetjha1goufdqaypnp7o' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hzviu132lbvm97jtmtmncrvtjc1ft1' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Light Controller' AS extension_name,'panel' AS extension_anchor,'bergability@gmail.com' AS extension_author_email,'Bergability' AS extension_author_name,'support@bergability.com' AS extension_support_email,'https://www.twitch.tv/ext/hzviu132lbvm97jtmtmncrvtjc1ft1' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'87rjb2p3ax33dxyxic3j0vrrtrs2dm' AS extension_id,'1.0.7' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Live Emote Reactions' AS extension_name,'video_overlay' AS extension_anchor,'ido@porcupine.tv' AS extension_author_email,'Porcupine' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/87rjb2p3ax33dxyxic3j0vrrtrs2dm' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'0biqu5sb4f8fq6pxxg09xix27d0uo2' AS extension_id,'2.2.0' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Live Pet' AS extension_name,'panel' AS extension_anchor,'ido@porcupine.tv' AS extension_author_email,'Porcupine' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/0biqu5sb4f8fq6pxxg09xix27d0uo2' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'0biqu5sb4f8fq6pxxg09xix27d0uo2' AS extension_id,'2.1.9' AS extension_version,'' AS extension_category_id,'Live Pet' AS extension_name,'panel' AS extension_anchor,'ido@porcupine.tv' AS extension_author_email,'Porcupine' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/0biqu5sb4f8fq6pxxg09xix27d0uo2' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'x8dkgah9d5rh8vbfdq0u0hzvlwmoi5' AS extension_id,'0.1.3' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Live Pet Bits' AS extension_name,'panel' AS extension_anchor,'ido@porcupine.tv' AS extension_author_email,'porcupinetv' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/x8dkgah9d5rh8vbfdq0u0hzvlwmoi5' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'x8dkgah9d5rh8vbfdq0u0hzvlwmoi5' AS extension_id,'0.0.3' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Live Pet Bits' AS extension_name,'panel' AS extension_anchor,'ido@porcupine.tv' AS extension_author_email,'porcupinetv' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/x8dkgah9d5rh8vbfdq0u0hzvlwmoi5' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'ubdlwdf85al36p7lemdacc0iifjev3' AS extension_id,'0.0.1' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Live Pixel Hunt' AS extension_name,'panel' AS extension_anchor,'team@porcupine.tv' AS extension_author_email,'porcupinetv' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/ubdlwdf85al36p7lemdacc0iifjev3' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'y268ru81e4jt09zlx0jaf5xwqrwgxg' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Live Tournament Stats' AS extension_name,'video_overlay' AS extension_anchor,'thijs.molendijk@gmail.com' AS extension_author_email,'Thijs Molendijk (molenzwiebel)' AS extension_author_name,'thijs.molendijk@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/y268ru81e4jt09zlx0jaf5xwqrwgxg' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'qml0i86o5jm1ru7gzwqn6q8dt91ib7' AS extension_id,'1.0.1' AS extension_version,'' AS extension_category_id,'LoLPlox' AS extension_name,'video_overlay' AS extension_anchor,'laurodaniel@outlook.com' AS extension_author_email,'LoLPlox' AS extension_author_name,'info@lolplox.com' AS extension_support_email,'https://www.twitch.tv/ext/qml0i86o5jm1ru7gzwqn6q8dt91ib7' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'qml0i86o5jm1ru7gzwqn6q8dt91ib7' AS extension_id,'1.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'LoLPlox.com' AS extension_name,'video_overlay' AS extension_anchor,'laurodaniel@outlook.com' AS extension_author_email,'LoLPlox.com' AS extension_author_name,'info@lolplox.com' AS extension_support_email,'https://www.twitch.tv/ext/qml0i86o5jm1ru7gzwqn6q8dt91ib7' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'0v0oflrh1oqk4p0al4xxfpeta834kb' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'LoserClippy' AS extension_name,'video_overlay' AS extension_anchor,'benjamin@sannholm.se' AS extension_author_email,'Sannholm' AS extension_author_name,'loserclippy@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/0v0oflrh1oqk4p0al4xxfpeta834kb' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'sexqzozeq87utkv0k0e9kbyjb6k6zz' AS extension_id,'0.0.4' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Lost in House - Whats Playing' AS extension_name,'panel' AS extension_anchor,'sisa1917@windowslive.com' AS extension_author_email,'skill1917' AS extension_author_name,'admin@gamegym.cz' AS extension_support_email,'https://www.twitch.tv/ext/sexqzozeq87utkv0k0e9kbyjb6k6zz' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'mcg3xmuqr7fv0ye99hfvjt8e9wcamk' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'MCViewerDrops' AS extension_name,'panel' AS extension_anchor,'amorelandra@twitch.tv' AS extension_author_email,'amorelandra' AS extension_author_name,'amorelandra@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/mcg3xmuqr7fv0ye99hfvjt8e9wcamk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'bpdwalhiyro3a31fnn34qwuk5tgufv' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Maestro Overlay' AS extension_name,'video_overlay' AS extension_anchor,'dev@maestro.io' AS extension_author_email,'Maestro' AS extension_author_name,'support@maestro.io' AS extension_support_email,'https://www.twitch.tv/ext/bpdwalhiyro3a31fnn34qwuk5tgufv' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Ready For Review' AS extension_state,'8y20yh3ya3ca9x1s8k5sa0xj5hs19r' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Maestro Quest Panel' AS extension_name,'panel' AS extension_anchor,'dev@maestro.io' AS extension_author_email,'Maestro' AS extension_author_name,'support@maestro.io' AS extension_support_email,'https://www.twitch.tv/ext/8y20yh3ya3ca9x1s8k5sa0xj5hs19r' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'lhyvltp09mg6xmdy3p9ey6t1pyz445' AS extension_id,'0.1.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'MasterOverwatch' AS extension_name,'video_overlay' AS extension_anchor,'inquiries@masteroverwatch.com' AS extension_author_email,'Master Network' AS extension_author_name,'inquiries@masteroverwatch.com' AS extension_support_email,'https://www.twitch.tv/ext/lhyvltp09mg6xmdy3p9ey6t1pyz445' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'lj3bifhwkjjxgvohzckle4s45jf2se' AS extension_id,'0.1.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Matts Test Extension' AS extension_name,'panel' AS extension_anchor,'rudderm@twitch.tv' AS extension_author_email,'Matt Rudder' AS extension_author_name,'rudderm@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/lj3bifhwkjjxgvohzckle4s45jf2se' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2qc77tn0lhp0jju8yl2rm1qr6zwl9x' AS extension_id,'0.0.2' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Matts Test Panel' AS extension_name,'panel' AS extension_anchor,'rudderm@twitch.tv' AS extension_author_email,'Matt Rudder' AS extension_author_name,'rudderm@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/2qc77tn0lhp0jju8yl2rm1qr6zwl9x' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'i8z0nct9wygyq2x64481coetiiqvw8' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Meastosos FFXIV FFLogs Overlay' AS extension_name,'video_overlay' AS extension_anchor,'carensdorf@gmail.com' AS extension_author_email,'meastoso' AS extension_author_name,'meastoso@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/i8z0nct9wygyq2x64481coetiiqvw8' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'aler6fbat3ah13z31bhouz4yp4cig6' AS extension_id,'0.0.1' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Medazzaland Extension 1' AS extension_name,'video_overlay' AS extension_anchor,'paj@medazzaland.co.uk' AS extension_author_email,'medazzaland' AS extension_author_name,'twitch@medazzaland.co.uk' AS extension_support_email,'https://www.twitch.tv/ext/aler6fbat3ah13z31bhouz4yp4cig6' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'qfhy4mk7ov3d2di7zezjkblaii4sap' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Mobalytics.gg' AS extension_name,'video_overlay' AS extension_anchor,'nl@mobalytics.gg' AS extension_author_email,'Mobalytics' AS extension_author_name,'support@mobalytics.gg' AS extension_support_email,'https://www.twitch.tv/ext/qfhy4mk7ov3d2di7zezjkblaii4sap' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'11tabh117xzmujisiqfcmeihpphbxi' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Mobalytics.gg for League of Legends' AS extension_name,'video_overlay' AS extension_anchor,'nl@mobalytics.gg' AS extension_author_email,'Mobalytics' AS extension_author_name,'support@mobalytics.gg' AS extension_support_email,'https://www.twitch.tv/ext/11tabh117xzmujisiqfcmeihpphbxi' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'x92a5yiivjs0vfv6vqvzc8g9p99wdo' AS extension_id,'1.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'ModsPls' AS extension_name,'component' AS extension_anchor,'jtan@ksv.gg' AS extension_author_email,'ModsPls' AS extension_author_name,'support@modspls.com' AS extension_support_email,'https://www.twitch.tv/ext/x92a5yiivjs0vfv6vqvzc8g9p99wdo' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'jrltn6yuxdiwpof16bbofu7k6pwr1w' AS extension_id,'1.0.2' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Mosaic' AS extension_name,'panel' AS extension_anchor,'sam_cm_to@hotmail.com' AS extension_author_email,'PurityDev' AS extension_author_name,'info@puritydev.io' AS extension_support_email,'https://www.twitch.tv/ext/jrltn6yuxdiwpof16bbofu7k6pwr1w' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'jrltn6yuxdiwpof16bbofu7k6pwr1w' AS extension_id,'1.0.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Mosaic' AS extension_name,'panel' AS extension_anchor,'sam_cm_to@hotmail.com' AS extension_author_email,'PurityDev' AS extension_author_name,'info@puritydev.io' AS extension_support_email,'https://www.twitch.tv/ext/jrltn6yuxdiwpof16bbofu7k6pwr1w' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'yvi77da9edbnjuffpghz4uluzf021g' AS extension_id,'1.0.2' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Music Requests' AS extension_name,'video_overlay' AS extension_anchor,'colbydude@voidteam.net' AS extension_author_email,'Colbydude' AS extension_author_name,'colbydude@voidteam.net' AS extension_support_email,'https://www.twitch.tv/ext/yvi77da9edbnjuffpghz4uluzf021g' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'7vgxduew8hz35gvs092gwamlxp1sth' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'MyPaladins' AS extension_name,'video_overlay' AS extension_anchor,'business@zoneapp.net' AS extension_author_email,'Zone GmbH' AS extension_author_name,'hello@zoneapp.net' AS extension_support_email,'https://www.twitch.tv/ext/7vgxduew8hz35gvs092gwamlxp1sth' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2k9c9x1dqjxar850l5m6r3lhhyv7iq' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'MyPaladins Stats Panel' AS extension_name,'panel' AS extension_anchor,'business@zoneapp.net' AS extension_author_email,'Zone GmbH' AS extension_author_name,'hello@zoneapp.net' AS extension_support_email,'https://www.twitch.tv/ext/2k9c9x1dqjxar850l5m6r3lhhyv7iq' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'e3ene24eo1ykignselxba81mb6qczk' AS extension_id,'2.0.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'NBA G League Extension' AS extension_name,'video_overlay' AS extension_anchor,'notanemail@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/e3ene24eo1ykignselxba81mb6qczk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'gh70y1spw727ohtgzbhc0hppvq9br2' AS extension_id,'0.2.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Niconico!' AS extension_name,'video_overlay' AS extension_anchor,'srwfe2@yahoo.com.tw' AS extension_author_email,'srwfe' AS extension_author_name,'srwfe2@yahoo.com.tw' AS extension_support_email,'https://www.twitch.tv/ext/gh70y1spw727ohtgzbhc0hppvq9br2' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Rejected' AS extension_state,'62a2yvqm2fsec02pycycyd7gvm727q' AS extension_id,'0.1.2' AS extension_version,'' AS extension_category_id,'Now Playing' AS extension_name,'panel' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/62a2yvqm2fsec02pycycyd7gvm727q' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'lgpf9j7y8n1ja9onkb6w7bxfkhk2zl' AS extension_id,'1.1.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'OP.GG for League of Legends' AS extension_name,'video_overlay' AS extension_anchor,'kars@op.gg' AS extension_author_email,'OP.GG Inc.' AS extension_author_name,'support@op.gg' AS extension_support_email,'https://www.twitch.tv/ext/lgpf9j7y8n1ja9onkb6w7bxfkhk2zl' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'lgpf9j7y8n1ja9onkb6w7bxfkhk2zl' AS extension_id,'1.1.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'OP.GG for League of Legends' AS extension_name,'video_overlay' AS extension_anchor,'kars@op.gg' AS extension_author_email,'OP.GG Inc.' AS extension_author_name,'support@op.gg' AS extension_support_email,'https://www.twitch.tv/ext/lgpf9j7y8n1ja9onkb6w7bxfkhk2zl' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'efu6io2rqap5etnqkkzekzzv0981kj' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'OP.GG for PUBG' AS extension_name,'video_overlay' AS extension_anchor,'while@awhile.us' AS extension_author_email,'OP.GG Inc.' AS extension_author_name,'support@op.gg' AS extension_support_email,'https://www.twitch.tv/ext/efu6io2rqap5etnqkkzekzzv0981kj' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'efu6io2rqap5etnqkkzekzzv0981kj' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'OP.GG for PUBG' AS extension_name,'video_overlay' AS extension_anchor,'while@awhile.us' AS extension_author_email,'kargnas' AS extension_author_name,'support@op.gg' AS extension_support_email,'https://www.twitch.tv/ext/efu6io2rqap5etnqkkzekzzv0981kj' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ynrzj2rhioa4yrgkti2j2c5csxgfd6' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Octarine: Dota Stats Overlay' AS extension_name,'video_overlay' AS extension_anchor,'justin.blau8@gmail.com' AS extension_author_email,'BlueCloudDev' AS extension_author_name,'justin.blau8@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/ynrzj2rhioa4yrgkti2j2c5csxgfd6' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'nu0wcl1epquwc4fqjq97kcnby1dve4' AS extension_id,'0.2.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'OneView' AS extension_name,'video_overlay' AS extension_anchor,'admin@esports.one' AS extension_author_email,'Esports One' AS extension_author_name,'support@esports.one' AS extension_support_email,'https://www.twitch.tv/ext/nu0wcl1epquwc4fqjq97kcnby1dve4' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'q9hjbqg3j6ukrq81pqyb9j5kwomzl8' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Open Dccon Selector' AS extension_name,'video_overlay' AS extension_anchor,'rishubil@gmail.com' AS extension_author_email,'Nesswit' AS extension_author_name,'rishubil+jod@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/q9hjbqg3j6ukrq81pqyb9j5kwomzl8' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'aqjwzc9c7d45xgiv27i5zygc29a778' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Otis Bot Leaderboards' AS extension_name,'panel' AS extension_anchor,'lyonbeckers@gmail.com' AS extension_author_email,'lyonbeckers' AS extension_author_name,'help@nylonblonde.com' AS extension_support_email,'https://www.twitch.tv/ext/aqjwzc9c7d45xgiv27i5zygc29a778' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ka3y28rrgh2f533mxt9ml37fv6zb8k' AS extension_id,'1.0.3' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Overlay' AS extension_name,'video_overlay' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/ka3y28rrgh2f533mxt9ml37fv6zb8k' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'hz584ynr8wyug0tnajrps6d48hy0qk' AS extension_id,'1.1.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Overwatch League Overlay Extension' AS extension_name,'video_overlay' AS extension_anchor,'suport@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/hz584ynr8wyug0tnajrps6d48hy0qk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hz584ynr8wyug0tnajrps6d48hy0qk' AS extension_id,'1.0.8' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Overwatch League Overlay Extension' AS extension_name,'video_overlay' AS extension_anchor,'suport@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/hz584ynr8wyug0tnajrps6d48hy0qk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'ys5t8unpbrpjo91xf1hcp7syvke029' AS extension_id,'0.0.3' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'PTZOptics Audience Camera Controller' AS extension_name,'video_overlay' AS extension_anchor,'paul.richards@streamgeeks.us' AS extension_author_email,'sgeeks' AS extension_author_name,'paul.richards@ptzoptics.com' AS extension_support_email,'https://www.twitch.tv/ext/ys5t8unpbrpjo91xf1hcp7syvke029' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ys5t8unpbrpjo91xf1hcp7syvke029' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'PTZOptics Audience Camera Controller' AS extension_name,'video_overlay' AS extension_anchor,'paul.richards@streamgeeks.us' AS extension_author_email,'sgeeks' AS extension_author_name,'paul.richards@ptzoptics.com' AS extension_support_email,'https://www.twitch.tv/ext/ys5t8unpbrpjo91xf1hcp7syvke029' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ntoy7596k38wxwaj4rfb5vaw9jsimn' AS extension_id,'1.0.2' AS extension_version,'' AS extension_category_id,'PUBG Contraband' AS extension_name,'video_overlay' AS extension_anchor,'patrick@twitch.tv' AS extension_author_email,'Twitch' AS extension_author_name,'extensions-support@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/ntoy7596k38wxwaj4rfb5vaw9jsimn' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'h0j38o8b6cvzsn4jtzd272rzf8cwim' AS extension_id,'1.0.2' AS extension_version,'' AS extension_category_id,'PUBG Contraband Panel' AS extension_name,'panel' AS extension_anchor,'patrick@twitch.tv' AS extension_author_email,'Twitch' AS extension_author_name,'extensions-support@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/h0j38o8b6cvzsn4jtzd272rzf8cwim' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'b7pozpf4r0qjgdn4hfrvw0mlbpqp9e' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'PUBG Warfare Master(PWM) Video Overlay' AS extension_name,'video_overlay' AS extension_anchor,'kenpark@spotvgames.com' AS extension_author_email,'PWM2018' AS extension_author_name,'jhahn@spotvgames.com' AS extension_support_email,'https://www.twitch.tv/ext/b7pozpf4r0qjgdn4hfrvw0mlbpqp9e' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'b7pozpf4r0qjgdn4hfrvw0mlbpqp9e' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'PUBG Warfare Master(PWM) Video Overlay' AS extension_name,'video_overlay' AS extension_anchor,'kenpark@spotvgames.com' AS extension_author_email,'PWM2018' AS extension_author_name,'jhahn@spotvgames.com' AS extension_support_email,'https://www.twitch.tv/ext/b7pozpf4r0qjgdn4hfrvw0mlbpqp9e' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'t1w9b6gnc9k71w4x7ytsxcppfxrq3l' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'PUBG dropPoll - Live Drop Location Polls' AS extension_name,'video_overlay' AS extension_anchor,'benjohnson9117@gmail.com' AS extension_author_email,'ben' AS extension_author_name,'ben@benjohnson.studio' AS extension_support_email,'https://www.twitch.tv/ext/t1w9b6gnc9k71w4x7ytsxcppfxrq3l' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'6jhaq431m7znwmdo8zoos3kzh4apri' AS extension_id,'1.0.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'PaladinsGuru Panel' AS extension_name,'panel' AS extension_anchor,'eric@egn.io' AS extension_author_email,'Evolution Gaming LLC' AS extension_author_name,'support@egn.io' AS extension_support_email,'https://www.twitch.tv/ext/6jhaq431m7znwmdo8zoos3kzh4apri' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4r5dbjkggpumuzfvmisn3pbr5irjsp' AS extension_id,'0.0.1' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Panda Pizza Party' AS extension_name,'panel' AS extension_anchor,'artur@fracek.com' AS extension_author_email,'polishedperspective' AS extension_author_name,'support@polishedperspective.com' AS extension_support_email,'https://www.twitch.tv/ext/4r5dbjkggpumuzfvmisn3pbr5irjsp' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'qzb7tlfzzs6khjzscdy3h6aq38vb6s' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Paragon by Playr.online' AS extension_name,'video_overlay' AS extension_anchor,'support@playr.online' AS extension_author_email,'Playr.online' AS extension_author_name,'support@playr.online' AS extension_support_email,'https://www.twitch.tv/ext/qzb7tlfzzs6khjzscdy3h6aq38vb6s' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'cue7cbi87k8mwtkvj8941vx44pmu8v' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Particles Creator' AS extension_name,'video_overlay' AS extension_anchor,'webmaster@queleas.com' AS extension_author_email,'Queleas LLC' AS extension_author_name,'webmaster@queleas.com' AS extension_support_email,'https://www.twitch.tv/ext/cue7cbi87k8mwtkvj8941vx44pmu8v' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'lxjbzka0izf2rwuwn0160y10jratqw' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Pastebin Viewer' AS extension_name,'video_overlay' AS extension_anchor,'lukaskrickl@gmail.com' AS extension_author_email,'unlink2' AS extension_author_name,'lukaskrickl@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/lxjbzka0izf2rwuwn0160y10jratqw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'e54djnfqu7dc8bd3913mx01yxcypbw' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Pats Test Extension' AS extension_name,'video_overlay' AS extension_anchor,'patrick@twitch.tv' AS extension_author_email,'Pat Sanchez' AS extension_author_name,'patrick@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/e54djnfqu7dc8bd3913mx01yxcypbw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'0uyptukpdot0t6enn9js4eo8csm34w' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Pats Test Extension 4' AS extension_name,'panel' AS extension_anchor,'patrick@twitch.tv' AS extension_author_email,'Pat Sanchez' AS extension_author_name,'patrick@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/0uyptukpdot0t6enn9js4eo8csm34w' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'buesfgive961xt62gksyff7qmga3dt' AS extension_id,'1.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Path of Exile Streamer Gear Viewer' AS extension_name,'video_overlay' AS extension_anchor,'sakurazaki.setsunita@gmail.com' AS extension_author_email,'k3shanberk' AS extension_author_name,'sakurazaki.setsunita@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/buesfgive961xt62gksyff7qmga3dt' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'k7mzfi3ma4oi30kyj9oq4vnes2ga37' AS extension_id,'0.0.5' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Phoe wow Armory' AS extension_name,'video_overlay' AS extension_anchor,'jhosan@gmail.com' AS extension_author_email,'non_internerd' AS extension_author_name,'internerddev@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/k7mzfi3ma4oi30kyj9oq4vnes2ga37' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'cqc8dmwbndhk744yf7g1ugyotna8vi' AS extension_id,'0.0.6' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Pixel Breeders' AS extension_name,'panel' AS extension_anchor,'chris@pixel-maniacs.com' AS extension_author_email,'pixel_maniacs' AS extension_author_name,'info@pixel-maniacs.com' AS extension_support_email,'https://www.twitch.tv/ext/cqc8dmwbndhk744yf7g1ugyotna8vi' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'og8bawl7ztp332mt3xm4va6fsk4oy7' AS extension_id,'1.1.02' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Pixel Hunt' AS extension_name,'video_overlay' AS extension_anchor,'team@porcupine.tv' AS extension_author_email,'porcupinetv' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/og8bawl7ztp332mt3xm4va6fsk4oy7' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'6tpu6v7sjdjh7jqprlq63e2vmntpad' AS extension_id,'1.0.0' AS extension_version,'' AS extension_category_id,'Poll' AS extension_name,'panel' AS extension_anchor,'pulsoidnet@gmail.com' AS extension_author_email,'pulsoid' AS extension_author_name,'pulsoidnet@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/6tpu6v7sjdjh7jqprlq63e2vmntpad' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ipakgpo1zkxqq56j7xjj47ibk4dzmt' AS extension_id,'0.0.6' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Power Rangers: HyperForce RPG' AS extension_name,'panel' AS extension_anchor,'pz@hyperrpg.com' AS extension_author_email,'pillowzac' AS extension_author_name,'pz@hyperrpg.com' AS extension_support_email,'https://www.twitch.tv/ext/ipakgpo1zkxqq56j7xjj47ibk4dzmt' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'f5647q7fyxw8848z7ksuk6b1ry79ks' AS extension_id,'2.0.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Powered Up Animations!' AS extension_name,'video_overlay' AS extension_anchor,'casperryt@gmail.com' AS extension_author_email,'Casperr' AS extension_author_name,'casperryt@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/f5647q7fyxw8848z7ksuk6b1ry79ks' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'f5647q7fyxw8848z7ksuk6b1ry79ks' AS extension_id,'1.0.2' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Powered Up Bits Animations' AS extension_name,'video_overlay' AS extension_anchor,'casperryt@gmail.com' AS extension_author_email,'Casperr' AS extension_author_name,'casperryt@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/f5647q7fyxw8848z7ksuk6b1ry79ks' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'lym9op247qx2dplz60iu0quhhwrjwt' AS extension_id,'0.0.4' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Pretzel Rocks (Song Requests)' AS extension_name,'panel' AS extension_anchor,'devs+twitch@pretzel.rocks' AS extension_author_email,'Pretzel Tech LLC' AS extension_author_name,'help+twitch@pretzel.rocks' AS extension_support_email,'https://www.twitch.tv/ext/lym9op247qx2dplz60iu0quhhwrjwt' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'lym9op247qx2dplz60iu0quhhwrjwt' AS extension_id,'0.0.3' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Pretzel Rocks (Song Requests)' AS extension_name,'video_overlay' AS extension_anchor,'devs+twitch@pretzel.rocks' AS extension_author_email,'Pretzel Tech LLC' AS extension_author_name,'help+twitch@pretzel.rocks' AS extension_support_email,'https://www.twitch.tv/ext/lym9op247qx2dplz60iu0quhhwrjwt' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'qh13438dnohbfdnbkvo1n9hnsofrel' AS extension_id,'0.0.4' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Pretzel Rocks: Whats Playing' AS extension_name,'panel' AS extension_anchor,'dev+twitch@pretzel.rocks' AS extension_author_email,'Pretzel Tech' AS extension_author_name,'help+twitch@pretzel.rocks' AS extension_support_email,'https://www.twitch.tv/ext/qh13438dnohbfdnbkvo1n9hnsofrel' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'gf8iji2drnbafa59e238r1u1rqqo1f' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Pretzel: Isaac Tracker' AS extension_name,'panel' AS extension_anchor,'dev+twitch@pretzel.gg' AS extension_author_email,'Pretzel Tech' AS extension_author_name,'help+twitch@pretzel.gg' AS extension_support_email,'https://www.twitch.tv/ext/gf8iji2drnbafa59e238r1u1rqqo1f' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'d4uvtfdr04uq6raoenvj7m86gdk16v' AS extension_id,'2.0.2' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Prime Subscription and Loot Reminder' AS extension_name,'video_overlay' AS extension_anchor,'twitch-prime-extension-dev@amazon.com' AS extension_author_email,'Twitch Prime' AS extension_author_name,'twitch-prime-extension-support@amazon.com' AS extension_support_email,'https://www.twitch.tv/ext/d4uvtfdr04uq6raoenvj7m86gdk16v' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'u4xkb2t4a2v6ex9f465sghrpk458a2' AS extension_id,'0.0.3' AS extension_version,'' AS extension_category_id,'Purchases Demo' AS extension_name,'panel' AS extension_anchor,'yoh@twitch.tv' AS extension_author_email,'Yoh Suzuki' AS extension_author_name,'yoh@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/u4xkb2t4a2v6ex9f465sghrpk458a2' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'pvto7ucug1oy5z6m65z8lw4590n86e' AS extension_id,'0.0.3' AS extension_version,'' AS extension_category_id,'Purchases Demo Video' AS extension_name,'video_overlay' AS extension_anchor,'yoh@twitch.tv' AS extension_author_email,'yohsuzuki' AS extension_author_name,'yoh@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/pvto7ucug1oy5z6m65z8lw4590n86e' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Ready For Review' AS extension_state,'zbb2zh4jthrh83jnsr4h8o43vhtyks' AS extension_id,'0.1' AS extension_version,'' AS extension_category_id,'QA PANEL 1' AS extension_name,'panel' AS extension_anchor,'kzzhang@twitch.tv' AS extension_author_email,'kzzhang' AS extension_author_name,'kzzhang@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/zbb2zh4jthrh83jnsr4h8o43vhtyks' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'5ul5ajg49sjyrc8ezab5qqv25fdscp' AS extension_id,'0.2' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Queue' AS extension_name,'panel' AS extension_anchor,'seravy@gmail.com' AS extension_author_email,'Seravy' AS extension_author_name,'support@seravy.com' AS extension_support_email,'https://www.twitch.tv/ext/5ul5ajg49sjyrc8ezab5qqv25fdscp' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'49qu7wv3myvul5fa7fxazo1bcsnc8j' AS extension_id,'0.2' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Queue+' AS extension_name,'panel' AS extension_anchor,'seravy@gmail.com' AS extension_author_email,'Seravy' AS extension_author_name,'support@seravy.com' AS extension_support_email,'https://www.twitch.tv/ext/49qu7wv3myvul5fa7fxazo1bcsnc8j' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'5xnotsdijslpzrgn0eqq1tqg0uepkl' AS extension_id,'0.0.5' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'RIU PokerStars' AS extension_name,'video_overlay' AS extension_anchor,'rorymacdonald6@hotmail.com' AS extension_author_email,'rorrrr90' AS extension_author_name,'rory@runitup.com' AS extension_support_email,'https://www.twitch.tv/ext/5xnotsdijslpzrgn0eqq1tqg0uepkl' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'bcgmgp5qbmvh2clmvuu3lzalid5926' AS extension_id,'0.1.0' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Reabsbot_Overlay' AS extension_name,'video_overlay' AS extension_anchor,'Reabs3@gmail.com' AS extension_author_email,'Reabs' AS extension_author_name,'Reabs3@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/bcgmgp5qbmvh2clmvuu3lzalid5926' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'lfjwu2x53w4l451ximyx8nufvcoe6s' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'ReactionGifs!' AS extension_name,'component' AS extension_anchor,'coen.mcclelland@gmail.com' AS extension_author_email,'tallco.de' AS extension_author_name,'reactiongifs@tallco.de' AS extension_support_email,'https://www.twitch.tv/ext/lfjwu2x53w4l451ximyx8nufvcoe6s' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'9eaxe01xx93y3rul21rt9cl89dis6v' AS extension_id,'1.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Reactions' AS extension_name,'video_overlay' AS extension_anchor,'akira_laine@outlook.com' AS extension_author_email,'chess' AS extension_author_name,'akira_laine@outlook.com' AS extension_support_email,'https://www.twitch.tv/ext/9eaxe01xx93y3rul21rt9cl89dis6v' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'kmcggd427iggksg7lsxhkj8bkjp6h7' AS extension_id,'1.2.5' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Reactions by Emotists' AS extension_name,'panel' AS extension_anchor,'eric@egn.io' AS extension_author_email,'Emotists' AS extension_author_name,'support@egn.io' AS extension_support_email,'https://www.twitch.tv/ext/kmcggd427iggksg7lsxhkj8bkjp6h7' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'kmcggd427iggksg7lsxhkj8bkjp6h7' AS extension_id,'1.2.0' AS extension_version,'' AS extension_category_id,'Reactions by Emotists' AS extension_name,'video_overlay' AS extension_anchor,'eric@egn.io' AS extension_author_email,'Emotists' AS extension_author_name,'support@egn.io' AS extension_support_email,'https://www.twitch.tv/ext/kmcggd427iggksg7lsxhkj8bkjp6h7' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'zobz6murw44q77mas474u69y52aubg' AS extension_id,'1.0.0' AS extension_version,'' AS extension_category_id,'Recent Videos' AS extension_name,'panel' AS extension_anchor,'ekennedy@ek81.com' AS extension_author_email,'burrito_cheesy' AS extension_author_name,'ekennedy@ek81.com' AS extension_support_email,'https://www.twitch.tv/ext/zobz6murw44q77mas474u69y52aubg' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ah9foa4l785rl4ygk0y64tpgcaxwtk' AS extension_id,'0.0.4' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Rock Paper BITS' AS extension_name,'video_overlay' AS extension_anchor,'dev@maestro.io' AS extension_author_email,'ofsoulheartmind' AS extension_author_name,'support@maestro.io' AS extension_support_email,'https://www.twitch.tv/ext/ah9foa4l785rl4ygk0y64tpgcaxwtk' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'3wdyco0mi2ndsupp5b2zbc6ig0i9zy' AS extension_id,'1.1.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Roleplay Character Sheets' AS extension_name,'video_overlay' AS extension_anchor,'themetamancer@gmail.com' AS extension_author_email,'metamancer' AS extension_author_name,'support@metamancer.tv' AS extension_support_email,'https://www.twitch.tv/ext/3wdyco0mi2ndsupp5b2zbc6ig0i9zy' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'kkzco5b4bok6cerwl4lgtdy43hpzfb' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Run It Up Studios' AS extension_name,'video_overlay' AS extension_anchor,'rorymacdonald6@hotmail.com' AS extension_author_email,'rorrrr90' AS extension_author_name,'rory@runitup.com' AS extension_support_email,'https://www.twitch.tv/ext/kkzco5b4bok6cerwl4lgtdy43hpzfb' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'w6napr71wufwip7n0y7hdbt1omtzir' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Ryans Testing Extension' AS extension_name,'video_overlay' AS extension_anchor,'rlubinsk@twitch.tv' AS extension_author_email,'RyanL Inc.' AS extension_author_name,'testingthis@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/w6napr71wufwip7n0y7hdbt1omtzir' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'uzyk6s03wo91dcji520t84x2mhwb65' AS extension_id,'0.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'SC2 Tracker' AS extension_name,'panel' AS extension_anchor,'soufiane.hassou@gmail.com' AS extension_author_email,'Soufiane H.' AS extension_author_name,'soufiane.hassou@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/uzyk6s03wo91dcji520t84x2mhwb65' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hts7bfg5bccjwy9p0hcof7cxkqbmeq' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'SD MTGO Draft Tracker' AS extension_name,'video_overlay' AS extension_anchor,'StreamDecker@Gmail.com' AS extension_author_email,'StreamDecker' AS extension_author_name,'StreamDecker@Gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/hts7bfg5bccjwy9p0hcof7cxkqbmeq' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'9hzxsfv4wbukwsctgvnrrtsekgjcc9' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'SHolidays School' AS extension_name,'video_overlay' AS extension_anchor,'ds@red-square.org' AS extension_author_email,'sholidays' AS extension_author_name,'dev31123@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/9hzxsfv4wbukwsctgvnrrtsekgjcc9' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'1ho24kr7crna6qq1997yk9egdybhde' AS extension_id,'0.0.7' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'SMITE Live Stats' AS extension_name,'video_overlay' AS extension_anchor,'asims178@gmail.com' AS extension_author_email,'Asim' AS extension_author_name,'asims178@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/1ho24kr7crna6qq1997yk9egdybhde' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'8jefzhtahl455ftq87euflde7ad69m' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'SRC Miniboard' AS extension_name,'video_overlay' AS extension_anchor,'Jmunoz802@gmail.com' AS extension_author_email,'Nice Engineering' AS extension_author_name,'nooberttwitch@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/8jefzhtahl455ftq87euflde7ad69m' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'qyldiw6439m8ppedknq9f3gogfn3y3' AS extension_id,'0.0.1' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'STOMT in your Panels' AS extension_name,'panel' AS extension_anchor,'max.klenk@stomt.com' AS extension_author_email,'STOMT' AS extension_author_name,'info@stomt.com' AS extension_support_email,'https://www.twitch.tv/ext/qyldiw6439m8ppedknq9f3gogfn3y3' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'al3n7eaaifof6bcjxo4cgnwkwqn8ge' AS extension_id,'1.0.0' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'STOMT in your Stream' AS extension_name,'video_overlay' AS extension_anchor,'max.klenk@stomt.com' AS extension_author_email,'STOMT' AS extension_author_name,'max@stomt.com' AS extension_support_email,'https://www.twitch.tv/ext/al3n7eaaifof6bcjxo4cgnwkwqn8ge' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'2zra50425wzzregbr7nqy9ma6eh9ed' AS extension_id,'0.8.5' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Schedule' AS extension_name,'panel' AS extension_anchor,'contact@layerone.io' AS extension_author_email,'Layer One' AS extension_author_name,'contact@layerone.io' AS extension_support_email,'https://www.twitch.tv/ext/2zra50425wzzregbr7nqy9ma6eh9ed' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2zra50425wzzregbr7nqy9ma6eh9ed' AS extension_id,'0.8.4' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Schedule' AS extension_name,'panel' AS extension_anchor,'contact@layerone.io' AS extension_author_email,'Layer One' AS extension_author_name,'contact@layerone.io' AS extension_support_email,'https://www.twitch.tv/ext/2zra50425wzzregbr7nqy9ma6eh9ed' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'fpgrhspactjwtf8u5lc6pwd4e4lnhw' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Screen Controls' AS extension_name,'video_overlay' AS extension_anchor,'beamplayshs@gmail.com' AS extension_author_email,'TwitchPlayzHS' AS extension_author_name,'andreasgeis94@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/fpgrhspactjwtf8u5lc6pwd4e4lnhw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ebqi0pcrcsa4pl8dvr9l7lua0xolv4' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Screen Sync' AS extension_name,'video_overlay' AS extension_anchor,'kolyaopahle@googlemail.com' AS extension_author_email,'kolpao' AS extension_author_name,'kolyaopahle@googlemail.com' AS extension_support_email,'https://www.twitch.tv/ext/ebqi0pcrcsa4pl8dvr9l7lua0xolv4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'3ibaum1nyc7ru62htue9zrsjrfdh9k' AS extension_id,'0.0.1' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Serpent.AI Schedule' AS extension_name,'panel' AS extension_anchor,'nicholas@serpent.ai' AS extension_author_email,'serpent_ai' AS extension_author_name,'nicholas@serpent.ai' AS extension_support_email,'https://www.twitch.tv/ext/3ibaum1nyc7ru62htue9zrsjrfdh9k' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'j7k6c70mwwyhsamq0nold3kikikpg6' AS extension_id,'0.0.1' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'SimLiveRadio' AS extension_name,'panel' AS extension_anchor,'mirco@laxz.de' AS extension_author_email,'LaxZ' AS extension_author_name,'support@laxz.de' AS extension_support_email,'https://www.twitch.tv/ext/j7k6c70mwwyhsamq0nold3kikikpg6' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'6u30jon0uvoruonsllb9joifzu8ioa' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Simple World of Warcraft Armory Overlay' AS extension_name,'video_overlay' AS extension_anchor,'laason.fredrik@gmail.com' AS extension_author_email,'Morgonbladet' AS extension_author_name,'laason.fredrik@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/6u30jon0uvoruonsllb9joifzu8ioa' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'3mg0l8qvrqsavmlgmc1g8c2hnv8c1r' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Sinnlos GmbH' AS extension_name,'panel' AS extension_anchor,'mirco@laxz.de' AS extension_author_email,'LaxZ' AS extension_author_name,'support@laxz.de' AS extension_support_email,'https://www.twitch.tv/ext/3mg0l8qvrqsavmlgmc1g8c2hnv8c1r' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'d8klr4cjvwro1v4il175ybamam7q6n' AS extension_id,'0.0.1' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Slaw Panel v2' AS extension_name,'panel' AS extension_anchor,'hungryed6@yahoo.com' AS extension_author_email,'hungryed' AS extension_author_name,'hungryed6@yahoo.com' AS extension_support_email,'https://www.twitch.tv/ext/d8klr4cjvwro1v4il175ybamam7q6n' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'c8okel68mmobvnso7ty0cygj8easam' AS extension_id,'0.1.5' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Smart Click Maps' AS extension_name,'video_overlay' AS extension_anchor,'twitch@exmg.tv' AS extension_author_email,'ExMachina' AS extension_author_name,'twitch@exmg.tv' AS extension_support_email,'https://www.twitch.tv/ext/c8okel68mmobvnso7ty0cygj8easam' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'z64j8jifuufkralahq0spsjciko0ot' AS extension_id,'1.2.0' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Snap' AS extension_name,'panel' AS extension_anchor,'ehgoodenough@gmail.com' AS extension_author_email,'yeahgoodenough' AS extension_author_name,'ehgoodenough+snap@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/z64j8jifuufkralahq0spsjciko0ot' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'z64j8jifuufkralahq0spsjciko0ot' AS extension_id,'1.1.0' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Snap' AS extension_name,'video_overlay' AS extension_anchor,'ehgoodenough@gmail.com' AS extension_author_email,'yeahgoodenough' AS extension_author_name,'ehgoodenough+snap@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/z64j8jifuufkralahq0spsjciko0ot' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4503ze1ivznosb6vh5es8a0pmrwrq4' AS extension_id,'0.0.2' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Song Playlist Voter' AS extension_name,'video_overlay' AS extension_anchor,'twitchexstensions@trainor.org.uk' AS extension_author_email,'Jordan30001' AS extension_author_name,'twitchexstensions@trainor.org.uk' AS extension_support_email,'https://www.twitch.tv/ext/4503ze1ivznosb6vh5es8a0pmrwrq4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'bttsqjy6dnv05acplp5vy0mflgrh3z' AS extension_id,'1.0.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Sound Alerts' AS extension_name,'panel' AS extension_anchor,'altoar@live.de' AS extension_author_email,'Altoar.io' AS extension_author_name,'altoar@live.de' AS extension_support_email,'https://www.twitch.tv/ext/bttsqjy6dnv05acplp5vy0mflgrh3z' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'bttsqjy6dnv05acplp5vy0mflgrh3z' AS extension_id,'0.0.7' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Sound Alerts' AS extension_name,'panel' AS extension_anchor,'altoar@live.de' AS extension_author_email,'Altoar.io' AS extension_author_name,'altoar@live.de' AS extension_support_email,'https://www.twitch.tv/ext/bttsqjy6dnv05acplp5vy0mflgrh3z' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'0rxxisdzyer9cbo2rpsnzytec9o2i4' AS extension_id,'0.1.11' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Speedrun Personal Best Panel' AS extension_name,'panel' AS extension_anchor,'lukaskrickl@gmail.com' AS extension_author_email,'unlink2' AS extension_author_name,'lukaskrickl@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/0rxxisdzyer9cbo2rpsnzytec9o2i4' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'u2nvainvlx73h5a7cnxpiodpfcbmo1' AS extension_id,'1.1.2' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Speedrun Personal Bests' AS extension_name,'panel' AS extension_anchor,'xtvaser@gmail.com' AS extension_author_email,'xTVaser' AS extension_author_name,'xtvaserdev@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/u2nvainvlx73h5a7cnxpiodpfcbmo1' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'5531batpbm8ryhlhxfsn5gjm2dh6vx' AS extension_id,'0.0.2' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Speedrun Summary' AS extension_name,'panel' AS extension_anchor,'mitchkendall@gmail.com' AS extension_author_email,'mitch3a' AS extension_author_name,'mitch3apps@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/5531batpbm8ryhlhxfsn5gjm2dh6vx' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'udg8lekjffg56yft0mhrszhbwoyavy' AS extension_id,'0.0.2' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Speedrunners PB Panel' AS extension_name,'panel' AS extension_anchor,'twitchesxstensions+srcompanel@trainor.org.uk' AS extension_author_email,'jordan30001' AS extension_author_name,'twitchexstensionssupport+srcompanel@trainor.org.uk' AS extension_support_email,'https://www.twitch.tv/ext/udg8lekjffg56yft0mhrszhbwoyavy' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'d6rtelgrhmzkf7mav0a5yc2h9u0sga' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Splat' AS extension_name,'video_overlay' AS extension_anchor,'dev.shawn.m@gmail.com' AS extension_author_email,'Zippers' AS extension_author_name,'cptzippers@outlook.com' AS extension_support_email,'https://www.twitch.tv/ext/d6rtelgrhmzkf7mav0a5yc2h9u0sga' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'asppxuf1di6v7hwfucmogjg9eh32au' AS extension_id,'0.0.1' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Spotify Recently Played' AS extension_name,'panel' AS extension_anchor,'coen.mcclelland@gmail.com' AS extension_author_email,'tallco.de' AS extension_author_name,'twitchspotify@tallco.de' AS extension_support_email,'https://www.twitch.tv/ext/asppxuf1di6v7hwfucmogjg9eh32au' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'h7683cdyci11yov0tlac9f6lkvgtzi' AS extension_id,'0.0.6' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'Spotify: Now Playing' AS extension_name,'panel' AS extension_anchor,'ashton@pixlfox.com' AS extension_author_email,'StreamLabs' AS extension_author_name,'support@pixlfox.com' AS extension_support_email,'https://www.twitch.tv/ext/h7683cdyci11yov0tlac9f6lkvgtzi' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'tel8o38klejg0wn9xmd4l96ib7gbuq' AS extension_id,'1.0.2' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'StanzaCal' AS extension_name,'panel' AS extension_anchor,'founders@stanza.co' AS extension_author_email,'Stanza' AS extension_author_name,'founders@stanza.co' AS extension_support_email,'https://www.twitch.tv/ext/tel8o38klejg0wn9xmd4l96ib7gbuq' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'mjjy5shhoakqt1d5etpcw4kz1qxhfw' AS extension_id,'0.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Starcraft Remastered Encyclopedia' AS extension_name,'panel' AS extension_anchor,'alexpineda86@gmail.com' AS extension_author_email,'Dark Matter & SCTools.TV' AS extension_author_name,'alexpineda86@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/mjjy5shhoakqt1d5etpcw4kz1qxhfw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Rejected' AS extension_state,'cf25h70tgvbedftrsbji783fxeva6s' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Straw Poll' AS extension_name,'video_overlay' AS extension_anchor,'jroberts@justin.tv' AS extension_author_email,'Curse inc.' AS extension_author_name,'overlaysupport@curse.com' AS extension_support_email,'https://www.twitch.tv/ext/cf25h70tgvbedftrsbji783fxeva6s' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'6wz9oxnra11lzjlkr53hjjftk5t6fo' AS extension_id,'0.9.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Streaker (Fortnite LoL & PUBG)' AS extension_name,'video_overlay' AS extension_anchor,'tech@pwnwin.com' AS extension_author_email,'Streaker.gg' AS extension_author_name,'info@streaker.gg' AS extension_support_email,'https://www.twitch.tv/ext/6wz9oxnra11lzjlkr53hjjftk5t6fo' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'fe5a78xkj1lnk9wefpk295p6x3dsvl' AS extension_id,'0.1.0' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Stream Avatars' AS extension_name,'panel' AS extension_anchor,'travismillerdev@gmail.com' AS extension_author_email,'ClonzEh' AS extension_author_name,'travismillerdev@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/fe5a78xkj1lnk9wefpk295p6x3dsvl' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'fe5a78xkj1lnk9wefpk295p6x3dsvl' AS extension_id,'0.0.8' AS extension_version,'' AS extension_category_id,'Stream Avatars' AS extension_name,'panel' AS extension_anchor,'travismillerdev@gmail.com' AS extension_author_email,'ClonzEh' AS extension_author_name,'travismillerdev@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/fe5a78xkj1lnk9wefpk295p6x3dsvl' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'rmyvypn1xvsizd03c1n1g1ojs64vbk' AS extension_id,'0.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Stream Clicker' AS extension_name,'video_overlay' AS extension_anchor,'jan.jurzitza@gmail.com' AS extension_author_email,'WebFreak' AS extension_author_name,'extensions@webfreak.org' AS extension_support_email,'https://www.twitch.tv/ext/rmyvypn1xvsizd03c1n1g1ojs64vbk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'l7p5fhn3253hhezjjl34inwzxyzpop' AS extension_id,'1.0.2' AS extension_version,'' AS extension_category_id,'Stream On "Streamer Says" Challenge' AS extension_name,'video_overlay' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/l7p5fhn3253hhezjjl34inwzxyzpop' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'l7p5fhn3253hhezjjl34inwzxyzpop' AS extension_id,'1.0.1' AS extension_version,'' AS extension_category_id,'Stream On "Streamer Says" Challenge' AS extension_name,'video_overlay' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/l7p5fhn3253hhezjjl34inwzxyzpop' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'y4jq5ejqgodi64cueqvjdip2ekfg0r' AS extension_id,'0.0.1' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Stream Pucks Controller' AS extension_name,'panel' AS extension_anchor,'contact@streamgenie.tv' AS extension_author_email,'Stream Genie' AS extension_author_name,'contact@streamgenie.tv' AS extension_support_email,'https://www.twitch.tv/ext/y4jq5ejqgodi64cueqvjdip2ekfg0r' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'xlxhl2ix3p9dkgsozhi58eymw6cubp' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Stream Suggestions' AS extension_name,'video_overlay' AS extension_anchor,'adamgedeborg@gmail.com' AS extension_author_email,'Adam Gedeborg' AS extension_author_name,'adamgedeborg@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/xlxhl2ix3p9dkgsozhi58eymw6cubp' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'m0ibe6y2mvn58xpgufhs66d47ut35u' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Stream Wager' AS extension_name,'video_overlay' AS extension_anchor,'danefairbanks@gmail.com' AS extension_author_email,'dhqk' AS extension_author_name,'support@danefairbanks.com' AS extension_support_email,'https://www.twitch.tv/ext/m0ibe6y2mvn58xpgufhs66d47ut35u' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'zx96wti8l9b10uhkvgyymez6s9uw0p' AS extension_id,'0.0.2' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'StreamBattlers' AS extension_name,'component' AS extension_anchor,'rorymacdonald6@hotmail.com' AS extension_author_email,'rorrrr90' AS extension_author_name,'rorymacdonald6@hotmail.com' AS extension_support_email,'https://www.twitch.tv/ext/zx96wti8l9b10uhkvgyymez6s9uw0p' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'p6wg2uslpz97av0n61d1v0c7zo3buk' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'StreamDecker Current Decklist' AS extension_name,'video_overlay' AS extension_anchor,'StreamDecker@Gmail.com' AS extension_author_email,'StreamDecker' AS extension_author_name,'streamdecker@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/p6wg2uslpz97av0n61d1v0c7zo3buk' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'p6wg2uslpz97av0n61d1v0c7zo3buk' AS extension_id,'0.0.31' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'StreamDecker Current Decklist' AS extension_name,'video_overlay' AS extension_anchor,'StreamDecker@Gmail.com' AS extension_author_email,'StreamDecker' AS extension_author_name,'streamdecker@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/p6wg2uslpz97av0n61d1v0c7zo3buk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'uaw3vx1k0ttq74u9b2zfvt768eebh1' AS extension_id,'0.2.2' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'StreamElements Leaderboards' AS extension_name,'panel' AS extension_anchor,'info@streamelements.com' AS extension_author_email,'StreamElements.com' AS extension_author_name,'support@streamelements.com' AS extension_support_email,'https://www.twitch.tv/ext/uaw3vx1k0ttq74u9b2zfvt768eebh1' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ro13roxp88918kulntih9uzm7vs9jr' AS extension_id,'1.14.3440' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'StreamLegends' AS extension_name,'panel' AS extension_anchor,'services@proletariat.com' AS extension_author_email,'Proletariat Inc.' AS extension_author_name,'sleghelp@proletariat.com' AS extension_support_email,'https://www.twitch.tv/ext/ro13roxp88918kulntih9uzm7vs9jr' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'gvchn1osmk8ffmazs2pw0a6glao6t0' AS extension_id,'0.0.11' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'StreamLegends Overlay' AS extension_name,'video_overlay' AS extension_anchor,'services@proletariat.com' AS extension_author_email,'Proletariat Inc.' AS extension_author_name,'sleghelp@proletariat.com' AS extension_support_email,'https://www.twitch.tv/ext/gvchn1osmk8ffmazs2pw0a6glao6t0' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'zfh2irvx2jb4s60f02jq0ajm8vwgka' AS extension_id,'1.0.19' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Streamlabs' AS extension_name,'video_overlay' AS extension_anchor,'devteam@streamlabs.com' AS extension_author_email,'Streamlabs' AS extension_author_name,'support@streamlabs.com' AS extension_support_email,'https://www.twitch.tv/ext/zfh2irvx2jb4s60f02jq0ajm8vwgka' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'23mcx0kd450kqgzrvirylw57ogjxrv' AS extension_id,'0.0.3' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Streamlabs (Bits)' AS extension_name,'video_overlay' AS extension_anchor,'devteam@streamlabs.com' AS extension_author_email,'Streamlabs' AS extension_author_name,'support@streamlabs.com' AS extension_support_email,'https://www.twitch.tv/ext/23mcx0kd450kqgzrvirylw57ogjxrv' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'wi08ebtatdc7oj83wtl9uxwz807l8b' AS extension_id,'1.1.91' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Streamlabs Leaderboard' AS extension_name,'panel' AS extension_anchor,'devteam@streamlabs.com' AS extension_author_email,'Streamlabs' AS extension_author_name,'support@streamlabs.com' AS extension_support_email,'https://www.twitch.tv/ext/wi08ebtatdc7oj83wtl9uxwz807l8b' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'wi08ebtatdc7oj83wtl9uxwz807l8b' AS extension_id,'1.1.8' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Streamlabs Leaderboard' AS extension_name,'panel' AS extension_anchor,'devteam@streamlabs.com' AS extension_author_email,'streamlabs.com' AS extension_author_name,'support@streamlabs.com' AS extension_support_email,'https://www.twitch.tv/ext/wi08ebtatdc7oj83wtl9uxwz807l8b' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'naty2zwfp7vecaivuve8ef1hohh6bo' AS extension_id,'1.0.9' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Streamlabs Stream Schedule & Countdown' AS extension_name,'panel' AS extension_anchor,'devteam@streamlabs.com' AS extension_author_email,'streamlabs.com' AS extension_author_name,'support@streamlabs.com' AS extension_support_email,'https://www.twitch.tv/ext/naty2zwfp7vecaivuve8ef1hohh6bo' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'naty2zwfp7vecaivuve8ef1hohh6bo' AS extension_id,'1.0.10' AS extension_version,'' AS extension_category_id,'Streamlabs Stream Schedule & Countdown' AS extension_name,'panel' AS extension_anchor,'devteam@streamlabs.com' AS extension_author_email,'streamlabs.com' AS extension_author_name,'support@streamlabs.com' AS extension_support_email,'https://www.twitch.tv/ext/naty2zwfp7vecaivuve8ef1hohh6bo' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'8rj6jnrdc7vqrlzds8in2fcwecaimz' AS extension_id,'0.0.2' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'SubTable' AS extension_name,'panel' AS extension_anchor,'alexrobertson519@gmail.com' AS extension_author_email,'PaleAleAlex' AS extension_author_name,'SubTable@hodor.run' AS extension_support_email,'https://www.twitch.tv/ext/8rj6jnrdc7vqrlzds8in2fcwecaimz' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'do3e1cmcmos4a17ynwdkvnf7gbqj6d' AS extension_id,'0.1.7' AS extension_version,'' AS extension_category_id,'Subscription Gifting Leaderboard' AS extension_name,'panel' AS extension_anchor,'object.caleb@gmail.com' AS extension_author_email,'antimattertape' AS extension_author_name,'antimattertape@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/do3e1cmcmos4a17ynwdkvnf7gbqj6d' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'z400armyk7r942xmmviyb70sl2zqa5' AS extension_id,'0.0.6' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Sudokitch Overlay' AS extension_name,'video_overlay' AS extension_anchor,'andy@andymorrell.net' AS extension_author_email,'LuckyNoS7evin' AS extension_author_name,'sudoku@andymorrell.net' AS extension_support_email,'https://www.twitch.tv/ext/z400armyk7r942xmmviyb70sl2zqa5' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'z400armyk7r942xmmviyb70sl2zqa5' AS extension_id,'0.0.5' AS extension_version,'' AS extension_category_id,'Sudokitch Overlay' AS extension_name,'video_overlay' AS extension_anchor,'andy@andymorrell.net' AS extension_author_email,'LuckyNoS7evin' AS extension_author_name,'sudoku@andymorrell.net' AS extension_support_email,'https://www.twitch.tv/ext/z400armyk7r942xmmviyb70sl2zqa5' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'6rh8h42nhnjmirlyxc0w9lbpmeehi0' AS extension_id,'0.4.0' AS extension_version,'' AS extension_category_id,'Suggestion Box' AS extension_name,'panel' AS extension_anchor,'guanzo91@gmail.com' AS extension_author_email,'guanzo' AS extension_author_name,'guanzo91@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/6rh8h42nhnjmirlyxc0w9lbpmeehi0' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'74vwlv5j6u4ij320opfy3t9f3n9b0q' AS extension_id,'0.2.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Summoner Info' AS extension_name,'panel' AS extension_anchor,'legendarybuilds@krispin.it' AS extension_author_email,'Legendary Builds' AS extension_author_name,'summonerinfo@krispin.it' AS extension_support_email,'https://www.twitch.tv/ext/74vwlv5j6u4ij320opfy3t9f3n9b0q' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'t9l5z2vcpdfgqpf19rzzoa7yhp2p64' AS extension_id,'0.1.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'SuperCouchBot Overlay' AS extension_name,'video_overlay' AS extension_anchor,'colin.gebler@gebler-online.de' AS extension_author_email,'Nilxoc' AS extension_author_name,'colin.gebler@gebler-online.de' AS extension_support_email,'https://www.twitch.tv/ext/t9l5z2vcpdfgqpf19rzzoa7yhp2p64' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'zvveq8zd8if3hwcx7kl5tc33389bkp' AS extension_id,'0.2.3' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'SwiftsBot Display' AS extension_name,'video_overlay' AS extension_anchor,'josephalmi@gmail.com' AS extension_author_email,'Swiftor' AS extension_author_name,'joseph@swiftor.com' AS extension_support_email,'https://www.twitch.tv/ext/zvveq8zd8if3hwcx7kl5tc33389bkp' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'nbtib9uc5xf03dsfx5yl6y2enbwamk' AS extension_id,'1.0.7' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'TRN Battlegrounds (PUBG) Live Tracker' AS extension_name,'panel' AS extension_anchor,'xorth@tracker.network' AS extension_author_email,'Tracker Network' AS extension_author_name,'support@tracker.network' AS extension_support_email,'https://www.twitch.tv/ext/nbtib9uc5xf03dsfx5yl6y2enbwamk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'fbk122g5sfkw0wnztttrwejp8r0lcj' AS extension_id,'1.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'TRN Battlegrounds (PUBG) Video Overlay' AS extension_name,'video_overlay' AS extension_anchor,'xorth@tracker.network' AS extension_author_email,'Tracker Network' AS extension_author_name,'support@tracker.network' AS extension_support_email,'https://www.twitch.tv/ext/fbk122g5sfkw0wnztttrwejp8r0lcj' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2ilfbph9acvmuki81dfpac8bvkrabl' AS extension_id,'1.1.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'TRN Destiny 2 Live Tracker' AS extension_name,'panel' AS extension_anchor,'xorth@tracker.network' AS extension_author_email,'Tracker Network' AS extension_author_name,'support@tracker.network' AS extension_support_email,'https://www.twitch.tv/ext/2ilfbph9acvmuki81dfpac8bvkrabl' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'2ilfbph9acvmuki81dfpac8bvkrabl' AS extension_id,'1.1.3' AS extension_version,'' AS extension_category_id,'TRN Destiny 2 Live Tracker' AS extension_name,'panel' AS extension_anchor,'xorth@tracker.network' AS extension_author_email,'Tracker Network' AS extension_author_name,'support@tracker.network' AS extension_support_email,'https://www.twitch.tv/ext/2ilfbph9acvmuki81dfpac8bvkrabl' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'vtf6kwleslxtobyiyd8flzwspenf0g' AS extension_id,'1.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'TRN Rocket League Live Tracker' AS extension_name,'panel' AS extension_anchor,'xorth@tracker.network' AS extension_author_email,'Tracker Network' AS extension_author_name,'support@tracker.network' AS extension_support_email,'https://www.twitch.tv/ext/vtf6kwleslxtobyiyd8flzwspenf0g' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2ci87jglc9v7wi6sj75mbklr7lmx5q' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'TT' AS extension_name,'video_overlay' AS extension_anchor,'twitch@stephank.nl' AS extension_author_email,'sock_stream' AS extension_author_name,'tt@stephank.nl' AS extension_support_email,'https://www.twitch.tv/ext/2ci87jglc9v7wi6sj75mbklr7lmx5q' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hbauf6y0646ttp9g98yk6bmy8lrfzq' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'TWIST Gaming - Kingdom Death' AS extension_name,'video_overlay' AS extension_anchor,'info@twistgaming.tv' AS extension_author_email,'TWIST Gaming' AS extension_author_name,'info@twistgaming.tv' AS extension_support_email,'https://www.twitch.tv/ext/hbauf6y0646ttp9g98yk6bmy8lrfzq' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'em0o1a6fls2dvhy6l73n5d1ayxdytj' AS extension_id,'0.0.3' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Team Members' AS extension_name,'panel' AS extension_anchor,'casperryt@gmail.com' AS extension_author_email,'Casperr' AS extension_author_name,'casperryt@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/em0o1a6fls2dvhy6l73n5d1ayxdytj' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'cd2qmmin0wba52w9kbmtzv3hpqys2c' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Team ZeroFriction // Partner Panel' AS extension_name,'panel' AS extension_anchor,'sander@frostfoxstudios.com' AS extension_author_email,'FrostFoxStudios' AS extension_author_name,'sander@frostfoxstudios.com' AS extension_support_email,'https://www.twitch.tv/ext/cd2qmmin0wba52w9kbmtzv3hpqys2c' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'gv3u2ua0xn5bvurodbb7fb2a0pr9ts' AS extension_id,'0.1.4' AS extension_version,'' AS extension_category_id,'Test Extension #5' AS extension_name,'video_overlay' AS extension_anchor,'barrober@twitch.tv' AS extension_author_email,'Ryan Inc' AS extension_author_name,'barrober@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/gv3u2ua0xn5bvurodbb7fb2a0pr9ts' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'97lhk8ksz34a70zjp8a6okxh89mhw9' AS extension_id,'0.0.4' AS extension_version,'' AS extension_category_id,'Test Extension 3' AS extension_name,'video_overlay' AS extension_anchor,'blakpri@twitch.tv' AS extension_author_email,'Zeldo Inc' AS extension_author_name,'test@test.com' AS extension_support_email,'https://www.twitch.tv/ext/97lhk8ksz34a70zjp8a6okxh89mhw9' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'97lhk8ksz34a70zjp8a6okxh89mhw9' AS extension_id,'0.0.3' AS extension_version,'' AS extension_category_id,'Test Extension 3' AS extension_name,'video_overlay' AS extension_anchor,'blakpri@twitch.tv' AS extension_author_email,'Zeldo Inc' AS extension_author_name,'test@test.com' AS extension_support_email,'https://www.twitch.tv/ext/97lhk8ksz34a70zjp8a6okxh89mhw9' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'k260xayxzkn712vybc8efqwuw7l8ll' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Test10293812340983204958' AS extension_name,'panel' AS extension_anchor,'aldrt@justin.tv' AS extension_author_email,'Telshin' AS extension_author_name,'telshin@telshin.com' AS extension_support_email,'https://www.twitch.tv/ext/k260xayxzkn712vybc8efqwuw7l8ll' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'7tugs7hlvrhxbppixdq1ma63cygk8x' AS extension_id,'0.0.3' AS extension_version,'' AS extension_category_id,'Tgd Award 2017' AS extension_name,'video_overlay' AS extension_anchor,'twip@ejn.kr' AS extension_author_email,'twipkr' AS extension_author_name,'twip@ejn.kr' AS extension_support_email,'https://www.twitch.tv/ext/7tugs7hlvrhxbppixdq1ma63cygk8x' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'rildamg4x9md4pok3rtzxu5b9gpa8j' AS extension_id,'1.0.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'The 2018 SXSW Gaming Awards Predictions' AS extension_name,'video_overlay' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/rildamg4x9md4pok3rtzxu5b9gpa8j' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'tnaduhar9vxsid5u9r9jw0licnzmgc' AS extension_id,'0.0.4' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'The 42nd Tags Redemption Store' AS extension_name,'panel' AS extension_anchor,'barry@barrycarlyon.co.uk' AS extension_author_email,'BarryCarlyon' AS extension_author_name,'extensions@barrycarlyon.co.uk' AS extension_support_email,'https://www.twitch.tv/ext/tnaduhar9vxsid5u9r9jw0licnzmgc' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'3eb5w3fyrjo9bhkp7nrd3lvwvb9303' AS extension_id,'1.0.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'The Game Awards 2017: Community Predicts' AS extension_name,'video_overlay' AS extension_anchor,'camr@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/3eb5w3fyrjo9bhkp7nrd3lvwvb9303' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'vsfl1b1y8rrnb6zdzymojuhzgoowuh' AS extension_id,'0.0.1' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'The8BitDrummer Song Request' AS extension_name,'panel' AS extension_anchor,'ihm.andrew@gmail.com' AS extension_author_email,'Ihm' AS extension_author_name,'ihm.andrew@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/vsfl1b1y8rrnb6zdzymojuhzgoowuh' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'4mh0i8edteozfcqr2cezm040mtu1ox' AS extension_id,'1.2.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Tiles' AS extension_name,'video_overlay' AS extension_anchor,'dev.shawn.m@gmail.com' AS extension_author_email,'cptzippers' AS extension_author_name,'cptzippers@outlook.com' AS extension_support_email,'https://www.twitch.tv/ext/4mh0i8edteozfcqr2cezm040mtu1ox' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'ceo810pnp6nm0u4v12gbm9kwuaolxg' AS extension_id,'0.0.1' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'Tilted Trivia by SLIVER.tv' AS extension_name,'video_overlay' AS extension_anchor,'ryannichols@sliver.tv' AS extension_author_email,'SLIVER.tv' AS extension_author_name,'support@sliver.tv' AS extension_support_email,'https://www.twitch.tv/ext/ceo810pnp6nm0u4v12gbm9kwuaolxg' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'xbxtltofdtemb8hkchrsc1ijukifp0' AS extension_id,'0.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Timothy Cole (+Social Blade Stats)' AS extension_name,'panel' AS extension_anchor,'tim@timcole.me' AS extension_author_email,'Timothy Cole' AS extension_author_name,'tim@timcole.me' AS extension_support_email,'https://www.twitch.tv/ext/xbxtltofdtemb8hkchrsc1ijukifp0' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'aug73iqv77n9asj9zoh2o0sg4d8mdr' AS extension_id,'1.0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Tobii Ghost' AS extension_name,'video_overlay' AS extension_anchor,'tobiitechsocial@tobii.com' AS extension_author_email,'Tobii AB' AS extension_author_name,'help.twitch@tobii.com' AS extension_support_email,'https://www.twitch.tv/ext/aug73iqv77n9asj9zoh2o0sg4d8mdr' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'b29sebclkxh0iik1uwz5bwr3ncr4oy' AS extension_id,'0.1.7' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Tomatoes' AS extension_name,'video_overlay' AS extension_anchor,'nhatbuiq@gmail.com' AS extension_author_email,'gnatbuoy' AS extension_author_name,'tomatoes@nhatqbui.com' AS extension_support_email,'https://www.twitch.tv/ext/b29sebclkxh0iik1uwz5bwr3ncr4oy' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'8olvjgqnsqcw9sybmr08erk5622867' AS extension_id,'0.0.3' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Tomatoes PRO' AS extension_name,'video_overlay' AS extension_anchor,'tomatoes@nhatqbui.com' AS extension_author_email,'gnatbuoy' AS extension_author_name,'tomatoes@nhatqbui.com' AS extension_support_email,'https://www.twitch.tv/ext/8olvjgqnsqcw9sybmr08erk5622867' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'rh6jq1q334hqc2rr1qlzqbvwlfl3x0' AS extension_id,'1.2.0' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'TopClip' AS extension_name,'panel' AS extension_anchor,'mbeierling@gmail.com' AS extension_author_email,'ted_o_brian' AS extension_author_name,'tedobrian4real@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/rh6jq1q334hqc2rr1qlzqbvwlfl3x0' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'rh6jq1q334hqc2rr1qlzqbvwlfl3x0' AS extension_id,'1.1.0' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'TopClip' AS extension_name,'panel' AS extension_anchor,'mbeierling@gmail.com' AS extension_author_email,'ted_o_brian' AS extension_author_name,'tedobrian4real@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/rh6jq1q334hqc2rr1qlzqbvwlfl3x0' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'jxkkd2xxkbfazhkqw3q6zzypahb0s3' AS extension_id,'1.2.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Tracker Network' AS extension_name,'video_overlay' AS extension_anchor,'support@tracker.network' AS extension_author_email,'Tracker Network LLC' AS extension_author_name,'support@tracker.network' AS extension_support_email,'https://www.twitch.tv/ext/jxkkd2xxkbfazhkqw3q6zzypahb0s3' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'jxkkd2xxkbfazhkqw3q6zzypahb0s3' AS extension_id,'1.0.0' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Tracker Network (Overlay)' AS extension_name,'video_overlay' AS extension_anchor,'support@tracker.network' AS extension_author_email,'Tracker Network LLC' AS extension_author_name,'support@tracker.network' AS extension_support_email,'https://www.twitch.tv/ext/jxkkd2xxkbfazhkqw3q6zzypahb0s3' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'odd4uicgl9h26mpkmo49j16ssvrtcd' AS extension_id,'0.0.2' AS extension_version,'bb7763ca-d2d5-4b97-b202-c4785b729681' AS extension_category_id,'TriviaChamp' AS extension_name,'video_overlay' AS extension_anchor,'carensdorf@gmail.com' AS extension_author_email,'meastoso' AS extension_author_name,'meastoso@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/odd4uicgl9h26mpkmo49j16ssvrtcd' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'83jz10x181tj7a4uqgn3mv02fpypav' AS extension_id,'0.0.2' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'TruckersFM' AS extension_name,'panel' AS extension_anchor,'jhawsh@gmail.com' AS extension_author_email,'TruckersFM' AS extension_author_name,'zer0@truckers.fm' AS extension_support_email,'https://www.twitch.tv/ext/83jz10x181tj7a4uqgn3mv02fpypav' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'4ced1fygnrzerfs95cofbwiltq88uh' AS extension_id,'1.1' AS extension_version,'' AS extension_category_id,'Twitch AFK' AS extension_name,'video_overlay' AS extension_anchor,'ryayoung@amazon.com' AS extension_author_email,'Amazon Game Studios' AS extension_author_name,'ags-extensions-support@amazon.com' AS extension_support_email,'https://www.twitch.tv/ext/4ced1fygnrzerfs95cofbwiltq88uh' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'fr22g90tzrvi91eevh5ipehxbko7gd' AS extension_id,'2.4.0' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'Twitch Picks' AS extension_name,'panel' AS extension_anchor,'ags-extensions@amazon.com' AS extension_author_email,'Amazon Game Studios' AS extension_author_name,'ags-hedgehog@amazon.com' AS extension_support_email,'https://www.twitch.tv/ext/fr22g90tzrvi91eevh5ipehxbko7gd' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'fr22g90tzrvi91eevh5ipehxbko7gd' AS extension_id,'2.3.0' AS extension_version,'' AS extension_category_id,'Twitch Picks' AS extension_name,'panel' AS extension_anchor,'ags-extensions@amazon.com' AS extension_author_email,'Amazon Game Studios' AS extension_author_name,'ags-hedgehog@amazon.com' AS extension_support_email,'https://www.twitch.tv/ext/fr22g90tzrvi91eevh5ipehxbko7gd' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'8ssb1ssh4mz5hy5ly43n2hrg8kdago' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Twitch Promotions: Rooster Teeth' AS extension_name,'video_overlay' AS extension_anchor,'marian@twitch.tv' AS extension_author_email,'Twitch' AS extension_author_name,'help@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/8ssb1ssh4mz5hy5ly43n2hrg8kdago' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'dpapioxqc6nckcaa2nh2wgl31uthhc' AS extension_id,'1.0.0' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Ubisoft E3 Press Conference' AS extension_name,'video_overlay' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/dpapioxqc6nckcaa2nh2wgl31uthhc' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'zu1czbamgfvq08r02qac923aa0s425' AS extension_id,'0.0.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Unknown Meta' AS extension_name,'panel' AS extension_anchor,'team@porcupine.tv' AS extension_author_email,'porcupinetv' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/zu1czbamgfvq08r02qac923aa0s425' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'zu1czbamgfvq08r02qac923aa0s425' AS extension_id,'0.0.3' AS extension_version,'' AS extension_category_id,'Unknown Meta' AS extension_name,'panel' AS extension_anchor,'team@porcupine.tv' AS extension_author_email,'porcupinetv' AS extension_author_name,'team@porcupine.tv' AS extension_support_email,'https://www.twitch.tv/ext/zu1czbamgfvq08r02qac923aa0s425' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Approved' AS extension_state,'piihe79t2bxhhv51rub1ss7o5rtemi' AS extension_id,'1.5.1' AS extension_version,'' AS extension_category_id,'UpNext' AS extension_name,'panel' AS extension_anchor,'licensing@themoneymatches.com' AS extension_author_email,'MoneyMatches' AS extension_author_name,'support@themoneymatches.com' AS extension_support_email,'https://www.twitch.tv/ext/piihe79t2bxhhv51rub1ss7o5rtemi' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'piihe79t2bxhhv51rub1ss7o5rtemi' AS extension_id,'1.5.0' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'UpNext' AS extension_name,'panel' AS extension_anchor,'licensing@themoneymatches.com' AS extension_author_email,'MoneyMatches' AS extension_author_name,'support@themoneymatches.com' AS extension_support_email,'https://www.twitch.tv/ext/piihe79t2bxhhv51rub1ss7o5rtemi' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'piihe79t2bxhhv51rub1ss7o5rtemi' AS extension_id,'0.2.0' AS extension_version,'' AS extension_category_id,'UpNext' AS extension_name,'panel' AS extension_anchor,'licensing@themoneymatches.com' AS extension_author_email,'theMoneyMatches' AS extension_author_name,'kperez@themoneymatches.com' AS extension_support_email,'https://www.twitch.tv/ext/piihe79t2bxhhv51rub1ss7o5rtemi' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'hxhdkbhtlrg1uh08iijo5c8r068oij' AS extension_id,'1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Usher' AS extension_name,'panel' AS extension_anchor,'sam_cm_to@hotmail.com' AS extension_author_email,'PurityDev' AS extension_author_name,'info@puritydev.io' AS extension_support_email,'https://www.twitch.tv/ext/hxhdkbhtlrg1uh08iijo5c8r068oij' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'lz9fe5vrqoshjo9is4iv6isxs1520h' AS extension_id,'0.1.4' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Variety Tracker' AS extension_name,'panel' AS extension_anchor,'evilkimau@gmail.com' AS extension_author_email,'kimau' AS extension_author_name,'twitch@flammablepenguins.com' AS extension_support_email,'https://www.twitch.tv/ext/lz9fe5vrqoshjo9is4iv6isxs1520h' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'9zqhb3hba48m0c382uno7k2t74isfi' AS extension_id,'0.1.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'Viewer Geolocation' AS extension_name,'panel' AS extension_anchor,'rootcommander@gmail.com' AS extension_author_email,'CommanderRoot' AS extension_author_name,'viewer-geolocation-support@rootonline.de' AS extension_support_email,'https://www.twitch.tv/ext/9zqhb3hba48m0c382uno7k2t74isfi' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'18mdz6bwjda5he7bfsae6h91lgxgdw' AS extension_id,'0.0.6' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Viewer Information' AS extension_name,'panel' AS extension_anchor,'andy.ramit@gmail.com' AS extension_author_email,'LuckyNoS7evin' AS extension_author_name,'follow-alert@andymorrell.net' AS extension_support_email,'https://www.twitch.tv/ext/18mdz6bwjda5he7bfsae6h91lgxgdw' AS extension_url,false AS is_bits_enabled,true AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'18mdz6bwjda5he7bfsae6h91lgxgdw' AS extension_id,'0.0.5' AS extension_version,'' AS extension_category_id,'Viewer Information' AS extension_name,'panel' AS extension_anchor,'andy.ramit@gmail.com' AS extension_author_email,'LuckyNoS7evin' AS extension_author_name,'follow-alert@andymorrell.net' AS extension_support_email,'https://www.twitch.tv/ext/18mdz6bwjda5he7bfsae6h91lgxgdw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'43ag9chddwfn15kcm2ji265jxpgfop' AS extension_id,'0.8.5' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'Viewer Message Alerts' AS extension_name,'panel' AS extension_anchor,'hellcat@hellcat.net' AS extension_author_email,'HELLCAT' AS extension_author_name,'twitch-extensions@therealhellcat.de' AS extension_support_email,'https://www.twitch.tv/ext/43ag9chddwfn15kcm2ji265jxpgfop' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'t4dxevn0t8eej7dpettj6l45rt76g3' AS extension_id,'0.1.0' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'Viewer Queue' AS extension_name,'panel' AS extension_anchor,'Thef3602@gmail.com' AS extension_author_email,'Thef' AS extension_author_name,'TeragonTech@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/t4dxevn0t8eej7dpettj6l45rt76g3' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'i3k5pm5csfvvvngbyok3pc1amc6mne' AS extension_id,'0.0.6' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Vote Chess by Chess.com' AS extension_name,'video_overlay' AS extension_anchor,'danny@chess.com' AS extension_author_email,'chess' AS extension_author_name,'support@chess.com' AS extension_support_email,'https://www.twitch.tv/ext/i3k5pm5csfvvvngbyok3pc1amc6mne' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'i3k5pm5csfvvvngbyok3pc1amc6mne' AS extension_id,'0.0.5' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Vote Chess by Chess.com' AS extension_name,'video_overlay' AS extension_anchor,'danny@chess.com' AS extension_author_email,'chess' AS extension_author_name,'support@chess.com' AS extension_support_email,'https://www.twitch.tv/ext/i3k5pm5csfvvvngbyok3pc1amc6mne' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'0ms0a4rmjh6b7beixaqndrefsz1dfy' AS extension_id,'1.9.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Vote to Play' AS extension_name,'video_overlay' AS extension_anchor,'guanzo91@gmail.com' AS extension_author_email,'guanzo' AS extension_author_name,'guanzo91@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/0ms0a4rmjh6b7beixaqndrefsz1dfy' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'xc65l98oiu0g8jxzv949sznwkd8735' AS extension_id,'1.1.0' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'Voting Studio' AS extension_name,'video_overlay' AS extension_anchor,'mlohier@ipowow.com' AS extension_author_email,'iPowow!' AS extension_author_name,'help@ipowow.com' AS extension_support_email,'https://www.twitch.tv/ext/xc65l98oiu0g8jxzv949sznwkd8735' AS extension_url,true AS is_bits_enabled,true AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'r5fn1ribun5c47bbzzbu4zx6m9iw62' AS extension_id,'1.0.0' AS extension_version,'' AS extension_category_id,'Watch Next' AS extension_name,'panel' AS extension_anchor,'support@muxy.io' AS extension_author_email,'Muxy Inc.' AS extension_author_name,'support@muxy.io' AS extension_support_email,'https://www.twitch.tv/ext/r5fn1ribun5c47bbzzbu4zx6m9iw62' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'0qr7fa6llzn4txgnfgb8ipeksd5v24' AS extension_id,'1.2.7' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Waystone Overlay for Eternal Card Game' AS extension_name,'video_overlay' AS extension_anchor,'accounts@direwolfdigital.com' AS extension_author_email,'direwolfdigitaldev' AS extension_author_name,'support@direwolfdigital.com' AS extension_support_email,'https://www.twitch.tv/ext/0qr7fa6llzn4txgnfgb8ipeksd5v24' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'u7cjogohlfdgfcoitxv12clnpzjxcw' AS extension_id,'0.0.4' AS extension_version,'d86ef964-5f30-441f-aff2-4eb824696656' AS extension_category_id,'Weekly Schedule' AS extension_name,'panel' AS extension_anchor,'ujifgc+twitchext@gmail.com' AS extension_author_email,'NonlinearGenetics' AS extension_author_name,'ujifgc+twitchext@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/u7cjogohlfdgfcoitxv12clnpzjxcw' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'t2w8fbb97a337mh2ykxbti86b6pkwk' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'Wheel' AS extension_name,'video_overlay' AS extension_anchor,'mbeierling@gmail.com' AS extension_author_email,'ted_o_brian' AS extension_author_name,'tedobrian4real@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/t2w8fbb97a337mh2ykxbti86b6pkwk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'k272edely6fljrto73iaswy61w7zhs' AS extension_id,'0.0.3' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'WoW Armory (World of Warcraft)' AS extension_name,'panel' AS extension_anchor,'goldgleb@yandex.ru' AS extension_author_email,'salmondx' AS extension_author_name,'goldgleb@yandex.ru' AS extension_support_email,'https://www.twitch.tv/ext/k272edely6fljrto73iaswy61w7zhs' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'tsf5rtdd0din9w6fps7uw9kwz5s96w' AS extension_id,'0.0.5' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'WoW MDI Overlay' AS extension_name,'video_overlay' AS extension_anchor,'thomas@hawkes.ca' AS extension_author_email,'@StarshipWoW' AS extension_author_name,'thomas@hawkes.ca' AS extension_support_email,'https://www.twitch.tv/ext/tsf5rtdd0din9w6fps7uw9kwz5s96w' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'kr7m1hz7esldlrptruk0fd76l6yq36' AS extension_id,'1.1.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'World of Warcraft Armory' AS extension_name,'panel' AS extension_anchor,'altoar@live.de' AS extension_author_email,'Altoar.io' AS extension_author_name,'altoar@live.de' AS extension_support_email,'https://www.twitch.tv/ext/kr7m1hz7esldlrptruk0fd76l6yq36' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'b761gcvkac6qbwo26ededwf9sluqh0' AS extension_id,'1.0.2' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Wowhead' AS extension_name,'video_overlay' AS extension_anchor,'jdain@zam.com' AS extension_author_email,'Wowhead' AS extension_author_name,'feedback@wowhead.com' AS extension_support_email,'https://www.twitch.tv/ext/b761gcvkac6qbwo26ededwf9sluqh0' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'zmrkgltgj3cdduponncbuussd5iy4k' AS extension_id,'0.1.3' AS extension_version,'' AS extension_category_id,'Yoz - Support the stream with style' AS extension_name,'video_overlay' AS extension_anchor,'itai@inthegame.io' AS extension_author_email,'Inthegame' AS extension_author_name,'support@inthegame.io' AS extension_support_email,'https://www.twitch.tv/ext/zmrkgltgj3cdduponncbuussd5iy4k' AS extension_url,true AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'1lutpjhjm31s03t1kqfxuozi9lqrv8' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'Zelda Universe Panel' AS extension_name,'panel' AS extension_anchor,'webmaster@zeldauniverse.net' AS extension_author_email,'Zelda Universe' AS extension_author_name,'webmaster@zeldauniverse.net' AS extension_support_email,'https://www.twitch.tv/ext/1lutpjhjm31s03t1kqfxuozi9lqrv8' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'j48t9kkdoid122qw5m36hu7tyzoixk' AS extension_id,'0.0.2' AS extension_version,'' AS extension_category_id,'Zeldo Test 12-1' AS extension_name,'panel' AS extension_anchor,'blakpri@twitch.tv' AS extension_author_email,'ZeldoKavira' AS extension_author_name,'asD@asd.com' AS extension_support_email,'https://www.twitch.tv/ext/j48t9kkdoid122qw5m36hu7tyzoixk' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'v52fknt4kvk2s9dn1kcddqsnm1vdft' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'aZeldo Test Jan 25' AS extension_name,'panel' AS extension_anchor,'blakpri@twitch.tv' AS extension_author_email,'ZeldoKavira' AS extension_author_name,'blakpri@twitch.tv' AS extension_support_email,'https://www.twitch.tv/ext/v52fknt4kvk2s9dn1kcddqsnm1vdft' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'39jp2gp77ltj60k2b34on24sgl7237' AS extension_id,'0.0.1' AS extension_version,'' AS extension_category_id,'ask' AS extension_name,'video_overlay' AS extension_anchor,'william@offbeat.space' AS extension_author_email,'offbeat.space' AS extension_author_name,'support@offbeat.space' AS extension_support_email,'https://www.twitch.tv/ext/39jp2gp77ltj60k2b34on24sgl7237' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'wqwefjcbqi7pd7iarg54bixk3uh2i8' AS extension_id,'0.0.3' AS extension_version,'' AS extension_category_id,'fansensBot' AS extension_name,'video_overlay' AS extension_anchor,'justin.buettner@gmx.de' AS extension_author_email,'fansens' AS extension_author_name,'fansens@venicraft.at' AS extension_support_email,'https://www.twitch.tv/ext/wqwefjcbqi7pd7iarg54bixk3uh2i8' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'wqwefjcbqi7pd7iarg54bixk3uh2i8' AS extension_id,'0.0.1' AS extension_version,'5f90120d-be64-41a7-bc83-6ecc9ba10910' AS extension_category_id,'fansensBot' AS extension_name,'video_overlay' AS extension_anchor,'justin.buettner@gmx.de' AS extension_author_email,'fansens' AS extension_author_name,'fansens@venicraft.at' AS extension_support_email,'https://www.twitch.tv/ext/wqwefjcbqi7pd7iarg54bixk3uh2i8' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'v76zyoita01f5clnnt7q5z68yz42pt' AS extension_id,'0.0.20' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'iPowow Extension' AS extension_name,'panel' AS extension_anchor,'scante@ipowow.com' AS extension_author_email,'iPowow' AS extension_author_name,'info@ipowow.com' AS extension_support_email,'https://www.twitch.tv/ext/v76zyoita01f5clnnt7q5z68yz42pt' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'2b9s9g75awk0ju391l0o2w4e7jxo47' AS extension_id,'0.0.1' AS extension_version,'eb89b9c9-7acc-4731-b5f1-41dbcd64bb12' AS extension_category_id,'lastfm-panel' AS extension_name,'panel' AS extension_anchor,'ldesgoui@gmail.com' AS extension_author_email,'twiikuu' AS extension_author_name,'ldesgoui@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/2b9s9g75awk0ju391l0o2w4e7jxo47' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'y7s07543lwunmvv0eshpdlttt4gk1j' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'lootlot' AS extension_name,'video_overlay' AS extension_anchor,'jacky@veand.co' AS extension_author_email,'mach11726' AS extension_author_name,'jacky@veand.co' AS extension_support_email,'https://www.twitch.tv/ext/y7s07543lwunmvv0eshpdlttt4gk1j' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'In Review' AS extension_state,'nx4cn1zq653a759wfy4aku0fgmql8l' AS extension_id,'2.0.1' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'mySetup.co' AS extension_name,'panel' AS extension_anchor,'contact@mysetup.co' AS extension_author_email,'mySetup.co' AS extension_author_name,'support@mysetup.co' AS extension_support_email,'https://www.twitch.tv/ext/nx4cn1zq653a759wfy4aku0fgmql8l' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'nx4cn1zq653a759wfy4aku0fgmql8l' AS extension_id,'1.2.0' AS extension_version,'e02ee494-3e26-4f4d-8717-93ac5d7fa8b9' AS extension_category_id,'mySetup.co' AS extension_name,'panel' AS extension_anchor,'contact@mysetup.co' AS extension_author_email,'mySetup.co' AS extension_author_name,'support@mysetup.co' AS extension_support_email,'https://www.twitch.tv/ext/nx4cn1zq653a759wfy4aku0fgmql8l' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Pending Action' AS extension_state,'nx4cn1zq653a759wfy4aku0fgmql8l' AS extension_id,'1.1.0' AS extension_version,'' AS extension_category_id,'mySetup.co' AS extension_name,'panel' AS extension_anchor,'contact@mysetup.co' AS extension_author_email,'mySetup.co' AS extension_author_name,'support@mysetup.co' AS extension_support_email,'https://www.twitch.tv/ext/nx4cn1zq653a759wfy4aku0fgmql8l' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'f84i7aihacvbim14kres5qpc5wzl5e' AS extension_id,'0.2.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'osu! stats' AS extension_name,'panel' AS extension_anchor,'peter.t.ludlow@gmail.com' AS extension_author_email,'tetsuo286' AS extension_author_name,'tetsuo286.dev@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/f84i7aihacvbim14kres5qpc5wzl5e' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,false AS is_overlay_enabled,true AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'gtt8i342nc81xbihik820e569bx969' AS extension_id,'0.1' AS extension_version,'f3d9ce3c-696d-4c6f-b623-e76c06e33f1d' AS extension_category_id,'paint charades!' AS extension_name,'video_overlay' AS extension_anchor,'desperatebassplayer@gmail.com' AS extension_author_email,'NikitkaCodes' AS extension_author_name,'desperatebassplayer@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/gtt8i342nc81xbihik820e569bx969' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'p7f191llvyb1ezetzydttwoewmf0g6' AS extension_id,'0.0.1' AS extension_version,'cbca1847-6448-409d-a0e2-03e0076a6165' AS extension_category_id,'pubg.gg statistics' AS extension_name,'video_overlay' AS extension_anchor,'glensargecc@gmail.com' AS extension_author_email,'glenlol' AS extension_author_name,'glensargecc@gmail.com' AS extension_support_email,'https://www.twitch.tv/ext/p7f191llvyb1ezetzydttwoewmf0g6' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,false AS is_whitelisted_extension
UNION ALL
SELECT '2018-06-18'::TIMESTAMP AS the_date,'Released' AS extension_state,'jixc9ud5w265xftu13tx2rs5bz1ktx' AS extension_id,'0.0.1' AS extension_version,'51aa177b-797d-42bb-a8bc-b547551a650a' AS extension_category_id,'throwdownVote' AS extension_name,'video_overlay' AS extension_anchor,'tdadmin@showdownco.com' AS extension_author_email,'throwdowntv' AS extension_author_name,'tdadmin@showdownco.com' AS extension_support_email,'https://www.twitch.tv/ext/jixc9ud5w265xftu13tx2rs5bz1ktx' AS extension_url,false AS is_bits_enabled,false AS is_component_enabled,true AS is_overlay_enabled,false AS is_panel_enabled,true AS is_whitelisted_extension
);




--
--
-- SELECT extension_anchor, COUNT(DISTINCT extension_id) AS extensions, COUNT(1) AS rows, COUNT(DISTINCT extension_id+extension_anchor) AS extension_and_anchor
-- FROM analysis.dsds_281_historical_extensions
-- WHERE extension_state = 'Released'
-- GROUP BY 1
-- ORDER BY 1
-- ;
--
-- SELECT * FROM (
-- SELECT extension_id, COUNT(1) AS rows, COUNT(DISTINCT extension_anchor) AS anchors
-- FROM analysis.dsds_281_historical_extensions
-- WHERE extension_state = 'Released'
-- GROUP BY 1
-- )
-- WHERE rows>1
-- ORDER BY 1
--
-- ;
--
-- SELECT * FROM analysis.dsds_281_historical_extensions
-- WHERE extension_id = '24u62kim5mn0slhwigdt7v4ybkwef5'
-- AND extension_state = 'Released'
