CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds_281_extension_daily_version);

INSERT INTO the_temp_table
(

  WITH
  the_constants AS (
    SELECT
      DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '7 day' AS range_start --look back last 7 days in case we don't run this every day
      , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS range_end
  )

  --get all the possible extension_id and extension_version combinations
  , the_render_logs_step1 AS (
    SELECT "time" AS the_time, extension_id, extension_version
    FROM tahoe.extension_render
    WHERE date>=(SELECT range_start FROM the_constants) AND date<(SELECT range_end FROM the_constants)
    GROUP BY 1,2,3
  )
  -- count the times each extension_id and extension_version combo occurs each day
  , the_render_logs_step2 AS (
    SELECT *, RANK() OVER (PARTITION BY the_day, extension_id ORDER BY rows DESC) AS row_count_rank
    FROM (
      SELECT DATE_TRUNC('day', the_time) AS the_day, extension_id, extension_version, COUNT(1) AS rows
      FROM the_render_logs_step1
      GROUP BY 1,2,3
    )
  )
  -- to break ties, select the max (latest) extension_version
  , the_render_logs_step3 AS (
    SELECT the_day, extension_id, MAX(extension_version) AS extension_version, rows, row_count_rank
    FROM the_render_logs_step2
    WHERE row_count_rank=1
    GROUP BY 1,2,4,5
  )

  , final_data AS (
    SELECT the_day, extension_id, extension_version
    FROM the_render_logs_step3
    GROUP BY 1,2,3
  )
  SELECT * FROM final_data

);


-- Remove from ROLLUP_TABLE any data also existing in THE_TEMP_TABLE
DELETE FROM analysis.dsds_281_extension_daily_version
USING the_temp_table
WHERE
  the_temp_table.the_day = analysis.dsds_281_extension_daily_version.the_day
  AND the_temp_table.extension_id = analysis.dsds_281_extension_daily_version.extension_id
  AND the_temp_table.extension_version = analysis.dsds_281_extension_daily_version.extension_version
;



-- Load TEMP_TABLE into ROLLUP_TABLE
INSERT INTO analysis.dsds_281_extension_daily_version
(SELECT * FROM the_temp_table);
