
-- -- Create the rollup table with these column values:
-- -- Create the Table with explicit schema
-- --(OPTIONAL) FIRST DEFINE YOUR SCHEMA (IF THIS IS YOUR SECOND TIME RUNNING IT THEN REMOVE THIS CHUNK OF CODE)
-- DROP TABLE IF EXISTS analysis.dsds_281_extension_daily_channel_presence_new;
-- CREATE TABLE IF NOT EXISTS analysis.dsds_281_extension_daily_channel_presence_new (
--   the_day                         TIMESTAMP WITHOUT TIME ZONE sortkey
--   , extension_id                  VARCHAR(32) distkey
--   , extension_version             VARCHAR(25)
--   , extension_anchor              VARCHAR(50)
--   , channel_id                    BIGINT
--   , flag_install_activate_status  VARCHAR(25)
--   , time_most_recent_install      TIMESTAMP WITHOUT TIME ZONE
--   , time_most_recent_activate     TIMESTAMP WITHOUT TIME ZONE
--   , time_most_recent_deactivate   TIMESTAMP WITHOUT TIME ZONE
--   , time_most_recent_uninstall    TIMESTAMP WITHOUT TIME ZONE
--   , time_most_recent_delete       TIMESTAMP WITHOUT TIME ZONE
--   , bool_extension_activated      BOOLEAN
--   , bool_extension_installed      BOOLEAN
-- );




--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds_281_extension_daily_channel_presence_new);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table (

  WITH
  the_parameter_constants AS (
    SELECT
      $1::TIMESTAMP AS range_start
      , DATEADD(day, 1, $1::TIMESTAMP) AS range_end
  )
  --used to get the time frame to look at the the activation/deactivation/uninstall/delete logs
  , the_basetable_date AS (
    SELECT
      '2017-05-01'::TIMESTAMP AS start_date --start from may 1st to capture all possible events
      , date::TIMESTAMP AS end_date
    FROM metadata.date
    WHERE date>=(SELECT range_start FROM the_parameter_constants) AND date<(SELECT range_end FROM the_parameter_constants)
    GROUP BY 1,2
  )







  --get raw install logs and remove duplicates
  , install_logs_step0 AS (
    SELECT
      (SELECT start_date::DATE FROM the_basetable_date) AS start_date
      , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
      , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, channel_id::BIGINT
    FROM logs.extension_install
    WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    GROUP BY 1,2,3,4,5,6
  )
  --processing to deal with same event firing duplicate rows with one being normal extension_version and another being extension_version='N/A'
  , install_logs_step1 AS (
    SELECT start_date, end_date, "time", extension_id
      , MAX(CASE WHEN extension_version='N/A' THEN '0.0.0' ELSE extension_version END) AS extension_version --this is to deal with same event firing duplicate events with one being regular extension_version and another being extension_version='N/A'
      , channel_id
    FROM install_logs_step0
    GROUP BY 1,2,3,4,6
  )
  --for each user and extension and version combo, get the last timestamp that the action occurred (for the given start_date to end_date range)
  , install_logs_step2 AS (
    SELECT start_date, end_date, extension_id, extension_version, channel_id, MAX(time) AS last_time_install
    FROM install_logs_step1
    GROUP BY 1,2,3,4,5
  )
  --for each user and extension, return 1 row that is the most recent action
  , install_logs_step3 AS (
    SELECT final.start_date, final.end_date, final.extension_id, final.extension_version, final.channel_id, final.last_time_install
    FROM (
      SELECT *, MAX(last_time_install) OVER (PARTITION BY start_date, end_date, channel_id, extension_id) AS max_last_time_install --this max timestamp is extension_version agnostic
      FROM install_logs_step2
    ) AS final
    WHERE last_time_install = max_last_time_install --only get the activate record that matches the max timestamp (i.e. they activate/reactivate multiple times within same day)
  )




  --get raw activate logs and remove duplicates
  , activate_logs_step0 AS (
    SELECT
      (SELECT start_date::DATE FROM the_basetable_date) AS start_date
      , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
      , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, channel_id, extension_anchor::VARCHAR
    FROM logs.extension_activate
    WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    GROUP BY 1,2,3,4,5,6,7
  )
  --processing to deal with same event firing duplicate rows with one being normal extension_version and another being extension_version='N/A'
  , activate_logs_step1 AS (
    SELECT start_date, end_date, "time", extension_id
    , MAX(CASE WHEN extension_version='N/A' THEN '0.0.0' ELSE extension_version END) AS extension_version --this is to deal with same event firing duplicate events with one being regular extension_version and another being extension_version='N/A'
    , channel_id, extension_anchor
    FROM activate_logs_step0
    GROUP BY 1,2,3,4,6,7
  )
  --for each user and extension and version and anchor combo, get the last timestamp that the action occurred (for the given start_date to end_date range)
  , activate_logs_step2 AS (
    SELECT start_date, end_date, extension_id, extension_version, channel_id, extension_anchor, MAX(time) AS last_time_activate
    FROM activate_logs_step1
    GROUP BY 1,2,3,4,5,6
  )
  --for each user and extension, return 1 row that is the most recent action
  , activate_logs_step3 AS (
    SELECT final.start_date, final.end_date, final.extension_id, final.extension_version, final.channel_id, final.extension_anchor, final.last_time_activate
    FROM (
      SELECT *, MAX(last_time_activate) OVER (PARTITION BY start_date, end_date, channel_id, extension_id) AS max_last_time_activate --this max timestamp is extension_version agnostic
      FROM activate_logs_step2
    ) AS final
    WHERE last_time_activate = max_last_time_activate --only get the activate record that matches the max timestamp (i.e. they activate/reactivate multiple times within same day, just take the last one)
  )







  --join install and activate data together using FULL OUTER JOIN
  , install_activate_logs AS (
    SELECT
      NVL(install.start_date, activate.start_date) AS start_date
      , NVL(install.end_date, activate.end_date) AS end_date
      , (NVL(install.end_date, activate.end_date) - INTERVAL '1 day')::DATE AS the_day
      , NVL(install.extension_id, activate.extension_id) AS extension_id
      , NVL(install.extension_version, activate.extension_version) AS extension_version
      , (NVL(install.channel_id, activate.channel_id))::BIGINT AS channel_id
      , activate.extension_anchor
      , install.last_time_install AS time_most_recent_install
      , activate.last_time_activate AS time_most_recent_activate
      , CASE
          WHEN install.last_time_install IS NULL AND activate.last_time_activate IS NOT NULL THEN 'activate_only'
          WHEN install.last_time_install IS NOT NULL AND activate.last_time_activate IS NULL THEN 'install_only'
          WHEN install.last_time_install IS NULL AND activate.last_time_activate IS NULL THEN 'error_both_null'
          WHEN install.last_time_install IS NOT NULL AND activate.last_time_activate IS NOT NULL THEN 'activate_and_install'
          ELSE 'error_weird'
        END AS flag_install_activate_status
    FROM install_logs_step3 AS install
    FULL OUTER JOIN activate_logs_step3 AS activate --full outer join to make sure we cover all potential cases of activate and install
      ON install.channel_id = activate.channel_id
      AND install.extension_id = activate.extension_id
      -- AND install.extension_version = activate.extension_version --IS THIS NEEDED? PROBABLY NOT
  )






  --get raw deactivate logs and remove duplicates
  , deactivate_logs_step0 AS (
    SELECT
      (SELECT start_date::DATE FROM the_basetable_date) AS start_date
      , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
      , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, channel_id
    FROM logs.extension_deactivate
    WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    GROUP BY 1,2,3,4,5,6
  )
  --processing to deal with same event firing duplicate rows with one being normal extension_version and another being extension_version='N/A'
  , deactivate_logs_step1 AS (
    SELECT start_date, end_date, "time", extension_id
      , MAX(CASE WHEN extension_version='N/A' THEN '0.0.0' ELSE extension_version END) AS extension_version --this is to deal with same event firing duplicate events with one being regular extension_version and another being extension_version='N/A'
      , channel_id
    FROM deactivate_logs_step0
    GROUP BY 1,2,3,4,6
  )
  --for each user and extension and version combo, get the last timestamp that the action occurred (for the given start_date to end_date range)
  , deactivate_logs_step2 AS (
    SELECT start_date, end_date, extension_id, extension_version, channel_id, MAX(time) AS last_time_deactivate
    FROM deactivate_logs_step1
    GROUP BY 1,2,3,4,5
  )
  --for each user and extension, return 1 row that is the most recent action
  , deactivate_logs_step3 AS (
    SELECT final.start_date, final.end_date, final.extension_id, final.extension_version, final.channel_id, final.last_time_deactivate
    FROM (
      SELECT *, MAX(last_time_deactivate) OVER (PARTITION BY start_date, end_date, channel_id, extension_id) AS max_last_time_deactivate --this max timestamp is extension_version agnostic
      FROM deactivate_logs_step2
    ) AS final
    WHERE last_time_deactivate = max_last_time_deactivate --only get the activate record that matches the max timestamp (i.e. they activate/reactivate multiple times within same day, just take the last one)
  )







  --get raw uninstall logs and remove duplicates
  , uninstall_logs_step0 AS (
    SELECT
      (SELECT start_date::DATE FROM the_basetable_date) AS start_date
      , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
      , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, channel_id
    FROM logs.extension_uninstall
    WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    GROUP BY 1,2,3,4,5,6
  )
  --processing to deal with same event firing duplicate rows with one being normal extension_version and another being extension_version='N/A'
  , uninstall_logs_step1 AS (
    SELECT start_date, end_date, "time", extension_id
    , MAX(CASE WHEN extension_version='N/A' THEN '0.0.0' ELSE extension_version END) AS extension_version --this is to deal with same event firing duplicate events with one being regular extension_version and another being extension_version='N/A'
    , channel_id
    FROM uninstall_logs_step0
    GROUP BY 1,2,3,4,6
  )
  --for each user and extension and version combo, get the last timestamp that the action occurred (for the given start_date to end_date range)
  , uninstall_logs_step2 AS (
    SELECT start_date, end_date, extension_id, extension_version, channel_id, MAX(time) AS last_time_uninstall
    FROM uninstall_logs_step1
    GROUP BY 1,2,3,4,5
  )
  --for each user and extension, return 1 row that is the most recent action
  , uninstall_logs_step3 AS (
    SELECT final.start_date, final.end_date, final.extension_id, final.extension_version, final.channel_id, final.last_time_uninstall
    FROM (
      SELECT *, MAX(last_time_uninstall) OVER (PARTITION BY start_date, end_date, channel_id, extension_id) AS max_last_time_uninstall --this max timestamp is extension_version agnostic
      FROM uninstall_logs_step2
    ) AS final
    WHERE last_time_uninstall = max_last_time_uninstall --only get the activate record that matches the max timestamp (i.e. they activate/reactivate multiple times within same day)
  )




  --get raw delete logs and remove duplicates, used when extension_version IS NOT the value 'N/A' (which we assign to 0.0.0)
  , delete_logs_v1 AS (
    SELECT
      (SELECT start_date::DATE FROM the_basetable_date) AS start_date
      , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
      , MAX("time")::TIMESTAMP AS "time", extension_id::VARCHAR, extension_version::VARCHAR
    FROM logs.extension_delete
    WHERE extension_id IS NOT NULL AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    GROUP BY 1,2,4,5
  )
  --return 1 row per extension_id that has a delete event, used when extension_version IS the value 'N/A' (which we assign to 0.0.0)
  , delete_logs_v2 AS (
    SELECT start_date, end_date, MAX("time") AS "time", extension_id, MAX(extension_version) AS extension_version
    FROM delete_logs_v1
    GROUP BY 1,2,4
  )








  -- JOIN install_activate_logs with deactivate_logs_step2, uninstall_logs_step2, delete_logs_step0
  , all_join_logs_step0 AS (
    SELECT base.start_date, base.end_date, base.the_day
      , base.extension_id, base.extension_version, base.extension_anchor, base.channel_id
      , base.flag_install_activate_status, base.time_most_recent_install, base.time_most_recent_activate
      , deact.last_time_deactivate AS time_most_recent_deactivate, uninstall.last_time_uninstall AS time_most_recent_uninstall
      , NVL(delete_v1.time, delete_v2.time) AS time_most_recent_delete
    FROM install_activate_logs AS base
    LEFT JOIN deactivate_logs_step3 AS deact ON base.channel_id = deact.channel_id AND base.extension_id = deact.extension_id
    LEFT JOIN uninstall_logs_step3 AS uninstall ON base.channel_id = uninstall.channel_id AND base.extension_id = uninstall.extension_id
    LEFT JOIN delete_logs_v1 AS delete_v1 --when extension_version!='N/A', then we do join against extension_version
      ON base.extension_version!='0.0.0' AND base.extension_id = delete_v1.extension_id AND base.extension_version=delete_v1.extension_version
    LEFT JOIN delete_logs_v2 AS delete_v2 --when extension_version='N/A', then we don't join against extension_version
      ON base.extension_version='0.0.0' AND base.extension_id = delete_v2.extension_id
  )
  --use timestamps of the different events to determine if the extension is activated, calculate this first as the bool_extension_activated is used later
  , all_join_logs_step1 AS (
    SELECT the_day, extension_id, extension_version, extension_anchor, channel_id, flag_install_activate_status
      , time_most_recent_install, time_most_recent_activate, time_most_recent_deactivate
      , time_most_recent_uninstall, time_most_recent_delete
      , CASE
          WHEN time_most_recent_activate IS NULL THEN false --if no activate timestamp then can't be activated
          WHEN time_most_recent_deactivate >= time_most_recent_activate AND time_most_recent_deactivate IS NOT NULL THEN false -- deactivate happened after activate, then not activated
          WHEN time_most_recent_uninstall >= time_most_recent_activate AND time_most_recent_uninstall IS NOT NULL THEN false -- uninstall happened after activate, then not activated
          WHEN time_most_recent_delete >= time_most_recent_activate AND time_most_recent_delete IS NOT NULL THEN false --delete happened after activate, then not activated
          ELSE true
      END AS bool_extension_activated
    FROM all_join_logs_step0
  )
  --use timestamps of the different events to determine if the extension is installed, uses bool_extension_activated from before
  , all_join_logs_step2 AS (
    SELECT *
      , CASE
          WHEN bool_extension_activated IS TRUE THEN true --if extension is activated based on logic, then it must be installed even if the timestamps don't have it
          WHEN time_most_recent_install IS NULL THEN false --if no install timestamp then can't be installed, this also should never happen in this query (both install and activate timestamps are null)
          WHEN time_most_recent_uninstall >= time_most_recent_install AND time_most_recent_install IS NOT NULL THEN false -- uninstall happened after install, then not installed
          WHEN time_most_recent_delete >= time_most_recent_install AND time_most_recent_delete IS NOT NULL THEN false --delete happened after install, then not installed
          ELSE true
      END AS bool_extension_installed
    FROM all_join_logs_step1
  )




  , final_data AS (
    SELECT * FROM all_join_logs_step2 --WHERE bool_extension_installed IS TRUE OR bool_extension_activated IS TRUE
  )
  SELECT * FROM final_data

);










--RUN THE INSERT FUNCTIONS BY ITERATING OVER DIFFERENT VALUES
-- EXECUTE the_insert_function ('2017-08-01');
-- EXECUTE the_insert_function ('2017-08-02');
-- EXECUTE the_insert_function ('2017-08-03');
-- EXECUTE the_insert_function ('2017-08-04');
-- EXECUTE the_insert_function ('2017-08-05');
-- EXECUTE the_insert_function ('2017-08-06');
-- EXECUTE the_insert_function ('2017-08-07');
-- EXECUTE the_insert_function ('2017-08-08');
-- EXECUTE the_insert_function ('2017-08-09');
-- EXECUTE the_insert_function ('2017-08-10');
-- EXECUTE the_insert_function ('2017-08-11');
-- EXECUTE the_insert_function ('2017-08-12');
-- EXECUTE the_insert_function ('2017-08-13');
-- EXECUTE the_insert_function ('2017-08-14');
-- EXECUTE the_insert_function ('2017-08-15');
-- EXECUTE the_insert_function ('2017-08-16');
-- EXECUTE the_insert_function ('2017-08-17');
-- EXECUTE the_insert_function ('2017-08-18');
-- EXECUTE the_insert_function ('2017-08-19');
-- EXECUTE the_insert_function ('2017-08-20');
-- EXECUTE the_insert_function ('2017-08-21');
-- EXECUTE the_insert_function ('2017-08-22');
-- EXECUTE the_insert_function ('2017-08-23');
-- EXECUTE the_insert_function ('2017-08-24');
-- EXECUTE the_insert_function ('2017-08-25');
-- EXECUTE the_insert_function ('2017-08-26');
-- EXECUTE the_insert_function ('2017-08-27');
-- EXECUTE the_insert_function ('2017-08-28');
-- EXECUTE the_insert_function ('2017-08-29');
-- EXECUTE the_insert_function ('2017-08-30');
-- EXECUTE the_insert_function ('2017-08-31');
--
-- EXECUTE the_insert_function ('2017-09-01');
-- EXECUTE the_insert_function ('2017-09-02');
-- EXECUTE the_insert_function ('2017-09-03');
-- EXECUTE the_insert_function ('2017-09-04');
-- EXECUTE the_insert_function ('2017-09-05');
-- EXECUTE the_insert_function ('2017-09-06');
-- EXECUTE the_insert_function ('2017-09-07');
-- EXECUTE the_insert_function ('2017-09-08');
-- EXECUTE the_insert_function ('2017-09-09');
-- EXECUTE the_insert_function ('2017-09-10');
-- EXECUTE the_insert_function ('2017-09-11');
-- EXECUTE the_insert_function ('2017-09-12');
-- EXECUTE the_insert_function ('2017-09-13');
-- EXECUTE the_insert_function ('2017-09-14');
-- EXECUTE the_insert_function ('2017-09-15');
-- EXECUTE the_insert_function ('2017-09-16');
-- EXECUTE the_insert_function ('2017-09-17');
-- EXECUTE the_insert_function ('2017-09-18');
-- EXECUTE the_insert_function ('2017-09-19');
-- EXECUTE the_insert_function ('2017-09-20');
-- EXECUTE the_insert_function ('2017-09-21');
-- EXECUTE the_insert_function ('2017-09-22');
-- EXECUTE the_insert_function ('2017-09-23');
-- EXECUTE the_insert_function ('2017-09-24');
-- EXECUTE the_insert_function ('2017-09-25');
-- EXECUTE the_insert_function ('2017-09-26');
-- EXECUTE the_insert_function ('2017-09-27');
-- EXECUTE the_insert_function ('2017-09-28');
-- EXECUTE the_insert_function ('2017-09-29');
-- EXECUTE the_insert_function ('2017-09-30');

-- EXECUTE the_insert_function ('2017-10-01');
-- EXECUTE the_insert_function ('2017-10-02');
-- EXECUTE the_insert_function ('2017-10-03');
-- EXECUTE the_insert_function ('2017-10-04');
-- EXECUTE the_insert_function ('2017-10-05');
-- EXECUTE the_insert_function ('2017-10-06');
-- EXECUTE the_insert_function ('2017-10-07');
-- EXECUTE the_insert_function ('2017-10-08');
-- EXECUTE the_insert_function ('2017-10-09');
-- EXECUTE the_insert_function ('2017-10-10');
-- EXECUTE the_insert_function ('2017-10-11');
-- EXECUTE the_insert_function ('2017-10-12');
-- EXECUTE the_insert_function ('2017-10-13');
-- EXECUTE the_insert_function ('2017-10-14');
-- EXECUTE the_insert_function ('2017-10-15');
-- EXECUTE the_insert_function ('2017-10-16');
-- EXECUTE the_insert_function ('2017-10-17');
-- EXECUTE the_insert_function ('2017-10-18');
-- EXECUTE the_insert_function ('2017-10-19');
-- EXECUTE the_insert_function ('2017-10-20');
-- EXECUTE the_insert_function ('2017-10-21');
-- EXECUTE the_insert_function ('2017-10-22');
-- EXECUTE the_insert_function ('2017-10-23');
-- EXECUTE the_insert_function ('2017-10-24');
-- EXECUTE the_insert_function ('2017-10-25');
-- EXECUTE the_insert_function ('2017-10-26');
-- EXECUTE the_insert_function ('2017-10-27');
-- EXECUTE the_insert_function ('2017-10-28');
-- EXECUTE the_insert_function ('2017-10-29');
-- EXECUTE the_insert_function ('2017-10-30');
-- EXECUTE the_insert_function ('2017-10-31');
--
-- EXECUTE the_insert_function ('2017-11-01');
-- EXECUTE the_insert_function ('2017-11-02');
-- EXECUTE the_insert_function ('2017-11-03');
-- EXECUTE the_insert_function ('2017-11-04');
-- EXECUTE the_insert_function ('2017-11-05');
-- EXECUTE the_insert_function ('2017-11-06');
-- EXECUTE the_insert_function ('2017-11-07');
-- EXECUTE the_insert_function ('2017-11-08');
-- EXECUTE the_insert_function ('2017-11-09');
-- EXECUTE the_insert_function ('2017-11-10');
-- EXECUTE the_insert_function ('2017-11-11');
-- EXECUTE the_insert_function ('2017-11-12');
-- EXECUTE the_insert_function ('2017-11-13');
-- EXECUTE the_insert_function ('2017-11-14');
-- EXECUTE the_insert_function ('2017-11-15');
-- EXECUTE the_insert_function ('2017-11-16');
-- EXECUTE the_insert_function ('2017-11-17');
-- EXECUTE the_insert_function ('2017-11-18');
-- EXECUTE the_insert_function ('2017-11-19');
-- EXECUTE the_insert_function ('2017-11-20');
-- EXECUTE the_insert_function ('2017-11-21');
-- EXECUTE the_insert_function ('2017-11-22');
-- EXECUTE the_insert_function ('2017-11-23');
-- EXECUTE the_insert_function ('2017-11-24');
-- EXECUTE the_insert_function ('2017-11-25');
-- EXECUTE the_insert_function ('2017-11-26');
-- EXECUTE the_insert_function ('2017-11-27');
-- EXECUTE the_insert_function ('2017-11-28');
-- EXECUTE the_insert_function ('2017-11-29');
-- EXECUTE the_insert_function ('2017-11-30');

-- EXECUTE the_insert_function ('2017-12-01');
-- EXECUTE the_insert_function ('2017-12-02');
-- EXECUTE the_insert_function ('2017-12-03');
-- EXECUTE the_insert_function ('2017-12-04');
-- EXECUTE the_insert_function ('2017-12-05');
-- EXECUTE the_insert_function ('2017-12-06');
-- EXECUTE the_insert_function ('2017-12-07');
-- EXECUTE the_insert_function ('2017-12-08');
-- EXECUTE the_insert_function ('2017-12-09');
-- EXECUTE the_insert_function ('2017-12-10');
-- EXECUTE the_insert_function ('2017-12-11');
-- EXECUTE the_insert_function ('2017-12-12');
-- EXECUTE the_insert_function ('2017-12-13');
-- EXECUTE the_insert_function ('2017-12-14');
-- EXECUTE the_insert_function ('2017-12-15');
-- EXECUTE the_insert_function ('2017-12-16');
-- EXECUTE the_insert_function ('2017-12-17');
-- EXECUTE the_insert_function ('2017-12-18');
-- EXECUTE the_insert_function ('2017-12-19');
-- EXECUTE the_insert_function ('2017-12-20');
-- EXECUTE the_insert_function ('2017-12-21');
-- EXECUTE the_insert_function ('2017-12-22');
-- EXECUTE the_insert_function ('2017-12-23');
-- EXECUTE the_insert_function ('2017-12-24');
-- EXECUTE the_insert_function ('2017-12-25');
-- EXECUTE the_insert_function ('2017-12-26');
-- EXECUTE the_insert_function ('2017-12-27');
-- EXECUTE the_insert_function ('2017-12-28');
-- EXECUTE the_insert_function ('2017-12-29');
-- EXECUTE the_insert_function ('2017-12-30');
-- EXECUTE the_insert_function ('2017-12-31');
--
-- EXECUTE the_insert_function ('2018-01-01');
-- EXECUTE the_insert_function ('2018-01-02');
-- EXECUTE the_insert_function ('2018-01-03');
-- EXECUTE the_insert_function ('2018-01-04');
-- EXECUTE the_insert_function ('2018-01-05');
-- EXECUTE the_insert_function ('2018-01-06');
-- EXECUTE the_insert_function ('2018-01-07');
-- EXECUTE the_insert_function ('2018-01-08');
-- EXECUTE the_insert_function ('2018-01-09');
-- EXECUTE the_insert_function ('2018-01-10');
-- EXECUTE the_insert_function ('2018-01-11');
-- EXECUTE the_insert_function ('2018-01-12');
-- EXECUTE the_insert_function ('2018-01-13');
-- EXECUTE the_insert_function ('2018-01-14');
-- EXECUTE the_insert_function ('2018-01-15');
-- EXECUTE the_insert_function ('2018-01-16');
-- EXECUTE the_insert_function ('2018-01-17');
-- EXECUTE the_insert_function ('2018-01-18');
-- EXECUTE the_insert_function ('2018-01-19');
-- EXECUTE the_insert_function ('2018-01-20');
-- EXECUTE the_insert_function ('2018-01-21');
-- EXECUTE the_insert_function ('2018-01-22');
-- EXECUTE the_insert_function ('2018-01-23');
-- EXECUTE the_insert_function ('2018-01-24');
-- EXECUTE the_insert_function ('2018-01-25');
-- EXECUTE the_insert_function ('2018-01-26');
-- EXECUTE the_insert_function ('2018-01-27');
-- EXECUTE the_insert_function ('2018-01-28');
-- EXECUTE the_insert_function ('2018-01-29');
-- EXECUTE the_insert_function ('2018-01-30');
-- EXECUTE the_insert_function ('2018-01-31');



-- EXECUTE the_insert_function ('2018-02-01');
-- EXECUTE the_insert_function ('2018-02-02');
-- EXECUTE the_insert_function ('2018-02-03');
-- EXECUTE the_insert_function ('2018-02-04');
-- EXECUTE the_insert_function ('2018-02-05');
-- EXECUTE the_insert_function ('2018-02-06');
-- EXECUTE the_insert_function ('2018-02-07');
-- EXECUTE the_insert_function ('2018-02-08');
-- EXECUTE the_insert_function ('2018-02-09');
-- EXECUTE the_insert_function ('2018-02-10');
-- EXECUTE the_insert_function ('2018-02-11');
-- EXECUTE the_insert_function ('2018-02-12');
-- EXECUTE the_insert_function ('2018-02-13');
-- EXECUTE the_insert_function ('2018-02-14');
-- EXECUTE the_insert_function ('2018-02-15');
-- EXECUTE the_insert_function ('2018-02-16');
-- EXECUTE the_insert_function ('2018-02-17');
-- EXECUTE the_insert_function ('2018-02-18');
-- EXECUTE the_insert_function ('2018-02-19');
-- EXECUTE the_insert_function ('2018-02-20');
-- EXECUTE the_insert_function ('2018-02-21');
-- EXECUTE the_insert_function ('2018-02-22');
-- EXECUTE the_insert_function ('2018-02-23');
-- EXECUTE the_insert_function ('2018-02-24');
-- EXECUTE the_insert_function ('2018-02-25');
-- EXECUTE the_insert_function ('2018-02-26');
-- EXECUTE the_insert_function ('2018-02-27');
-- EXECUTE the_insert_function ('2018-02-28');
--
-- EXECUTE the_insert_function ('2018-03-01');
-- EXECUTE the_insert_function ('2018-03-02');
-- EXECUTE the_insert_function ('2018-03-03');
-- EXECUTE the_insert_function ('2018-03-04');
-- EXECUTE the_insert_function ('2018-03-05');
-- EXECUTE the_insert_function ('2018-03-06');
-- EXECUTE the_insert_function ('2018-03-07');
-- EXECUTE the_insert_function ('2018-03-08');
-- EXECUTE the_insert_function ('2018-03-09');
-- EXECUTE the_insert_function ('2018-03-10');
-- EXECUTE the_insert_function ('2018-03-11');
-- EXECUTE the_insert_function ('2018-03-12');
-- EXECUTE the_insert_function ('2018-03-13');
-- EXECUTE the_insert_function ('2018-03-14');
-- EXECUTE the_insert_function ('2018-03-15');
-- EXECUTE the_insert_function ('2018-03-16');
-- EXECUTE the_insert_function ('2018-03-17');
-- EXECUTE the_insert_function ('2018-03-18');
-- EXECUTE the_insert_function ('2018-03-19');
-- EXECUTE the_insert_function ('2018-03-20');
-- EXECUTE the_insert_function ('2018-03-21');
-- EXECUTE the_insert_function ('2018-03-22');
-- EXECUTE the_insert_function ('2018-03-23');
-- EXECUTE the_insert_function ('2018-03-24');
-- EXECUTE the_insert_function ('2018-03-25');
-- EXECUTE the_insert_function ('2018-03-26');
-- EXECUTE the_insert_function ('2018-03-27');
-- EXECUTE the_insert_function ('2018-03-28');
-- EXECUTE the_insert_function ('2018-03-29');
-- EXECUTE the_insert_function ('2018-03-30');
-- EXECUTE the_insert_function ('2018-03-31');
--
-- EXECUTE the_insert_function ('2018-04-01');
-- EXECUTE the_insert_function ('2018-04-02');
-- EXECUTE the_insert_function ('2018-04-03');
-- EXECUTE the_insert_function ('2018-04-04');
-- EXECUTE the_insert_function ('2018-04-05');
-- EXECUTE the_insert_function ('2018-04-06');
-- EXECUTE the_insert_function ('2018-04-07');
-- EXECUTE the_insert_function ('2018-04-08');
-- EXECUTE the_insert_function ('2018-04-09');
-- EXECUTE the_insert_function ('2018-04-10');
-- EXECUTE the_insert_function ('2018-04-11');
-- EXECUTE the_insert_function ('2018-04-12');
-- EXECUTE the_insert_function ('2018-04-13');
-- EXECUTE the_insert_function ('2018-04-14');
-- EXECUTE the_insert_function ('2018-04-15');
-- EXECUTE the_insert_function ('2018-04-16');
-- EXECUTE the_insert_function ('2018-04-17');
-- EXECUTE the_insert_function ('2018-04-18');
-- EXECUTE the_insert_function ('2018-04-19');
-- EXECUTE the_insert_function ('2018-04-20');
-- EXECUTE the_insert_function ('2018-04-21');
-- EXECUTE the_insert_function ('2018-04-22');
-- EXECUTE the_insert_function ('2018-04-23');
-- EXECUTE the_insert_function ('2018-04-24');
-- EXECUTE the_insert_function ('2018-04-25');
-- EXECUTE the_insert_function ('2018-04-26');
-- EXECUTE the_insert_function ('2018-04-27');
-- EXECUTE the_insert_function ('2018-04-28');
-- EXECUTE the_insert_function ('2018-04-29');
-- EXECUTE the_insert_function ('2018-04-30');

EXECUTE the_insert_function ('2018-05-01');
EXECUTE the_insert_function ('2018-05-02');
EXECUTE the_insert_function ('2018-05-03');
EXECUTE the_insert_function ('2018-05-04');
EXECUTE the_insert_function ('2018-05-05');
EXECUTE the_insert_function ('2018-05-06');
EXECUTE the_insert_function ('2018-05-07');
EXECUTE the_insert_function ('2018-05-08');
EXECUTE the_insert_function ('2018-05-09');
EXECUTE the_insert_function ('2018-05-10');
EXECUTE the_insert_function ('2018-05-11');
EXECUTE the_insert_function ('2018-05-12');
EXECUTE the_insert_function ('2018-05-13');
EXECUTE the_insert_function ('2018-05-14');
EXECUTE the_insert_function ('2018-05-15');
EXECUTE the_insert_function ('2018-05-16');
EXECUTE the_insert_function ('2018-05-17');
EXECUTE the_insert_function ('2018-05-18');
EXECUTE the_insert_function ('2018-05-19');
EXECUTE the_insert_function ('2018-05-20');
EXECUTE the_insert_function ('2018-05-21');
EXECUTE the_insert_function ('2018-05-22');
EXECUTE the_insert_function ('2018-05-23');
EXECUTE the_insert_function ('2018-05-24');
EXECUTE the_insert_function ('2018-05-25');
EXECUTE the_insert_function ('2018-05-26');
EXECUTE the_insert_function ('2018-05-27');
EXECUTE the_insert_function ('2018-05-28');
EXECUTE the_insert_function ('2018-05-29');
EXECUTE the_insert_function ('2018-05-30');
EXECUTE the_insert_function ('2018-05-31');

EXECUTE the_insert_function ('2018-06-01');
EXECUTE the_insert_function ('2018-06-02');
EXECUTE the_insert_function ('2018-06-03');
EXECUTE the_insert_function ('2018-06-04');
EXECUTE the_insert_function ('2018-06-05');
EXECUTE the_insert_function ('2018-06-06');
EXECUTE the_insert_function ('2018-06-07');
EXECUTE the_insert_function ('2018-06-08');
EXECUTE the_insert_function ('2018-06-09');
EXECUTE the_insert_function ('2018-06-10');
EXECUTE the_insert_function ('2018-06-11');
EXECUTE the_insert_function ('2018-06-12');
EXECUTE the_insert_function ('2018-06-13');
EXECUTE the_insert_function ('2018-06-14');
EXECUTE the_insert_function ('2018-06-15');
EXECUTE the_insert_function ('2018-06-16');
EXECUTE the_insert_function ('2018-06-17');
EXECUTE the_insert_function ('2018-06-18');
EXECUTE the_insert_function ('2018-06-19');
EXECUTE the_insert_function ('2018-06-20');
EXECUTE the_insert_function ('2018-06-21');
EXECUTE the_insert_function ('2018-06-22');
EXECUTE the_insert_function ('2018-06-23');
EXECUTE the_insert_function ('2018-06-24');
EXECUTE the_insert_function ('2018-06-25');
EXECUTE the_insert_function ('2018-06-26');
EXECUTE the_insert_function ('2018-06-27');
EXECUTE the_insert_function ('2018-06-28');
EXECUTE the_insert_function ('2018-06-29');
EXECUTE the_insert_function ('2018-06-30');

EXECUTE the_insert_function ('2018-07-01');
EXECUTE the_insert_function ('2018-07-02');
EXECUTE the_insert_function ('2018-07-03');
EXECUTE the_insert_function ('2018-07-04');
EXECUTE the_insert_function ('2018-07-05');
EXECUTE the_insert_function ('2018-07-06');
EXECUTE the_insert_function ('2018-07-07');
EXECUTE the_insert_function ('2018-07-08');
EXECUTE the_insert_function ('2018-07-09');
EXECUTE the_insert_function ('2018-07-10');
EXECUTE the_insert_function ('2018-07-11');
EXECUTE the_insert_function ('2018-07-12');
EXECUTE the_insert_function ('2018-07-13');
EXECUTE the_insert_function ('2018-07-14');
EXECUTE the_insert_function ('2018-07-15');
EXECUTE the_insert_function ('2018-07-16');
EXECUTE the_insert_function ('2018-07-17');
EXECUTE the_insert_function ('2018-07-18');
EXECUTE the_insert_function ('2018-07-19');
EXECUTE the_insert_function ('2018-07-20');
EXECUTE the_insert_function ('2018-07-21');
EXECUTE the_insert_function ('2018-07-22');
EXECUTE the_insert_function ('2018-07-23');
EXECUTE the_insert_function ('2018-07-24');
EXECUTE the_insert_function ('2018-07-25');
EXECUTE the_insert_function ('2018-07-26');
EXECUTE the_insert_function ('2018-07-27');
EXECUTE the_insert_function ('2018-07-28');
EXECUTE the_insert_function ('2018-07-29');
EXECUTE the_insert_function ('2018-07-30');
EXECUTE the_insert_function ('2018-07-31');

EXECUTE the_insert_function ('2018-08-01');
EXECUTE the_insert_function ('2018-08-02');
EXECUTE the_insert_function ('2018-08-03');
EXECUTE the_insert_function ('2018-08-04');
EXECUTE the_insert_function ('2018-08-05');
EXECUTE the_insert_function ('2018-08-06');
EXECUTE the_insert_function ('2018-08-07');
EXECUTE the_insert_function ('2018-08-08');
EXECUTE the_insert_function ('2018-08-09');
EXECUTE the_insert_function ('2018-08-10');
EXECUTE the_insert_function ('2018-08-11');
EXECUTE the_insert_function ('2018-08-12');
EXECUTE the_insert_function ('2018-08-13');




-- Remove from TABLE any data also existing in THE_TEMP_TABLE
DELETE FROM analysis.dsds_281_extension_daily_channel_presence_new
USING the_temp_table
WHERE the_temp_table.the_day = analysis.dsds_281_extension_daily_channel_presence_new.the_day
AND the_temp_table.extension_id = analysis.dsds_281_extension_daily_channel_presence_new.extension_id
AND the_temp_table.channel_id = analysis.dsds_281_extension_daily_channel_presence_new.channel_id
-- AND the_temp_table.some_id_2 = schema.table_name.some_id_2
;

-- Load TEMP_TABLE into TABLE
INSERT INTO analysis.dsds_281_extension_daily_channel_presence_new
(SELECT * FROM the_temp_table);

-- DEALLOCATE THE INSERT FUNCTION
DEALLOCATE the_insert_function;




--TEST DATA
SELECT * FROM analysis.dsds_281_extension_daily_channel_presence_new
WHERE extension_id = 'h7683cdyci11yov0tlac9f6lkvgtzi' AND channel_id = 174523291 AND the_day>='2018-08-01'::TIMESTAMP ORDER BY the_day;


--CHECK TO SEE IF THERE ARE DUPLICATES
WITH
weird_channel_id AS (
  SELECT *
  FROM (
    SELECT channel_id, extension_id, the_day, COUNT(1) AS rows
    FROM analysis.dsds_281_extension_daily_channel_presence_new
    GROUP BY 1,2,3
  )
  WHERE rows>1
)

SELECT * FROM analysis.dsds_281_extension_daily_channel_presence_new
WHERE channel_id IN (SELECT channel_id FROM weird_channel_id)
ORDER BY channel_id, extension_id, time_most_recent_activate
;


--CHECK extension_anchor
SELECT the_day
  , SUM(CASE WHEN extension_anchor IS NULL THEN 1 ELSE 0 END) AS count_null_extension_anchor
  , SUM(CASE WHEN extension_anchor NOT IN ('component','panel','video_overlay') AND extension_anchor IS NOT NULL THEN 1 ELSE 0 END) AS count_error_extension_anchor
  , SUM(CASE WHEN extension_anchor ='component' THEN 1 ELSE 0 END) AS count_component_extensions
  , SUM(CASE WHEN extension_anchor ='panel' THEN 1 ELSE 0 END) AS count_panel_extensions
  , SUM(CASE WHEN extension_anchor ='video_overlay' THEN 1 ELSE 0 END) AS count_overlay_extensions
FROM analysis.dsds_281_extension_daily_channel_presence_new
WHERE the_day>='2018-06-01'::TIMESTAMP
GROUP BY 1
ORDER BY 1
;
