--CHECK TO SEE IF THERE ARE DUPLICATES
WITH
the_data AS (
  SELECT *  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  WHERE the_day >= '2019-02-01'::TIMESTAMP
  --the_day = '2018-07-01'::TIMESTAMP OR
  --group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14
)
, weird_channel_id AS (
  SELECT *
  FROM (
    SELECT channel_id, extension_id, the_day, COUNT(1) AS rows
    FROM the_data
    GROUP BY 1,2,3
  )
  WHERE rows>1
)
SELECT extension_id, SUM(rows) AS rows, COUNT(DISTINCT channel_id) AS channels, COUNT(DISTINCT the_day) AS days
, MIN(the_day) AS min_day, MAX(the_day) AS max_day
FROM weird_channel_id GROUP BY 1 ORDER BY 2 DESC;



--get raw delete logs and remove duplicates, used when extension_version IS NOT the value ‘N/A’ (which we assign to 0.0.0)

   SELECT
     "time"::TIMESTAMP, base.extension_id::VARCHAR, base.extension_version::VARCHAR, ael.extension_name
   FROM tahoe.extension_delete AS base
   LEFT JOIN analysis.all_extensions_latest AS ael ON base.extension_id = ael.extension_id
   WHERE base.extension_id IS NOT NULL AND base.extension_version IS NOT NULL
     AND '2017-05-01'::DATE<="date"
     AND state IN ('Deleted') --there is non ‘Deleted’ data in this table for op.gg league of legends extensions for date=2017-11-10
   GROUP BY 1,2,3,4
   ORDER BY 1 DESC, 2, 3
   ;





--CHECK RECORD COUNTS PER DAY
SELECT the_day, COUNT(1) AS rows, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS total_activations, COUNT(DISTINCT channel_id) AS users, COUNT(DISTINCT extension_id) AS extensions
FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
WHERE the_day>='2019-02-15'
GROUP BY 1
ORDER BY 1
;

--CHECK RECORD COUNTS PER DAY
SELECT the_day, COUNT(1) AS rows, SUM(CASE WHEN bool_extension_activated THEN 1 ELSE 0 END) AS total_activations, COUNT(DISTINCT channel_id) AS users, COUNT(DISTINCT extension_id) AS extensions
FROM analysis.dsds_281_test
WHERE the_day>='2019-02-05'
GROUP BY 1
ORDER BY 1
;




--CHECK DAILY NET ACTIVATIONS CHANGE
SELECT the_day
  , SUM(CASE WHEN metric_new_net_activations=-1 THEN 1 ELSE 0 END) AS num_new_deactivations
  , SUM(CASE WHEN metric_new_net_activations=0 THEN 1 ELSE 0 END) AS num_same_as_prev
  , SUM(CASE WHEN metric_new_net_activations=1 THEN 1 ELSE 0 END) AS num_new_activations

FROM analysis.dsds292_metric_new_net_activations_daily
WHERE the_day>='2019-02-15'
GROUP BY 1
ORDER BY 1
;



--CHECK PER EXTENSION CHANGE
WITH
the_extensions AS (
  SELECT * FROM (
  SELECT the_day, extension_id
    , SUM(CASE WHEN metric_new_net_activations=-1 THEN 1 ELSE 0 END) AS num_new_deactivations
    , SUM(CASE WHEN metric_new_net_activations=0 THEN 1 ELSE 0 END) AS num_same_as_prev
    , SUM(CASE WHEN metric_new_net_activations=1 THEN 1 ELSE 0 END) AS num_new_activations

  FROM analysis.dsds292_metric_new_net_activations_daily
  WHERE the_day='2019-02-19' --change the date
  GROUP BY 1,2
  )
  --WHERE num_same_as_prev<=5 AND num_new_deactivations<=5 AND num_new_activations>=10
)
--SELECT SUM(num_new_deactivations) FROM the_extensions


SELECT base.*, ael.extension_name, ael.extension_state
FROM the_extensions AS base
LEFT JOIN analysis.all_extensions_latest AS ael ON base.extension_id = ael.extension_id
ORDER BY the_day, num_new_deactivations DESC
;
--
-- the_day       |          extension_id          | num_new_deactivations | num_same_as_prev | num_new_activations |            extension_name             | extension_state
-- ---------------------+--------------------------------+-----------------------+------------------+---------------------+---------------------------------------+-----------------
-- 2019-02-18 00:00:00 | h7683cdyci11yov0tlac9f6lkvgtzi |                     0 |                0 |              108319 | Spotify: Now Playing                  | Deleted
-- 2019-02-18 00:00:00 | 2zra50425wzzregbr7nqy9ma6eh9ed |                     0 |                1 |               22873 | Schedule                              | Deleted
-- 2019-02-18 00:00:00 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 |                     0 |                0 |               11360 | TopClip                               | Deleted
-- 2019-02-18 00:00:00 | f84i7aihacvbim14kres5qpc5wzl5e |                     0 |                0 |                4831 | osu! stats                            | Deleted
-- 2019-02-18 00:00:00 | 3ibaum1nyc7ru62htue9zrsjrfdh9k |                     0 |                0 |                2084 | Serpent.AI Schedule                   | Deleted
-- 2019-02-18 00:00:00 | k272edely6fljrto73iaswy61w7zhs |                     0 |                0 |                1991 | WoW Armory (World of Warcraft)        | Deleted
-- 2019-02-18 00:00:00 | k3ad8hnlfq7nord4d0yg4ij8eh1dlx |                     0 |                1 |                1141 | Hero Audience Reactions and Analytics | Deleted
-- 2019-02-18 00:00:00 | buesfgive961xt62gksyff7qmga3dt |                     0 |                0 |                 788 | Path of Exile Streamer Gear Viewer    | Deleted
-- 2019-02-18 00:00:00 | spvcaw5fckcv27lse6svg5pagxab3q |                     0 |                3 |                 456 | Heroes                                | Deleted
-- 2019-02-18 00:00:00 | oy8j5chemi3ie120yo8q1ibdi8gvc5 |                     0 |                0 |                 375 | Bobmob                                | Deleted
-- 2019-02-18 00:00:00 | fp6wx90nh8ciwtqb6male0jen9dap8 |                     0 |                0 |                 266 | Top 8+ by GameWisp                    | Deleted
-- 2019-02-18 00:00:00 | 03zordc4rx66x7b7hihhuhe5bd1uo2 |                     0 |                0 |                 207 | TruckersFM Song and listeners         | Deleted
-- 2019-02-18 00:00:00 | cb063xrtohf9muwpjl4doijbjycqa2 |                     0 |                0 |                 206 | Christmas Tree                        | Deleted
-- 2019-02-18 00:00:00 | z400armyk7r942xmmviyb70sl2zqa5 |                     0 |                0 |                 134 | Sudokitch Overlay                     | Deleted
-- 2019-02-18 00:00:00 | p7f191llvyb1ezetzydttwoewmf0g6 |                     0 |                0 |                 124 | pubg.gg statistics                    | Deleted
-- 2019-02-18 00:00:00 | ouuwb7426ddl4vp9ciwy2ueje3gsga |                     0 |                0 |                  73 | GamerLink Viewer Games                | Deleted
-- 2019-02-18 00:00:00 | ampqh0mn1lt0nssj5xo5m7mml7g9mz |                     0 |                1 |                  71 | Boom Interactions                     | Deleted
-- 2019-02-18 00:00:00 | iukyfu2x8xeihf9j5zkgd1cvua9v66 |                     0 |                0 |                  51 | Pubg Fullscreen Stats                 | Deleted
-- 2019-02-18 00:00:00 | kmcggd427iggksg7lsxhkj8bkjp6h7 |                     0 |                0 |                  49 | Reactions by Emotists                 | Deleted
-- 2019-02-18 00:00:00 | u6jfe8tzvph8gecfyv1fn0e4khu3kt |                     0 |                0 |                  31 | Matches                               | Deleted
-- 2019-02-18 00:00:00 | tbiqafy7nq62dzfqni9v2jtkqbzvow |                     0 |                0 |                  23 | Extra Life Donation Dashboard         | Deleted
-- 2019-02-18 00:00:00 | 2uwzmjkompom5umd417bfk0ycr807b |                     0 |                0 |                  17 | Drawtastic                            | Deleted
-- 2019-02-18 00:00:00 | 8olvjgqnsqcw9sybmr08erk5622867 |                     0 |                0 |                  15 | Tomatoes PRO                          | Deleted
-- 2019-02-18 00:00:00 | jrltn6yuxdiwpof16bbofu7k6pwr1w |                     0 |                2 |                  15 | Mosaic                                | Deleted
-- 2019-02-18 00:00:00 | 0jb0014htz8blipx5tzg0tpp64ge72 |                     0 |                2 |                  12 | Tournament Organizer                  | Deleted
-- 2019-02-18 00:00:00 | 3v9falpvk6qw6n5i4okm3xo3bazg8t |                     0 |                0 |                  12 | Streamlabs Pet                        | Deleted
-- 2019-02-18 00:00:00 | juk6e7vuh0eejfznsz4ij1uich6s12 |                     0 |                1 |                  10 | TestAlliances                         | Deleted


SELECT *
FROM tahoe.extension_activate
WHERE extension_id='h7683cdyci11yov0tlac9f6lkvgtzi' --deleted spotify now playing
AND date>='2018-10-01'
;





--check the records that exist in analysis.dsds_281_test_new_cte but not in analysis.dsds_281_extension_daily_channel_presence_all_anchor
WITH

the_constants_date AS (
  SELECT '2019-02-24'::TIMESTAMP AS the_day
)

, the_new_table AS (
  SELECT *
  FROM analysis.dsds_281_test
  WHERE
        the_day = (SELECT the_day FROM the_constants_date)
    --AND bool_extension_activated = TRUE
)

, the_orig_table AS (
  SELECT *
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  WHERE
        the_day = (SELECT the_day FROM the_constants_date)
    --AND bool_extension_activated = TRUE
)

, join_data AS (
  SELECT newtab.the_day, newtab.channel_id, newtab.extension_id, newtab.extension_anchor, newtab.bool_extension_activated, newtab.bool_extension_installed
    , orig.channel_id AS channel_id_old, orig.extension_id AS extension_id_old, orig.extension_anchor AS extension_anchor_old, orig.bool_extension_activated AS bool_extension_activated_old, orig.bool_extension_installed AS bool_extension_installed_old
  FROM the_new_table AS newtab
  FULL OUTER JOIN the_orig_table AS orig
    ON newtab.the_day = orig.the_day
    AND newtab.channel_id = orig.channel_id
    AND newtab.extension_id = orig.extension_id
    --AND newtab.extension_anchor = orig.extension_anchor
)

, final_data AS (
  SELECT *
    , CASE
      WHEN
        channel_id IS NOT NULL AND channel_id_old IS NOT NULL
        AND extension_id IS NOT NULL AND extension_id_old IS NOT NULL
        AND extension_anchor IS NOT NULL AND extension_anchor_old IS NOT NULL
        AND bool_extension_activated = TRUE AND bool_extension_activated_old = TRUE
          THEN '0_activate_exist_in_both'
      WHEN
        channel_id IS NULL AND channel_id_old IS NOT NULL
        AND extension_id IS NULL AND extension_id_old IS NOT NULL
        AND extension_anchor IS NULL AND extension_anchor_old IS NOT NULL
        AND (bool_extension_activated = TRUE OR bool_extension_activated_old = TRUE)
          THEN '1_activate_exist_in_old_only'
      WHEN
        channel_id IS NOT NULL AND channel_id_old IS NULL
        AND extension_id IS NOT NULL AND extension_id_old IS NULL
        AND extension_anchor IS NOT NULL AND extension_anchor_old IS NULL
        AND (bool_extension_activated = TRUE OR bool_extension_activated_old = TRUE)
          THEN '2_activate_exist_in_new_only'

      WHEN
        channel_id IS NOT NULL AND channel_id_old IS NOT NULL
        AND extension_id IS NOT NULL AND extension_id_old IS NOT NULL
        AND extension_anchor IS NULL AND extension_anchor_old IS NULL
        AND bool_extension_activated = FALSE AND bool_extension_activated_old = FALSE
          THEN '3_install_exist_in_both'
      WHEN
        channel_id IS NULL AND channel_id_old IS NOT NULL
        AND extension_id IS NULL AND extension_id_old IS NOT NULL
        AND extension_anchor IS NULL AND extension_anchor_old IS NULL
        AND (bool_extension_activated IS NULL AND bool_extension_activated_old = FALSE)
          THEN '4_install_exist_in_old_only'
      WHEN
        channel_id IS NOT NULL AND channel_id_old IS NULL
        AND extension_id IS NOT NULL AND extension_id_old IS NULL
        AND extension_anchor IS NULL AND extension_anchor_old IS NULL
        AND (bool_extension_activated = FALSE AND bool_extension_activated_old IS NULL)
          THEN '5_install_exist_in_new_only'
      WHEN
        bool_extension_activated != bool_extension_activated_old
          THEN '6_activate_records_no_match'
      WHEN
        bool_extension_installed != bool_extension_installed_old
          THEN '7_install_records_no_match'
      ELSE '99_other_error?'
      END AS flag_record
  FROM join_data
)

-- SELECT
--   flag_record, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels_new, COUNT(DISTINCT extension_id) AS extensions_new
--     , COUNT(DISTINCT channel_id_old) AS channels_old, COUNT(DISTINCT extension_id_old) AS extensions_old
-- FROM final_data
-- GROUP BY 1
-- ORDER BY 1



SELECT base.*, ael.extension_name, ael.extension_url, users.login, 'www.twitch.tv/'||users.login AS channel_url
FROM (
  SELECT *
  , NVL(channel_id,channel_id_old) AS the_channel_id
  , NVL(extension_id,extension_id_old) AS the_extension_id
  , NVL(extension_anchor,extension_anchor_old) AS the_extension_anchor
  FROM final_data
  WHERE flag_record='2_activate_exist_in_new_only'
) AS base
LEFT JOIN analysis.all_extensions_latest AS ael ON base.the_extension_id = ael.extension_id
LEFT JOIN db_snapshots.users AS users ON base.the_channel_id = users.id

--SELECT * FROM final_data WHERE flag_record IN ('5_install_exist_in_new_only', '99_other_error?', '6_activate_records_no_match')


;
