WITH
the_constants AS (
  SELECT 21597546 AS channel_id
  , '2017-09-01'::TIMESTAMP AS start_time
  , '2018-09-01'::TIMESTAMP AS end_time
)



SELECT base.*, 'www.twitch.tv/'+su.login AS url, REPLACE(rel.extension_name, ',', '') AS extension_name
FROM (

  SELECT 'activate' AS the_table, "time" AS the_time, user_id, channel_id, extension_id, extension_anchor
  FROM tahoe.extension_activate
  WHERE channel_id = (SELECT channel_id FROM the_constants) AND "time">=(SELECT start_time FROM the_constants) AND "date">=(SELECT start_time FROM the_constants)


  UNION ALL
  SELECT 'deactivate' AS the_table, "time" AS the_time, user_id, channel_id, extension_id, '' AS extension_anchor
  FROM tahoe.extension_deactivate
  WHERE channel_id = (SELECT channel_id FROM the_constants) AND "time">=(SELECT start_time FROM the_constants) AND "date">=(SELECT start_time FROM the_constants)


  UNION ALL
  SELECT 'uninstall' AS the_table, "time" AS the_time, user_id, channel_id, extension_id, '' AS extension_anchor
  FROM tahoe.extension_uninstall
  WHERE channel_id = (SELECT channel_id FROM the_constants) AND "time">=(SELECT start_time FROM the_constants) AND "date">=(SELECT start_time FROM the_constants)

) AS base
LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
LEFT JOIN analysis.sitedb_users AS su ON base.channel_id = su.user_id

ORDER BY 2
