WITH
the_constants AS (
  SELECT 136563385 AS channel_id --streamer with multiple anchor for same extension starting 2018-06-25
  , '2018-08-01'::TIMESTAMP AS start_time
  , '2018-09-01'::TIMESTAMP AS end_time
)

, the_basetable_date AS (
  SELECT '2017-05-01'::TIMESTAMP AS start_date
  , '2018-06-27'::TIMESTAMP AS end_date
)


  --get raw activate logs and remove duplicates
  , anchor_changed_logs_step0 AS (
    SELECT
      (SELECT start_date::DATE FROM the_basetable_date) AS start_date
      , (SELECT end_date::DATE FROM the_basetable_date) AS end_date
      , "time"::TIMESTAMP, extension_id::VARCHAR, extension_version::VARCHAR, channel_id, extension_anchor_new::VARCHAR
    FROM tahoe.extension_anchor_changed
    WHERE extension_id IS NOT NULL --AND extension_version IS NOT NULL
    AND (SELECT start_date FROM the_basetable_date)<="time" AND "time"<(SELECT end_date FROM the_basetable_date)
    AND (SELECT start_date FROM the_basetable_date)<="date" AND "date"<(SELECT end_date FROM the_basetable_date)
    AND channel_id = (SELECT channel_id FROM the_constants)
    GROUP BY 1,2,3,4,5,6,7
  )

  --processing to deal with same event firing duplicate rows with one being normal extension_version and another being extension_version='N/A'
  , anchor_changed_logs_step1 AS (
    SELECT start_date, end_date, "time", extension_id
    , MAX(CASE WHEN extension_version='N/A' THEN '0.0.0' ELSE extension_version END) AS extension_version --this is to deal with same event firing duplicate events with one being regular extension_version and another being extension_version='N/A'
    , channel_id, extension_anchor_new
    FROM anchor_changed_logs_step0
    GROUP BY 1,2,3,4,6,7
  )
  --for each user and extension and version and anchor combo, get the last timestamp that the action occurred (for the given start_date to end_date range)
  , anchor_changed_logs_step2 AS (
    SELECT start_date, end_date, extension_id, extension_version, channel_id, extension_anchor_new, MAX(time) AS last_time_anchor_changed
    FROM anchor_changed_logs_step1
    GROUP BY 1,2,3,4,5,6
    --SELECT * FROM anchor_changed_logs_step1
  )
  --for each user and extension, return 1 row that is the most recent action, but there are cases where the same timestamp exists for same extension_id but different extension_anchor, so then use the_random_seed to randomly assign the anchor
  , anchor_changed_logs_step3 AS (
    SELECT final.start_date, final.end_date, final.extension_id, final.extension_version, final.channel_id, final.extension_anchor_new, final.last_time_anchor_changed, RANDOM() AS the_random_seed
    FROM (
      SELECT *, MAX(last_time_anchor_changed) OVER (PARTITION BY start_date, end_date, channel_id, extension_id) AS max_last_time_anchor_changed --this max timestamp is extension_version agnostic
      FROM anchor_changed_logs_step2
    ) AS final
    WHERE last_time_anchor_changed = max_last_time_anchor_changed --only get the record that matches the max timestamp (i.e. they activate/reactivate multiple times within same day, just take the last one)
  )
  --for each user and extension, get the rank of the_random_seed, then pick only the one row with rank 1 (used to break ties for cases where the same timestamp exists for same extension_id but different extension_anchor)
  , anchor_changed_logs_step4 AS (
    SELECT *
    FROM (
      SELECT *, RANK() OVER (PARTITION BY start_date, end_date, extension_id, extension_version, channel_id ORDER BY the_random_seed DESC) AS the_random_seed_rank
      FROM anchor_changed_logs_step3
    )
    WHERE the_random_seed_rank=1
    --ORDER BY end_date, channel_id, extension_id, the_random_seed_rank
  )



, final_data AS (
  SELECT base.*, REPLACE(rel.extension_name, ',', '') AS extension_name
  FROM anchor_changed_logs_step4 AS base
  LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
  LEFT JOIN analysis.sitedb_users AS su ON base.channel_id = su.user_id
)
SELECT * FROM final_data ORDER BY 3
-- SELECT base.*
--   -- , 'www.twitch.tv/'+su.login AS url
--   , REPLACE(rel.extension_name, ',', '') AS extension_name
-- FROM (
--   SELECT 'anchor_changed' AS the_table, "time" AS the_time, channel_id, extension_id
--     , extension_anchor_new, extension_pos_x_new, extension_pos_y_new
--   FROM tahoe.extension_anchor_changed
--   WHERE channel_id = (SELECT channel_id FROM the_constants) AND "time">=(SELECT start_time FROM the_constants) AND "date">=(SELECT start_time FROM the_constants)
-- ) AS base
-- LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
-- LEFT JOIN analysis.sitedb_users AS su ON base.channel_id = su.user_id
--
-- ORDER BY 2

-- CHANGING FOR OVERLAY TO COMPONENT DOES THIS FIRE THE RIGHT ACTIVATE DEACTIVATES??
-- a_dot_burr 2018-08-20 14:32
-- amazon prime extension is active as overlay 1
-- changed it to component 2
-- then changed it to component 1
-- then change it back to video overlay 1
-- then set it as component 2


-- the_table    |      the_time       | channel_id |          extension_id          | extension_anchor_new | extension_pos_x_new | extension_pos_y_new |            extension_name
-- ----------------+---------------------+------------+--------------------------------+----------------------+---------------------+---------------------+--------------------------------------
-- anchor_changed | 2018-08-08 07:20:13 |  155528531 | fe5a78xkj1lnk9wefpk295p6x3dsvl | panel                |                   0 |                   0 | Stream Avatars
-- anchor_changed | 2018-08-20 14:32:52 |  155528531 | d4uvtfdr04uq6raoenvj7m86gdk16v | component            |                3645 |                1620 | Prime Subscription and Loot Reminder
-- anchor_changed | 2018-08-20 14:33:00 |  155528531 | d4uvtfdr04uq6raoenvj7m86gdk16v | component            |                8000 |                3447 | Prime Subscription and Loot Reminder
-- anchor_changed | 2018-08-20 14:33:25 |  155528531 | d4uvtfdr04uq6raoenvj7m86gdk16v | video_overlay        |                   0 |                   0 | Prime Subscription and Loot Reminder
-- anchor_changed | 2018-08-20 14:33:49 |  155528531 | d4uvtfdr04uq6raoenvj7m86gdk16v | component            |                8000 |                1620 | Prime Subscription and Loot Reminder
-- anchor_changed | 2018-08-20 18:34:12 |  155528531 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 | panel                |                   0 |                   0 | TopClip
-- (6 rows)




-- the_table  |      the_time       |  user_id  | channel_id |          extension_id          | extension_anchor |           url            |             extension_name
-- ------------+---------------------+-----------+------------+--------------------------------+------------------+--------------------------+-----------------------------------------
-- activate   | 2017-09-07 13:42:29 | 155528531 |  155528531 | 7hoqd16sufw9f9h3swlkdt6lqdn3ud |                  | www.twitch.tv/a_dot_burr | Gear on Amazon
-- deactivate | 2017-09-07 13:44:06 | 155528531 |  155528531 | 7hoqd16sufw9f9h3swlkdt6lqdn3ud |                  | www.twitch.tv/a_dot_burr | Gear on Amazon
-- uninstall  | 2017-09-07 16:15:55 | 155528531 |  155528531 | 7hoqd16sufw9f9h3swlkdt6lqdn3ud |                  | www.twitch.tv/a_dot_burr | Gear on Amazon
-- activate   | 2017-09-14 14:51:52 | 155528531 |  155528531 | 7hoqd16sufw9f9h3swlkdt6lqdn3ud |                  | www.twitch.tv/a_dot_burr | Gear on Amazon
-- activate   | 2017-09-14 14:52:18 | 155528531 |  155528531 | ro13roxp88918kulntih9uzm7vs9jr |                  | www.twitch.tv/a_dot_burr | StreamLegends
-- activate   | 2017-09-14 14:53:02 | 155528531 |  155528531 | 0biqu5sb4f8fq6pxxg09xix27d0uo2 |                  | www.twitch.tv/a_dot_burr | Live Pet
-- uninstall  | 2017-10-09 17:06:54 | 155528531 |  155528531 | 7hoqd16sufw9f9h3swlkdt6lqdn3ud |                  | www.twitch.tv/a_dot_burr | Gear on Amazon
-- uninstall  | 2017-10-09 17:06:59 | 155528531 |  155528531 | ro13roxp88918kulntih9uzm7vs9jr |                  | www.twitch.tv/a_dot_burr | StreamLegends
-- uninstall  | 2017-10-09 17:07:03 | 155528531 |  155528531 | 0biqu5sb4f8fq6pxxg09xix27d0uo2 |                  | www.twitch.tv/a_dot_burr | Live Pet
-- activate   | 2017-10-10 17:06:30 | 155528531 |  155528531 | 24u62kim5mn0slhwigdt7v4ybkwef5 |                  | www.twitch.tv/a_dot_burr | Leaderboard
-- uninstall  | 2017-10-12 16:28:08 | 155528531 |  155528531 | c8okel68mmobvnso7ty0cygj8easam |                  | www.twitch.tv/a_dot_burr | Smart Click Maps
-- activate   | 2017-11-06 14:11:20 | 155528531 |  155528531 | u4xkb2t4a2v6ex9f465sghrpk458a2 |                  | www.twitch.tv/a_dot_burr |
-- deactivate | 2018-01-22 11:36:08 | 155528531 |  155528531 | 24u62kim5mn0slhwigdt7v4ybkwef5 |                  | www.twitch.tv/a_dot_burr | Leaderboard
-- activate   | 2018-01-22 11:36:20 | 155528531 |  155528531 | 24u62kim5mn0slhwigdt7v4ybkwef5 |                  | www.twitch.tv/a_dot_burr | Leaderboard
-- uninstall  | 2018-01-22 11:36:35 | 155528531 |  155528531 | 24u62kim5mn0slhwigdt7v4ybkwef5 |                  | www.twitch.tv/a_dot_burr | Leaderboard
-- deactivate | 2018-01-22 11:36:36 | 155528531 |  155528531 | 24u62kim5mn0slhwigdt7v4ybkwef5 |                  | www.twitch.tv/a_dot_burr | Leaderboard
-- activate   | 2018-02-14 17:25:56 | 155528531 |  155528531 | 9zqhb3hba48m0c382uno7k2t74isfi |                  | www.twitch.tv/a_dot_burr | Viewer Geolocation
-- activate   | 2018-02-14 17:26:28 | 155528531 |  155528531 | uaw3vx1k0ttq74u9b2zfvt768eebh1 |                  | www.twitch.tv/a_dot_burr | StreamElements Leaderboards
-- deactivate | 2018-02-14 17:27:44 | 155528531 |  155528531 | u4xkb2t4a2v6ex9f465sghrpk458a2 |                  | www.twitch.tv/a_dot_burr |
-- uninstall  | 2018-02-14 17:27:44 | 155528531 |  155528531 | u4xkb2t4a2v6ex9f465sghrpk458a2 |                  | www.twitch.tv/a_dot_burr |
-- activate   | 2018-02-14 17:29:22 | 155528531 |  155528531 | 24u62kim5mn0slhwigdt7v4ybkwef5 |                  | www.twitch.tv/a_dot_burr | Leaderboard
-- activate   | 2018-03-06 17:00:44 | 155528531 |  155528531 | 4ntuott0zqw008atk0wy60phfa8jyf |                  | www.twitch.tv/a_dot_burr | Innkeeper: Advanced Hearthstone Overlay
-- uninstall  | 2018-04-20 17:26:11 | 155528531 |  155528531 | wi08ebtatdc7oj83wtl9uxwz807l8b |                  | www.twitch.tv/a_dot_burr | Streamlabs Leaderboard
-- uninstall  | 2018-06-06 14:01:25 | 155528531 |  155528531 | d4uvtfdr04uq6raoenvj7m86gdk16v |                  | www.twitch.tv/a_dot_burr | Prime Subscription and Loot Reminder
-- deactivate | 2018-06-19 12:09:11 | 155528531 |  155528531 | 4ntuott0zqw008atk0wy60phfa8jyf |                  | www.twitch.tv/a_dot_burr | Innkeeper: Advanced Hearthstone Overlay
-- activate   | 2018-06-19 12:09:11 | 155528531 |  155528531 | d4uvtfdr04uq6raoenvj7m86gdk16v | video_overlay    | www.twitch.tv/a_dot_burr | Prime Subscription and Loot Reminder
-- activate   | 2018-08-08 07:18:59 | 155528531 |  155528531 | fe5a78xkj1lnk9wefpk295p6x3dsvl | component        | www.twitch.tv/a_dot_burr | Stream Avatars
-- deactivate | 2018-08-08 07:20:13 | 155528531 |  155528531 | uaw3vx1k0ttq74u9b2zfvt768eebh1 |                  | www.twitch.tv/a_dot_burr | StreamElements Leaderboards
-- deactivate | 2018-08-16 14:48:59 | 155528531 |  155528531 | 9zqhb3hba48m0c382uno7k2t74isfi |                  | www.twitch.tv/a_dot_burr | Viewer Geolocation
-- activate   | 2018-08-16 14:48:59 | 155528531 |  155528531 | 0biqu5sb4f8fq6pxxg09xix27d0uo2 | panel            | www.twitch.tv/a_dot_burr | Live Pet
-- deactivate | 2018-08-16 14:49:05 | 155528531 |  155528531 | 24u62kim5mn0slhwigdt7v4ybkwef5 |                  | www.twitch.tv/a_dot_burr | Leaderboard
-- activate   | 2018-08-16 14:49:05 | 155528531 |  155528531 | 9zqhb3hba48m0c382uno7k2t74isfi | panel            | www.twitch.tv/a_dot_burr | Viewer Geolocation
-- deactivate | 2018-08-16 14:49:18 | 155528531 |  155528531 | fe5a78xkj1lnk9wefpk295p6x3dsvl |                  | www.twitch.tv/a_dot_burr | Stream Avatars
-- activate   | 2018-08-16 14:49:18 | 155528531 |  155528531 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 | panel            | www.twitch.tv/a_dot_burr | TopClip
-- deactivate | 2018-08-16 14:49:28 | 155528531 |  155528531 | 0biqu5sb4f8fq6pxxg09xix27d0uo2 |                  | www.twitch.tv/a_dot_burr | Live Pet
-- activate   | 2018-08-16 14:49:28 | 155528531 |  155528531 | ro13roxp88918kulntih9uzm7vs9jr | panel            | www.twitch.tv/a_dot_burr | StreamLegends
-- activate   | 2018-08-20 15:11:53 | 155528531 |  155528531 | wi08ebtatdc7oj83wtl9uxwz807l8b | panel            | www.twitch.tv/a_dot_burr | Streamlabs Leaderboard
-- deactivate | 2018-08-20 15:11:53 | 155528531 |  155528531 | ro13roxp88918kulntih9uzm7vs9jr |                  | www.twitch.tv/a_dot_burr | StreamLegends
-- deactivate | 2018-08-20 18:34:12 | 155528531 |  155528531 | 9zqhb3hba48m0c382uno7k2t74isfi |                  | www.twitch.tv/a_dot_burr | Viewer Geolocation
-- (39 rows)




-- changing extension’s anchor_types without over riding existing extension (i.e. video to component)
   -- this does not fire the implicit activate/deactivate, it only fires to anchor_changed
   -- because anchor_changed does not send the previous anchor, there can be data errors in mapping timestamps and extension+channel combo only without the “activate” as new anchor and “deactivate” from previous anchor

-- changing extension’s anchor_types AND over riding existing extension slot (i.e. video to component to replace an existing component)
  -- this does fire the deactivate, and it fires to anchor_changed, but not the implicit activate
  -- cannot use timestamps as join key as there is data logs showing that the time between the anchor_changed and deactivate can be 1 second off


-- changing extension’s slot (i.e. panel slot 1 to panel slot 2)
   -- if changing the slot over-rides an existing activated extension, then it will fire deactivate but not activate
   -- this fires anchor_changed
   -- there is an existing ticket to add anchor slot to tracking events https://jira.twitch.com/browse/ANC-230

-- activating over an existing extension
   -- this fires the implicit activate and deactivate, but there might be some cases early on when we didn’t fire this (i.e. no tracking code yet)


-- removing the extension from ‘edit panels’ on the channel page
   -- the extension technically is not uninstalled or deactivated, only the visible panel iframe is gone in the channel page
   -- should we do something different here??





   -- 2018-08-21 03:40
   -- activated TOP CLIP extension from panel slot 2 to panel slot 1, this over ridden stream labs leaderboard
   -- activated TOP CLIP extension from panel slot 2 to component slot 1, this over ridden twitch prime extension

  --  start_date |  end_date  |        time         |          extension_id          | extension_version | channel_id | extension_anchor_new |            extension_name
  -- ------------+------------+---------------------+--------------------------------+-------------------+------------+----------------------+--------------------------------------
  --  2017-05-01 | 2018-08-22 | 2018-08-08 07:20:13 | fe5a78xkj1lnk9wefpk295p6x3dsvl | N/A               |  155528531 | panel                | Stream Avatars
  --  2017-05-01 | 2018-08-22 | 2018-08-20 14:32:52 | d4uvtfdr04uq6raoenvj7m86gdk16v | N/A               |  155528531 | component            | Prime Subscription and Loot Reminder
  --  2017-05-01 | 2018-08-22 | 2018-08-20 14:33:00 | d4uvtfdr04uq6raoenvj7m86gdk16v | N/A               |  155528531 | component            | Prime Subscription and Loot Reminder
  --  2017-05-01 | 2018-08-22 | 2018-08-20 14:33:25 | d4uvtfdr04uq6raoenvj7m86gdk16v | N/A               |  155528531 | video_overlay        | Prime Subscription and Loot Reminder
  --  2017-05-01 | 2018-08-22 | 2018-08-20 14:33:49 | d4uvtfdr04uq6raoenvj7m86gdk16v | N/A               |  155528531 | component            | Prime Subscription and Loot Reminder
  --  2017-05-01 | 2018-08-22 | 2018-08-20 18:34:12 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 | N/A               |  155528531 | panel                | TopClip
  --  2017-05-01 | 2018-08-22 | 2018-08-21 03:40:34 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 | N/A               |  155528531 | panel                | TopClip
  --  2017-05-01 | 2018-08-22 | 2018-08-21 03:42:09 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 | N/A               |  155528531 | component            | TopClip

  -- deactivate | 2018-08-20 18:34:12 | 155528531 |  155528531 | 9zqhb3hba48m0c382uno7k2t74isfi |                  | www.twitch.tv/a_dot_burr | Viewer Geolocation
  -- deactivate | 2018-08-21 03:40:35 | 155528531 |  155528531 | wi08ebtatdc7oj83wtl9uxwz807l8b |                  | www.twitch.tv/a_dot_burr | Streamlabs Leaderboard
  -- deactivate | 2018-08-21 03:42:09 | 155528531 |  155528531 | d4uvtfdr04uq6raoenvj7m86gdk16v |                  | www.twitch.tv/a_dot_burr | Prime Subscription and Loot Reminder
