SELECT base.channel_id, su.login, base.extension_id, base.extension_anchor
, 'www.twitch.tv/'+su.login AS url, REPLACE(rel.extension_name, ',', '') AS extension_name
, MIN("time") AS first_time_rendered, MAX("time") AS last_time_rendered
FROM logs.extension_render AS base
LEFT JOIN analysis.sitedb_users AS su ON base.channel_id = su.user_id
LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
WHERE channel_id = 106121-- AND extension_anchor='panel'
AND "time">='2018-01-01'::TIMESTAMP-- AND "time"<'2018-05-27'::TIMESTAMP
GROUP BY 1,2,3,4,5,6
ORDER BY 1,2,4,5,6


--
-- channel_id |          extension_id          | extension_anchor
-- ------------+--------------------------------+------------------
--      35512 | asppxuf1di6v7hwfucmogjg9eh32au |
--      35512 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 | panel
--      35512 | rh6jq1q334hqc2rr1qlzqbvwlfl3x0 |
--      35512 | wi08ebtatdc7oj83wtl9uxwz807l8b | panel

-- 2018-08-22 15:15:00 (CHECK IF PANEL EXTENSIONS REMOVED VIA EDIT PANELS STILL FIRES)
-- a_dot_burr activated stream elements leaderboard and stream avatar as panels (theres some replacement behavior before this)
-- then used edit panels to remove the slot for stream Avatar
-- then used incognito window to open up a_dot_burr's channel
-- check if stream avatar is firing a render event and view event?
-- 
