CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds_281_extension_daily_version);

INSERT INTO the_temp_table
(

  WITH
  the_constants AS (
    SELECT
      --DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) - INTERVAL '7 day' AS range_start --look back last 7 days in case we don't run this every day
      '2017-09-01'::TIMESTAMP AS range_start
      , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS range_end
  )

  , extension_first_date AS (
    SELECT
      extension_id, DATE_TRUNC('day', MIN(time)) AS first_extension_date
    FROM tahoe.extension_render
    WHERE
      date>='2017-09-01'::TIMESTAMP --extensions first launched to everyone in early Sep 2017
      AND date<(SELECT range_end FROM the_constants)
      AND extension_id IS NOT NULL
    GROUP BY 1
  )

  , the_basetable_date AS (
    SELECT
      date::TIMESTAMP AS the_day
    FROM metadata.date
    WHERE
      date>='2017-09-01'::TIMESTAMP --extensions first launched to everyone in early Sep 2017
      AND date<(SELECT range_end FROM the_constants)
    GROUP BY 1
  )
  , the_basetable_extension_date AS (
    SELECT *
    FROM (
      SELECT table_date.the_day, table_ext.extension_id, table_ext.first_extension_date
      FROM the_basetable_date AS table_date
      CROSS JOIN extension_first_date table_ext
    )
    WHERE the_day>=first_extension_date AND the_day>=(SELECT range_start FROM the_constants)
  )
  --SELECT * FROM the_basetable_extension_date ORDER BY 2,1

  --get all the possible extension_id and extension_version combinations
  , the_render_logs_step1 AS (
    SELECT "time" AS the_time, extension_id, extension_version
    FROM tahoe.extension_render
    WHERE date>=(SELECT range_start FROM the_constants) AND date<(SELECT range_end FROM the_constants)
    GROUP BY 1,2,3
  )
  -- count the times each extension_id and extension_version combo occurs each day
  , the_render_logs_step2 AS (
    SELECT *, RANK() OVER (PARTITION BY the_day, extension_id ORDER BY rows DESC) AS row_count_rank
    FROM (
      SELECT DATE_TRUNC('day', the_time) AS the_day, extension_id, extension_version, COUNT(1) AS rows
      FROM the_render_logs_step1
      GROUP BY 1,2,3
    )
  )
  -- to break ties, select the max (latest) extension_version
  , the_render_logs_step3 AS (
    SELECT the_day, extension_id, MAX(extension_version) AS extension_version, rows, row_count_rank
    FROM the_render_logs_step2
    WHERE row_count_rank=1
    GROUP BY 1,2,4,5
  )

  , merged_data_step1 AS (
    SELECT base.the_day, base.extension_id, base.first_extension_date, render.extension_version
    FROM the_basetable_extension_date AS base
    LEFT JOIN the_render_logs_step3 AS render
      ON base.the_day = render.the_day
      AND base.extension_id = render.extension_id
  )
  , merged_data_step2 AS (
    SELECT *, LAST_VALUE(extension_version IGNORE NULLS) OVER (PARTITION BY extension_id ORDER BY the_day ROWS BETWEEN unbounded preceding AND current row) as latest_known_version
    FROM merged_data_step1
  )
  , final_data AS (
    SELECT the_day, extension_id, latest_known_version AS extension_version
    FROM merged_data_step2
  )

  SELECT * FROM final_data
  --SELECT * FROM merged_data_step2 WHERE extension_id = '1nz6dcl6tj5ym9zv0idjftdjqatdth'

);


-- Remove from ROLLUP_TABLE any data also existing in THE_TEMP_TABLE
DELETE FROM analysis.dsds_281_extension_daily_version
USING the_temp_table
WHERE
  the_temp_table.the_day = analysis.dsds_281_extension_daily_version.the_day
  AND the_temp_table.extension_id = analysis.dsds_281_extension_daily_version.extension_id
;



-- Load TEMP_TABLE into ROLLUP_TABLE
INSERT INTO analysis.dsds_281_extension_daily_version
(SELECT * FROM the_temp_table);


SELECT *
FROM analysis.dsds_281_extension_daily_version
WHERE extension_id = '1nz6dcl6tj5ym9zv0idjftdjqatdth'
ORDER by 1
;
