-- Sound Alerts-> pull cheer benchmark for ARPPU and conversion
-- After talking to Joel, numerator they use for conversion is # that used bits and the denominator is # of active users (generated 5mp ) for a given time period?
-- however for extensions we are using video play to use bits conversion



WITH
the_constants_time AS (
  SELECT '2018-07-01'::TIMESTAMP AS start_time
    , '2018-08-01'::TIMESTAMP AS end_time
)
-- , conversion_denominator AS (
--   SELECT COUNT(DISTINCT user_id) AS active_viewers
--   FROM rollups.daily_active_viewers
--   WHERE day>=(SELECT start_time FROM the_constants_time)
--   AND day<(SELECT end_time FROM the_constants_time)
-- )
, conversion_denominator AS (
  SELECT COUNT(DISTINCT user_id) AS logged_in_users_who_watched_live
  FROM logs."video-play"
  WHERE "time">=(SELECT start_time FROM the_constants_time)
  AND "time"<(SELECT end_time FROM the_constants_time)
  AND live IS TRUE

)
, conversion_numerator AS (
  SELECT COUNT(DISTINCT user_id) AS bits_spenders, SUM(used_of_this_type) AS total_bits_used
  FROM logs.bits_used_v2
  WHERE "time">=(SELECT start_time FROM the_constants_time)
  AND "time"<(SELECT end_time FROM the_constants_time)
  AND context='cheer'
)

SELECT cn.bits_spenders::FLOAT / cd.logged_in_users_who_watched_live::FLOAT AS cheering_conversion
  , (cn.total_bits_used::FLOAT/100) / cn.bits_spenders::FLOAT AS arppu
FROM conversion_denominator AS cd
LEFT JOIN conversion_numerator AS cn ON 1=1

-- >=2018-01-01 to <2018-08-16
-- cheering_conversion |      arppu
-- ---------------------+-----------------
--  0.0326250551499041 | 23.355330901233


-- THE RESULT
-- cheering_conversion |      arppu       
-- ---------------------+------------------
--  0.0174590016036517 | 10.7090020701864
