-- Sound Alerts-> % of total bits-enabled MW



WITH
the_constants AS (
  SELECT '2018-07-01'::TIMESTAMP AS start_time
    , '2018-08-01'::TIMESTAMP AS end_time
    , 'bttsqjy6dnv05acplp5vy0mflgrh3z'::VARCHAR AS extension_id
)

, channels_with_extension AS (
  SELECT channel_id
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  WHERE the_day = (SELECT end_time - INTERVAL '1 day' FROM the_constants)
  AND extension_id = (SELECT extension_id FROM the_constants)
  AND bool_extension_activated IS TRUE
  GROUP BY 1
)

, channels_with_bits_enabled AS (
  SELECT channel_id
  FROM tahoe.bits_partner_onboarded
  WHERE "date" <(SELECT end_time FROM the_constants)
  GROUP BY 1
)

, mw_channels_with_extension AS (
  SELECT SUM(mw_live_total) AS total_live_mw
  FROM rollups.daily_minutes_watched_by_channel
  WHERE day>=(SELECT start_time FROM the_constants)
  AND day<(SELECT end_time FROM the_constants)
  AND channel_id IN (SELECT channel_id FROM channels_with_extension)
)

, mw_channels_with_bits_enabled AS (
  SELECT SUM(mw_live_total) AS total_live_mw
  FROM rollups.daily_minutes_watched_by_channel
  WHERE day>=(SELECT start_time FROM the_constants)
  AND day<(SELECT end_time FROM the_constants)
  AND channel_id IN (SELECT channel_id FROM channels_with_bits_enabled)
)

-- SELECT * FROM mw_channels_with_bits_enabled
-- total_live_mw
-- ---------------
--   29340467819


-- SELECT * FROM mw_channels_with_extension
-- total_live_mw
-- ---------------
--     258864263




-- SELECT COUNT(DISTINCT channel_id) FROM channels_with_bits_enabled
-- count
-- --------
--  335150



-- SELECT COUNT(DISTINCT channel_id) FROM channels_with_extension
--  count
-- -------
--   3026
