-- SELECT type, contract_title, event_name, channel_id, channelname, start_time_pt, end_time_pt, team_addition_date, team_removal_date
-- FROM analysis.esports_deal_channels
-- WHERE "type" <> 'UGC Esports'
-- --AND start_time_pt IS NULL OR end_time_pt IS NULL
-- ;
--

WITH

premium_non_gaming_raw as (
  SELECT su.user_id AS channel_id, base.channel
  FROM (
    SELECT LOWER(channel) AS channel
    FROM analysis.png_content_summary
    GROUP BY 1
  ) AS base
  LEFT JOIN analysis.sitedb_users AS su ON base.channel = su.login
  GROUP BY 1,2
)
, esports_raw AS (
  SELECT su.user_id AS channel_id, base.channel
  FROM (
    SELECT LOWER(channelname) AS channel
    FROM analysis.esports_deal_channels
    WHERE "type" <> 'UGC Esports'
    GROUP BY 1
  ) AS base
  LEFT JOIN analysis.sitedb_users AS su ON base.channel = su.login
  GROUP BY 1,2
)
, all_premium AS (
  SELECT * FROM (
    SELECT * FROM premium_non_gaming_raw
    UNION ALL SELECT * FROM esports_raw
  )
  WHERE channel_id IS NOT NULL
  GROUP BY 1,2
)
, weird_ids AS (
SELECT * FROM (
SELECT channel, COUNT(DISTINCT channel_id) AS channel_ids
FROM all_premium
GROUP BY 1
)
WHERE channel_ids >1
)

SELECT * FROM all_premium WHERE channel IN (SELECT channel FROM weird_ids)
