-- find the date for each channel_id and extension_id where there is 30 days post of continuous extension presence, and >=20 days pre of no extensions

DROP TABLE IF EXISTS analysis.dsds_302_day_channel_cross_join;

CREATE TABLE analysis.dsds_302_day_channel_cross_join AS


WITH
the_timeframe AS (
  SELECT '2017-10-01'::TIMESTAMP AS start_time
  , '2018-08-01'::TIMESTAMP AS end_time
)

, the_constants_timeframe AS (
  SELECT "date" AS the_day
  FROM metadata.date
  WHERE
    "date">= (SELECT start_time FROM the_timeframe)
    AND "date" <= (SELECT end_time FROM the_timeframe)
  GROUP BY 1
)
, the_constants_channels AS (
  SELECT channel_id
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
  RIGHT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id --only look at released extensions records
  WHERE
    base.the_day>=(SELECT MIN(the_day) FROM the_constants_timeframe)--'2017-08-31'::TIMESTAMP -- https://blog.twitch.tv/introducing-extensions-a-streaming-revolution-c31762addcd9
    AND base.the_day<(SELECT MAX(the_day) FROM the_constants_timeframe)
    AND base.bool_extension_activated = TRUE
  GROUP BY 1
)

, day_channel_cross_join AS (
  SELECT * FROM the_constants_timeframe
  CROSS JOIN the_constants_channels
)

SELECT * FROM day_channel_cross_join;

--
-- SELECT COUNT(1) FROM analysis.dsds_302_day_channel_cross_join;
