-- channelid	channelname	type	organizer
-- 8822	blizzard	License	Blizzard
-- 36616300	capcomfighters	Twitch Program	Capcom Pro Tour
-- 35630634	dota2ti	License	Dota Major
-- 50160915	dreamleague	License	DreamHack
-- 67834893	esl	License	ESL
-- 21681549	pgl	License	PGL
-- 36029255	riotgames	License	Riot Games
-- 57781936	rocketleague	Twitch Program	Rocket League





WITH
the_timeframe AS (
SELECT '2017-01-01 00:00:00'::TIMESTAMP AS start_time
, '2017-11-01 00:00:00'::TIMESTAMP AS end_time
)
-- , the_channels AS (
-- --SELECT 8822 AS channel_id, 'blizzard' AS channel
-- SELECT 36616300 AS channel_id, 'capcomfighters' AS channel
-- UNION ALL SELECT 35630634 AS channel_id, 'dota2ti' AS channel
-- UNION ALL SELECT 50160915 AS channel_id, 'dreamleague' AS channel
-- UNION ALL SELECT 67834893 AS channel_id, 'esl' AS channel
-- UNION ALL SELECT 21681549 AS channel_id, 'pgl' AS channel
-- UNION ALL SELECT 36029255 AS channel_id, 'riotgames' AS channel
-- UNION ALL SELECT 57781936 AS channel_id, 'rocketleague' AS channel
-- )

, mw_log AS (
SELECT channel_id, channel, SUM(1) AS mw_total, COUNT(DISTINCT user_id) AS users--, SUM(1)::FLOAT/COUNT(DISTINCT user_id)::FLOAT AS mw_per_user
FROM logs."minute-watched"
WHERE channel_id IN (8822, 36616300, 35630634, 50160915, 67834893, 21681549, 36029255, 57781936)
AND "time">=(SELECT start_time FROM the_timeframe)
AND "time"<(SELECT end_time FROM the_timeframe)
GROUP BY 1,2
)


SELECT * FROM mw_log
