--there are 4 "phases" of the fifa drops campaigns
--phase 1= 2018-01-26 04:00 to 2018-01-28 14:00
--phase 2= 2018-04-13 04:00 to 2018-04-15 13:30
--phase 3= 2018-05-28 05:00 to 2018-06-03 12:00
--phase 4= 2018-08-02 03:00 to 2018-08-04 14:00

--create a lookup table that indicates if the user was linked in each of the different phases
-- user_id
-- flag_linked_phase1
-- flag_linked_phase2
-- flag_linked_phase3
-- flag_linked_phase4

CREATE TABLE analysis.dsds_310_fifa_linked_accounts AS

WITH
game_devs AS (
  SELECT 'rg5jwqeyulmyy5s5zsu7juu2l3q1ue'::VARCHAR AS client_id --EA's client_id
)
, the_constants AS (
  SELECT '2018-01-01'::TIMESTAMP AS start_time
  , '2018-01-28 14:00'::TIMESTAMP AS end_time_phase1
  , '2018-04-15 13:30'::TIMESTAMP AS end_time_phase2
  , '2018-06-03 12:00'::TIMESTAMP AS end_time_phase3
  , '2018-08-04 14:00'::TIMESTAMP AS end_time_phase4
)

, account_links_log_phase1 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_auth
  FROM (
    SELECT gd.*, oa.time, oa.user_id
    FROM tahoe.oauth_authorize AS oa
    RIGHT JOIN game_devs AS gd ON oa.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase1)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase1 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_unlinks_log_phase1 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_deauth
  FROM (
    SELECT gd.*, od.time, od.user_id
    FROM tahoe.oauth_deauthorize AS od
    RIGHT JOIN game_devs AS gd ON od.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase1)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase1 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_logs_phase1 AS (
  SELECT link.*, unlink.last_time_deauth
  , CASE WHEN link.last_time_auth > unlink.last_time_deauth THEN 1
  WHEN link.last_time_auth IS NOT NULL AND unlink.last_time_deauth IS NULL THEN 1
  ELSE 0 END AS flag_is_linked_phase1
  FROM account_links_log_phase1 AS link
  LEFT JOIN account_unlinks_log_phase1 AS unlink ON link.client_id = unlink.client_id
    AND link.user_id = unlink.user_id
)









, account_links_log_phase2 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_auth
  FROM (
    SELECT gd.*, oa.time, oa.user_id
    FROM tahoe.oauth_authorize AS oa
    RIGHT JOIN game_devs AS gd ON oa.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase2)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase2 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_unlinks_log_phase2 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_deauth
  FROM (
    SELECT gd.*, od.time, od.user_id
    FROM tahoe.oauth_deauthorize AS od
    RIGHT JOIN game_devs AS gd ON od.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase2)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase2 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_logs_phase2 AS (
  SELECT link.*, unlink.last_time_deauth
  , CASE WHEN link.last_time_auth > unlink.last_time_deauth THEN 1
  WHEN link.last_time_auth IS NOT NULL AND unlink.last_time_deauth IS NULL THEN 1
  ELSE 0 END AS flag_is_linked_phase2
  FROM account_links_log_phase2 AS link
  LEFT JOIN account_unlinks_log_phase2 AS unlink ON link.client_id = unlink.client_id
    AND link.user_id = unlink.user_id
)












, account_links_log_phase3 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_auth
  FROM (
    SELECT gd.*, oa.time, oa.user_id
    FROM tahoe.oauth_authorize AS oa
    RIGHT JOIN game_devs AS gd ON oa.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase3)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase3 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_unlinks_log_phase3 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_deauth
  FROM (
    SELECT gd.*, od.time, od.user_id
    FROM tahoe.oauth_deauthorize AS od
    RIGHT JOIN game_devs AS gd ON od.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase3)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase3 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_logs_phase3 AS (
  SELECT link.*, unlink.last_time_deauth
  , CASE WHEN link.last_time_auth > unlink.last_time_deauth THEN 1
  WHEN link.last_time_auth IS NOT NULL AND unlink.last_time_deauth IS NULL THEN 1
  ELSE 0 END AS flag_is_linked_phase3
  FROM account_links_log_phase3 AS link
  LEFT JOIN account_unlinks_log_phase3 AS unlink ON link.client_id = unlink.client_id
    AND link.user_id = unlink.user_id
)










, account_links_log_phase4 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_auth
  FROM (
    SELECT gd.*, oa.time, oa.user_id
    FROM tahoe.oauth_authorize AS oa
    RIGHT JOIN game_devs AS gd ON oa.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase4)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase4 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_unlinks_log_phase4 AS (
  SELECT client_id, user_id, MAX(time) AS last_time_deauth
  FROM (
    SELECT gd.*, od.time, od.user_id
    FROM tahoe.oauth_deauthorize AS od
    RIGHT JOIN game_devs AS gd ON od.client_id = gd.client_id
    WHERE "date">=(SELECT start_time FROM the_constants)
      AND "date"< (SELECT DATE_TRUNC('day', end_time_phase4)+INTERVAL '1 day' FROM the_constants)
      AND "time"< (SELECT end_time_phase4 FROM the_constants)
  )
  GROUP BY 1,2
)

, account_logs_phase4 AS (
  SELECT link.*, unlink.last_time_deauth
  , CASE WHEN link.last_time_auth > unlink.last_time_deauth THEN 1
  WHEN link.last_time_auth IS NOT NULL AND unlink.last_time_deauth IS NULL THEN 1
  ELSE 0 END AS flag_is_linked_phase4
  FROM account_links_log_phase4 AS link
  LEFT JOIN account_unlinks_log_phase4 AS unlink ON link.client_id = unlink.client_id
    AND link.user_id = unlink.user_id
)













, full_join_1 AS (
  SELECT NVL(p1.user_id, p2.user_id) AS user_id
    , NVL(p1.flag_is_linked_phase1,0) AS flag_is_linked_phase1
    , NVL(p2.flag_is_linked_phase2,0) AS flag_is_linked_phase2
  FROM account_logs_phase1 AS p1
  FULL OUTER JOIN account_logs_phase2 AS p2 ON p1.user_id=p2.user_id
)

, full_join_2 AS (
  SELECT full_join_1.*
    , NVL(p3.flag_is_linked_phase3,0) AS flag_is_linked_phase3
  FROM full_join_1
  FULL OUTER JOIN account_logs_phase3 AS p3 ON full_join_1.user_id=p3.user_id
)

, full_join_3 AS (
  SELECT full_join_2.*
    , NVL(p4.flag_is_linked_phase4,0) AS flag_is_linked_phase4
  FROM full_join_2
  FULL OUTER JOIN account_logs_phase4 AS p4 ON full_join_2.user_id=p4.user_id
)

, final_data AS (
  SELECT * FROM full_join_3 WHERE user_id IS NOT NULL
)


SELECT * FROM final_data

-- SELECT
-- flag_is_linked_phase1
-- , flag_is_linked_phase2
-- , flag_is_linked_phase3
-- , flag_is_linked_phase4
-- , COUNT(DISTINCT user_id) AS users, COUNT(1) AS rows
-- FROM final_data
-- GROUP BY 1,2,3,4
-- ORDER BY 1,2,3,4
