--there are 4 "phases" of the fifa drops campaigns
--phase 1= 2018-01-26 04:00 to 2018-01-28 14:00
--phase 2= 2018-04-13 04:00 to 2018-04-15 13:30
--phase 3= 2018-05-28 05:00 to 2018-06-03 12:00
--phase 4= 2018-08-02 03:00 to 2018-08-04 14:00

--get mw during the timestamps of the drops campaign and the period immediately after
--get fifa mw and non fifa mw
--only look at the user_id in analysis.dsds_310_fifa_users_pre_drops_start

CREATE TABLE analysis.dsds_310_fifa_campaign_mw AS

WITH
the_constants AS (
  SELECT
    'FIFA 18' AS game
    , '2018-01-26 04:00:00' AS start_time -- start looking on first campaignn phase
    , '2018-11-27 04:00:00' AS end_time --look until recent nov end date
    , '2018-01-26 04:00:00' AS phase1_start, '2018-01-28 14:00:00' AS phase1_end
    , '2018-04-13 04:00:00' AS phase2_start, '2018-04-15 13:30:00' AS phase2_end
    , '2018-05-28 05:00:00' AS phase3_start, '2018-06-03 12:00:00' AS phase3_end
    , '2018-08-02 03:00:00' AS phase4_start, '2018-08-04 14:00:00' AS phase4_end
)

, mw_log AS (
  SELECT "time", user_id, game
    , CASE WHEN game=(SELECT game FROM the_constants) THEN 1 ELSE 0 END AS flag_is_fifa
    , CASE
      WHEN "time">=(SELECT phase1_start FROM the_constants) AND "time"<(SELECT phase1_end FROM the_constants) THEN '1a_during_phase1'
      WHEN "time">=(SELECT phase1_end FROM the_constants) AND "time"<(SELECT phase2_start FROM the_constants) THEN '1b_post_phase1'
      WHEN "time">=(SELECT phase2_start FROM the_constants) AND "time"<(SELECT phase2_end FROM the_constants) THEN '2a_during_phase2'
      WHEN "time">=(SELECT phase2_end FROM the_constants) AND "time"<(SELECT phase3_start FROM the_constants) THEN '2b_post_phase2'
      WHEN "time">=(SELECT phase3_start FROM the_constants) AND "time"<(SELECT phase3_end FROM the_constants) THEN '3a_during_phase3'
      WHEN "time">=(SELECT phase3_end FROM the_constants) AND "time"<(SELECT phase4_start FROM the_constants) THEN '3b_post_phase3'
      WHEN "time">=(SELECT phase4_start FROM the_constants) AND "time"<(SELECT phase4_end FROM the_constants) THEN '4a_during_phase4'
      WHEN "time">=(SELECT phase4_end FROM the_constants) AND "time"<(SELECT end_time FROM the_constants) THEN '4b_post_phase4'
      ELSE 'ERROR' END AS the_campaign_phase
    , 1 AS one_min_watch
  FROM logs."minute-watched"
  WHERE user_id IN (SELECT user_id FROM analysis.dsds_310_fifa_users_pre_drops_start) -- only look at the user_id in analysis.dsds_310_fifa_users_pre_drops_start
    AND (live = TRUE OR live IS NULL) --live minutes only
    AND "time">=(SELECT start_time FROM the_constants)
    AND "time"<=(SELECT end_time FROM the_constants)
)

SELECT * FROM mw_log
