WITH
the_constants_drops AS (
  SELECT start_time, end_time, channel_id::BIGINT, game::VARCHAR, start_time::DATE AS start_date, end_time::DATE AS end_date
    , regexp_replace(lower(game::VARCHAR),'([^a-z.])','') as game_flattened
  FROM tahoe_analysis.dsds_351_drops_history
)

, viewers_log AS (
  SELECT *
  FROM (
    SELECT "time", device_id, user_id, channel_id, game, regexp_replace(lower(game::VARCHAR),'([^a-z.])','') as game_flattened
    FROM tahoe."video-play"
    WHERE
          DATE>=(SELECT MIN(start_date) FROM the_constants_drops)
      AND DATE<=(SELECT MAX(end_date) FROM the_constants_drops)
      AND channel_id IN (SELECT channel_id FROM the_constants_drops GROUP BY 1)
      AND live = TRUE
      AND device_id NOT IN ('0', '0000000000000000', '00000000000000000000000000000000', '(null)')
      AND game IS NOT NULL
  )
  WHERE game_flattened IN (SELECT game_flattened FROM the_constants_drops GROUP BY 1)
)


, drops_viewers_log AS (
  SELECT base.*
  FROM viewers_log AS base
  RIGHT JOIN the_constants_drops AS drops
    ON drops.start_time<=base.time AND base.time<=drops.end_time
    AND drops.channel_id = base.channel_id
    AND drops.game_flattened = base.game_flattened
)



, viewers_log_time_bound AS (
  SELECT *
  FROM (
    SELECT device_id, user_id, game, FIRST_VALUE("time") OVER (PARTITION BY game, device_id) AS first_drops_view_time
    FROM drops_viewers_log
  )
  GROUP BY 1,2,3,4
)


-- , pageview_log AS (
--   SELECT "time", device_id, user_id
--   FROM tahoe.pageview
--   WHERE
--         DATE>=(SELECT MIN(start_date) FROM the_constants_drops)
--     AND DATE<=(SELECT MAX(end_date)+ INTERVAL '5 days' FROM the_constants_drops)
--     AND device_id IN (SELECT device_id FROM drops_viewers_log GROUP BY 1)
--     AND user_id IS NOT NULL --dont need the records of null user_id since that means they aren't logged in
--   GROUP BY 1,2,3
-- )





, daily_viewers AS (
  SELECT day, device_id, user_id, viewer_id
  FROM rollups.daily_viewers
  WHERE
        day>=(SELECT MIN(start_date) FROM the_constants_drops)
    AND day<=(SELECT MAX(end_date+ INTERVAL '5 days') FROM the_constants_drops)
)

, viewers_to_login_join AS (
  SELECT base.device_id, base.user_id, base.game, base.first_drops_view_time
    , dv.user_id AS dv_user_id, dv.viewer_id AS dv_viewer_id
  FROM viewers_log_time_bound AS base
  LEFT JOIN daily_viewers AS dv
    ON base.device_id = dv.device_id
    AND base.first_drops_view_time + INTERVAL '5 days'>=dv.day
)
, viewers_to_login_join2 AS (
  SELECT first_drops_view_time, game, device_id, user_id, dv_user_id, dv_viewer_id
    , CASE
      WHEN user_id IS NOT NULL THEN 1 --they are already logged in to begin with
      WHEN dv_viewer_id = dv_user_id THEN 1 --they got assgined a viewer_id that is a logged in user_id
      ELSE 0
    END AS flag_convert_to_login
  FROM viewers_to_login_join
)

, final_data AS (
  SELECT device_id, user_id, game
    , MAX(first_drops_view_time) AS first_drops_view_time
    , MAX(dv_user_id) AS dv_user_id
    , MAX(dv_viewer_id) AS dv_viewer_id
    , MAX(flag_convert_to_login) AS flag_convert_to_login
  FROM viewers_to_login_join2
  GROUP BY 1,2,3
)

SELECT game, SUM(flag_convert_to_login) AS num_login_viewers, COUNT(1) AS total_viewers
  , SUM(flag_convert_to_login::FLOAT)/COUNT(1::FLOAT) AS pct_login_ratio
FROM final_data
GROUP BY 1
