--
-- CREATE TEMP TABLE the_dates_table AS (
--   SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS the_day_we_run_script
-- );
--



  WITH
  the_parameter_input AS (
    SELECT DATEADD(  day, -1, (SELECT the_day_we_run_script FROM the_dates_table)  ) AS the_day_we_run_script
    --SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS the_day_we_run_script
  )

  -- take channels that have streamed at least once from 2015-01-01 onward
  , eligible_channels AS (
    SELECT channel_id, MIN(date) AS min_ccu_date
    FROM tahoe.channel_concurrents
    WHERE "date" >= '2015-01-01 00:00:00' AND "date"<(SELECT the_day_we_run_script FROM the_parameter_input)
    GROUP BY 1
  )

  --returns a list of channel_id that we should run the data for
  --it will return the channel_id if they ever streamed since 2015-01-01
  , day_channel_matrix AS (
    SELECT *
      , DATEDIFF ( second, start_time_rolling_1, end_time_rolling_1 )::FLOAT/86400 AS num_days_rolling_1 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_7, end_time_rolling_7 )::FLOAT/86400 AS num_days_rolling_7 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_14, end_time_rolling_14 )::FLOAT/86400 AS num_days_rolling_14 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_30, end_time_rolling_30 )::FLOAT/86400 AS num_days_rolling_30 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_60, end_time_rolling_60 )::FLOAT/86400 AS num_days_rolling_60 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_90, end_time_rolling_90 )::FLOAT/86400 AS num_days_rolling_90 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_180, end_time_rolling_180 )::FLOAT/86400 AS num_days_rolling_180 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_360, end_time_rolling_360 )::FLOAT/86400 AS num_days_rolling_360 --this is used just to verify that we are taking correct snapshot
    FROM (
      SELECT d."date" AS day
        , ec.channel_id
        , (d."date" - INTERVAL '0 days') AS start_time_rolling_1, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_1
        , (d."date" - INTERVAL '6 days') AS start_time_rolling_7, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_7
        , (d."date" - INTERVAL '13 days') AS start_time_rolling_14, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_14
        , (d."date" - INTERVAL '29 days') AS start_time_rolling_30, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_30
        , (d."date" - INTERVAL '59 days') AS start_time_rolling_60, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_60
        , (d."date" - INTERVAL '89 days') AS start_time_rolling_90, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_90
        , (d."date" - INTERVAL '179 days') AS start_time_rolling_180, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_180
        , (d."date" - INTERVAL '359 days') AS start_time_rolling_360, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_360
      FROM eligible_channels ec
      INNER JOIN metadata."date" d ON d."date" >= ec.min_ccu_date
      WHERE d."date" >= (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input)
      AND   d."date" < (SELECT the_day_we_run_script FROM the_parameter_input)--DATE_TRUNC('day',SYSDATE)
    )
  )



    --get all the ccu logs for all eligible_channels during the rolling 360 time period and add flags for other time periods
    , ccu_log AS (
      SELECT *
        , CASE WHEN start_time_rolling_1<="time" AND "time"<=end_time_rolling_1 THEN TRUE ELSE FALSE END AS flag_is_rolling_1
        , CASE WHEN start_time_rolling_7<="time" AND "time"<=end_time_rolling_7 THEN TRUE ELSE FALSE END AS flag_is_rolling_7
        , CASE WHEN start_time_rolling_14<="time" AND "time"<=end_time_rolling_14 THEN TRUE ELSE FALSE END AS flag_is_rolling_14
        , CASE WHEN start_time_rolling_30<="time" AND "time"<=end_time_rolling_30 THEN TRUE ELSE FALSE END AS flag_is_rolling_30
        , CASE WHEN start_time_rolling_60<="time" AND "time"<=end_time_rolling_60 THEN TRUE ELSE FALSE END AS flag_is_rolling_60
        , CASE WHEN start_time_rolling_90<="time" AND "time"<=end_time_rolling_90 THEN TRUE ELSE FALSE END AS flag_is_rolling_90
        , CASE WHEN start_time_rolling_180<="time" AND "time"<=end_time_rolling_180 THEN TRUE ELSE FALSE END AS flag_is_rolling_180
        , CASE WHEN start_time_rolling_360<="time" AND "time"<=end_time_rolling_360 THEN TRUE ELSE FALSE END AS flag_is_rolling_360
      FROM (
        SELECT ccu."time", dcm.*, ccu.total
        FROM logs.channel_concurrents AS ccu
        RIGHT JOIN day_channel_matrix AS dcm
          ON ccu.channel_id = dcm.channel_id
          AND dcm.start_time_rolling_360 <= ccu.time AND ccu.time<=dcm.end_time_rolling_360
      )
    )


      , ccu_per_day_log AS (
        SELECT DATE_TRUNC('day', "time") AS ccu_log_date, day AS the_date, channel_id
        , flag_is_rolling_1, flag_is_rolling_7, flag_is_rolling_14, flag_is_rolling_30, flag_is_rolling_60, flag_is_rolling_90, flag_is_rolling_180, flag_is_rolling_360
        , MAX(CASE WHEN flag_is_rolling_1 THEN 1 ELSE 0 END) AS indicator_is_rolling_1, MAX(CASE WHEN flag_is_rolling_7 THEN 1 ELSE 0 END) AS indicator_is_rolling_7
        , MAX(CASE WHEN flag_is_rolling_14 THEN 1 ELSE 0 END) AS indicator_is_rolling_14, MAX(CASE WHEN flag_is_rolling_30 THEN 1 ELSE 0 END) AS indicator_is_rolling_30
        , MAX(CASE WHEN flag_is_rolling_60 THEN 1 ELSE 0 END) AS indicator_is_rolling_60, MAX(CASE WHEN flag_is_rolling_90 THEN 1 ELSE 0 END) AS indicator_is_rolling_90
        , MAX(CASE WHEN flag_is_rolling_180 THEN 1 ELSE 0 END) AS indicator_is_rolling_180, MAX(CASE WHEN flag_is_rolling_360 THEN 1 ELSE 0 END) AS indicator_is_rolling_360
        -- , MAX(1) AS indicator_stream_this_day, sum(1) as mb
        FROM ccu_log
        GROUP BY 1,2,3,4,5,6,7,8,9,10,11
      )

      --get the per the_date per channel_id aggregated metrics on how many days streamed the past X days
      , ccu_aggregated_1 AS (
        SELECT the_date, channel_id
          , SUM(indicator_is_rolling_1) AS total_days_streamed_rolling_1, SUM(indicator_is_rolling_1::FLOAT)/1 AS pct_days_streamed_rolling_1
          , SUM(indicator_is_rolling_7) AS total_days_streamed_rolling_7, SUM(indicator_is_rolling_7::FLOAT)/7 AS pct_days_streamed_rolling_7
          , SUM(indicator_is_rolling_14) AS total_days_streamed_rolling_14, SUM(indicator_is_rolling_14::FLOAT)/14 AS pct_days_streamed_rolling_14
          , SUM(indicator_is_rolling_30) AS total_days_streamed_rolling_30, SUM(indicator_is_rolling_30::FLOAT)/30 AS pct_days_streamed_rolling_30
          , SUM(indicator_is_rolling_60) AS total_days_streamed_rolling_60, SUM(indicator_is_rolling_60::FLOAT)/60 AS pct_days_streamed_rolling_60
          , SUM(indicator_is_rolling_90) AS total_days_streamed_rolling_90, SUM(indicator_is_rolling_90::FLOAT)/90 AS pct_days_streamed_rolling_90
          , SUM(indicator_is_rolling_180) AS total_days_streamed_rolling_180, SUM(indicator_is_rolling_180::FLOAT)/180 AS pct_days_streamed_rolling_180
          , SUM(indicator_is_rolling_360) AS total_days_streamed_rolling_360, SUM(indicator_is_rolling_360::FLOAT)/360 AS pct_days_streamed_rolling_360
        FROM ccu_per_day_log
        GROUP BY 1,2
      )


        --get the per the_date per channel_id aggregated ccu and mb stats
        , ccu_aggregated_2 AS (
          SELECT the_date, channel_id
            , avg_ccu_rolling_1, NVL(mins_broadcast_rolling_1,0) AS mins_broadcast_rolling_1, NVL(avg_mb_per_day_rolling_1,0) AS avg_mb_per_day_rolling_1
            , avg_ccu_rolling_7, NVL(mins_broadcast_rolling_7,0) AS mins_broadcast_rolling_7, NVL(avg_mb_per_day_rolling_7,0) AS avg_mb_per_day_rolling_7
            , avg_ccu_rolling_14, NVL(mins_broadcast_rolling_14,0) AS mins_broadcast_rolling_14, NVL(avg_mb_per_day_rolling_14,0) AS avg_mb_per_day_rolling_14
            , avg_ccu_rolling_30, NVL(mins_broadcast_rolling_30,0) AS mins_broadcast_rolling_30, NVL(avg_mb_per_day_rolling_30,0) AS avg_mb_per_day_rolling_30
            , avg_ccu_rolling_60, NVL(mins_broadcast_rolling_60,0) AS mins_broadcast_rolling_60, NVL(avg_mb_per_day_rolling_60,0) AS avg_mb_per_day_rolling_60
            , avg_ccu_rolling_90, NVL(mins_broadcast_rolling_90,0) AS mins_broadcast_rolling_90, NVL(avg_mb_per_day_rolling_90,0) AS avg_mb_per_day_rolling_90
            , avg_ccu_rolling_180, NVL(mins_broadcast_rolling_180,0) AS mins_broadcast_rolling_180, NVL(avg_mb_per_day_rolling_180,0) AS avg_mb_per_day_rolling_180
            , avg_ccu_rolling_360, NVL(mins_broadcast_rolling_360,0) AS mins_broadcast_rolling_360, NVL(avg_mb_per_day_rolling_360,0) AS avg_mb_per_day_rolling_360
          FROM (
            SELECT day AS the_date, channel_id

            , AVG(CASE WHEN flag_is_rolling_1 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_1
            , COUNT(CASE WHEN flag_is_rolling_1 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_1
            , COUNT(CASE WHEN flag_is_rolling_1 THEN 1 ELSE NULL END)::FLOAT/7 AS avg_mb_per_day_rolling_1

            , AVG(CASE WHEN flag_is_rolling_7 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_7
            , COUNT(CASE WHEN flag_is_rolling_7 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_7
            , COUNT(CASE WHEN flag_is_rolling_7 THEN 1 ELSE NULL END)::FLOAT/7 AS avg_mb_per_day_rolling_7

            , AVG(CASE WHEN flag_is_rolling_14 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_14
            , COUNT(CASE WHEN flag_is_rolling_14 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_14
            , COUNT(CASE WHEN flag_is_rolling_14 THEN 1 ELSE NULL END)::FLOAT/14 AS avg_mb_per_day_rolling_14

            , AVG(CASE WHEN flag_is_rolling_30 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_30
            , COUNT(CASE WHEN flag_is_rolling_30 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_30
            , COUNT(CASE WHEN flag_is_rolling_30 THEN 1 ELSE NULL END)::FLOAT/30 AS avg_mb_per_day_rolling_30

            , AVG(CASE WHEN flag_is_rolling_60 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_60
            , COUNT(CASE WHEN flag_is_rolling_60 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_60
            , COUNT(CASE WHEN flag_is_rolling_60 THEN 1 ELSE NULL END)::FLOAT/60 AS avg_mb_per_day_rolling_60

            , AVG(CASE WHEN flag_is_rolling_90 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_90
            , COUNT(CASE WHEN flag_is_rolling_90 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_90
            , COUNT(CASE WHEN flag_is_rolling_90 THEN 1 ELSE NULL END)::FLOAT/90 AS avg_mb_per_day_rolling_90

            , AVG(CASE WHEN flag_is_rolling_180 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_180
            , COUNT(CASE WHEN flag_is_rolling_180 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_180
            , COUNT(CASE WHEN flag_is_rolling_180 THEN 1 ELSE NULL END)::FLOAT/180 AS avg_mb_per_day_rolling_180

            , AVG(CASE WHEN flag_is_rolling_360 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_360
            , COUNT(CASE WHEN flag_is_rolling_360 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_360
            , COUNT(CASE WHEN flag_is_rolling_360 THEN 1 ELSE NULL END)::FLOAT/360 AS avg_mb_per_day_rolling_360

            FROM ccu_log
            GROUP BY 1,2
          )
        )


          -- are they a partner or affiliate at the the_date date?
          , rollup_partner_affiliate AS (
            SELECT day AS the_date, channel_id, is_partner, is_affiliate
            FROM rollups.affiliates_partners_daily_channel_summary
            WHERE day = (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input)
            GROUP BY 1,2,3,4 --use GROUP BY just in case there are duplicate records
          )
          , meta_partner_affiliate AS (
            SELECT the_date, channel_id
            , CASE
                WHEN is_partner =TRUE THEN 'partner'
                WHEN is_affiliate = TRUE THEN 'affiliate'
                ELSE 'not_partner_affiliate'
              END AS channel_type
            FROM rollup_partner_affiliate
          )


            -- return a row per channel name along with the date they were added and removed to be counted as a "premium" channel
            -- see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit
            , premium_channel_name as (
              select
                channel
                , min(date_added) as date_added
                , max(date_removed) as date_removed
              from (
                select
                  channel
                  , case when date_added > '2018-10-01'::date then date_added else to_date('01/01/2000', 'MM/DD/YYYY') end as date_added
                  , date_removed
                from (
                  select
                    lower(channelname) as channel
                    , to_date(case when sheet_addition_date > '' then sheet_addition_date else '01/01/2000' end, 'MM/DD/YYYY') as date_added
                    , to_date('9999-12-31 00:00:00', 'YYYY-MM-DD HH24:MI:SS') as date_removed
                  from analysis.esports_general_channels
                  where "type" <> 'UGC Esports'
                  group by 1,2,3
                )
                union
                select
                  channel
                  , to_date(case when date_added::text > '' then date_added else '2000-01-01 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_added
                  , to_date(case when date_removed > '' then date_removed else '9999-12-31 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_removed
                from analysis.png_whitelist
                group by 1,2,3
              )
              group by 1
            )

            , meta_premium_channel AS (
              SELECT MIN(channel) AS channel, channel_id, MIN(date_added) AS date_added, MAX(date_removed) AS date_removed
              FROM (
                SELECT base.channel, map.user_id AS channel_id, base.date_added, base.date_removed
                FROM premium_channel_name AS base
                LEFT JOIN analysis.user_id_login_mapping_all AS map ON base.channel = map.login
              )
              WHERE channel_id IS NOT NULL
              GROUP BY channel_id
            )
            , the_data_1 AS (
              SELECT the_date, channel_id
                , total_days_streamed_rolling_1, pct_days_streamed_rolling_1
                , total_days_streamed_rolling_7, pct_days_streamed_rolling_7
                , total_days_streamed_rolling_14, pct_days_streamed_rolling_14
                , total_days_streamed_rolling_30, pct_days_streamed_rolling_30
                , total_days_streamed_rolling_60, pct_days_streamed_rolling_60
                , total_days_streamed_rolling_90, pct_days_streamed_rolling_90
                , total_days_streamed_rolling_180, pct_days_streamed_rolling_180
                , total_days_streamed_rolling_360, pct_days_streamed_rolling_360
              FROM ccu_aggregated_1
            )


              --take the_data_rolling_30 as the "default" metric for "tier" and "active streamer status"
              --this is the opinion from DX team on the standard to use
              , the_data_2 AS (
                SELECT base.the_date, base.channel_id, su.login AS channel
                  , NVL(mpa.channel_type,'not_partner_affiliate') AS channel_type
                  , base.avg_ccu_rolling_1, base.mins_broadcast_rolling_1, base.avg_mb_per_day_rolling_1
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_1 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_1 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_1 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_1 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_1 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 1 DAYS'
                    END AS tier_rolling_1 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_1>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_1
                  , base.avg_ccu_rolling_7, base.mins_broadcast_rolling_7, base.avg_mb_per_day_rolling_7
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_7 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_7 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_7 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_7 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_7 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 7 DAYS'
                    END AS tier_rolling_7 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_7>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_7
                  , base.avg_ccu_rolling_14, base.mins_broadcast_rolling_14, base.avg_mb_per_day_rolling_14
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_14 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_14 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_14 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_14 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_14 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 14 DAYS'
                    END AS tier_rolling_14 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_14>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_14
                  , base.avg_ccu_rolling_30, base.mins_broadcast_rolling_30, base.avg_mb_per_day_rolling_30
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_30 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_30 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_30 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_30 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_30 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 30 DAYS'
                    END AS tier_rolling_30 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_30>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_30
                  , base.avg_ccu_rolling_60, base.mins_broadcast_rolling_60, base.avg_mb_per_day_rolling_60
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_60 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_60 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_60 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_60 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_60 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 60 DAYS'
                    END AS tier_rolling_60 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_60>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_60
                  , base.avg_ccu_rolling_90, base.mins_broadcast_rolling_90, base.avg_mb_per_day_rolling_90
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_90 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_90 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_90 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_90 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_90 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 90 DAYS'
                    END AS tier_rolling_90 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_90>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_90
                  , base.avg_ccu_rolling_180, base.mins_broadcast_rolling_180, base.avg_mb_per_day_rolling_180
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_180 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_180 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_180 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_180 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_180 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 180 DAYS'
                    END AS tier_rolling_180 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_180>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_180
                  , base.avg_ccu_rolling_360, base.mins_broadcast_rolling_360, base.avg_mb_per_day_rolling_360
                  , CASE
                      WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
                      WHEN base.avg_ccu_rolling_360 <= 2 THEN 'T0: 0-2 ccv'
                      WHEN base.avg_ccu_rolling_360 <= 10 THEN 'T1: 3-10 ccv'
                      WHEN base.avg_ccu_rolling_360 <= 100 THEN  'T2: 11-100 ccv'
                      WHEN base.avg_ccu_rolling_360 <= 4000 THEN  'T3: 101-4000 ccv'
                      WHEN base.avg_ccu_rolling_360 > 4000 THEN  'T4: 4001+ ccv'
                      ELSE 'NULL: NOT STREAM LAST 360 DAYS'
                    END AS tier_rolling_360 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
                  , CASE
                      WHEN avg_mb_per_day_rolling_360>=10 THEN 'active_streamer'
                      ELSE 'not_active_streamer'
                    END AS active_streamer_status_rolling_360
                FROM ccu_aggregated_2 AS base
                LEFT JOIN meta_premium_channel AS mpc ON
                  base.channel_id = mpc.channel_id
                  AND mpc.date_added <= base.the_date
                  AND base.the_date < mpc.date_removed
                LEFT JOIN meta_partner_affiliate AS mpa ON
                  base.the_date = mpa.the_date
                  AND base.channel_id = mpa.channel_id
                LEFT JOIN db_snapshots.users AS su ON base.channel_id = su.id
              )


                , final_data AS (
                  SELECT base.the_date, base.channel_id, base.channel, channel_type, tier_rolling_30 AS tier, active_streamer_status_rolling_30 AS active_streamer_status
                    , avg_ccu_rolling_1, mins_broadcast_rolling_1, avg_mb_per_day_rolling_1, tier_rolling_1, active_streamer_status_rolling_1, total_days_streamed_rolling_1, pct_days_streamed_rolling_1
                    , avg_ccu_rolling_7, mins_broadcast_rolling_7, avg_mb_per_day_rolling_7, tier_rolling_7, active_streamer_status_rolling_7, total_days_streamed_rolling_7, pct_days_streamed_rolling_7
                    , avg_ccu_rolling_14, mins_broadcast_rolling_14, avg_mb_per_day_rolling_14, tier_rolling_14, active_streamer_status_rolling_14, total_days_streamed_rolling_14, pct_days_streamed_rolling_14
                    , avg_ccu_rolling_30, mins_broadcast_rolling_30, avg_mb_per_day_rolling_30, tier_rolling_30, active_streamer_status_rolling_30, total_days_streamed_rolling_30, pct_days_streamed_rolling_30
                    , avg_ccu_rolling_60, mins_broadcast_rolling_60, avg_mb_per_day_rolling_60, tier_rolling_60, active_streamer_status_rolling_60, total_days_streamed_rolling_60, pct_days_streamed_rolling_60
                    , avg_ccu_rolling_90, mins_broadcast_rolling_90, avg_mb_per_day_rolling_90, tier_rolling_90, active_streamer_status_rolling_90, total_days_streamed_rolling_90, pct_days_streamed_rolling_90
                    , avg_ccu_rolling_180, mins_broadcast_rolling_180, avg_mb_per_day_rolling_180, tier_rolling_180, active_streamer_status_rolling_180, total_days_streamed_rolling_180, pct_days_streamed_rolling_180
                    , avg_ccu_rolling_360, mins_broadcast_rolling_360, avg_mb_per_day_rolling_360, tier_rolling_360, active_streamer_status_rolling_360, total_days_streamed_rolling_360, pct_days_streamed_rolling_360
                  FROM the_data_2 AS base
                  LEFT JOIN the_data_1 AS other ON base.the_date = other.the_date AND base.channel_id = other.channel_id
                  --LEFT JOIN the_data_rolling_30 AS roll30 ON base.the_date = roll30.the_date AND base.channel_id = roll30.channel_id
                )
                , the_final_data AS (
                SELECT * FROM final_data
                GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62
                )
      SELECT * FROM the_final_data WHERE channel_id = 30351034 ORDER BY the_date



SELECT * FROM (
  SELECT channel_id, the_date, COUNT(1) AS instances FROM the_final_data GROUP BY 1,2
) WHERE instances>1;


SELECT *
FROM db_snapshots.users WHERE id = 182176897
