--  https://docs.google.com/document/d/1CDHO8IpiNGQa-vN1swpxwCRVitstk8ZxrML4tbPnJvQ/edit?ts=5c2fc558#
-- new tiers here: https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5

-- Total active streamer market size
-- T3-T5 active streamer market size
-- T3-T5 active streamer w/ extension impression
-- T3-T5 active streamer net installs
-- T3-T5 active streamer net activations
-- T3-T5 Coverage of MW
-- T3-T5 net activations of “high potential” tools extensions or game developer extensions
-- T3-T5 coverage of MW of “high potential” tools extensions or game developer extensions

WITH

the_constants_timeframe AS (
  SELECT '2019-01-01'::TIMESTAMP AS the_run_report_month
)

, premium_channel_name as (
  select
    channel
    , min(date_added) as date_added
    , max(date_removed) as date_removed
  from (
    select
      channel
      , case when date_added > '2018-10-01'::date then date_added else to_date('01/01/2000', 'MM/DD/YYYY') end as date_added
      , date_removed
    from (
      select
        lower(channelname) as channel
        , to_date(case when sheet_addition_date > '' then sheet_addition_date else '01/01/2000' end, 'MM/DD/YYYY') as date_added
        , to_date('9999-12-31 00:00:00', 'YYYY-MM-DD HH24:MI:SS') as date_removed
      from analysis.esports_general_channels
      where "type" <> 'UGC Esports'
      group by 1,2,3
    )
    union
    select
      channel
      , to_date(case when date_added::text > '' then date_added else '2000-01-01 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_added
      , to_date(case when date_removed > '' then date_removed else '9999-12-31 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_removed
    from analysis.png_whitelist
    group by 1,2,3
  )
  group by 1
)

, premium_channel AS (
  SELECT base.channel, map.user_id AS channel_id, base.date_added, base.date_removed
  FROM premium_channel_name AS base
  LEFT JOIN analysis.user_id_login_mapping_all AS map ON base.channel = map.login
)
--   WITH
--   the_constants_time AS (
--     SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  ) AS the_date
--       , DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  ) - INTERVAL '29 days' AS start_time_rolling_30 --Greater Than Equal To (>=) this timestamp
--       , DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))  ) + INTERVAL '1 days' - INTERVAL '1 second'  AS end_time_rolling_30 -- Less Than Equal To (<=) this timestamp
--   )

, ccu_log AS (
  SELECT ccu.channel_id, ccu.total, premium.channel_id AS premium_channel_id
  FROM logs.channel_concurrents AS ccu
  LEFT JOIN premium_channel AS premium
      on ccu.channel_id = premium.channel_id
      And ccu.time >= premium.date_added
      and ccu.time < premium.date_removed
  WHERE
        ccu.time>=(SELECT the_run_report_month - INTERVAL '29 days' FROM the_constants_timeframe)
    AND ccu.time<=(SELECT the_run_report_month - INTERVAL '1 second' FROM the_constants_timeframe)
)
, ccu_aggregated AS (
  SELECT channel_id, premium_channel_id
  , AVG(total::FLOAT) AS avg_ccu_rolling_30, COUNT(1) AS mins_broadcast
  --SELECT DATE_DIFF('minute', '2017-09-01 00:00:00', '2017-09-30 23:59:59')::FLOAT/60/24 ===> 29.999 days ===> divide by 30 days
  , COUNT(1)::FLOAT/30 AS avg_mb_per_day_rolling_30
  FROM ccu_log
  GROUP BY 1,2
)

, channel_tier_active_status AS (
  SELECT channel_id, premium_channel_id, avg_ccu_rolling_30, mins_broadcast, avg_mb_per_day_rolling_30
    , case
        when premium_channel_id is not null then 'T5: premium'
        when avg_ccu_rolling_30 <= 2 then 'T0: 0-2 CCU'
        when avg_ccu_rolling_30 <= 10 then 'T1: 3-10 CCU'
        when avg_ccu_rolling_30 <= 100 then 'T2: 11-100 CCU'
        when avg_ccu_rolling_30 <= 4000 then 'T3: 101-4000 CCU'
        when avg_ccu_rolling_30 > 4000 then 'T4: 4001+ CCU'
        else 'NULL_NO_STREAM_LAST_30_DAYS'
      END as tier
    , CASE
        WHEN avg_mb_per_day_rolling_30>=10 THEN 'active_streamer'
        ELSE 'not_active_streamer'
      END AS active_streamer_status
  from ccu_aggregated
)

, all_active_streamers AS (
  SELECT * FROM channel_tier_active_status
  WHERE active_streamer_status='active_streamer'
)
, t3_5_active_streamers AS (
  SELECT * FROM all_active_streamers
  WHERE tier IN ('T3: 101-4000 CCU', 'T4: 4001+ CCU', 'T5: premium')
)



-- Total active streamer market size
, funnel1 AS (
  SELECT '1. Total active streamer market size' AS the_funnel, COUNT(DISTINCT channel_id) AS channels, 0 AS net_metric
  FROM all_active_streamers
)
-- T3-T5 active streamer market size
, funnel2 AS (
  SELECT '2. T3-T5 active streamer market size' AS the_funnel, COUNT(DISTINCT channel_id) AS channels, 0 AS net_metric
  FROM t3_5_active_streamers
)






, t3_5_active_streamers_ext_page AS (
  SELECT user_id, 1 AS flag_ext_page
  FROM (
    SELECT user_id, url
      , CASE
        WHEN url LIKE '%www.twitch.tv/%/dashboard/extensions' THEN 'extension_manager_page'
        WHEN url LIKE '%www.twitch.tv/ext/categories/%' THEN 'extension_category_page'
        WHEN url LIKE '%www.twitch.tv/ext/%' THEN 'extension_detail_page'
        ELSE 'not_extension_related'
      END AS url_type
    FROM logs.pageview AS pv
    WHERE
      user_id IN (SELECT channel_id FROM t3_5_active_streamers)
      AND pv.time>=(SELECT the_run_report_month - INTERVAL '29 days' FROM the_constants_timeframe)
      AND pv.time<=(SELECT the_run_report_month - INTERVAL '1 second' FROM the_constants_timeframe)
  )
  WHERE url_type IN ('extension_detail_page','extension_manager_page','extension_category_page')
  GROUP BY 1
)

, t3_5_active_streamers_panelpalooza_page AS (
  SELECT user_id, 1 AS flag_panelpalooza_page
  FROM tahoe.extension_recommend_panel_render AS panel
  WHERE
    user_id IN (SELECT channel_id FROM t3_5_active_streamers)
    AND panel.time>=(SELECT the_run_report_month - INTERVAL '29 days' FROM the_constants_timeframe)
    AND panel.time<=(SELECT the_run_report_month - INTERVAL '1 second' FROM the_constants_timeframe)
    AND panel.date>=(SELECT the_run_report_month - INTERVAL '29 days' FROM the_constants_timeframe)
    AND panel.date<=(SELECT the_run_report_month FROM the_constants_timeframe)
  GROUP BY 1
)
, t3_5_active_streamers_w_impression AS (
  SELECT channel_id, SUM(1) AS impressions
  FROM (
    SELECT base.*, ext.flag_ext_page, panel.flag_panelpalooza_page
    FROM t3_5_active_streamers AS base
    LEFT JOIN t3_5_active_streamers_ext_page AS ext ON base.channel_id = ext.user_id
    LEFT JOIN t3_5_active_streamers_panelpalooza_page AS panel ON base.channel_id = panel.user_id
  )
  WHERE flag_ext_page=1 OR flag_panelpalooza_page=1
  GROUP BY 1
)

-- T3-T5 active streamer w/ extension tool impression
, funnel3 AS (
  SELECT '3. T3-T5 active streamer w/ extension tool impression' AS the_funnel, COUNT(DISTINCT channel_id) AS channels, 0 AS net_metric
  FROM t3_5_active_streamers_w_impression
)

, extension_daily_channel_presence AS (
  SELECT the_day, channel_id, extension_id, bool_extension_activated, bool_extension_installed
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor
  WHERE
    channel_id IN (SELECT channel_id FROM t3_5_active_streamers)
    AND the_day>=(SELECT the_run_report_month - INTERVAL '29 days' FROM the_constants_timeframe)
    AND the_day<(SELECT the_run_report_month FROM the_constants_timeframe)
)
-- T3-T5 active streamer net installs
, funnel4 AS (
  SELECT '4. T3-T5 active streamer net installs of their extensions' AS the_funnel, COUNT(DISTINCT channel_id) AS channels, COUNT(1) AS net_metric
  FROM extension_daily_channel_presence
  WHERE bool_extension_installed = TRUE
)
-- T3-T5 active streamer net activations
, funnel5 AS (
  SELECT '5. T3-T5 active streamer net activations of their extensions' AS the_funnel, COUNT(DISTINCT channel_id) AS channels, COUNT(1) AS net_metric
  FROM extension_daily_channel_presence
  WHERE bool_extension_activated = TRUE
)


, game_extension_id AS (
  SELECT '20nvc0bcw7n9g0raambsqwc2cpp2jw'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '1bsyryrx6lus67n81lu2z8b3yoj9ru'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'u6sud2nknhji1bf50rmhjmynf49hw4'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'dnfkgec7teq4odcnzfsauzwcydhvuj'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'fw3xzmoe7jgzc4w6mnwhznvq9rkr3g'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'izb9s2rwqbcto5yn633z7vxebhoqgx'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'zyt20fl337b4xbaisl72m23j5ipkce'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'y0io0scnvisnnlyga0j0bo5vdxkxgv'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'ix4apxjpd4wh7dm6dzb5l4g9eudn86'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '2ilfbph9acvmuki81dfpac8bvkrabl'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'fozlqfmrrdtastjnfxw3pmnqto9zns'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'l0m154prxsmwu1m0tyic1ei0915byb'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '48tho10wcksqo22iu60pf0r13cynnl'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '92ydmhd13dzrhhp087hyxqu3jks7f6'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'xj64yera57wb8n3rclp4kq3yrp30iv'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'nu3urjvo2y0j93y1ajsmrfcokl05pd'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'ebfbsgj6lg9k2d4czcycledd89vrz9'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'ynrzj2rhioa4yrgkti2j2c5csxgfd6'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'a14lkzez270g3uvyoi52sjwzciupq5'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'unw8a1ertldsu8x01o44ng68rcbfzw'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'f2wg5ogca5w3eipuys60k95ik63qns'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'uddfpjpm83bcj33vmxkyzf7m55o20q'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '0qr7fa6llzn4txgnfgb8ipeksd5v24'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '5ir8oppel9oq9706ib639v8fqhurpr'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'lr7pd0g0itey0ecsbazh5x6l4a32w8'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'i8z0nct9wygyq2x64481coetiiqvw8'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '5rh2lrliu60ksairiau01m18hpijuz'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'k62z4ww3mrt8iir3395osbowv0gdv2'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'sj16zr66yig2f38ju7y8dos0cr4r90'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '4fe6rcd6nxjvm2x1tepbszba59ye6c'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'ochmobrlxk3aomwuofj5b3p3x393a5'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'hecb122wgtrzumrv9ywwjn7wg6nglq'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '9bmsurtng2qfh90y5r7mmshzvdryuy'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'jxkkd2xxkbfazhkqw3q6zzypahb0s3'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '9bcrslmfbw59kqwi7gl968a7sixhyl'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'hfhakw02k45ke92uwts5qkk7l82a9e'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '4ntuott0zqw008atk0wy60phfa8jyf'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'apwln3g3ia45kk690tzabfp525h9e1'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'hz2xqdan4xslxg5veudm7coxoknpu9'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'bxo59i0znhya1jat2k69a20eggtlri'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'qml0i86o5jm1ru7gzwqn6q8dt91ib7'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'nyqzr44abh0thukspz7nsu8lyrv01w'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'auajwk3d5t6tr1vhd8baeikfzs7etn'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '115etf1m5o90c9ohpi11fc0598kwiw'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '74vwlv5j6u4ij320opfy3t9f3n9b0q'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '11tabh117xzmujisiqfcmeihpphbxi'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'qfhy4mk7ov3d2di7zezjkblaii4sap'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'lgpf9j7y8n1ja9onkb6w7bxfkhk2zl'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'cplheah4pxjyuwe9mkno9kbmb11lyc'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'hts7bfg5bccjwy9p0hcof7cxkqbmeq'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '1y54m3qx82zc0qxhr0ttcipjc0z51r'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'zydsgjlem0um10bq16kw6x7q92juu2'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '71h3uexcz11lljm5s8jpjipm9wsmhu'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'lhyvltp09mg6xmdy3p9ey6t1pyz445'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'hz584ynr8wyug0tnajrps6d48hy0qk'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'eug7fim8pj2b6w2od8ht1vk3aga3ad'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'h3v5ndvu3qiiij77jvtxnefq0k3bwf'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '7vgxduew8hz35gvs092gwamlxp1sth'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '6jhaq431m7znwmdo8zoos3kzh4apri'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '2k9c9x1dqjxar850l5m6r3lhhyv7iq'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'fdpp9vcx5bsz8osxvqii4i9cumwswd'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'iukyfu2x8xeihf9j5zkgd1cvua9v66'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 't1w9b6gnc9k71w4x7ytsxcppfxrq3l'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'b7pozpf4r0qjgdn4hfrvw0mlbpqp9e'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'nbtib9uc5xf03dsfx5yl6y2enbwamk'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'zrpr81v0emdss40vwenz4bbcewshd1'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'efu6io2rqap5etnqkkzekzzv0981kj'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '7sdcs3nahyvzqknrugv6yetof38ndb'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'qhkxgybrzjfjjb5fwwwjkcohh2uzmc'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'oks2vrhq8iqq1qv714n35fo70igtjc'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'fbk122g5sfkw0wnztttrwejp8r0lcj'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'lnelv2x2551z7mtwis1iyp1oqbe83k'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'vtf6kwleslxtobyiyd8flzwspenf0g'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '1ho24kr7crna6qq1997yk9egdybhde'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'mjjy5shhoakqt1d5etpcw4kz1qxhfw'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'uzyk6s03wo91dcji520t84x2mhwb65'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'wg56zk271bqja047pknv3pk65m0rbr'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'k7y5b2qx4gbmgbdefku82onu9semnc'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'gf8iji2drnbafa59e238r1u1rqqo1f'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'aj2etwudaropts463an0jwhfibz6jy'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'jm74cnw8pkzsvq9ilcloajmwm0apk3'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '6u30jon0uvoruonsllb9joifzu8ioa'::VARCHAR(255) AS extension_id
  UNION ALL SELECT '8m9jikqys7q8gi953s3uqp93zm4tdb'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'kr7m1hz7esldlrptruk0fd76l6yq36'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'b761gcvkac6qbwo26ededwf9sluqh0'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'ipcfemlzs77j38jjhnqf1pr9g22nor'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'k7mzfi3ma4oi30kyj9oq4vnes2ga37'::VARCHAR(255) AS extension_id
  UNION ALL SELECT 'eke6vam83fi9dkfrgh4y28l48wz363'::VARCHAR(255) AS extension_id
)
, high_potential_extension_id AS (
  SELECT extension_id::VARCHAR(255) FROM game_extension_id
  UNION ALL SELECT extension_id::VARCHAR(255) FROM analysis.released_extensions_latest WHERE is_mobile_enabled OR is_bits_enabled
)

-- T3-T5 Coverage of MW

-- T3-T5 net activations of “high potential” tools extensions or game developer extensions
, funnel7 AS (
  SELECT '7. T3-T5 active streamer net activations of “high potential” extensions' AS the_funnel, COUNT(DISTINCT channel_id) AS channels, COUNT(1) AS net_metric
  FROM extension_daily_channel_presence
  WHERE bool_extension_activated = TRUE
  AND extension_id::VARCHAR(255) IN (SELECT extension_id FROM high_potential_extension_id)
)
-- T3-T5 coverage of MW of “high potential” tools extensions or game developer extensions

, the_final_funnel AS (
  SELECT * FROM funnel1
  UNION ALL SELECT * FROM funnel2
  UNION ALL SELECT * FROM funnel3
  UNION ALL SELECT * FROM funnel4
  UNION ALL SELECT * FROM funnel5
  UNION ALL SELECT * FROM funnel7
)



SELECT * FROM the_final_funnel ORDER BY 1
--
-- --base.the_run_report_month - INTERVAL '1 month' AS the_month
-- SELECT
--   dateadd(month, -1, base.the_run_report_month::DATE) AS the_month
--   , funnel.*
-- FROM the_constants_timeframe AS base
-- LEFT JOIN the_final_funnel AS funnel
-- ON 1=1
-- ORDER BY 1,2
