CREATE TABLE analysis.dsds_379_extensions_2019_mobile_metric AS
WITH
the_parameter_date AS (
  SELECT '2019-01-01'::TIMESTAMP AS the_date_we_run_report
)

, the_constants_time as (
  SELECT (SELECT the_date_we_run_report FROM the_parameter_date)::date as end_date
  , DATEADD(day,-1,(SELECT the_date_we_run_report FROM the_parameter_date))::date as start_date
  , DATEADD(day,-1,(SELECT the_date_we_run_report FROM the_parameter_date))::date as the_day
)

--fires when a device_id loads a channel_id page with puzzle icon present on mobile
, impression_pre as (
  SELECT
  b.extension_id, a.device_id, a.platform
  FROM tahoe.extension_active a
  JOIN analysis.dsds_281_extension_daily_channel_presence_all_anchor b on a.channel_id = b.channel_id and a.date = b.the_day
  JOIN analysis.released_extensions_latest rel on rel.extension_id = b.extension_id
  WHERE date >= (SELECT start_date FROM the_constants_time) and date < (SELECT end_date FROM the_constants_time)
  AND a.platform IN ('ios','android')
  AND bool_extension_activated is true
  AND rel.is_mobile_enabled is true
  and a.extension_active is true
)

, impression as (
  select extension_id, platform, count(distinct device_id)
  from impression_pre
  group by 1,2
)

--fires when the device_id clicks on the puzzle icon on the channel_id on mobile (renders extensions)
, interact as (
  select r.extension_id, r.platform, count(distinct r.device_id)
  from tahoe.extension_render r
  join impression_pre i on r.device_id = i.device_id and r.extension_id = i.extension_id and r.platform = i.platform
  where r.platform in ('android', 'ios')
  AND date >= (SELECT start_date FROM the_constants_time) and date < (SELECT end_date FROM the_constants_time)
  group by 1,2
)

, final_metric AS (
  select (SELECT start_date FROM the_constants_time) AS the_day
    , a.extension_id, c.extension_name, a.platform, a.count as view, b.count as render, b.count::float/a.count as engagement_rate
  from impression a
  left join interact b on a.extension_id = b.extension_id and a.platform = b.platform
  join analysis.all_extensions_latest c on c.extension_id = a.extension_id
)

SELECT * FROM final_metric
-- WHERE view>=1000
--order by engagement_rate desc
;




-- SELEcT * FROM analysis.dsds_379_extensions_2019_mobile_metric order by engagement_rate desc

SELECT * FROM (
SELEcT the_day, platform, extension_id, extension_name, COUNT(DISTINCT extension_id) AS extensions, COUNT(1) AS rows, SUM(view) AS views, SUM(render) AS renders, AVG(engagement_rate) AS engagement_rate
FROM analysis.dsds_379_extensions_2019_mobile_metric
GROUP BY 1,2,3,4
)
WHERE engagement_rate>=0.1 AND views>=50
ORDER BY 1,2, engagement_rate DESC
