
CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds_379_extensions_2019_mobile_metric);


PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table
(



WITH
the_parameter_date AS (
  SELECT $1::DATE AS the_date_we_run_report
)

, the_constants_time as (
  SELECT (SELECT the_date_we_run_report FROM the_parameter_date)::date as end_date
  , DATEADD(day,-1,(SELECT the_date_we_run_report FROM the_parameter_date))::date as start_date
  , DATEADD(day,-1,(SELECT the_date_we_run_report FROM the_parameter_date))::date as the_day
)

--fires when a device_id loads a channel_id page with puzzle icon present on mobile
, impression_pre as (
  SELECT
  b.extension_id, a.device_id, a.platform
  FROM tahoe.extension_active a
  JOIN analysis.dsds_281_extension_daily_channel_presence_all_anchor b on a.channel_id = b.channel_id and a.date = b.the_day
  JOIN analysis.released_extensions_latest rel on rel.extension_id = b.extension_id
  WHERE date >= (SELECT start_date FROM the_constants_time) and date < (SELECT end_date FROM the_constants_time)
  AND a.platform IN ('ios','android')
  AND bool_extension_activated is true
  AND rel.is_mobile_enabled is true
  and a.extension_active is true
)

, impression as (
  select extension_id, platform, count(distinct device_id)
  from impression_pre
  group by 1,2
)

--fires when the device_id clicks on the puzzle icon on the channel_id on mobile (renders extensions)
, interact as (
  select r.extension_id, r.platform, count(distinct r.device_id)
  from tahoe.extension_render r
  join impression_pre i on r.device_id = i.device_id and r.extension_id = i.extension_id and r.platform = i.platform
  where r.platform in ('android', 'ios')
  AND date >= (SELECT start_date FROM the_constants_time) and date < (SELECT end_date FROM the_constants_time)
  group by 1,2
)

, final_metric AS (
  select (SELECT start_date FROM the_constants_time) AS the_day
    , a.extension_id, c.extension_name, a.platform, a.count as view, b.count as render, b.count::float/a.count as engagement_rate
  from impression a
  left join interact b on a.extension_id = b.extension_id and a.platform = b.platform
  join analysis.all_extensions_latest c on c.extension_id = a.extension_id
)

SELECT * FROM final_metric

);


--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (VARCHAR) AS
DELETE FROM analysis.dsds_379_extensions_2019_mobile_metric
WHERE analysis.dsds_379_extensions_2019_mobile_metric.the_day = DATEADD(day, -1, $1::DATE)
;





EXECUTE the_insert_function ('2019-01-02');
EXECUTE the_insert_function ('2019-01-03');
EXECUTE the_insert_function ('2019-01-04');
EXECUTE the_insert_function ('2019-01-05');
EXECUTE the_insert_function ('2019-01-06');
EXECUTE the_insert_function ('2019-01-07');
EXECUTE the_insert_function ('2019-01-08');
EXECUTE the_insert_function ('2019-01-09');
EXECUTE the_insert_function ('2019-01-10');
EXECUTE the_insert_function ('2019-01-11');
EXECUTE the_insert_function ('2019-01-12');
EXECUTE the_insert_function ('2019-01-13');
EXECUTE the_insert_function ('2019-01-14');
EXECUTE the_insert_function ('2019-01-15');
EXECUTE the_insert_function ('2019-01-16');
EXECUTE the_insert_function ('2019-01-17');
EXECUTE the_insert_function ('2019-01-18');
EXECUTE the_insert_function ('2019-01-19');
EXECUTE the_insert_function ('2019-01-20');
EXECUTE the_insert_function ('2019-01-21');
EXECUTE the_insert_function ('2019-01-22');
EXECUTE the_insert_function ('2019-01-23');
EXECUTE the_insert_function ('2019-01-24');
EXECUTE the_insert_function ('2019-01-25');
EXECUTE the_insert_function ('2019-01-26');
EXECUTE the_insert_function ('2019-01-27');
EXECUTE the_insert_function ('2019-01-28');
EXECUTE the_insert_function ('2019-01-29');
EXECUTE the_insert_function ('2019-01-30');
EXECUTE the_insert_function ('2019-01-31');

EXECUTE the_insert_function ('2019-02-01');
EXECUTE the_insert_function ('2019-02-02');
EXECUTE the_insert_function ('2019-02-03');
EXECUTE the_insert_function ('2019-02-04');
EXECUTE the_insert_function ('2019-02-05');
EXECUTE the_insert_function ('2019-02-06');
EXECUTE the_insert_function ('2019-02-07');
EXECUTE the_insert_function ('2019-02-08');
EXECUTE the_insert_function ('2019-02-09');
EXECUTE the_insert_function ('2019-02-10');
EXECUTE the_insert_function ('2019-02-11');
EXECUTE the_insert_function ('2019-02-12');
EXECUTE the_insert_function ('2019-02-13');
EXECUTE the_insert_function ('2019-02-14');
EXECUTE the_insert_function ('2019-02-15');
EXECUTE the_insert_function ('2019-02-16');
EXECUTE the_insert_function ('2019-02-17');
EXECUTE the_insert_function ('2019-02-18');
EXECUTE the_insert_function ('2019-02-19');





-- Load TEMP_TABLE into ROLLUP_TABLE
INSERT INTO analysis.dsds_379_extensions_2019_mobile_metric
(SELECT * FROM the_temp_table);



DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
