--NOTE: THERE ARE A LOT OF MOVING PIECES AND UNKNOWNS STILL AS OF 2019-02-27
--UPDATE THE FOLLOWING LINES AS NECESSARY IN THE FUTURE
--45 to 59, 82 to 87, 97 to 106
CREATE TABLE analysis.dsds_389_2019_dx_mw_metric AS



WITH

the_constants_time AS (
  SELECT '2019-01-01'::DATE AS start_date
    , '2019-01-02'::DATE AS end_date
)
--for ugc channels, get the "blessed" list of game to extension_id mapping
--https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=738274537
, first_party_extension_log AS (
  SELECT *, TRUE AS flag_is_ugc_content_matched_extension FROM analysis.dsds_389_blessed_first_party_extensions
  -- game_name	        VARCHAR(256)
  -- extension_id	      VARCHAR(256)
  -- extension_name	    VARCHAR(256)
  -- extension_url	    VARCHAR(256)
  -- game_flattened	    VARCHAR(256)
)
-- for premium channels, these are the extension_id to count towards content matched mw
-- https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=0
, blessed_premium_extensions AS (
  SELECT extension_id, extension_name, extension_url, flag_is_content_matched AS flag_is_premium_content_matched_extension
  FROM analysis.dsds_389_premium_content_match_extensions
  WHERE flag_is_content_matched = TRUE
  GROUP BY 1,2,3,4
  -- extension_id	            VARCHAR(256)
  -- extension_name	          VARCHAR(256)
  -- extension_url	          VARCHAR(256)
  -- flag_is_content_matched	BOOL
)
--only take records where the extension is activated
, extension_daily_channel_presence_log AS (
  SELECT the_day, base.channel_id, cds.tier, CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel, base.extension_id
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
  LEFT JOIN analysis.dsds294_channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.the_day = cds.the_date
  WHERE
    (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
    AND bool_extension_activated = TRUE
)
--only include records where the extensions are in the blessed list of extensions for ugc channels, or they are tier 5 (o&o) with the premium extensions
, extension_daily_channel_presence_log_step2 AS (
  SELECT *
  FROM (
    SELECT the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.extension_id, first_p.game_name, first_p.game_flattened, first_p.flag_is_ugc_content_matched_extension, bpe.flag_is_premium_content_matched_extension
    FROM extension_daily_channel_presence_log AS base
    LEFT JOIN first_party_extension_log AS first_p ON base.extension_id = first_p.extension_id
    LEFT JOIN blessed_premium_extensions AS bpe ON base.extension_id = bpe.extension_id
  )
  WHERE
    (flag_is_premium_content_matched_extension AND flag_ugc_oo_channel='O&O Channel') -- it is a premium channel, and it has a premium channel content matched extension
    OR (flag_is_ugc_content_matched_extension AND flag_ugc_oo_channel='UGC Channel') --it is not a premium channel, and it has a ugc channel content matched extension
)

--logic to determine if the extension should count various platform mins watched
, extensions_metadata_log AS (
  SELECT *
    --if any of the conditions of enabled on overlay, panel or component is true, then count web as true, else false
    , CASE WHEN is_overlay_enabled OR is_panel_enabled OR is_component_enabled THEN true ELSE false END AS flag_count_web
    --if is_mobile_enabled is true THEN count android as true, else false
    , CASE WHEN is_mobile_enabled THEN true ELSE false END AS flag_count_android
    --need special logic for ios pending discussion with Danny Chi on extensions team, because ios needs special whitelist
    , false AS flag_count_ios
    ----------------------------------------------------------------------------------------------
    --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE OR DESKTOP APP)--------
    ----------------------------------------------------------------------------------------------
    --Desklight project will bring extensions onto the desktop app, official launch date still TBD
    , CASE WHEN the_day>='3000-01-01' THEN true ELSE false END AS flag_count_desktop
    --for console, there are no current plans to support extensions
    , false AS flag_count_playstation
    , false AS flag_count_xboxone
    , false AS flag_count_xbox360
    --mobile web and chromecase and other are not slated to have extensions support
    , false AS flag_count_mobile_web
    , false AS flag_count_chromecast
    , false AS flag_count_other
    ----------------------------------------------------------------------------------------------
    ----------------------------------------------------------------------------------------------
  FROM (
    SELECT *
    FROM analysis.dsds_389_extensions_daily_metadata AS base
    WHERE
      the_day = (SELECT MAX(the_day) AS the_day FROM analysis.dsds_389_extensions_daily_metadata)
      --(SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
  )
)
--join the data
, daily_blessed_extension_per_channel AS (
  SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel
    , base.extension_id, base.game_name, base.game_flattened
    , ext_meta.extension_name, ext_meta.extension_url, ext_meta.extension_category_name
    , ext_meta.flag_count_web, ext_meta.flag_count_android, ext_meta.flag_count_ios, ext_meta.flag_count_desktop
    , ext_meta.flag_count_playstation, ext_meta.flag_count_xboxone, ext_meta.flag_count_xbox360
    , ext_meta.flag_count_mobile_web, ext_meta.flag_count_chromecast, ext_meta.flag_count_other
    , base.flag_is_ugc_content_matched_extension, base.flag_is_premium_content_matched_extension
  FROM extension_daily_channel_presence_log_step2 AS base
  LEFT JOIN extensions_metadata_log AS ext_meta ON base.extension_id = ext_meta.extension_id
)



, daily_hours_watched_per_channel_platform_game AS (
  SELECT base.day AS the_day, base.channel_id, base.platform, regexp_replace(lower(base.game),'([^a-z.])','') as game_flattened
  , cds.tier, CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
  , SUM(base.sum_hw) AS hw
  ---------------------------------------------------------------------
  --POTENTIALLY NEED TO CHANGE NAME OF ROLLUP WHEN SERDAR/SAM UPDATE IT
  ---------------------------------------------------------------------
  FROM rollups.aggtest_viewers AS base
  ---------------------------------------------------------------------
  ---------------------------------------------------------------------
  LEFT JOIN analysis.dsds294_channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.day = cds.the_date
  WHERE
    (SELECT start_date FROM the_constants_time)<=day AND day<(SELECT end_date FROM the_constants_time)
    AND content_type IN ('live stream')
  GROUP BY 1,2,3,4,5,6
)


, joined_daily_blessed_hours_watched_ugc AS (
  SELECT *
  FROM (
    SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.platform, base.game_flattened
      , NVL(blessed_game.flag_is_blessed_game, FALSE) AS flag_is_blessed_game
      -----------------------------------------------------------------------
      --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
      -----------------------------------------------------------------------
      , CASE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
      ELSE FALSE END AS flag_mw_with_blessed_extension
      -----------------------------------------------------------------------
      -----------------------------------------------------------------------
      , base.hw, blessed.extension_id, blessed.extension_name, blessed.extension_url, blessed.extension_category_name
      , blessed.flag_count_web, blessed.flag_count_android, blessed.flag_count_ios, blessed.flag_count_desktop
      , blessed.flag_count_playstation, blessed.flag_count_xboxone, blessed.flag_count_xbox360
      , blessed.flag_count_mobile_web, blessed.flag_count_chromecast, blessed.flag_count_other
    FROM daily_hours_watched_per_channel_platform_game AS base
    LEFT JOIN analysis.dsds_389_blessed_games_list AS blessed_game ON base.game_flattened = blessed_game.game_flattened
    LEFT JOIN daily_blessed_extension_per_channel AS blessed
      ON base.the_day = blessed.the_day
      AND base.channel_id = blessed.channel_id
      AND base.game_flattened = blessed.game_flattened
  )
  WHERE flag_ugc_oo_channel= 'UGC Channel'
)

--ASSUME THAT IF AN O&O CHANNEL HAS THE BLESSED EXTENSION ACTIVE, THEN COUNT IT AS HW WITH EXTENSION (i.e. TWITCH PRESENTS CHANNEL WILL CORRECTLY TURN OFF POKEMON EXTENSION WHEN NOT STREAMING POKEMON)
--NOTE: flag_is_blessed_game field are not relevant for O&O channels
, joined_daily_blessed_hours_watched_premium AS (
  SELECT *
  FROM (
    SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.platform, base.game_flattened
      , TRUE AS flag_is_blessed_game
      -----------------------------------------------------------------------
      --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
      -----------------------------------------------------------------------
      , CASE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
      ELSE FALSE END AS flag_mw_with_blessed_extension
      -----------------------------------------------------------------------
      -----------------------------------------------------------------------
      , base.hw, blessed.extension_id, blessed.extension_name, blessed.extension_url, blessed.extension_category_name
      , blessed.flag_count_web, blessed.flag_count_android, blessed.flag_count_ios, blessed.flag_count_desktop
      , blessed.flag_count_playstation, blessed.flag_count_xboxone, blessed.flag_count_xbox360
      , blessed.flag_count_mobile_web, blessed.flag_count_chromecast, blessed.flag_count_other
    FROM daily_hours_watched_per_channel_platform_game AS base
    LEFT JOIN daily_blessed_extension_per_channel AS blessed
      ON base.the_day = blessed.the_day
      AND base.channel_id = blessed.channel_id
  )
  WHERE flag_ugc_oo_channel= 'O&O Channel'
)


, final_data_ugc AS (
  SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, the_game
    , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
    , ROUND(total_hw::FLOAT,2) AS total_hw
    , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
  FROM (
    SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, CASE WHEN flag_is_blessed_game THEN game_flattened ELSE 'other_games_w_no_official_extension' END AS the_game
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
    , SUM(hw) AS total_hw
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/NULLIF(SUM(hw::FLOAT),0) AS pct_hw_with_blessed_extension
    FROM joined_daily_blessed_hours_watched_ugc
    GROUP BY 1,2,3,4,5,6
  )
)

, final_data_premium AS (
  SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, the_game
    , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
    , ROUND(total_hw::FLOAT,2) AS total_hw
    , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
  FROM (
    SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, CASE WHEN flag_is_blessed_game THEN game_flattened ELSE 'other_games_w_no_official_extension' END AS the_game
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
    , SUM(hw) AS total_hw
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/NULLIF(SUM(hw::FLOAT),0) AS pct_hw_with_blessed_extension
    FROM joined_daily_blessed_hours_watched_premium
    GROUP BY 1,2,3,4,5,6
  )
)


, final_data AS (
  SELECT * FROM final_data_ugc
  UNION ALL
  SELECT * FROM final_data_premium
)


SELECT * FROM final_data;


--
--
-- SELECT the_month, flag_ugc_oo_channel, hw_with_official_extension, total_hw, ROUND(pct_hw_with_official_extension, 4) pct_hw_with_official_extension
-- FROM (
--   SELECT DATE_TRUNC('month', the_day) AS the_month, flag_ugc_oo_channel, the_game, SUM(hw_with_blessed_extension) AS hw_with_official_extension
--   , SUM(total_hw) AS total_hw, SUM(hw_with_blessed_extension::FLOAT)/SUM(total_hw::FLOAT) AS pct_hw_with_official_extension
--   FROM final_data
--   WHERE the_day>='2019-01-01'
--   GROUP BY 1,2,3
-- )
-- ORDER BY 1,2
-- ;







--
-- -- analysis.dsds_366_premium_content_match_extension_2019_01
-- --numerator = premium mw on days with the extensions activated on the channels
-- --denominator = total premium mw for the month
--
-- with
--
-- the_constants_blessed_premium_extensions AS (
-- --    Column
-- -- extension_id
-- -- extension_name
-- -- extension_url
-- -- flag_is_content_matched
-- SELECT extension_id FROM analysis.dsds_366_premium_content_match_extension_2019_01 WHERE flag_is_content_matched GROUP BY 1
-- )
--
-- , the_constants_time AS (
-- SELECT start_time, DATEADD('month',1,start_time) AS end_time
-- FROM (SELECT '2019-01-01'::TIMESTAMP AS start_time)
-- )
--
-- , the_premium_streamers AS (
-- SELECT channel_id::BIGINT
-- FROM analysis.dsds_366_mbr_2019_01
-- WHERE tier IN ('T5: Premium', 'NULL: NOT STREAM LAST 1 DAYS')
-- GROUP BY 1
-- )
--
--
--
-- , hw_all as (
-- select day AS the_day, channel_id, sum(mw_total) as mw
-- from rollups.daily_minutes_watched_by_channel
-- where day >= (SELECT start_time FROM the_constants_time) and day < (SELECT end_time FROM the_constants_time)
-- AND channel_id IN (SELECT channel_id FROM the_premium_streamers)
-- group by 1,2
-- )
--
--
--
-- , extensions as (
-- select base.the_day, base.channel_id, base.bool_extension_activated
-- from analysis.dsds_281_extension_daily_channel_presence_all_anchor as base
-- where base.bool_extension_activated = TRUE
-- AND base.channel_id IN (SELECT channel_id FROM the_premium_streamers)
-- AND base.extension_id IN (SELECT extension_id FROM the_constants_blessed_premium_extensions)
-- GROUP BY 1,2,3
-- )
--
--
--
-- , hw_map as (
-- select base.the_day, base.channel_id, mw, bool_extension_activated AS flag_is_content_matched_day
-- from hw_all as base
-- LEFT JOIN extensions as ext
-- on base.channel_id = ext.channel_id and base.the_day = ext.the_day
-- group by 1,2,3,4
-- )
--
-- , premium_final as(
-- select channel_id, SUM(mw) AS mw, SUM(CASE WHEN flag_is_content_matched_day THEN mw ELSE 0 END) AS matched_mw
-- from hw_map
-- GROUP BY 1
-- )
--
-- select *, matched_mw::float/mw as pct_mw
-- from premium_final
-- ;
