

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE analysis.dsds_389_2019_dx_mw_metric);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table (


WITH

the_constants_time AS (
  SELECT start_date, DATEADD(day, 1, start_date) AS end_date
  FROM (SELECT $1::DATE AS start_date)
)
--for ugc channels, get the "blessed" list of game to extension_id mapping
--https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=738274537
, first_party_extension_log AS (
  SELECT *, TRUE AS flag_is_ugc_content_matched_extension FROM analysis.dsds_389_blessed_first_party_extensions
  -- game_name	        VARCHAR(256)
  -- extension_id	      VARCHAR(256)
  -- extension_name	    VARCHAR(256)
  -- extension_url	    VARCHAR(256)
  -- game_flattened	    VARCHAR(256)
)
-- for premium channels, these are the extension_id to count towards content matched mw
-- https://docs.google.com/spreadsheets/d/1hk7i3qeL63s4jxAItljN__2dejtzZCpMv4SHk3y6Dqs/edit#gid=0
, blessed_premium_extensions AS (
  SELECT extension_id, extension_name, extension_url, flag_is_content_matched AS flag_is_premium_content_matched_extension
  FROM analysis.dsds_389_premium_content_match_extensions
  WHERE flag_is_content_matched = TRUE
  GROUP BY 1,2,3,4
  -- extension_id	            VARCHAR(256)
  -- extension_name	          VARCHAR(256)
  -- extension_url	          VARCHAR(256)
  -- flag_is_content_matched	BOOL
)
--only take records where the extension is activated
, extension_daily_channel_presence_log AS (
  SELECT the_day, base.channel_id, cds.tier, CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel, base.extension_id
  FROM analysis.dsds_281_extension_daily_channel_presence_all_anchor AS base
  LEFT JOIN analysis.dsds294_channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.the_day = cds.the_date
  WHERE
    (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
    AND bool_extension_activated = TRUE
)
--only include records where the extensions are in the blessed list of extensions for ugc channels, or they are tier 5 (o&o) with the premium extensions
, extension_daily_channel_presence_log_step2 AS (
  SELECT *
  FROM (
    SELECT the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.extension_id, first_p.game_name, first_p.game_flattened, first_p.flag_is_ugc_content_matched_extension, bpe.flag_is_premium_content_matched_extension
    FROM extension_daily_channel_presence_log AS base
    LEFT JOIN first_party_extension_log AS first_p ON base.extension_id = first_p.extension_id
    LEFT JOIN blessed_premium_extensions AS bpe ON base.extension_id = bpe.extension_id
  )
  WHERE
    (flag_is_premium_content_matched_extension AND flag_ugc_oo_channel='O&O Channel') -- it is a premium channel, and it has a premium channel content matched extension
    OR (flag_is_ugc_content_matched_extension AND flag_ugc_oo_channel='UGC Channel') --it is not a premium channel, and it has a ugc channel content matched extension
)

--logic to determine if the extension should count various platform mins watched
, extensions_metadata_log AS (
  SELECT *
    --if any of the conditions of enabled on overlay, panel or component is true, then count web as true, else false
    , CASE WHEN is_overlay_enabled OR is_panel_enabled OR is_component_enabled THEN true ELSE false END AS flag_count_web
    --if is_mobile_enabled is true THEN count android as true, else false
    , CASE WHEN is_mobile_enabled THEN true ELSE false END AS flag_count_android
    --need special logic for ios pending discussion with Danny Chi on extensions team, because ios needs special whitelist
    , false AS flag_count_ios
    ----------------------------------------------------------------------------------------------
    --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE OR DESKTOP APP)--------
    ----------------------------------------------------------------------------------------------
    --Desklight project will bring extensions onto the desktop app, official launch date still TBD
    , CASE WHEN the_day>='3000-01-01' THEN true ELSE false END AS flag_count_desktop
    --for console, there are no current plans to support extensions
    , false AS flag_count_playstation
    , false AS flag_count_xboxone
    , false AS flag_count_xbox360
    --mobile web and chromecase and other are not slated to have extensions support
    , false AS flag_count_mobile_web
    , false AS flag_count_chromecast
    , false AS flag_count_other
    ----------------------------------------------------------------------------------------------
    ----------------------------------------------------------------------------------------------
  FROM (
    SELECT *
    FROM analysis.dsds_389_extensions_daily_metadata AS base
    WHERE
      the_day = (SELECT MAX(the_day) AS the_day FROM analysis.dsds_389_extensions_daily_metadata)
      --(SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
  )
)

--logic to determine if the extension should count various platform mins watched
--NOTE: We dont have data for analysis.dsds_389_extensions_daily_metadata before 2018-12-13, so use 2018-12-13 as the date if running historical mw data before this date
, extensions_metadata_log_historical AS (
  SELECT *
    --if any of the conditions of enabled on overlay, panel or component is true, then count web as true, else false
    , CASE WHEN is_overlay_enabled OR is_panel_enabled OR is_component_enabled THEN true ELSE false END AS flag_count_web
    --if is_mobile_enabled is true THEN count android as true, else false
    , CASE WHEN is_mobile_enabled THEN true ELSE false END AS flag_count_android
    --need special logic for ios pending discussion with Danny Chi on extensions team, because ios needs special whitelist
    , false AS flag_count_ios
    ----------------------------------------------------------------------------------------------
    --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE OR DESKTOP APP)--------
    ----------------------------------------------------------------------------------------------
    --Desklight project will bring extensions onto the desktop app, official launch date still TBD
    , CASE WHEN the_day>='3000-01-01' THEN true ELSE false END AS flag_count_desktop
    --for console, there are no current plans to support extensions
    , false AS flag_count_playstation
    , false AS flag_count_xboxone
    , false AS flag_count_xbox360
    --mobile web and chromecase and other are not slated to have extensions support
    , false AS flag_count_mobile_web
    , false AS flag_count_chromecast
    , false AS flag_count_other
    ----------------------------------------------------------------------------------------------
    ----------------------------------------------------------------------------------------------
  FROM (
    SELECT *
    FROM analysis.dsds_389_extensions_daily_metadata AS base
    WHERE
      base.the_day = '2018-12-13'
  )
)

--join the data
, daily_blessed_extension_per_channel AS (
  SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel
    , base.extension_id, base.game_name, base.game_flattened
    , NVL(ext_meta.extension_name, ext_meta_historical.extension_name) AS extension_name
    , NVL(ext_meta.extension_url, ext_meta_historical.extension_url) AS extension_url
    , NVL(ext_meta.extension_category_name, ext_meta_historical.extension_category_name) AS extension_category_name
    , NVL(ext_meta.flag_count_web, ext_meta_historical.flag_count_web) AS flag_count_web
    , NVL(ext_meta.flag_count_android, ext_meta_historical.flag_count_android) AS flag_count_android
    , NVL(ext_meta.flag_count_ios, ext_meta_historical.flag_count_ios) AS flag_count_ios
    , NVL(ext_meta.flag_count_desktop, ext_meta_historical.flag_count_desktop) AS flag_count_desktop
    , NVL(ext_meta.flag_count_playstation, ext_meta_historical.flag_count_playstation) AS flag_count_playstation
    , NVL(ext_meta.flag_count_xboxone, ext_meta_historical.flag_count_xboxone) AS flag_count_xboxone
    , NVL(ext_meta.flag_count_xbox360, ext_meta_historical.flag_count_xbox360) AS flag_count_xbox360
    , NVL(ext_meta.flag_count_mobile_web, ext_meta_historical.flag_count_mobile_web) AS flag_count_mobile_web
    , NVL(ext_meta.flag_count_chromecast, ext_meta_historical.flag_count_chromecast) AS flag_count_chromecast
    , NVL(ext_meta.flag_count_other, ext_meta_historical.flag_count_other) AS flag_count_other
    , base.flag_is_ugc_content_matched_extension, base.flag_is_premium_content_matched_extension
  FROM extension_daily_channel_presence_log_step2 AS base
  LEFT JOIN extensions_metadata_log AS ext_meta ON base.extension_id = ext_meta.extension_id AND base.the_day>='2018-12-13'
  LEFT JOIN extensions_metadata_log_historical AS ext_meta_historical ON base.extension_id = ext_meta_historical.extension_id AND base.the_day<'2018-12-13'
)



, daily_hours_watched_per_channel_platform_game AS (
  SELECT base.day AS the_day, base.channel_id, base.platform, regexp_replace(lower(base.game),'([^a-z.])','') as game_flattened
  , cds.tier, CASE WHEN cds.tier IN ('T5: Premium') THEN 'O&O Channel' ELSE 'UGC Channel' END AS flag_ugc_oo_channel
  , SUM(base.mw::FLOAT/60) AS hw
  ---------------------------------------------------------------------
  --POTENTIALLY NEED TO CHANGE NAME OF ROLLUP WHEN SERDAR/SAM UPDATE IT
  ---------------------------------------------------------------------
  FROM cubes.hours_watched_daily_by_device AS base--FROM rollups.aggtest_viewers AS base
  ---------------------------------------------------------------------
  ---------------------------------------------------------------------
  LEFT JOIN analysis.dsds294_channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.day = cds.the_date
  WHERE
    (SELECT start_date FROM the_constants_time)<=base.day AND base.day<(SELECT end_date FROM the_constants_time)
    AND base.content_mode IN ('live stream')--AND base.content_type IN ('live stream')
  GROUP BY 1,2,3,4,5,6
)


, joined_daily_blessed_hours_watched_ugc AS (
  SELECT *
  FROM (
    SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.platform, base.game_flattened
      , NVL(blessed_game.flag_is_blessed_game, FALSE) AS flag_is_blessed_game
      -----------------------------------------------------------------------
      --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
      -----------------------------------------------------------------------
      , CASE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
      ELSE FALSE END AS flag_mw_with_blessed_extension
      -----------------------------------------------------------------------
      -----------------------------------------------------------------------
      , base.hw, blessed.extension_id, blessed.extension_name, blessed.extension_url, blessed.extension_category_name
      , blessed.flag_count_web, blessed.flag_count_android, blessed.flag_count_ios, blessed.flag_count_desktop
      , blessed.flag_count_playstation, blessed.flag_count_xboxone, blessed.flag_count_xbox360
      , blessed.flag_count_mobile_web, blessed.flag_count_chromecast, blessed.flag_count_other
    FROM daily_hours_watched_per_channel_platform_game AS base
    LEFT JOIN analysis.dsds_389_blessed_games_list AS blessed_game ON base.game_flattened = blessed_game.game_flattened
    LEFT JOIN daily_blessed_extension_per_channel AS blessed
      ON base.the_day = blessed.the_day
      AND base.channel_id = blessed.channel_id
      AND base.game_flattened = blessed.game_flattened
  )
  WHERE flag_ugc_oo_channel= 'UGC Channel'
)

--ASSUME THAT IF AN O&O CHANNEL HAS THE BLESSED EXTENSION ACTIVE, THEN COUNT IT AS HW WITH EXTENSION (i.e. TWITCH PRESENTS CHANNEL WILL CORRECTLY TURN OFF POKEMON EXTENSION WHEN NOT STREAMING POKEMON)
--NOTE: flag_is_blessed_game field are not relevant for O&O channels
, joined_daily_blessed_hours_watched_premium AS (
  SELECT *
  FROM (
    SELECT base.the_day, base.channel_id, base.tier, base.flag_ugc_oo_channel, base.platform, base.game_flattened
      , TRUE AS flag_is_blessed_game
      -----------------------------------------------------------------------
      --ADJUST THIS WHEN OTHER PLATFORMS GET EXTENSION SUPPORT (i.e. CONSOLE)
      -----------------------------------------------------------------------
      , CASE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='UGC Channel' AND blessed.flag_is_ugc_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='web' AND flag_count_web THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='android' AND flag_count_android THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='ios' AND flag_count_ios THEN TRUE
        WHEN base.flag_ugc_oo_channel='O&O Channel' AND blessed.flag_is_premium_content_matched_extension AND base.platform='desktop' AND flag_count_desktop THEN TRUE
      ELSE FALSE END AS flag_mw_with_blessed_extension
      -----------------------------------------------------------------------
      -----------------------------------------------------------------------
      , base.hw, blessed.extension_id, blessed.extension_name, blessed.extension_url, blessed.extension_category_name
      , blessed.flag_count_web, blessed.flag_count_android, blessed.flag_count_ios, blessed.flag_count_desktop
      , blessed.flag_count_playstation, blessed.flag_count_xboxone, blessed.flag_count_xbox360
      , blessed.flag_count_mobile_web, blessed.flag_count_chromecast, blessed.flag_count_other
    FROM daily_hours_watched_per_channel_platform_game AS base
    LEFT JOIN daily_blessed_extension_per_channel AS blessed
      ON base.the_day = blessed.the_day
      AND base.channel_id = blessed.channel_id
  )
  WHERE flag_ugc_oo_channel= 'O&O Channel'
)


, final_data_ugc AS (
  SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, the_game
    , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
    , ROUND(total_hw::FLOAT,2) AS total_hw
    , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
  FROM (
    SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, CASE WHEN flag_is_blessed_game THEN game_flattened ELSE 'other_games_w_no_official_extension' END AS the_game
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
    , SUM(hw) AS total_hw
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/NULLIF(SUM(hw::FLOAT),0) AS pct_hw_with_blessed_extension
    FROM joined_daily_blessed_hours_watched_ugc
    GROUP BY 1,2,3,4,5,6
  )
)

, final_data_premium AS (
  SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, the_game
    , ROUND(hw_with_blessed_extension::FLOAT,2) AS hw_with_blessed_extension
    , ROUND(total_hw::FLOAT,2) AS total_hw
    , ROUND(pct_hw_with_blessed_extension::FLOAT,6) AS pct_hw_with_blessed_extension
  FROM (
    SELECT the_day, channel_id, platform, flag_ugc_oo_channel, flag_is_blessed_game, CASE WHEN flag_is_blessed_game THEN game_flattened ELSE 'other_games_w_no_official_extension' END AS the_game
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END) AS hw_with_blessed_extension
    , SUM(hw) AS total_hw
    , SUM(CASE WHEN flag_mw_with_blessed_extension THEN hw ELSE 0 END)::FLOAT/NULLIF(SUM(hw::FLOAT),0) AS pct_hw_with_blessed_extension
    FROM joined_daily_blessed_hours_watched_premium
    GROUP BY 1,2,3,4,5,6
  )
)


, final_data AS (
  SELECT * FROM final_data_ugc
  UNION ALL
  SELECT * FROM final_data_premium
)


SELECT * FROM final_data
);



--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (VARCHAR) AS
DELETE FROM analysis.dsds_389_2019_dx_mw_metric
WHERE the_day = $1::DATE
;













EXECUTE the_insert_function ('2019-04-01');
EXECUTE the_insert_function ('2019-04-02');
EXECUTE the_insert_function ('2019-04-03');
EXECUTE the_insert_function ('2019-04-04');
EXECUTE the_insert_function ('2019-04-05');
EXECUTE the_insert_function ('2019-04-06');
EXECUTE the_insert_function ('2019-04-07');
EXECUTE the_insert_function ('2019-04-08');
EXECUTE the_insert_function ('2019-04-09');
EXECUTE the_insert_function ('2019-04-10');
EXECUTE the_insert_function ('2019-04-11');
EXECUTE the_insert_function ('2019-04-12');
EXECUTE the_insert_function ('2019-04-13');
EXECUTE the_insert_function ('2019-04-14');
EXECUTE the_insert_function ('2019-04-15');
EXECUTE the_insert_function ('2019-04-16');
EXECUTE the_insert_function ('2019-04-17');
EXECUTE the_insert_function ('2019-04-18');
EXECUTE the_insert_function ('2019-04-19');
EXECUTE the_insert_function ('2019-04-20');
EXECUTE the_insert_function ('2019-04-21');
EXECUTE the_insert_function ('2019-04-22');
EXECUTE the_insert_function ('2019-04-23');
EXECUTE the_insert_function ('2019-04-24');
EXECUTE the_insert_function ('2019-04-25');
EXECUTE the_insert_function ('2019-04-26');
EXECUTE the_insert_function ('2019-04-27');
EXECUTE the_insert_function ('2019-04-28');
EXECUTE the_insert_function ('2019-04-29');
EXECUTE the_insert_function ('2019-04-30');



EXECUTE the_delete_function ('2019-04-01');
EXECUTE the_delete_function ('2019-04-02');
EXECUTE the_delete_function ('2019-04-03');
EXECUTE the_delete_function ('2019-04-04');
EXECUTE the_delete_function ('2019-04-05');
EXECUTE the_delete_function ('2019-04-06');
EXECUTE the_delete_function ('2019-04-07');
EXECUTE the_delete_function ('2019-04-08');
EXECUTE the_delete_function ('2019-04-09');
EXECUTE the_delete_function ('2019-04-10');
EXECUTE the_delete_function ('2019-04-11');
EXECUTE the_delete_function ('2019-04-12');
EXECUTE the_delete_function ('2019-04-13');
EXECUTE the_delete_function ('2019-04-14');
EXECUTE the_delete_function ('2019-04-15');
EXECUTE the_delete_function ('2019-04-16');
EXECUTE the_delete_function ('2019-04-17');
EXECUTE the_delete_function ('2019-04-18');
EXECUTE the_delete_function ('2019-04-19');
EXECUTE the_delete_function ('2019-04-20');
EXECUTE the_delete_function ('2019-04-21');
EXECUTE the_delete_function ('2019-04-22');
EXECUTE the_delete_function ('2019-04-23');
EXECUTE the_delete_function ('2019-04-24');
EXECUTE the_delete_function ('2019-04-25');
EXECUTE the_delete_function ('2019-04-26');
EXECUTE the_delete_function ('2019-04-27');
EXECUTE the_delete_function ('2019-04-28');
EXECUTE the_delete_function ('2019-04-29');
EXECUTE the_delete_function ('2019-04-30');










-- Load TEMP_TABLE into TABLE AFTER DELETING THE DATA
INSERT INTO analysis.dsds_389_2019_dx_mw_metric
(SELECT * FROM the_temp_table);


DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
